/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import imaging.DW_Scheme;
import inverters.DT_Inversion;
import inverters.LinearDT_Inversion;
import java.util.Random;
import java.util.logging.Logger;
import misc.DT;
import numerics.Vector3D;
import tractography.BayesDiracRandomizer;

public class BayesDiracCylSymmTensorRandomizer
extends BayesDiracRandomizer {
    private static Logger logger = Logger.getLogger("camino.tractography.BayesDiracCylSymmTensorRandomizer");
    protected final DT_Inversion inv;

    public BayesDiracCylSymmTensorRandomizer(float[][][][] fArray, DW_Scheme dW_Scheme, Random random) {
        super(fArray, dW_Scheme, random);
        this.inv = new LinearDT_Inversion(dW_Scheme);
    }

    public BayesDiracCylSymmTensorRandomizer(float[][][][] fArray, DW_Scheme dW_Scheme, int n, Random random) {
        super(fArray, dW_Scheme, n, random);
        this.inv = new LinearDT_Inversion(dW_Scheme);
    }

    @Override
    protected void computeLikelihood(int n, int n2, int n3) {
        int n4;
        this.likelihood[n][n2][n3] = new float[this.numVectors];
        double[] dArray = new double[this.numMeas];
        for (int i = 0; i < this.numMeas; ++i) {
            dArray[i] = this.data[n][n2][n3][i];
        }
        double[] dArray2 = this.inv.invert(dArray);
        double d = dArray2[1];
        DT dT = new DT(dArray2[2], dArray2[3], dArray2[4], dArray2[5], dArray2[6], dArray2[7]);
        double[][] dArray3 = dT.sortedEigenSystem();
        double d2 = dArray3[0][0];
        double d3 = (dArray3[0][1] + dArray3[0][2]) / 2.0;
        double d4 = d2 - d3;
        double[] dArray4 = new double[this.numMeas];
        for (int i = 0; i < this.numMeas; ++i) {
            dArray4[i] = Math.log(this.data[n][n2][n3][i]);
        }
        double[] dArray5 = new double[this.numMeas];
        double[] dArray6 = new double[this.numMeas];
        double d5 = 0.0;
        double d6 = 1.0 / ((double)this.numMeas - 5.0);
        Vector3D vector3D = new Vector3D(dArray3[1][0], dArray3[2][0], dArray3[3][0]);
        for (int i = 0; i < this.numMeas; ++i) {
            double d7 = vector3D.dot(this.g[i]);
            dArray5[i] = Math.exp(d - this.b[i] * (d3 + d4 * d7 * d7));
            d5 += d6 * ((double)this.data[n][n2][n3][i] - dArray5[i]) * ((double)this.data[n][n2][n3][i] - dArray5[i]);
        }
        double d8 = Math.sqrt(Math.PI * 2 * d5);
        double[] dArray7 = new double[this.numVectors];
        double d9 = 0.0;
        for (n4 = 0; n4 < this.numVectors; ++n4) {
            dArray7[n4] = 1.0;
            for (int i = 0; i < this.numMeas; ++i) {
                double d10 = 0.0;
                dArray6[i] = d - this.b[i] * (d3 + d4 * this.vDotG[i][n4] * this.vDotG[i][n4]);
                dArray5[i] = Math.exp(dArray6[i]);
            }
            double d11 = 1.0;
            double d12 = 0.0;
            for (int i = 0; i < this.numMeas; ++i) {
                d11 *= dArray5[i] / d8;
                d12 += -1.0 * (dArray5[i] * dArray5[i]) * (dArray4[i] - dArray6[i]) * (dArray4[i] - dArray6[i]) / (2.0 * d5);
            }
            dArray7[n4] = d11 * Math.exp(d12);
            if (this.externalPriors != null) {
                dArray7[n4] = dArray7[n4] * this.externalPriors.pdf(n, n2, n3, 0, this.vectors[n4]);
            }
            if (!(dArray7[n4] > 0.0)) continue;
            d9 += dArray7[n4];
        }
        for (n4 = 0; n4 < this.numVectors; ++n4) {
            this.likelihood[n][n2][n3][n4] = d9 > 0.0 ? (float)(dArray7[n4] / d9) : 0.07957747f;
        }
    }
}

