/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import imaging.DW_Scheme;
import java.util.Random;
import numerics.Vector3D;
import tractography.TractographyImage;

public abstract class BootstrapTractographyImage
extends TractographyImage {
    protected final int[][][] voxelClassification;
    protected final DW_Scheme imPars;
    protected final int numMeasurements;
    protected final Random ran;

    public BootstrapTractographyImage(int[] nArray, double[] dArray, int n, int[][][] nArray2, DW_Scheme dW_Scheme, Random random) {
        super(nArray, dArray, n);
        this.ran = random;
        this.voxelClassification = nArray2;
        this.numMeasurements = dW_Scheme.numMeasurements();
        this.imPars = dW_Scheme;
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    if (nArray2[k][j][i] < 0) {
                        this.numPDs[k][j][i] = 0;
                        continue;
                    }
                    if (nArray2[k][j][i] < 4) {
                        this.numPDs[k][j][i] = 1;
                        continue;
                    }
                    if (nArray2[k][j][i] == 4) {
                        this.numPDs[k][j][i] = 2;
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported order " + nArray2[k][j][i] + " in voxel classification");
                }
            }
        }
        this.computeIsotropicMask();
    }

    @Override
    public final Vector3D[] getPDs(int n, int n2, int n3) {
        this.setVectors(n, n2, n3);
        return super.getPDs(n, n2, n3);
    }

    protected abstract void setVectors(int var1, int var2, int var3);
}

