/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import numerics.Point3D;

public class EightNeighbourInterpolator {
    protected int xDataDim;
    protected int yDataDim;
    protected int zDataDim;
    protected double xVoxelDim;
    protected double yVoxelDim;
    protected double zVoxelDim;

    public EightNeighbourInterpolator(int n, int n2, int n3, double d, double d2, double d3) {
        this.xDataDim = n;
        this.yDataDim = n2;
        this.zDataDim = n3;
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
    }

    public EightNeighbourInterpolator(int[] nArray, double[] dArray) {
        this.xDataDim = nArray[0];
        this.yDataDim = nArray[1];
        this.zDataDim = nArray[2];
        this.xVoxelDim = dArray[0];
        this.yVoxelDim = dArray[1];
        this.zVoxelDim = dArray[2];
    }

    public final int setInterpolationVoxels(Point3D point3D, double[] dArray, int[] nArray) {
        double[] dArray2 = new double[3];
        this.interpIndicesAndOffsets(point3D, nArray, dArray2);
        dArray[0] = (1.0 - dArray2[0]) * (1.0 - dArray2[1]) * (1.0 - dArray2[2]);
        dArray[1] = (1.0 - dArray2[0]) * (1.0 - dArray2[1]) * dArray2[2];
        dArray[2] = (1.0 - dArray2[0]) * dArray2[1] * (1.0 - dArray2[2]);
        dArray[3] = (1.0 - dArray2[0]) * dArray2[1] * dArray2[2];
        dArray[4] = dArray2[0] * (1.0 - dArray2[1]) * (1.0 - dArray2[2]);
        dArray[5] = dArray2[0] * (1.0 - dArray2[1]) * dArray2[2];
        dArray[6] = dArray2[0] * dArray2[1] * (1.0 - dArray2[2]);
        dArray[7] = dArray2[0] * dArray2[1] * dArray2[2];
        return 4 * (dArray2[0] < 0.5 ? 0 : 1) + 2 * (dArray2[1] < 0.5 ? 0 : 1) + (dArray2[2] < 0.5 ? 0 : 1);
    }

    public final int setInterpolationVoxelsDX(Point3D point3D, double[] dArray, int[] nArray) {
        double[] dArray2 = new double[3];
        this.interpIndicesAndOffsets(point3D, nArray, dArray2);
        dArray[0] = -1.0 / this.xVoxelDim * (1.0 - dArray2[1]) * (1.0 - dArray2[2]);
        dArray[1] = -1.0 / this.xVoxelDim * (1.0 - dArray2[1]) * dArray2[2];
        dArray[2] = -1.0 / this.xVoxelDim * dArray2[1] * (1.0 - dArray2[2]);
        dArray[3] = -1.0 / this.xVoxelDim * dArray2[1] * dArray2[2];
        dArray[4] = 1.0 / this.xVoxelDim * (1.0 - dArray2[1]) * (1.0 - dArray2[2]);
        dArray[5] = 1.0 / this.xVoxelDim * (1.0 - dArray2[1]) * dArray2[2];
        dArray[6] = 1.0 / this.xVoxelDim * dArray2[1] * (1.0 - dArray2[2]);
        dArray[7] = 1.0 / this.xVoxelDim * dArray2[1] * dArray2[2];
        return 4 * (dArray2[0] < 0.5 ? 0 : 1) + 2 * (dArray2[1] < 0.5 ? 0 : 1) + (dArray2[2] < 0.5 ? 0 : 1);
    }

    public final int setInterpolationVoxelsDY(Point3D point3D, double[] dArray, int[] nArray) {
        double[] dArray2 = new double[3];
        this.interpIndicesAndOffsets(point3D, nArray, dArray2);
        dArray[0] = (1.0 - dArray2[0]) * (-1.0 / this.yVoxelDim) * (1.0 - dArray2[2]);
        dArray[1] = (1.0 - dArray2[0]) * (-1.0 / this.yVoxelDim) * dArray2[2];
        dArray[2] = (1.0 - dArray2[0]) * (1.0 / this.yVoxelDim) * (1.0 - dArray2[2]);
        dArray[3] = (1.0 - dArray2[0]) * (1.0 / this.yVoxelDim) * dArray2[2];
        dArray[4] = dArray2[0] * (-1.0 / this.yVoxelDim) * (1.0 - dArray2[2]);
        dArray[5] = dArray2[0] * (-1.0 / this.yVoxelDim) * dArray2[2];
        dArray[6] = dArray2[0] * (1.0 / this.yVoxelDim) * (1.0 - dArray2[2]);
        dArray[7] = dArray2[0] * (1.0 / this.yVoxelDim) * dArray2[2];
        return 4 * (dArray2[0] < 0.5 ? 0 : 1) + 2 * (dArray2[1] < 0.5 ? 0 : 1) + (dArray2[2] < 0.5 ? 0 : 1);
    }

    public final int setInterpolationVoxelsDZ(Point3D point3D, double[] dArray, int[] nArray) {
        double[] dArray2 = new double[3];
        this.interpIndicesAndOffsets(point3D, nArray, dArray2);
        dArray[0] = (1.0 - dArray2[0]) * (1.0 - dArray2[1]) * (-1.0 / this.zVoxelDim);
        dArray[1] = (1.0 - dArray2[0]) * (1.0 - dArray2[1]) * (1.0 / this.zVoxelDim);
        dArray[2] = (1.0 - dArray2[0]) * dArray2[1] * (-1.0 / this.zVoxelDim);
        dArray[3] = (1.0 - dArray2[0]) * dArray2[1] * (1.0 / this.zVoxelDim);
        dArray[4] = dArray2[0] * (1.0 - dArray2[1]) * (-1.0 / this.zVoxelDim);
        dArray[5] = dArray2[0] * (1.0 - dArray2[1]) * (1.0 / this.zVoxelDim);
        dArray[6] = dArray2[0] * dArray2[1] * (-1.0 / this.zVoxelDim);
        dArray[7] = dArray2[0] * dArray2[1] * (1.0 / this.zVoxelDim);
        return 4 * (dArray2[0] < 0.5 ? 0 : 1) + 2 * (dArray2[1] < 0.5 ? 0 : 1) + (dArray2[2] < 0.5 ? 0 : 1);
    }

    private void interpIndicesAndOffsets(Point3D point3D, int[] nArray, double[] dArray) {
        int[] nArray2 = new int[]{(int)(point3D.x / this.xVoxelDim - 0.5), (int)(point3D.y / this.yVoxelDim - 0.5), (int)(point3D.z / this.zVoxelDim - 0.5)};
        nArray2[0] = nArray2[0] < 0 ? 0 : nArray2[0];
        nArray2[1] = nArray2[1] < 0 ? 0 : nArray2[1];
        nArray2[2] = nArray2[2] < 0 ? 0 : nArray2[2];
        dArray[0] = point3D.x / this.xVoxelDim - 0.5 - (double)nArray2[0];
        dArray[1] = point3D.y / this.yVoxelDim - 0.5 - (double)nArray2[1];
        dArray[2] = point3D.z / this.zVoxelDim - 0.5 - (double)nArray2[2];
        nArray[0] = nArray2[0];
        nArray[2] = nArray2[1];
        nArray[4] = nArray2[2];
        if (dArray[0] < 0.0) {
            nArray[1] = 0;
            dArray[0] = -1.0 * dArray[0];
        } else {
            nArray[1] = nArray[0] == this.xDataDim - 1 ? nArray[0] : nArray[0] + 1;
        }
        if (dArray[1] < 0.0) {
            nArray[3] = 0;
            dArray[1] = -1.0 * dArray[1];
        } else {
            nArray[3] = nArray[2] == this.yDataDim - 1 ? nArray[2] : nArray[2] + 1;
        }
        if (dArray[2] < 0.0) {
            nArray[5] = 0;
            dArray[2] = -1.0 * dArray[2];
        } else {
            nArray[5] = nArray[4] == this.zDataDim - 1 ? nArray[4] : nArray[4] + 1;
        }
    }
}

