/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import numerics.Point3D;
import numerics.Vector3D;
import tractography.FibreTracker;
import tractography.ImageInterpolator;
import tractography.Tract;
import tractography.TractographyImage;

public abstract class EulerFibreTracker
extends FibreTracker {
    private final double stepSize;
    protected ImageInterpolator interpolator;

    public EulerFibreTracker(TractographyImage tractographyImage, double d, double d2) {
        super(tractographyImage, d2);
        this.stepSize = d;
        if (this.stepSize <= 0.0) {
            throw new IllegalArgumentException("Can't track with step size " + this.stepSize);
        }
    }

    public double stepSize() {
        return this.stepSize;
    }

    @Override
    protected Vector3D[] getPDs(int n, int n2, int n3) {
        throw new UnsupportedOperationException("Interpolated trackers should take PDs from interpolator");
    }

    @Override
    protected final Tract trackFromSeed(Point3D point3D, int n, boolean bl) {
        Tract tract = new Tract(200, 100.0);
        Point3D point3D2 = point3D;
        tract.addPoint(point3D, 0.0);
        if (!this.inBounds(point3D)) {
            return tract;
        }
        int n2 = (int)(point3D2.x / this.xVoxelDim);
        int n3 = (int)(point3D2.y / this.yVoxelDim);
        int n4 = (int)(point3D2.z / this.zVoxelDim);
        if (this.isotropic[n2][n3][n4]) {
            return tract;
        }
        Vector3D vector3D = this.interpolator.getTrackingDirection(point3D, n, bl);
        short s = 1;
        int n5 = (int)(1000.0 / this.stepSize);
        this.visitedVoxel[n2][n3][n4] = 1;
        int n6 = (int)(this.zVoxelDim / this.stepSize) > 0 ? (int)(this.zVoxelDim / this.stepSize) : 1;
        Vector3D vector3D2 = vector3D;
        do {
            if (!this.inBounds(point3D2 = point3D2.displace(vector3D.scaled(this.stepSize)))) {
                return tract;
            }
            n2 = (int)(point3D2.x / this.xVoxelDim);
            n3 = (int)(point3D2.y / this.yVoxelDim);
            n4 = (int)(point3D2.z / this.zVoxelDim);
            if (this.isotropic[n2][n3][n4]) {
                return tract;
            }
            if (this.visitedVoxel[n2][n3][n4] - s > n6) {
                return tract;
            }
            this.visitedVoxel[n2][n3][n4] = s;
            Vector3D vector3D3 = vector3D;
            vector3D = this.interpolator.getTrackingDirection(point3D2, vector3D3);
            if (s % n6 == 0) {
                if (vector3D2.dot(vector3D) < this.ipThreshold) {
                    tract.addPoint(point3D2, this.stepSize);
                    return tract;
                }
                vector3D2 = vector3D;
            }
            tract.addPoint(point3D2, this.stepSize);
        } while ((s = (short)(s + 1)) != n5);
        return tract;
    }
}

