/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Random;
import numerics.Point3D;
import tractography.EulerFibreTracker;
import tractography.NeighbourChoiceInterpolator;
import tractography.TractCollection;
import tractography.TractographyImage;

public class NC_ProbFibreTracker
extends EulerFibreTracker {
    protected final NeighbourChoiceInterpolator interpProbRef;

    public NC_ProbFibreTracker(TractographyImage tractographyImage, double d, double d2, Random random) {
        super(tractographyImage, d, d2);
        this.interpolator = new NeighbourChoiceInterpolator(tractographyImage, random);
        this.interpProbRef = (NeighbourChoiceInterpolator)this.interpolator;
    }

    @Override
    public TractCollection trackFromSeed(Point3D point3D) {
        TractCollection tractCollection = super.trackFromSeed(point3D);
        this.interpProbRef.resetRandomization();
        return tractCollection;
    }

    @Override
    public TractCollection trackFromSeed(Point3D point3D, int n) {
        TractCollection tractCollection = super.trackFromSeed(point3D, n);
        this.interpProbRef.resetRandomization();
        return tractCollection;
    }
}

