/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Arrays;
import numerics.Point3D;
import numerics.Vector3D;
import tractography.FibreTracker;
import tractography.Tract;
import tractography.TractographyImage;

public class NonInterpolatedFibreTracker
extends FibreTracker {
    public NonInterpolatedFibreTracker(TractographyImage tractographyImage, double d) {
        super(tractographyImage, d);
    }

    @Override
    protected final Tract trackFromSeed(Point3D point3D, int n, boolean bl) {
        Tract tract = new Tract(200, 100.0);
        Point3D point3D2 = point3D;
        tract.addPoint(point3D, 0.0);
        if (!this.inBounds(point3D)) {
            return tract;
        }
        int n2 = (int)(point3D2.x / this.xVoxelDim);
        int n3 = (int)(point3D2.y / this.yVoxelDim);
        int n4 = (int)(point3D2.z / this.zVoxelDim);
        if (this.isotropic[n2][n3][n4]) {
            return tract;
        }
        Vector3D[] vector3DArray = this.getPDs(n2, n3, n4);
        Vector3D vector3D = vector3DArray[n];
        if (!bl) {
            vector3D = vector3D.negated();
        }
        short s = 1;
        short s2 = 10000;
        Vector3D vector3D2 = vector3D;
        double[] dArray = new double[6];
        double d = 0.0;
        do {
            this.visitedVoxel[n2][n3][n4] = s;
            double d2 = this.yVoxelDim * (double)(1 + n3);
            double d3 = this.yVoxelDim * (double)n3;
            double d4 = this.zVoxelDim * (double)(1 + n4);
            double d5 = this.zVoxelDim * (double)n4;
            double d6 = this.xVoxelDim * (double)(1 + n2);
            double d7 = this.xVoxelDim * (double)n2;
            if (vector3D.y != 0.0) {
                dArray[0] = (d2 - point3D2.y) / vector3D.y;
                dArray[1] = (d3 - point3D2.y) / vector3D.y;
            } else {
                dArray[0] = Double.MAX_VALUE;
                dArray[1] = Double.MAX_VALUE;
            }
            if (vector3D.z != 0.0) {
                dArray[2] = (d4 - point3D2.z) / vector3D.z;
                dArray[3] = (d5 - point3D2.z) / vector3D.z;
            } else {
                dArray[2] = Double.MAX_VALUE;
                dArray[3] = Double.MAX_VALUE;
            }
            if (vector3D.x != 0.0) {
                dArray[4] = (d7 - point3D2.x) / vector3D.x;
                dArray[5] = (d6 - point3D2.x) / vector3D.x;
            } else {
                dArray[4] = Double.MAX_VALUE;
                dArray[5] = Double.MAX_VALUE;
            }
            Arrays.sort(dArray);
            int n5 = 0;
            while (dArray[n5] < 0.0) {
                ++n5;
            }
            double d8 = dArray[n5] + 0.001;
            Point3D point3D3 = point3D2.displace(vector3D.scaled(d8));
            d += d8;
            if (!this.inBounds(point3D3)) {
                return tract;
            }
            n2 = (int)(point3D3.x / this.xVoxelDim);
            n3 = (int)(point3D3.y / this.yVoxelDim);
            n4 = (int)(point3D3.z / this.zVoxelDim);
            if (this.visitedVoxel[n2][n3][n4] > 0) {
                if (s - this.visitedVoxel[n2][n3][n4] > 1) {
                    return tract;
                }
                if (s == this.visitedVoxel[n2][n3][n4]) {
                    point3D3 = point3D2.displace(vector3D.scaled(d8 += 0.001));
                    if (!this.inBounds(point3D3)) {
                        return tract;
                    }
                    n2 = (int)(point3D3.x / this.xVoxelDim);
                    n3 = (int)(point3D3.y / this.yVoxelDim);
                    n4 = (int)(point3D3.z / this.zVoxelDim);
                } else {
                    this.visitedVoxel[n2][n3][n4] = s;
                    point3D3 = point3D2.displace(vector3D.scaled(d8 = d8 < 0.1 ? 0.1 : d8));
                    if (!this.inBounds(point3D3)) {
                        return tract;
                    }
                    n2 = (int)(point3D3.x / this.xVoxelDim);
                    n3 = (int)(point3D3.y / this.yVoxelDim);
                    n4 = (int)(point3D3.z / this.zVoxelDim);
                }
            }
            point3D2 = point3D3;
            Vector3D vector3D3 = vector3D;
            if (this.isotropic[n2][n3][n4]) {
                return tract;
            }
            vector3D = this.getTrackingDirection(n2, n3, n4, vector3D3);
            if (d >= this.zVoxelDim) {
                d = 0.0;
                if (vector3D2.dot(vector3D) < this.ipThreshold) {
                    tract.addPoint(point3D2, d8);
                    return tract;
                }
                vector3D2 = vector3D;
            }
            tract.addPoint(point3D2, d8);
        } while ((s = (short)(s + 1)) != s2);
        return tract;
    }

    protected Vector3D getTrackingDirection(int n, int n2, int n3, Vector3D vector3D) {
        Vector3D vector3D2;
        Vector3D[] vector3DArray = this.getPDs(n, n2, n3);
        double d = 0.0;
        int n4 = 0;
        if (vector3DArray.length > 1) {
            for (int i = 0; i < vector3DArray.length; ++i) {
                double d2 = Math.abs(vector3DArray[i].dot(vector3D));
                if (!(d2 > d)) continue;
                d = d2;
                n4 = i;
            }
        }
        if ((vector3D2 = vector3DArray[n4]).dot(vector3D) < 0.0) {
            vector3D2 = vector3D2.negated();
        }
        return vector3D2;
    }
}

