/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import misc.LoggedException;
import numerics.Point3D;
import tractography.Tract;
import tractography.TractCollection;
import tractography.Voxel;
import tractography.VoxelList;

public class StreamlineROI_Filter {
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;
    private final int xDataDim;
    private final int yDataDim;
    private final int zDataDim;
    private int[][][] waypoints;
    private int numWaypoints = 0;
    private int maxWaypointIndex = 0;
    private int minTractPoints = 0;
    private double minTractLength = 0.0;
    private int maxTractPoints = 0;
    private double maxTractLength = 0.0;
    private int[][][] exclusionROI;
    private boolean haveExclusionROIs = false;
    private int[][][] endZones;
    private boolean haveEndZones = false;
    private boolean discardInExclusionROI = false;
    private boolean truncateLoops = false;
    private boolean discardLoops = false;
    private boolean resample = false;
    private double resampleStepSize = 0.5;
    private static Logger logger = Logger.getLogger("camino.tractography.StreamlineROI_Filter");

    public StreamlineROI_Filter(int[] nArray, double[] dArray) {
        this.xDataDim = nArray[0];
        this.yDataDim = nArray[1];
        this.zDataDim = nArray[2];
        this.xVoxelDim = dArray[0];
        this.yVoxelDim = dArray[1];
        this.zVoxelDim = dArray[2];
        this.exclusionROI = new int[this.xDataDim][this.yDataDim][this.zDataDim];
    }

    public void setWaypoints(int[][][] nArray) {
        int n;
        int n2;
        if (nArray.length != this.xDataDim || nArray[0].length != this.yDataDim || nArray[0][0].length != this.zDataDim) {
            throw new LoggedException("Waypoint dimensions " + nArray.length + " " + nArray[0].length + " " + nArray[0][0].length + " do not match seed space dimensions " + this.xDataDim + " " + this.yDataDim + " " + this.zDataDim);
        }
        this.waypoints = nArray;
        this.numWaypoints = 0;
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(100, 0.75f);
        int n3 = 1;
        for (int i = 0; i < this.xDataDim; ++i) {
            for (n2 = 0; n2 < this.yDataDim; ++n2) {
                for (n = 0; n < this.zDataDim; ++n) {
                    Integer n4;
                    if (nArray[i][n2][n] <= 0 || hashMap.containsKey(n4 = new Integer(nArray[i][n2][n]))) continue;
                    hashMap.put(n4, n3);
                    ++n3;
                }
            }
        }
        Object[] objectArray = hashMap.keySet().toArray(new Integer[hashMap.size()]);
        this.numWaypoints = objectArray.length;
        Arrays.sort(objectArray);
        this.maxWaypointIndex = (Integer)objectArray[this.numWaypoints - 1];
        if (this.maxWaypointIndex > Short.MAX_VALUE) {
            if (this.numWaypoints > Short.MAX_VALUE) {
                throw new LoggedException("Too many waypoints " + this.numWaypoints);
            }
            logger.info("Re-mapping " + this.numWaypoints + " waypoints to range 1..." + this.numWaypoints + " for processing");
            for (n2 = 0; n2 < this.xDataDim; ++n2) {
                for (n = 0; n < this.yDataDim; ++n) {
                    for (int i = 0; i < this.zDataDim; ++i) {
                        int n5;
                        if (nArray[n2][n][i] <= 0) continue;
                        nArray[n2][n][i] = n5 = ((Integer)hashMap.get(new Integer(nArray[n2][n][i]))).intValue();
                    }
                }
            }
        }
    }

    public void setEndZones(int[][][] nArray) {
        if (nArray.length != this.xDataDim || nArray[0].length != this.yDataDim || nArray[0][0].length != this.zDataDim) {
            throw new LoggedException("EndZone dimensions " + nArray.length + " " + nArray[0].length + " " + nArray[0][0].length + " do not match seed space dimensions " + this.xDataDim + " " + this.yDataDim + " " + this.zDataDim);
        }
        this.endZones = nArray;
        this.haveEndZones = true;
    }

    public void setExclusionROIs(int[][][] nArray) {
        if (nArray.length != this.xDataDim || nArray[0].length != this.yDataDim || nArray[0][0].length != this.zDataDim) {
            throw new LoggedException("Exclusion ROI dimensions " + nArray.length + " " + nArray[0].length + " " + nArray[0][0].length + " do not match seed space dimensions " + this.xDataDim + " " + this.yDataDim + " " + this.zDataDim);
        }
        this.exclusionROI = nArray;
        this.haveExclusionROIs = true;
    }

    public TractCollection processTract(Tract tract) {
        TractCollection tractCollection = new TractCollection(2, 100.0);
        tractCollection.addTract(tract);
        return this.processTracts(tractCollection);
    }

    public TractCollection processTracts(TractCollection tractCollection) {
        TractCollection tractCollection2 = new TractCollection(tractCollection.numberOfTracts() + 1, 100.0);
        for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
            Tract tract = tractCollection.getTract(i);
            if (tract.numberOfPoints() < this.minTractPoints) continue;
            if (this.maxTractPoints > 0 && tract.numberOfPoints() > this.maxTractPoints) {
                tract.truncateToMaxPoints(this.maxTractPoints);
            }
            if (this.minTractLength > 0.0 && tract.length() < this.minTractLength) continue;
            if (this.maxTractLength > 0.0 && tract.length() > this.maxTractLength) {
                tract.truncateToMaxLength(this.maxTractLength);
            }
            this.truncateToBounds(tract);
            if (tract.numberOfPoints() == 0) continue;
            if (this.resample) {
                tract = tract.resample(this.resampleStepSize);
            }
            boolean bl = false;
            bl = this.truncateToExclusion(tract);
            boolean bl2 = true;
            if (this.numWaypoints > 0) {
                bl2 = this.passesWaypoints(tract, this.truncateLoops, this.discardLoops);
            }
            boolean bl3 = true;
            if (bl2 && this.haveEndZones) {
                bl3 = this.truncateToEndZones(tract);
            }
            if (!bl2 || !bl3 || bl && this.discardInExclusionROI) continue;
            tractCollection2.addTract(tract);
        }
        return tractCollection2;
    }

    private final boolean passesWaypoints(Tract tract, boolean bl, boolean bl2) {
        if (this.numWaypoints == 0) {
            return true;
        }
        boolean[] blArray = new boolean[this.maxWaypointIndex + 1];
        int n = 0;
        if (this.truncateLoops || this.discardLoops) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            Point3D[] point3DArray = tract.getPoints();
            int n7 = tract.seedPointIndex();
            int n8 = 0;
            int n9 = point3DArray.length - 1;
            int n10 = 0;
            for (n6 = n7; n6 >= 0; --n6) {
                n5 = (int)(point3DArray[n6].x / this.xVoxelDim);
                n4 = (int)(point3DArray[n6].y / this.yVoxelDim);
                n3 = (int)(point3DArray[n6].z / this.zVoxelDim);
                n2 = this.waypoints[n5][n4][n3];
                if (n2 > 0) {
                    if (blArray[n2]) {
                        if (n10 == n2) continue;
                        if (this.discardLoops) {
                            return false;
                        }
                        n8 = n6;
                        continue;
                    }
                    blArray[n2] = true;
                    ++n;
                    n10 = n2;
                    continue;
                }
                n10 = 0;
            }
            n10 = 0;
            for (n6 = n7; n6 < point3DArray.length; ++n6) {
                n5 = (int)(point3DArray[n6].x / this.xVoxelDim);
                n4 = (int)(point3DArray[n6].y / this.yVoxelDim);
                n3 = (int)(point3DArray[n6].z / this.zVoxelDim);
                n2 = this.waypoints[n5][n4][n3];
                if (n6 == n7) {
                    n10 = n2;
                }
                if (n2 > 0) {
                    if (blArray[n2]) {
                        if (n10 == n2) continue;
                        if (this.discardLoops) {
                            return false;
                        }
                        n9 = n6;
                        continue;
                    }
                    blArray[n2] = true;
                    ++n;
                    n10 = n2;
                    continue;
                }
                n10 = 0;
            }
            if (n8 > 0 || n9 < point3DArray.length - 1) {
                tract.chop(n8, n9);
            }
        } else {
            VoxelList voxelList = tract.toVoxelList(this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
            int n11 = voxelList.size();
            for (int i = 0; n < this.numWaypoints && i < n11; ++i) {
                Voxel voxel = voxelList.getVoxel(i);
                int n12 = this.waypoints[voxel.x][voxel.y][voxel.z];
                if (n12 <= 0 || blArray[n12]) continue;
                blArray[n12] = true;
                ++n;
            }
        }
        return n == this.numWaypoints;
    }

    private final boolean entersExclusion(Tract tract) {
        int n;
        int n2;
        Object object;
        if (!this.haveExclusionROIs) {
            return false;
        }
        if (tract.numberOfPoints() == 1) {
            object = tract.getPoint(0);
            n2 = (int)(((Point3D)object).x / this.xVoxelDim);
            n = (int)(((Point3D)object).y / this.yVoxelDim);
            int n3 = (int)(((Point3D)object).z / this.zVoxelDim);
            if (n2 < 0 || n2 >= this.xDataDim || n < 0 || n >= this.yDataDim || n3 < 0 || n3 >= this.zDataDim) {
                return false;
            }
        }
        object = tract.toVoxelList(this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
        n2 = ((VoxelList)object).size();
        for (n = 0; n < n2; ++n) {
            Voxel voxel = ((VoxelList)object).getVoxel(n);
            if (this.exclusionROI[voxel.x][voxel.y][voxel.z] <= 0) continue;
            return true;
        }
        return false;
    }

    private final void truncateToBounds(Tract tract) {
        int n;
        int n2;
        int n3;
        int n4;
        Point3D[] point3DArray = tract.getPoints();
        int n5 = tract.seedPointIndex();
        int n6 = 0;
        int n7 = point3DArray.length - 1;
        for (n4 = n5; n4 >= 0; --n4) {
            n3 = (int)(point3DArray[n4].x / this.xVoxelDim);
            n2 = (int)(point3DArray[n4].y / this.yVoxelDim);
            n = (int)(point3DArray[n4].z / this.zVoxelDim);
            if (n3 >= 0 && n3 < this.xDataDim && n2 >= 0 && n2 < this.yDataDim && n >= 0 && n < this.zDataDim) continue;
            n6 = n4 + 1;
            break;
        }
        for (n4 = n5; n4 < point3DArray.length; ++n4) {
            n3 = (int)(point3DArray[n4].x / this.xVoxelDim);
            n2 = (int)(point3DArray[n4].y / this.yVoxelDim);
            n = (int)(point3DArray[n4].z / this.zVoxelDim);
            if (n3 >= 0 && n3 < this.xDataDim && n2 >= 0 && n2 < this.yDataDim && n >= 0 && n < this.zDataDim) continue;
            n7 = n4 - 1;
            break;
        }
        if (n6 >= n7) {
            tract.truncateToMaxPoints(0);
        } else if (n6 > 0 || n7 < point3DArray.length - 1) {
            tract.chop(n6, n7);
        }
    }

    private final boolean truncateToExclusion(Tract tract) {
        int n;
        int n2;
        int n3;
        int n4;
        Point3D[] point3DArray = tract.getPoints();
        int n5 = tract.seedPointIndex();
        int n6 = 0;
        int n7 = point3DArray.length - 1;
        boolean bl = false;
        for (n4 = n5; n4 >= 0; --n4) {
            n3 = (int)(point3DArray[n4].x / this.xVoxelDim);
            n2 = (int)(point3DArray[n4].y / this.yVoxelDim);
            n = (int)(point3DArray[n4].z / this.zVoxelDim);
            if (this.exclusionROI[n3][n2][n] <= 0) continue;
            n6 = n4;
            bl = true;
            break;
        }
        for (n4 = n5; n4 < point3DArray.length; ++n4) {
            n3 = (int)(point3DArray[n4].x / this.xVoxelDim);
            n2 = (int)(point3DArray[n4].y / this.yVoxelDim);
            n = (int)(point3DArray[n4].z / this.zVoxelDim);
            if (this.exclusionROI[n3][n2][n] <= 0) continue;
            n7 = n4;
            bl = true;
            break;
        }
        if (n6 >= n7) {
            tract.chop(n5, n5);
        } else if (n6 > 0 || n7 < point3DArray.length - 1) {
            tract.chop(n6, n7);
        }
        return bl;
    }

    private final boolean truncateToEndZones(Tract tract) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Point3D[] point3DArray = tract.getPoints();
        if (point3DArray.length == 1) {
            return false;
        }
        int n6 = n5 = tract.seedPointIndex();
        int n7 = n5;
        int n8 = this.endZones[(int)(point3DArray[n5].x / this.xVoxelDim)][(int)(point3DArray[n5].y / this.yVoxelDim)][(int)(point3DArray[n5].z / this.zVoxelDim)];
        int n9 = 0;
        int n10 = 0;
        for (n4 = n5; n4 >= 0; --n4) {
            n3 = (int)(point3DArray[n4].x / this.xVoxelDim);
            n2 = (int)(point3DArray[n4].y / this.yVoxelDim);
            n = (int)(point3DArray[n4].z / this.zVoxelDim);
            if (this.endZones[n3][n2][n] <= 0 || this.endZones[n3][n2][n] == n8) continue;
            n6 = n4;
            n9 = this.endZones[n3][n2][n];
            break;
        }
        for (n4 = n5; n4 < point3DArray.length; ++n4) {
            n3 = (int)(point3DArray[n4].x / this.xVoxelDim);
            n2 = (int)(point3DArray[n4].y / this.yVoxelDim);
            n = (int)(point3DArray[n4].z / this.zVoxelDim);
            if (this.endZones[n3][n2][n] <= 0 || this.endZones[n3][n2][n] == n8) continue;
            n7 = n4;
            n10 = this.endZones[n3][n2][n];
            break;
        }
        if (n8 > 0) {
            double d;
            if (n9 == 0 && n10 == 0) {
                return false;
            }
            double d2 = n6 < n5 ? tract.pathLengthFromSeed(n6) : Double.MAX_VALUE;
            double d3 = d = n7 > n5 ? tract.pathLengthFromSeed(n7) : Double.MAX_VALUE;
            if (d2 < d) {
                tract.chop(n6, n5);
            } else {
                tract.chop(n5, n7);
            }
            return true;
        }
        if (n9 == 0 || n10 == 0) {
            return false;
        }
        if (n9 == n10) {
            return false;
        }
        if (n6 > 0 || n7 < point3DArray.length - 1) {
            tract.chop(n6, n7);
        }
        return true;
    }

    public void setDiscardOnExclusionEntry(boolean bl) {
        this.discardInExclusionROI = bl;
    }

    public void setResampleTracts(boolean bl) {
        this.resample = bl;
    }

    public void setResampleStepSize(double d) {
        if (d > 0.0) {
            this.resampleStepSize = d;
            this.resample = true;
        } else {
            this.resample = false;
        }
    }

    public void setMinTractPoints(int n) {
        this.minTractPoints = n;
    }

    public void setMinTractLength(double d) {
        this.minTractLength = d;
    }

    public void setMaxTractPoints(int n) {
        this.maxTractPoints = n;
    }

    public void setMaxTractLength(double d) {
        this.maxTractLength = d;
    }

    public void setTruncateLoops(boolean bl) {
        this.truncateLoops = bl;
    }

    public void setDiscardLoops(boolean bl) {
        this.discardLoops = bl;
        if (this.discardLoops) {
            this.truncateLoops = false;
        }
    }
}

