/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.util.HashMap;
import numerics.Point3D;
import tractography.Tract;
import tractography.TractCollection;
import tractography.Voxel;
import tractography.VoxelList;

public class TargetCP_Image {
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;
    private final int xDataDim;
    private final int yDataDim;
    private final int zDataDim;
    private int[][][] targets = null;
    private HashMap<Integer, int[]> targetSC = null;
    private int totalStreamlines = 0;
    private boolean countFirstEntry = true;

    public TargetCP_Image(int[][][] nArray, double d, double d2, double d3) {
        this.xDataDim = nArray.length;
        this.yDataDim = nArray[0].length;
        this.zDataDim = nArray[0][0].length;
        this.targets = nArray;
        this.targetSC = new HashMap(20, 0.75f);
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
    }

    public final void processTracts(TractCollection tractCollection) {
        for (int i = 0; i < tractCollection.numberOfTracts(); ++i) {
            this.processTract(tractCollection.getTract(i));
        }
    }

    private final void processTract(Tract tract) {
        ++this.totalStreamlines;
        VoxelList voxelList = tract.toVoxelList(this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
        Voxel[] voxelArray = voxelList.getVoxels();
        int n = voxelList.seedPointIndex();
        int n2 = tract.seedPointIndex();
        int n3 = voxelArray.length;
        int n4 = tract.numberOfPoints();
        if (this.countFirstEntry) {
            int n5;
            int n6;
            int n7;
            int n8;
            Object object;
            int n9;
            double d = -1.0;
            double d2 = -1.0;
            int n10 = 0;
            int n11 = 0;
            for (n9 = n2; n9 < n4; ++n9) {
                object = tract.getPoint(n9);
                n8 = (int)(((Point3D)object).x / this.xVoxelDim);
                n7 = (int)(((Point3D)object).y / this.yVoxelDim);
                n6 = (int)(((Point3D)object).z / this.zVoxelDim);
                n5 = this.targets[n8][n7][n6];
                if (n5 <= 0) continue;
                d = tract.pathLengthFromSeed(n9);
                n10 = n5;
                break;
            }
            for (n9 = n2; n9 >= 0; --n9) {
                object = tract.getPoint(n9);
                n8 = (int)(((Point3D)object).x / this.xVoxelDim);
                n7 = (int)(((Point3D)object).y / this.yVoxelDim);
                n6 = (int)(((Point3D)object).z / this.zVoxelDim);
                n5 = this.targets[n8][n7][n6];
                if (n5 <= 0) continue;
                d2 = tract.pathLengthFromSeed(n9);
                n11 = n5;
                break;
            }
            n9 = -1;
            if (d < 0.0) {
                if (d2 > 0.0) {
                    n9 = n11;
                }
            } else if (d2 < 0.0) {
                if (d > 0.0) {
                    n9 = n10;
                }
            } else {
                n9 = d < d2 ? n10 : n11;
            }
            if (n9 > 0) {
                object = this.targetSC.get(new Integer(n9));
                if (object == null) {
                    this.targetSC.put(new Integer(n9), new int[]{1});
                } else {
                    object[0] = object[0] + true;
                }
            }
        } else {
            HashMap<Integer, Boolean> hashMap = new HashMap<Integer, Boolean>();
            int n12 = voxelArray.length;
            for (int i = 0; i < n12; ++i) {
                Integer n13;
                int n14 = this.targets[voxelArray[i].x][voxelArray[i].y][voxelArray[i].z];
                if (n14 <= 0 || hashMap.containsKey(n13 = new Integer(n14))) continue;
                hashMap.put(new Integer(n14), new Boolean(true));
            }
            for (Integer n13 : hashMap.keySet()) {
                int[] nArray = this.targetSC.get(n13);
                if (nArray == null) {
                    this.targetSC.put(n13, new int[]{1});
                    continue;
                }
                nArray[0] = nArray[0] + 1;
            }
        }
    }

    public double[][][] getStreamlineCounts() {
        double[][][] dArray = null;
        dArray = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    if (this.targets[i][j][k] <= 0) continue;
                    int[] nArray = this.targetSC.get(new Integer(this.targets[i][j][k]));
                    dArray[i][j][k] = nArray == null ? 0.0 : (double)nArray[0];
                }
            }
        }
        return dArray;
    }

    public double[][][] getConnectionProbabilities() {
        double[][][] dArray = this.getStreamlineCounts();
        double[][][] dArray2 = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        double d = this.totalStreamlines;
        for (int i = 0; i < this.xDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.zDataDim; ++k) {
                    if (!(dArray[i][j][k] > 0.0)) continue;
                    dArray2[i][j][k] = dArray[i][j][k] / d;
                }
            }
        }
        return dArray2;
    }

    public int totalStreamlines() {
        return this.totalStreamlines;
    }

    public int getStreamlineCount(int n) {
        return this.targetSC.get(new Integer(n))[0];
    }

    public int[][] getNonZeroStreamlineCounts() {
        Integer[] integerArray = this.targetSC.keySet().toArray(new Integer[0]);
        int n = integerArray.length;
        int[][] nArray = new int[n][2];
        for (int i = 0; i < n; ++i) {
            nArray[i][0] = integerArray[i];
            nArray[i][1] = this.targetSC.get(integerArray[i])[0];
        }
        return nArray;
    }

    public void setCountFirstEntry(boolean bl) {
        this.countFirstEntry = bl;
    }
}

