/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import misc.DT;
import misc.LoggedException;
import numerics.Point3D;
import numerics.Vector3D;
import tractography.DT_TractographyImage;
import tractography.ImageInterpolator;

public class TendInterpolator
implements ImageInterpolator {
    private final DT_TractographyImage image;
    private double g = 0.0;
    private double xVoxelDim;
    private double yVoxelDim;
    private double zVoxelDim;
    private int xDataDim;
    private int yDataDim;
    private int zDataDim;
    private double[][][] f;

    public TendInterpolator(DT_TractographyImage dT_TractographyImage) {
        this(dT_TractographyImage, 1.0, 0.0);
    }

    public TendInterpolator(DT_TractographyImage dT_TractographyImage, double d, double d2) {
        this.image = dT_TractographyImage;
        this.xDataDim = dT_TractographyImage.xDataDim();
        this.yDataDim = dT_TractographyImage.yDataDim();
        this.zDataDim = dT_TractographyImage.zDataDim();
        this.xVoxelDim = dT_TractographyImage.xVoxelDim();
        this.yVoxelDim = dT_TractographyImage.yVoxelDim();
        this.zVoxelDim = dT_TractographyImage.zVoxelDim();
        this.f = new double[this.xDataDim][this.yDataDim][this.zDataDim];
        this.g = d2;
        if (!(d >= 0.0) || !(d <= 1.0)) {
            throw new LoggedException("Tend parameters must be between 0 and 1. f is " + d);
        }
        if (!(this.g >= 0.0) || !(this.g <= 1.0)) {
            throw new LoggedException("Tend parameters must be between 0 and 1. g is " + this.g);
        }
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    this.f[k][j][i] = d;
                }
            }
        }
    }

    public TendInterpolator(DT_TractographyImage dT_TractographyImage, double[][][] dArray, double d) {
        this.image = dT_TractographyImage;
        this.xDataDim = dT_TractographyImage.xDataDim();
        this.yDataDim = dT_TractographyImage.yDataDim();
        this.zDataDim = dT_TractographyImage.zDataDim();
        this.xVoxelDim = dT_TractographyImage.xVoxelDim();
        this.yVoxelDim = dT_TractographyImage.yVoxelDim();
        this.zVoxelDim = dT_TractographyImage.zVoxelDim();
        this.f = dArray;
        this.g = d;
        if (!(this.g >= 0.0) || !(this.g <= 1.0)) {
            throw new LoggedException("Tend parameters must be between 0 and 1. g is " + this.g);
        }
        for (int i = 0; i < this.zDataDim; ++i) {
            for (int j = 0; j < this.yDataDim; ++j) {
                for (int k = 0; k < this.xDataDim; ++k) {
                    if (this.f[k][j][i] >= 0.0 && this.f[k][j][i] <= 1.0) continue;
                    throw new LoggedException("Tend parameters must be between 0  and 1. Value of f at voxel " + k + " " + j + " " + i + " is " + this.f[k][j][i]);
                }
            }
        }
    }

    @Override
    public Vector3D getTrackingDirection(Point3D point3D, Vector3D vector3D) {
        int n = (int)(point3D.x / this.xVoxelDim);
        int n2 = (int)(point3D.y / this.yVoxelDim);
        int n3 = (int)(point3D.z / this.zVoxelDim);
        return this.getTrackingDirection(n, n2, n3, vector3D);
    }

    public Vector3D getTrackingDirection(int n, int n2, int n3, Vector3D vector3D) {
        Vector3D[] vector3DArray = this.image.getPDs(n, n2, n3);
        DT[] dTArray = this.image.getDTs(n, n2, n3);
        DT dT = dTArray[0];
        Vector3D vector3D2 = vector3DArray[0];
        if (dTArray.length > 1) {
            double d = -1.0;
            int n4 = 0;
            for (int i = 0; i < dTArray.length; ++i) {
                double d2 = Math.abs(vector3DArray[i].dot(vector3D));
                if (!(d2 > d)) continue;
                n4 = i;
                d = d2;
            }
            dT = dTArray[n4];
            vector3D2 = vector3DArray[n4];
        }
        if (vector3D2.dot(vector3D) < 0.0) {
            vector3D2 = vector3D2.negated();
        }
        double[] dArray = new double[]{vector3D.x, vector3D.y, vector3D.z};
        double[] dArray2 = dT.multiply(dArray);
        Vector3D vector3D3 = new Vector3D(dArray2).normalized();
        Vector3D vector3D4 = vector3D.scaled(1.0 - this.g).plus(vector3D3.scaled(this.g));
        Vector3D vector3D5 = vector3D2.scaled(this.f[n][n2][n3]).plus(vector3D4.scaled(1.0 - this.f[n][n2][n3]));
        return vector3D5.normalized();
    }

    @Override
    public Vector3D getTrackingDirection(Point3D point3D, int n, boolean bl) {
        int n2 = (int)(point3D.x / this.xVoxelDim);
        int n3 = (int)(point3D.y / this.yVoxelDim);
        int n4 = (int)(point3D.z / this.zVoxelDim);
        Vector3D[] vector3DArray = this.image.getPDs(n2, n3, n4);
        if (bl) {
            return vector3DArray[n];
        }
        return vector3DArray[n].negated();
    }
}

