/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import imaging.ImageHeader;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import misc.LoggedException;
import numerics.Point3D;
import numerics.RealMatrix;
import tractography.Tract;

public final class TractSource {
    private static Logger logger = Logger.getLogger("camino.tractography.TractSource");
    private final DataInputStream din;
    private Tract nextTract = null;
    private boolean reachedEndOfFile;
    private boolean noMoreTracts;
    private final RealMatrix physToVoxTransform;
    private final boolean transformToCaminoSpace;
    private final double xVoxelDim;
    private final double yVoxelDim;
    private final double zVoxelDim;

    public TractSource(String string) {
        this(string, null);
    }

    public TractSource(String string, ImageHeader imageHeader) {
        int n = 0x1800000;
        if (imageHeader != null) {
            this.transformToCaminoSpace = true;
            this.physToVoxTransform = imageHeader.getPhysicalToVoxelTransform();
            this.xVoxelDim = imageHeader.xVoxelDim();
            this.yVoxelDim = imageHeader.yVoxelDim();
            this.zVoxelDim = imageHeader.zVoxelDim();
        } else {
            this.transformToCaminoSpace = false;
            this.physToVoxTransform = null;
            this.xVoxelDim = 0.0;
            this.yVoxelDim = 0.0;
            this.zVoxelDim = 0.0;
        }
        try {
            if (string == null) {
                this.din = new DataInputStream(new BufferedInputStream(System.in, n));
                logger.info("reading data from standard input");
            } else if (string.endsWith(".gz")) {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.din = new DataInputStream(new GZIPInputStream(new BufferedInputStream(fileInputStream, n)));
            } else {
                FileInputStream fileInputStream = new FileInputStream(string);
                this.din = new DataInputStream(new BufferedInputStream(fileInputStream, n));
            }
        }
        catch (IOException iOException) {
            throw new LoggedException(iOException);
        }
        this.init();
    }

    private void init() {
        this.reachedEndOfFile = false;
        this.noMoreTracts = false;
        try {
            this.readNextTract();
            if (this.reachedEndOfFile) {
                this.noMoreTracts = true;
                throw new LoggedException("Input contains no tracts");
            }
        }
        catch (Exception exception) {
            throw new LoggedException(exception);
        }
    }

    private void readNextTract() {
        this.nextTract = this.readTractFromRaw();
    }

    private Tract readTractFromRaw() {
        boolean bl = true;
        try {
            int n;
            Tract tract = new Tract(100, 100.0);
            Tract tract2 = new Tract(100, 100.0);
            int n2 = (int)this.din.readFloat();
            bl = false;
            int n3 = (int)this.din.readFloat();
            Point3D[] point3DArray = new Point3D[n2];
            for (n = 0; n < n2; ++n) {
                double d = this.din.readFloat();
                double d2 = this.din.readFloat();
                double d3 = this.din.readFloat();
                point3DArray[n] = new Point3D(d, d2, d3);
            }
            bl = true;
            for (n = n3; n >= 0; --n) {
                tract.addPoint(point3DArray[n]);
            }
            for (n = n3; n < n2; ++n) {
                tract2.addPoint(point3DArray[n]);
            }
            tract2.joinTract(tract);
            return tract2;
        }
        catch (Exception exception) {
            if (exception instanceof EOFException) {
                if (!bl) {
                    throw new LoggedException("EOF before whole tract was read");
                }
                this.reachedEndOfFile = true;
                return null;
            }
            throw new LoggedException("Unexpected " + exception + " . Check that input is in RAW format");
        }
    }

    public Tract nextTract() {
        if (this.noMoreTracts) {
            throw new LoggedException("No more tracts in input");
        }
        Tract tract = this.nextTract;
        this.readNextTract();
        if (this.reachedEndOfFile) {
            this.noMoreTracts = true;
        }
        if (this.transformToCaminoSpace) {
            tract.transformToCaminoSpace(this.physToVoxTransform, this.xVoxelDim, this.yVoxelDim, this.zVoxelDim);
        }
        return tract;
    }

    public boolean more() {
        return !this.noMoreTracts;
    }
}

