/*
 * Decompiled with CFR 0.152.
 */
package tractography;

import java.io.DataOutputStream;
import java.io.IOException;
import numerics.Point3D;
import numerics.Vector3D;
import tractography.Tract;
import tractography.Voxel;

public class VoxelList {
    private final Voxel[] voxels;
    private final int seedPointIndex;
    private final int size;
    private final short[] tangentAtSeed;
    private final short[] negTangentAtSeed;
    private double xVoxelDim;
    private double yVoxelDim;
    private double zVoxelDim;

    public VoxelList(Voxel[] voxelArray, int n, double d, double d2, double d3, Vector3D vector3D, Vector3D vector3D2) {
        this.voxels = voxelArray;
        this.size = voxelArray.length;
        this.seedPointIndex = n;
        this.xVoxelDim = d;
        this.yVoxelDim = d2;
        this.zVoxelDim = d3;
        this.tangentAtSeed = this.vectorToShort(vector3D.normalized());
        this.negTangentAtSeed = this.vectorToShort(vector3D2.normalized());
    }

    public Voxel getVoxel(int n) {
        return this.voxels[n];
    }

    public int seedPointIndex() {
        return this.seedPointIndex;
    }

    public int size() {
        return this.size;
    }

    public Voxel[] getVoxels() {
        Voxel[] voxelArray = new Voxel[this.size];
        System.arraycopy(this.voxels, 0, voxelArray, 0, this.size);
        return voxelArray;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Number of voxels: " + this.size + "\n");
        stringBuffer.append("seed voxel: " + this.seedPointIndex + "\n");
        stringBuffer.append("Voxels:\n");
        for (int i = 0; i < this.size; ++i) {
            stringBuffer.append(this.voxels[i].x);
            stringBuffer.append(" ");
            stringBuffer.append(this.voxels[i].y);
            stringBuffer.append(" ");
            stringBuffer.append(this.voxels[i].z);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public Tract toTract() {
        Point3D point3D;
        int n;
        Tract tract = new Tract(this.size / 2 + 1, 100.0);
        Tract tract2 = new Tract(this.size / 2 + 1, 100.0);
        Point3D point3D2 = new Point3D(((double)this.voxels[this.seedPointIndex].x + 0.5) * this.xVoxelDim, ((double)this.voxels[this.seedPointIndex].y + 0.5) * this.yVoxelDim, ((double)this.voxels[this.seedPointIndex].z + 0.5) * this.zVoxelDim);
        Vector3D vector3D = new Vector3D(this.tangentAtSeed[0], this.tangentAtSeed[1], this.tangentAtSeed[2]).normalized();
        Vector3D vector3D2 = new Vector3D(this.negTangentAtSeed[0], this.negTangentAtSeed[1], this.negTangentAtSeed[2]).normalized();
        tract.addPoint(point3D2);
        tract.addPoint(point3D2.displace(vector3D2.scaled(0.01)));
        tract2.addPoint(point3D2);
        tract2.addPoint(point3D2.displace(vector3D.scaled(0.01)));
        for (n = this.seedPointIndex - 1; n >= 0; --n) {
            point3D = new Point3D(((double)this.voxels[n].x + 0.5) * this.xVoxelDim, ((double)this.voxels[n].y + 0.5) * this.yVoxelDim, ((double)this.voxels[n].z + 0.5) * this.zVoxelDim);
            tract.addPoint(point3D);
        }
        for (n = this.seedPointIndex + 1; n < this.size; ++n) {
            point3D = new Point3D(((double)this.voxels[n].x + 0.5) * this.xVoxelDim, ((double)this.voxels[n].y + 0.5) * this.yVoxelDim, ((double)this.voxels[n].z + 0.5) * this.zVoxelDim);
            tract2.addPoint(point3D);
        }
        tract2.joinTract(tract);
        return tract2;
    }

    public void writeVoxelList(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort((short)this.voxels.length);
        dataOutputStream.writeShort((short)this.seedPointIndex);
        dataOutputStream.writeShort(this.tangentAtSeed[0]);
        dataOutputStream.writeShort(this.tangentAtSeed[1]);
        dataOutputStream.writeShort(this.tangentAtSeed[2]);
        dataOutputStream.writeShort(this.negTangentAtSeed[0]);
        dataOutputStream.writeShort(this.negTangentAtSeed[1]);
        dataOutputStream.writeShort(this.negTangentAtSeed[2]);
        for (int i = 0; i < this.voxels.length; ++i) {
            dataOutputStream.writeShort((short)this.voxels[i].x);
            dataOutputStream.writeShort((short)this.voxels[i].y);
            dataOutputStream.writeShort((short)this.voxels[i].z);
        }
    }

    private short[] vectorToShort(Vector3D vector3D) {
        double d = vector3D.x;
        double d2 = vector3D.y;
        double d3 = vector3D.z;
        if (d > 1.0) {
            d = 1.0;
        } else if (d < -1.0) {
            d = -1.0;
        }
        if (d2 > 1.0) {
            d2 = 1.0;
        } else if (d2 < -1.0) {
            d2 = -1.0;
        }
        if (d3 > 1.0) {
            d3 = 1.0;
        } else if (d3 < -1.0) {
            d3 = -1.0;
        }
        return new short[]{(short)(32767.0 * d), (short)(32767.0 * d2), (short)(32767.0 * d3)};
    }

    public double[] getVoxelDims() {
        return new double[]{this.xVoxelDim, this.yVoxelDim, this.zVoxelDim};
    }
}

