/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.discreet;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.j3d.io.BlockDataInputStream;
import org.j3d.loaders.discreet.CameraBlock;
import org.j3d.loaders.discreet.ColorData;
import org.j3d.loaders.discreet.FalloffData;
import org.j3d.loaders.discreet.FieldOfViewData;
import org.j3d.loaders.discreet.HotspotData;
import org.j3d.loaders.discreet.KeyframeAmbientBlock;
import org.j3d.loaders.discreet.KeyframeBlock;
import org.j3d.loaders.discreet.KeyframeCameraBlock;
import org.j3d.loaders.discreet.KeyframeCameraTargetBlock;
import org.j3d.loaders.discreet.KeyframeColorBlock;
import org.j3d.loaders.discreet.KeyframeFOVBlock;
import org.j3d.loaders.discreet.KeyframeFalloffBlock;
import org.j3d.loaders.discreet.KeyframeFrameBlock;
import org.j3d.loaders.discreet.KeyframeHotspotBlock;
import org.j3d.loaders.discreet.KeyframeLightBlock;
import org.j3d.loaders.discreet.KeyframeMorphBlock;
import org.j3d.loaders.discreet.KeyframePositionBlock;
import org.j3d.loaders.discreet.KeyframeRollBlock;
import org.j3d.loaders.discreet.KeyframeRotationBlock;
import org.j3d.loaders.discreet.KeyframeScaleBlock;
import org.j3d.loaders.discreet.KeyframeSpotlightBlock;
import org.j3d.loaders.discreet.KeyframeSpotlightTargetBlock;
import org.j3d.loaders.discreet.KeyframeTag;
import org.j3d.loaders.discreet.LightBlock;
import org.j3d.loaders.discreet.MaterialBlock;
import org.j3d.loaders.discreet.MaterialData;
import org.j3d.loaders.discreet.MorphData;
import org.j3d.loaders.discreet.NodeHeaderData;
import org.j3d.loaders.discreet.ObjectBlock;
import org.j3d.loaders.discreet.ObjectMesh;
import org.j3d.loaders.discreet.PositionData;
import org.j3d.loaders.discreet.RollData;
import org.j3d.loaders.discreet.RotationData;
import org.j3d.loaders.discreet.ScaleData;
import org.j3d.loaders.discreet.TextureBlock;
import org.j3d.loaders.discreet.TrackData;
import org.j3d.loaders.discreet.TriangleMesh;

public class MaxParser {
    private BlockDataInputStream inputStream;
    private boolean dataReady = false;
    private ObjectMesh decodedMesh;
    private int releaseVersion;

    public MaxParser() {
    }

    public MaxParser(InputStream inputStream) {
        this();
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.inputStream = new BlockDataInputStream((InputStream)bufferedInputStream);
    }

    public void reset(InputStream inputStream) {
        BufferedInputStream bufferedInputStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.inputStream = new BlockDataInputStream((InputStream)bufferedInputStream);
        this.decodedMesh = null;
        this.dataReady = false;
    }

    public ObjectMesh getObjectMesh() {
        return this.decodedMesh;
    }

    public ObjectMesh parse() throws IOException {
        if (this.dataReady) {
            throw new IOException("Data has already been read from this stream");
        }
        this.parseMain();
        this.dataReady = true;
        return this.decodedMesh;
    }

    private void parseMain() throws IOException {
        int n = this.readUnsignedShort();
        int n2 = this.readInt();
        if (n != 19789) {
            throw new IOException("Wrong main chunk in file");
        }
        ObjectMesh objectMesh = new ObjectMesh();
        this.readMain(n2 - 6, objectMesh);
        this.decodedMesh = objectMesh;
    }

    private void readMain(int n, ObjectMesh objectMesh) throws IOException {
        int n2;
        int n3;
        block5: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 2: {
                    this.releaseVersion = objectMesh.meshVersion = this.readInt();
                    continue block5;
                }
                case 15677: {
                    this.readMeshChunk(n3 - 6, objectMesh);
                    continue block5;
                }
                case 45056: {
                    this.readKeyframeChunk(n3 - 6, objectMesh);
                    continue block5;
                }
                default: {
                    System.out.println("Unknown top-level block chunk ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for main mesh. Read: " + n2 + " required " + n);
        }
    }

    private void readMeshChunk(int n, ObjectMesh objectMesh) throws IOException {
        int n2;
        int n3;
        block21: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 16384: {
                    this.readObjectBlock(n3 - 6, objectMesh);
                    continue block21;
                }
                case 45055: {
                    this.readMaterialBlock(n3 - 6, objectMesh);
                    continue block21;
                }
                case 256: {
                    objectMesh.masterScale = this.readFloat();
                    continue block21;
                }
                case 15678: {
                    objectMesh.meshVersion = this.readInt();
                    continue block21;
                }
                case 8448: {
                    objectMesh.ambientLight = new float[3];
                    int n5 = this.readColor(objectMesh.ambientLight);
                    if (n3 - n5 - 6 == 0) continue block21;
                    this.skipBytes(n3 - n5 - 6);
                    continue block21;
                }
                case 5120: 
                case 5136: 
                case 5152: 
                case 5168: 
                case 5184: 
                case 5200: 
                case 5216: 
                case 5376: 
                case 28672: 
                case 28673: 
                case 28720: {
                    this.skipBytes(n3 - 6);
                    continue block21;
                }
                case 4352: {
                    objectMesh.backgroundBitmap = this.readString();
                    continue block21;
                }
                case 4608: {
                    objectMesh.solidBackgroundColor = new float[3];
                    int n5 = this.readColor(objectMesh.solidBackgroundColor);
                    if (n3 - n5 - 6 == 0) continue block21;
                    this.readColor(objectMesh.solidBackgroundColor);
                    continue block21;
                }
                case 4864: {
                    objectMesh.backgroundMidpoint = this.readFloat();
                    objectMesh.gradientBackgroundColors = new float[3][3];
                    int n5 = this.readColor(objectMesh.gradientBackgroundColors[0]);
                    n5 += this.readColor(objectMesh.gradientBackgroundColors[1]);
                    if (n3 - (n5 += this.readColor(objectMesh.gradientBackgroundColors[2])) - 6 - 4 == 0) continue block21;
                    objectMesh.gradientBackgroundColors[0] = objectMesh.gradientBackgroundColors[1];
                    this.readColor(objectMesh.gradientBackgroundColors[1]);
                    this.readColor(objectMesh.gradientBackgroundColors[2]);
                    this.readColor(objectMesh.gradientBackgroundColors[2]);
                    continue block21;
                }
                case 4865: {
                    objectMesh.selectedBackground = 2;
                    continue block21;
                }
                case 4609: {
                    objectMesh.selectedBackground = 4;
                    continue block21;
                }
                case 4353: {
                    objectMesh.selectedBackground = 1;
                    continue block21;
                }
                case 8704: {
                    objectMesh.linearFogDetails = new float[4];
                    objectMesh.fogColor = new float[3];
                    objectMesh.linearFogDetails[0] = this.readFloat();
                    objectMesh.linearFogDetails[1] = this.readFloat();
                    objectMesh.linearFogDetails[2] = this.readFloat();
                    objectMesh.linearFogDetails[3] = this.readFloat();
                    int n5 = this.readColor(objectMesh.fogColor);
                    if (n3 - n5 - 16 - 6 == 0) continue block21;
                    this.readUnsignedShort();
                    this.readInt();
                    objectMesh.fogBackground = true;
                    continue block21;
                }
                case 8962: {
                    objectMesh.layerFogDetails = new float[4];
                    objectMesh.fogColor = new float[3];
                    objectMesh.layerFogDetails[0] = this.readFloat();
                    objectMesh.layerFogDetails[1] = this.readFloat();
                    objectMesh.layerFogDetails[2] = this.readFloat();
                    objectMesh.layerFogFlags = this.readInt();
                    this.readColor(objectMesh.fogColor);
                    continue block21;
                }
                case 8960: {
                    objectMesh.distanceFogDetails = new float[4];
                    objectMesh.distanceFogDetails[0] = this.readFloat();
                    objectMesh.distanceFogDetails[1] = this.readFloat();
                    objectMesh.distanceFogDetails[2] = this.readFloat();
                    objectMesh.distanceFogDetails[3] = this.readFloat();
                    if (n3 - 16 - 6 == 0) continue block21;
                    this.readUnsignedShort();
                    this.readInt();
                    objectMesh.fogBackground = true;
                    continue block21;
                }
                case 8705: {
                    objectMesh.selectedFog = 1;
                    continue block21;
                }
                case 8963: {
                    objectMesh.selectedFog = 2;
                    continue block21;
                }
                case 8961: {
                    objectMesh.selectedFog = 4;
                    continue block21;
                }
                case 12288: {
                    this.skipBytes(n3 - 6);
                    continue block21;
                }
                default: {
                    System.out.println("Unknown mesh chunk ID 0x" + Integer.toHexString(n4) + " size " + n3);
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for mesh chunk. Read: " + n2 + " required " + n);
        }
    }

    private void readObjectBlock(int n, ObjectMesh objectMesh) throws IOException {
        int n2;
        int n3;
        ObjectBlock[] objectBlockArray;
        if (objectMesh.blocks.length == objectMesh.numBlocks) {
            objectBlockArray = new ObjectBlock[objectMesh.numBlocks + 8];
            System.arraycopy(objectMesh.blocks, 0, objectBlockArray, 0, objectMesh.numBlocks);
            objectMesh.blocks = objectBlockArray;
        }
        objectMesh.blocks[objectMesh.numBlocks] = objectBlockArray = new ObjectBlock();
        ++objectMesh.numBlocks;
        objectBlockArray.name = this.readString();
        block6: for (n2 = objectBlockArray.name.length() + 1; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 16640: {
                    this.readTriMesh(n3 - 6, (ObjectBlock)objectBlockArray);
                    continue block6;
                }
                case 17920: {
                    this.readLightBlock(n3 - 6, (ObjectBlock)objectBlockArray);
                    continue block6;
                }
                case 18176: {
                    this.readCameraBlock(n3 - 6, (ObjectBlock)objectBlockArray);
                    continue block6;
                }
                case 16401: 
                case 16402: 
                case 16403: 
                case 16404: 
                case 16405: 
                case 16406: 
                case 16407: {
                    continue block6;
                }
                default: {
                    System.out.println("Unknown object block chunk ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for object block. Read: " + n2 + " required " + n);
        }
    }

    private void readTriMesh(int n, ObjectBlock objectBlock) throws IOException {
        int n2;
        int n3;
        TriangleMesh[] triangleMeshArray;
        if (objectBlock.meshes.length == objectBlock.numMeshes) {
            triangleMeshArray = new TriangleMesh[objectBlock.numMeshes + 8];
            System.arraycopy(objectBlock.meshes, 0, triangleMeshArray, 0, objectBlock.numMeshes);
            objectBlock.meshes = triangleMeshArray;
        }
        objectBlock.meshes[objectBlock.numMeshes] = triangleMeshArray = new TriangleMesh();
        ++objectBlock.numMeshes;
        block8: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 16656: {
                    int n5;
                    triangleMeshArray.numVertices = this.readUnsignedShort();
                    triangleMeshArray.vertices = new float[triangleMeshArray.numVertices * 3];
                    for (n5 = 0; n5 < triangleMeshArray.numVertices; ++n5) {
                        this.readPoint(triangleMeshArray.vertices, n5 * 3);
                    }
                    continue block8;
                }
                case 16704: {
                    int n5;
                    triangleMeshArray.numTexCoords = this.readUnsignedShort();
                    triangleMeshArray.texCoords = new float[triangleMeshArray.numTexCoords * 2];
                    for (n5 = 0; n5 < triangleMeshArray.numTexCoords; ++n5) {
                        triangleMeshArray.texCoords[n5 * 2] = this.readFloat();
                        triangleMeshArray.texCoords[n5 * 2 + 1] = this.readFloat();
                    }
                    continue block8;
                }
                case 16736: {
                    int n5;
                    triangleMeshArray.localCoords = new float[12];
                    for (n5 = 0; n5 < 12; ++n5) {
                        triangleMeshArray.localCoords[n5] = this.readFloat();
                    }
                    continue block8;
                }
                case 16672: {
                    this.readFaceList(n3 - 6, (TriangleMesh)triangleMeshArray);
                    continue block8;
                }
                case 16784: {
                    triangleMeshArray.boxMapMaterials = new String[6];
                    triangleMeshArray.boxMapMaterials[0] = this.readString();
                    triangleMeshArray.boxMapMaterials[1] = this.readString();
                    triangleMeshArray.boxMapMaterials[2] = this.readString();
                    triangleMeshArray.boxMapMaterials[3] = this.readString();
                    triangleMeshArray.boxMapMaterials[4] = this.readString();
                    triangleMeshArray.boxMapMaterials[5] = this.readString();
                    continue block8;
                }
                case 16657: 
                case 16741: 
                case 16752: {
                    this.skipBytes(n3 - 6);
                    continue block8;
                }
                default: {
                    System.out.println("Unknown trimesh chunk ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for triangle mesh. Read: " + n2 + " required " + n);
        }
    }

    private void readFaceList(int n, TriangleMesh triangleMesh) throws IOException {
        int n2;
        int n3 = 0;
        triangleMesh.numFaces = this.readUnsignedShort();
        triangleMesh.faces = new int[triangleMesh.numFaces * 3];
        for (n2 = 0; n2 < triangleMesh.numFaces; ++n2) {
            triangleMesh.faces[n3++] = this.readUnsignedShort();
            triangleMesh.faces[n3++] = this.readUnsignedShort();
            triangleMesh.faces[n3++] = this.readUnsignedShort();
            this.readUnsignedShort();
        }
        n2 = triangleMesh.numFaces * 2 * 4 + 2;
        if (n2 < n) {
            while (n2 < n) {
                int n4 = this.readUnsignedShort();
                int n5 = this.readInt();
                switch (n4) {
                    case 16720: {
                        triangleMesh.smoothgroups = new int[triangleMesh.numFaces];
                        for (int i = 0; i < triangleMesh.numFaces; ++i) {
                            triangleMesh.smoothgroups[i] = this.readInt();
                        }
                        break;
                    }
                    case 16688: {
                        this.readMaterialList(n5 - 6, triangleMesh);
                        break;
                    }
                    default: {
                        System.out.println("Unknown subface list ID 0x" + Integer.toHexString(n4));
                        this.skipBytes(n5 - 6);
                    }
                }
                n2 += n5;
            }
            if (n2 != n) {
                System.out.println("Incorrect bytes read from file for face chunk. Read: " + n2 + " required " + n);
            }
        }
    }

    private void readMaterialList(int n, TriangleMesh triangleMesh) throws IOException {
        int n2;
        Object object;
        if (triangleMesh.materials == null || triangleMesh.materials.length == triangleMesh.numMaterials) {
            object = new MaterialData[triangleMesh.numMaterials + 4];
            if (triangleMesh.numMaterials != 0) {
                System.arraycopy(triangleMesh.materials, 0, object, 0, triangleMesh.numMaterials);
            }
            triangleMesh.materials = object;
        }
        triangleMesh.materials[triangleMesh.numMaterials] = object = new MaterialData();
        ++triangleMesh.numMaterials;
        object.materialName = this.readString();
        object.numFaces = this.readUnsignedShort();
        object.faceList = new int[object.numFaces];
        for (n2 = 0; n2 < object.numFaces; ++n2) {
            object.faceList[n2] = this.readUnsignedShort();
        }
        n2 = object.materialName.length() + 1 + 2 + object.numFaces * 2;
        if (n != n2) {
            System.out.println("Incorrect bytes read from file for material list. Read: " + n2 + " required " + n);
        }
    }

    private void readLightBlock(int n, ObjectBlock objectBlock) throws IOException {
        Object object;
        if (objectBlock.lights == null || objectBlock.lights.length == objectBlock.numLights) {
            object = new LightBlock[objectBlock.numLights + 8];
            if (objectBlock.numLights != 0) {
                System.arraycopy(objectBlock.lights, 0, object, 0, objectBlock.numLights);
            }
            objectBlock.lights = object;
        }
        objectBlock.lights[objectBlock.numLights] = object = new LightBlock();
        ++objectBlock.numLights;
        this.readPoint(object.direction, 0);
        int n2 = this.readColor(object.color);
        n2 += 12;
        while (n2 < n) {
            int n3 = this.readUnsignedShort();
            int n4 = this.readInt();
            switch (n3) {
                case 17936: {
                    this.readSpotlightBlock(n4 - 6, (LightBlock)object);
                    break;
                }
                case 17952: {
                    object.enabled = false;
                    break;
                }
                case 17957: {
                    object.attenuation = this.readFloat();
                    break;
                }
                case 18009: {
                    object.innerRange = this.readFloat();
                    break;
                }
                case 18010: {
                    object.outerRange = this.readFloat();
                    break;
                }
                case 18011: {
                    object.multiple = this.readFloat();
                    break;
                }
                case 18004: {
                    this.readString();
                    break;
                }
                default: {
                    System.out.println("Unknown light block ID 0x" + Integer.toHexString(n3));
                    this.skipBytes(n4 - 6);
                }
            }
            n2 += n4;
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for lights chunk. Read: " + n2 + " required " + n);
        }
    }

    private void readSpotlightBlock(int n, LightBlock lightBlock) throws IOException {
        int n2;
        int n3;
        lightBlock.type = 2;
        lightBlock.target = new float[3];
        this.readPoint(lightBlock.target, 0);
        lightBlock.hotspotAngle = this.readFloat();
        lightBlock.falloffAngle = this.readFloat();
        block9: for (n2 = 20; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 18006: {
                    lightBlock.rollAngle = this.readFloat();
                    continue block9;
                }
                case 18007: {
                    lightBlock.aspectRatio = this.readFloat();
                    continue block9;
                }
                case 18000: {
                    lightBlock.seeCone = true;
                    continue block9;
                }
                case 17968: {
                    lightBlock.castsShadows = true;
                    continue block9;
                }
                case 17985: {
                    lightBlock.shadowParams = new float[2];
                    lightBlock.shadowParams[0] = this.readFloat();
                    lightBlock.shadowParams[1] = this.readFloat();
                    lightBlock.shadowMapSize = this.readUnsignedShort();
                    continue block9;
                }
                case 18008: {
                    this.skipBytes(n3 - 6);
                    continue block9;
                }
                case 17959: {
                    continue block9;
                }
                default: {
                    System.out.println("Unknown spotlight block ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for spotlight block. Read: " + n2 + " required " + n);
        }
    }

    private void readCameraBlock(int n, ObjectBlock objectBlock) throws IOException {
        int n2;
        int n3;
        Object object;
        if (objectBlock.cameras == null || objectBlock.cameras.length == objectBlock.numCameras) {
            object = new CameraBlock[objectBlock.numCameras + 8];
            if (objectBlock.numCameras != 0) {
                System.arraycopy(objectBlock.cameras, 0, object, 0, objectBlock.numCameras);
            }
            objectBlock.cameras = object;
        }
        objectBlock.cameras[objectBlock.numCameras] = object = new CameraBlock();
        ++objectBlock.numCameras;
        this.readPoint(object.location, 0);
        this.readPoint(object.target, 0);
        object.bankAngle = this.readFloat();
        object.focus = this.readFloat();
        block4: for (n2 = 32; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 18192: {
                    object.seeOutline = true;
                    continue block4;
                }
                case 18208: {
                    object.ranges = new float[2];
                    object.ranges[0] = this.readFloat();
                    object.ranges[1] = this.readFloat();
                    continue block4;
                }
                default: {
                    System.out.println("Unknown camera block ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for camera block. Read: " + n2 + " required " + n);
        }
    }

    private void readMaterialBlock(int n, ObjectMesh objectMesh) throws IOException {
        int n2;
        int n3;
        Object object;
        if (objectMesh.materials == null || objectMesh.materials.length == objectMesh.numMaterials) {
            object = new MaterialBlock[objectMesh.numMaterials + 8];
            if (objectMesh.numMaterials != 0) {
                System.arraycopy(objectMesh.materials, 0, object, 0, objectMesh.numMaterials);
            }
            objectMesh.materials = object;
        }
        objectMesh.materials[objectMesh.numMaterials] = object = new MaterialBlock();
        ++objectMesh.numMaterials;
        block16: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 40960: {
                    object.name = this.readString();
                    continue block16;
                }
                case 40976: {
                    object.ambientColor = new float[3];
                    int n5 = this.readColor(object.ambientColor);
                    if (n3 - n5 - 6 == 0) continue block16;
                    this.skipBytes(n3 - n5 - 6);
                    continue block16;
                }
                case 40992: {
                    object.diffuseColor = new float[3];
                    int n5 = this.readColor(object.diffuseColor);
                    if (n3 - n5 - 6 == 0) continue block16;
                    this.skipBytes(n3 - n5 - 6);
                    continue block16;
                }
                case 41008: {
                    object.specularColor = new float[3];
                    int n5 = this.readColor(object.specularColor);
                    if (n3 - n5 - 6 == 0) continue block16;
                    this.skipBytes(n3 - n5 - 6);
                    continue block16;
                }
                case 41024: {
                    object.shininessRatio = this.readPercentage();
                    continue block16;
                }
                case 41025: {
                    object.shininessStrength = this.readPercentage();
                    continue block16;
                }
                case 41093: {
                    object.wireframe = true;
                    continue block16;
                }
                case 41095: {
                    object.wireSize = this.readFloat();
                    continue block16;
                }
                case 41216: {
                    object.shadingType = this.readUnsignedShort();
                    continue block16;
                }
                case 41091: {
                    object.additiveBlend = true;
                    continue block16;
                }
                case 41040: {
                    object.transparency = this.readPercentage();
                    continue block16;
                }
                case 41089: {
                    object.twoSidedLighting = true;
                    continue block16;
                }
                case 41472: 
                case 41476: 
                case 41488: 
                case 41504: 
                case 41520: 
                case 41786: 
                case 41788: 
                case 41790: 
                case 41792: 
                case 41794: 
                case 41796: 
                case 41798: 
                case 41800: 
                case 41804: {
                    this.readTextureBlock(n3 - 6, (MaterialBlock)object, n4);
                    continue block16;
                }
                case 41042: 
                case 41043: 
                case 41088: 
                case 41092: 
                case 41098: 
                case 41100: 
                case 41552: 
                case 41760: 
                case 41761: 
                case 41762: 
                case 41764: 
                case 41765: 
                case 41766: 
                case 41768: 
                case 41770: 
                case 41772: 
                case 41774: 
                case 41776: 
                case 41778: 
                case 41780: 
                case 41782: 
                case 41784: {
                    this.skipBytes(n3 - 6);
                    continue block16;
                }
                default: {
                    System.out.println("Unknown material block chunk ID 0x" + Integer.toHexString(n4));
                    if (n4 == 0) continue block16;
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for material block. Read: " + n2 + " required " + n);
        }
    }

    private void readTextureBlock(int n, MaterialBlock materialBlock, int n2) throws IOException {
        int n3;
        int n4;
        TextureBlock textureBlock = new TextureBlock();
        block33: for (n3 = 0; n3 < n; n3 += n4) {
            int n5 = this.readUnsignedShort();
            n4 = this.readInt();
            switch (n5) {
                case 48: {
                    int n6 = this.readUnsignedShort();
                    textureBlock.strength = (float)n6 * 0.01f;
                    continue block33;
                }
                case 41728: {
                    textureBlock.filename = this.readString();
                    continue block33;
                }
                case 41809: {
                    textureBlock.tiling = this.readUnsignedShort();
                    continue block33;
                }
                case 41811: {
                    textureBlock.blurring = this.readFloat();
                    continue block33;
                }
                case 41812: {
                    textureBlock.uScale = this.readFloat();
                    continue block33;
                }
                case 41814: {
                    textureBlock.vScale = this.readFloat();
                    continue block33;
                }
                case 41816: {
                    textureBlock.uOffset = this.readFloat();
                    continue block33;
                }
                case 41818: {
                    textureBlock.vOffset = this.readFloat();
                    continue block33;
                }
                case 41820: {
                    textureBlock.angle = this.readFloat();
                    continue block33;
                }
                case 41824: {
                    textureBlock.blendColor1 = new float[3];
                    int n7 = this.inputStream.readUnsignedByte();
                    textureBlock.blendColor1[0] = (float)n7 * 0.0039215f;
                    n7 = this.inputStream.readUnsignedByte();
                    textureBlock.blendColor1[1] = (float)n7 * 0.0039215f;
                    n7 = this.inputStream.readUnsignedByte();
                    textureBlock.blendColor1[2] = (float)n7 * 0.0039215f;
                    continue block33;
                }
                case 41826: {
                    textureBlock.blendColor2 = new float[3];
                    int n7 = this.inputStream.readUnsignedByte();
                    textureBlock.blendColor2[0] = (float)n7 * 0.0039215f;
                    n7 = this.inputStream.readUnsignedByte();
                    textureBlock.blendColor2[1] = (float)n7 * 0.0039215f;
                    n7 = this.inputStream.readUnsignedByte();
                    textureBlock.blendColor2[2] = (float)n7 * 0.0039215f;
                    continue block33;
                }
                case 41828: {
                    textureBlock.redBlends = new float[3];
                    int n7 = this.inputStream.readUnsignedByte();
                    textureBlock.redBlends[0] = (float)n7 * 0.0039215f;
                    n7 = this.inputStream.readUnsignedByte();
                    textureBlock.redBlends[1] = (float)n7 * 0.0039215f;
                    n7 = this.inputStream.readUnsignedByte();
                    textureBlock.redBlends[2] = (float)n7 * 0.0039215f;
                    continue block33;
                }
                case 41830: {
                    textureBlock.greenBlends = new float[3];
                    int n7 = this.inputStream.readUnsignedByte();
                    textureBlock.greenBlends[0] = (float)n7 * 0.0039215f;
                    n7 = this.inputStream.readUnsignedByte();
                    textureBlock.greenBlends[1] = (float)n7 * 0.0039215f;
                    n7 = this.inputStream.readUnsignedByte();
                    textureBlock.greenBlends[2] = (float)n7 * 0.0039215f;
                    continue block33;
                }
                case 41832: {
                    textureBlock.blueBlends = new float[3];
                    int n7 = this.inputStream.readUnsignedByte();
                    textureBlock.blueBlends[0] = (float)n7 * 0.0039215f;
                    n7 = this.inputStream.readUnsignedByte();
                    textureBlock.blueBlends[1] = (float)n7 * 0.0039215f;
                    n7 = this.inputStream.readUnsignedByte();
                    textureBlock.blueBlends[2] = (float)n7 * 0.0039215f;
                    continue block33;
                }
                case 41554: {
                    textureBlock.bumpPercentage = this.readUnsignedShort();
                    continue block33;
                }
                default: {
                    System.out.println("Unknown texture block chunk ID 0x" + Integer.toHexString(n5));
                    this.skipBytes(n4 - 6);
                }
            }
        }
        if (n3 != n) {
            System.out.println("Incorrect bytes read from file for texture block. Read: " + n3 + " required " + n);
        }
        switch (n2) {
            case 41472: {
                materialBlock.textureMap1 = textureBlock;
                break;
            }
            case 41786: {
                materialBlock.textureMap2 = textureBlock;
                break;
            }
            case 41788: {
                materialBlock.shininessMap = textureBlock;
                break;
            }
            case 41476: {
                materialBlock.specularMap = textureBlock;
                break;
            }
            case 41488: {
                materialBlock.opacityMap = textureBlock;
                break;
            }
            case 41504: {
                materialBlock.reflectionMap = textureBlock;
                break;
            }
            case 41520: {
                materialBlock.bumpMap = textureBlock;
                break;
            }
            case 41790: {
                materialBlock.textureMask1 = textureBlock;
                break;
            }
            case 41792: {
                materialBlock.textureMask2 = textureBlock;
                break;
            }
            case 41798: {
                materialBlock.shininessMask = textureBlock;
                break;
            }
            case 41800: {
                materialBlock.specularMask = textureBlock;
                break;
            }
            case 41794: {
                materialBlock.opacityMask = textureBlock;
                break;
            }
            case 41804: {
                materialBlock.reflectionMask = textureBlock;
                break;
            }
            case 41796: {
                materialBlock.bumpMask = textureBlock;
            }
        }
    }

    private void readKeyframeChunk(int n, ObjectMesh objectMesh) throws IOException {
        int n2;
        int n3;
        Object object;
        if (objectMesh.keyframes == null || objectMesh.keyframes.length == objectMesh.numKeyframes) {
            object = new KeyframeBlock[objectMesh.numKeyframes + 8];
            if (objectMesh.numKeyframes != 0) {
                System.arraycopy(objectMesh.keyframes, 0, object, 0, objectMesh.numKeyframes);
            }
            objectMesh.keyframes = object;
        }
        objectMesh.keyframes[objectMesh.numKeyframes] = object = new KeyframeBlock();
        ++objectMesh.numKeyframes;
        block13: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 45066: {
                    object.revision = this.readUnsignedShort();
                    object.filename = this.readString();
                    object.animationLength = this.readInt();
                    continue block13;
                }
                case 45064: {
                    object.startFrame = this.readInt();
                    object.endFrame = this.readInt();
                    continue block13;
                }
                case 45065: {
                    object.currentFrame = this.readInt();
                    continue block13;
                }
                case 45058: {
                    this.readObjectNodeTag(n3 - 6, (KeyframeBlock)object);
                    continue block13;
                }
                case 45059: {
                    this.readCameraNodeTag(n3 - 6, (KeyframeBlock)object);
                    continue block13;
                }
                case 45060: {
                    this.readCameraTargetNodeTag(n3 - 6, (KeyframeBlock)object);
                    continue block13;
                }
                case 45061: {
                    this.readLightNodeTag(n3 - 6, (KeyframeBlock)object);
                    continue block13;
                }
                case 45063: {
                    this.readSpotlightNodeTag(n3 - 6, (KeyframeBlock)object);
                    continue block13;
                }
                case 45062: {
                    this.readSpotlightTargetNodeTag(n3 - 6, (KeyframeBlock)object);
                    continue block13;
                }
                case 45057: {
                    this.readAmbientNodeTag(n3 - 6, (KeyframeBlock)object);
                    continue block13;
                }
                case 28673: {
                    this.skipBytes(n3 - 6);
                    continue block13;
                }
                default: {
                    System.out.println("Unknown keyframe chunk ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for keyframe chunk. Read: " + n2 + " required " + n);
        }
    }

    private void readObjectNodeTag(int n, KeyframeBlock keyframeBlock) throws IOException {
        int n2;
        int n3;
        Object object;
        if (keyframeBlock.frames == null || keyframeBlock.frames.length == keyframeBlock.numFrames) {
            object = new KeyframeFrameBlock[keyframeBlock.numFrames + 8];
            if (keyframeBlock.numFrames != 0) {
                System.arraycopy(keyframeBlock.frames, 0, object, 0, keyframeBlock.numFrames);
            }
            keyframeBlock.frames = object;
        }
        keyframeBlock.frames[keyframeBlock.numFrames] = object = new KeyframeFrameBlock();
        ++keyframeBlock.numFrames;
        block13: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 45104: {
                    object.nodeId = this.readUnsignedShort();
                    continue block13;
                }
                case 45072: {
                    this.readNodeHeader(n3 - 6, (KeyframeTag)object);
                    continue block13;
                }
                case 45088: {
                    object.positions = new KeyframePositionBlock();
                    this.readPositionTag(n3 - 6, object.positions);
                    continue block13;
                }
                case 45089: {
                    object.rotations = new KeyframeRotationBlock();
                    this.readRotationTag(n3 - 6, object.rotations);
                    continue block13;
                }
                case 45090: {
                    object.scales = new KeyframeScaleBlock();
                    this.readScaleTag(n3 - 6, object.scales);
                    continue block13;
                }
                case 45094: {
                    object.morphs = new KeyframeMorphBlock();
                    this.readMorphTag(n3 - 6, object.morphs);
                    continue block13;
                }
                case 45073: {
                    object.instanceName = this.readString();
                    continue block13;
                }
                case 45076: {
                    this.readPoint(object.minBounds, 0);
                    this.readPoint(object.maxBounds, 0);
                    continue block13;
                }
                case 45075: {
                    this.readPoint(object.pivotPoint, 0);
                    continue block13;
                }
                case 45077: {
                    object.morphSmoothingAngle = this.readFloat();
                    continue block13;
                }
                case 32768: {
                    this.skipBytes(n3 - 6);
                    continue block13;
                }
                default: {
                    System.out.println("Unknown keyframe frame ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for keyframe frame. Read: " + n2 + " required " + n);
        }
    }

    private void readCameraNodeTag(int n, KeyframeBlock keyframeBlock) throws IOException {
        int n2;
        int n3;
        Object object;
        if (keyframeBlock.cameraInfo == null || keyframeBlock.cameraInfo.length == keyframeBlock.numCameras) {
            object = new KeyframeCameraBlock[keyframeBlock.numCameras + 8];
            if (keyframeBlock.numCameras != 0) {
                System.arraycopy(keyframeBlock.cameraInfo, 0, object, 0, keyframeBlock.numCameras);
            }
            keyframeBlock.cameraInfo = object;
        }
        keyframeBlock.cameraInfo[keyframeBlock.numCameras] = object = new KeyframeCameraBlock();
        ++keyframeBlock.numCameras;
        block7: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 45104: {
                    object.nodeId = this.readUnsignedShort();
                    continue block7;
                }
                case 45072: {
                    this.readNodeHeader(n3 - 6, (KeyframeTag)object);
                    continue block7;
                }
                case 45088: {
                    object.positions = new KeyframePositionBlock();
                    this.readPositionTag(n3 - 6, object.positions);
                    continue block7;
                }
                case 45091: {
                    object.fovs = new KeyframeFOVBlock();
                    this.readFieldOfViewTag(n3 - 6, object.fovs);
                    continue block7;
                }
                case 45092: {
                    object.rolls = new KeyframeRollBlock();
                    this.readRolloffTag(n3 - 6, object.rolls);
                    continue block7;
                }
                default: {
                    System.out.println("Unknown keyframe camera ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for keyframe camera. Read: " + n2 + " required " + n);
        }
    }

    private void readCameraTargetNodeTag(int n, KeyframeBlock keyframeBlock) throws IOException {
        int n2;
        int n3;
        Object object;
        if (keyframeBlock.cameraTargetInfo == null || keyframeBlock.cameraTargetInfo.length == keyframeBlock.numCameraTargets) {
            object = new KeyframeCameraTargetBlock[keyframeBlock.numCameraTargets + 8];
            if (keyframeBlock.numCameraTargets != 0) {
                System.arraycopy(keyframeBlock.cameraTargetInfo, 0, object, 0, keyframeBlock.numCameraTargets);
            }
            keyframeBlock.cameraTargetInfo = object;
        }
        keyframeBlock.cameraTargetInfo[keyframeBlock.numCameraTargets] = object = new KeyframeCameraTargetBlock();
        ++keyframeBlock.numCameraTargets;
        block5: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 45104: {
                    object.nodeId = this.readUnsignedShort();
                    continue block5;
                }
                case 45072: {
                    this.readNodeHeader(n3 - 6, (KeyframeTag)object);
                    continue block5;
                }
                case 45088: {
                    object.positions = new KeyframePositionBlock();
                    this.readPositionTag(n3 - 6, object.positions);
                    continue block5;
                }
                default: {
                    System.out.println("Unknown keyframe camera target ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for keyframe camera target. Read: " + n2 + " required " + n);
        }
    }

    private void readAmbientNodeTag(int n, KeyframeBlock keyframeBlock) throws IOException {
        int n2;
        int n3;
        Object object;
        if (keyframeBlock.ambientInfo == null || keyframeBlock.ambientInfo.length == keyframeBlock.numAmbients) {
            object = new KeyframeAmbientBlock[keyframeBlock.numAmbients + 8];
            if (keyframeBlock.numAmbients != 0) {
                System.arraycopy(keyframeBlock.ambientInfo, 0, object, 0, keyframeBlock.numAmbients);
            }
            keyframeBlock.ambientInfo = object;
        }
        keyframeBlock.ambientInfo[keyframeBlock.numAmbients] = object = new KeyframeAmbientBlock();
        ++keyframeBlock.numAmbients;
        block5: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 45104: {
                    object.nodeId = this.readUnsignedShort();
                    continue block5;
                }
                case 45072: {
                    this.readNodeHeader(n3 - 6, (KeyframeTag)object);
                    continue block5;
                }
                case 45093: {
                    object.colors = new KeyframeColorBlock();
                    this.readColorTag(n3 - 6, object.colors);
                    continue block5;
                }
                default: {
                    System.out.println("Unknown keyframe ambient ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for keyframe ambient. Read: " + n2 + " required " + n);
        }
    }

    private void readLightNodeTag(int n, KeyframeBlock keyframeBlock) throws IOException {
        int n2;
        int n3;
        Object object;
        if (keyframeBlock.lightInfo == null || keyframeBlock.lightInfo.length == keyframeBlock.numLights) {
            object = new KeyframeLightBlock[keyframeBlock.numLights + 8];
            if (keyframeBlock.numLights != 0) {
                System.arraycopy(keyframeBlock.lightInfo, 0, object, 0, keyframeBlock.numLights);
            }
            keyframeBlock.lightInfo = object;
        }
        keyframeBlock.lightInfo[keyframeBlock.numLights] = object = new KeyframeLightBlock();
        ++keyframeBlock.numLights;
        block6: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 45104: {
                    object.nodeId = this.readUnsignedShort();
                    continue block6;
                }
                case 45072: {
                    this.readNodeHeader(n3 - 6, (KeyframeTag)object);
                    continue block6;
                }
                case 45088: {
                    object.positions = new KeyframePositionBlock();
                    this.readPositionTag(n3 - 6, object.positions);
                    continue block6;
                }
                case 45093: {
                    object.colors = new KeyframeColorBlock();
                    this.readColorTag(n3 - 6, object.colors);
                    continue block6;
                }
                default: {
                    System.out.println("Unknown keyframe light ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for keyframe light. Read: " + n2 + " required " + n);
        }
    }

    private void readSpotlightNodeTag(int n, KeyframeBlock keyframeBlock) throws IOException {
        int n2;
        int n3;
        Object object;
        if (keyframeBlock.spotlightInfo == null || keyframeBlock.spotlightInfo.length == keyframeBlock.numSpotlights) {
            object = new KeyframeSpotlightBlock[keyframeBlock.numSpotlights + 8];
            if (keyframeBlock.numSpotlights != 0) {
                System.arraycopy(keyframeBlock.spotlightInfo, 0, object, 0, keyframeBlock.numSpotlights);
            }
            keyframeBlock.spotlightInfo = object;
        }
        keyframeBlock.spotlightInfo[keyframeBlock.numSpotlights] = object = new KeyframeSpotlightBlock();
        ++keyframeBlock.numSpotlights;
        block9: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 45104: {
                    object.nodeId = this.readUnsignedShort();
                    continue block9;
                }
                case 45072: {
                    this.readNodeHeader(n3 - 6, (KeyframeTag)object);
                    continue block9;
                }
                case 45088: {
                    object.positions = new KeyframePositionBlock();
                    this.readPositionTag(n3 - 6, object.positions);
                    continue block9;
                }
                case 45093: {
                    object.colors = new KeyframeColorBlock();
                    this.readColorTag(n3 - 6, object.colors);
                    continue block9;
                }
                case 45095: {
                    object.hotspots = new KeyframeHotspotBlock();
                    this.readHotspotTag(n3 - 6, object.hotspots);
                    continue block9;
                }
                case 45096: {
                    object.falloffs = new KeyframeFalloffBlock();
                    this.readFalloffTag(n3 - 6, object.falloffs);
                    continue block9;
                }
                case 45092: {
                    object.rolloffs = new KeyframeRollBlock();
                    this.readRolloffTag(n3 - 6, object.rolloffs);
                    continue block9;
                }
                default: {
                    System.out.println("Unknown keyframe spotlight ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for keyframe spotlight. Read: " + n2 + " required " + n);
        }
    }

    private void readSpotlightTargetNodeTag(int n, KeyframeBlock keyframeBlock) throws IOException {
        int n2;
        int n3;
        Object object;
        if (keyframeBlock.spotlightTargetInfo == null || keyframeBlock.spotlightTargetInfo.length == keyframeBlock.numSpotlightTargets) {
            object = new KeyframeSpotlightTargetBlock[keyframeBlock.numSpotlightTargets + 8];
            if (keyframeBlock.numSpotlightTargets != 0) {
                System.arraycopy(keyframeBlock.spotlightTargetInfo, 0, object, 0, keyframeBlock.numSpotlightTargets);
            }
            keyframeBlock.spotlightTargetInfo = object;
        }
        keyframeBlock.spotlightTargetInfo[keyframeBlock.numSpotlightTargets] = object = new KeyframeSpotlightTargetBlock();
        ++keyframeBlock.numSpotlightTargets;
        block5: for (n2 = 0; n2 < n; n2 += n3) {
            int n4 = this.readUnsignedShort();
            n3 = this.readInt();
            switch (n4) {
                case 45104: {
                    object.nodeId = this.readUnsignedShort();
                    continue block5;
                }
                case 45072: {
                    this.readNodeHeader(n3 - 6, (KeyframeTag)object);
                    continue block5;
                }
                case 45088: {
                    object.positions = new KeyframePositionBlock();
                    this.readPositionTag(n3 - 6, object.positions);
                    continue block5;
                }
                default: {
                    System.out.println("Unknown keyframe spotlight target ID 0x" + Integer.toHexString(n4));
                    this.skipBytes(n3 - 6);
                }
            }
        }
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for keyframe spotlight target. Read: " + n2 + " required " + n);
        }
    }

    private void readNodeHeader(int n, KeyframeTag keyframeTag) throws IOException {
        keyframeTag.nodeHeader = new NodeHeaderData();
        keyframeTag.nodeHeader.name = this.readString();
        keyframeTag.nodeHeader.flags1 = this.readUnsignedShort();
        keyframeTag.nodeHeader.flags2 = this.readUnsignedShort();
        keyframeTag.nodeHeader.heirarchyPosition = this.readUnsignedShort();
        int n2 = keyframeTag.nodeHeader.name.length() + 1 + 2 + 2 + 2;
        if (n2 != n) {
            System.out.println("Incorrect bytes read from file for keyframe node header. Read: " + n2 + " required " + n);
        }
    }

    private void readPositionTag(int n, KeyframePositionBlock keyframePositionBlock) throws IOException {
        keyframePositionBlock.flags = this.readUnsignedShort();
        this.readInt();
        this.readInt();
        keyframePositionBlock.numKeys = this.readInt();
        keyframePositionBlock.positions = new PositionData[keyframePositionBlock.numKeys];
        for (int i = 0; i < keyframePositionBlock.numKeys; ++i) {
            PositionData positionData;
            keyframePositionBlock.positions[i] = positionData = new PositionData();
            this.readTrackData(positionData);
            positionData.x = this.readFloat();
            positionData.z = this.readFloat();
            positionData.y = this.readFloat();
        }
    }

    private void readRotationTag(int n, KeyframeRotationBlock keyframeRotationBlock) throws IOException {
        keyframeRotationBlock.flags = this.readUnsignedShort();
        this.readInt();
        this.readInt();
        keyframeRotationBlock.numKeys = this.readInt();
        keyframeRotationBlock.rotations = new RotationData[keyframeRotationBlock.numKeys];
        for (int i = 0; i < keyframeRotationBlock.numKeys; ++i) {
            RotationData rotationData;
            keyframeRotationBlock.rotations[i] = rotationData = new RotationData();
            this.readTrackData(rotationData);
            rotationData.rotation = this.readFloat();
            rotationData.xAxis = this.readFloat();
            rotationData.zAxis = this.readFloat();
            rotationData.yAxis = this.readFloat();
        }
    }

    private void readScaleTag(int n, KeyframeScaleBlock keyframeScaleBlock) throws IOException {
        keyframeScaleBlock.flags = this.readUnsignedShort();
        this.readInt();
        this.readInt();
        keyframeScaleBlock.numKeys = this.readInt();
        keyframeScaleBlock.scales = new ScaleData[keyframeScaleBlock.numKeys];
        for (int i = 0; i < keyframeScaleBlock.numKeys; ++i) {
            ScaleData scaleData;
            keyframeScaleBlock.scales[i] = scaleData = new ScaleData();
            this.readTrackData(scaleData);
            scaleData.xScale = this.readFloat();
            scaleData.zScale = this.readFloat();
            scaleData.yScale = this.readFloat();
        }
    }

    private void readFieldOfViewTag(int n, KeyframeFOVBlock keyframeFOVBlock) throws IOException {
        keyframeFOVBlock.flags = this.readUnsignedShort();
        this.readInt();
        this.readInt();
        keyframeFOVBlock.numKeys = this.readInt();
        keyframeFOVBlock.fovs = new FieldOfViewData[keyframeFOVBlock.numKeys];
        for (int i = 0; i < keyframeFOVBlock.numKeys; ++i) {
            FieldOfViewData fieldOfViewData;
            keyframeFOVBlock.fovs[i] = fieldOfViewData = new FieldOfViewData();
            this.readTrackData(fieldOfViewData);
            fieldOfViewData.fov = this.readFloat();
        }
    }

    private void readRolloffTag(int n, KeyframeRollBlock keyframeRollBlock) throws IOException {
        keyframeRollBlock.flags = this.readUnsignedShort();
        this.readInt();
        this.readInt();
        keyframeRollBlock.numKeys = this.readInt();
        keyframeRollBlock.rolls = new RollData[keyframeRollBlock.numKeys];
        for (int i = 0; i < keyframeRollBlock.numKeys; ++i) {
            RollData rollData;
            keyframeRollBlock.rolls[i] = rollData = new RollData();
            this.readTrackData(rollData);
            rollData.roll = this.readFloat();
        }
    }

    private void readColorTag(int n, KeyframeColorBlock keyframeColorBlock) throws IOException {
        keyframeColorBlock.flags = this.readUnsignedShort();
        this.readInt();
        this.readInt();
        keyframeColorBlock.numKeys = this.readInt();
        keyframeColorBlock.colors = new ColorData[keyframeColorBlock.numKeys];
        for (int i = 0; i < keyframeColorBlock.numKeys; ++i) {
            ColorData colorData;
            keyframeColorBlock.colors[i] = colorData = new ColorData();
            this.readTrackData(colorData);
            colorData.red = this.readFloat();
            colorData.green = this.readFloat();
            colorData.blue = this.readFloat();
        }
    }

    private void readMorphTag(int n, KeyframeMorphBlock keyframeMorphBlock) throws IOException {
        keyframeMorphBlock.flags = this.readUnsignedShort();
        this.readInt();
        this.readInt();
        keyframeMorphBlock.numKeys = this.readInt();
        keyframeMorphBlock.morphs = new MorphData[keyframeMorphBlock.numKeys];
        int n2 = 14;
        for (int i = 0; i < keyframeMorphBlock.numKeys; ++i) {
            MorphData morphData;
            keyframeMorphBlock.morphs[i] = morphData = new MorphData();
            this.readTrackData(morphData);
            morphData.objectName = this.readString();
            n2 += morphData.objectName.length() + 1;
        }
    }

    private void readHotspotTag(int n, KeyframeHotspotBlock keyframeHotspotBlock) throws IOException {
        keyframeHotspotBlock.flags = this.readUnsignedShort();
        this.readInt();
        this.readInt();
        keyframeHotspotBlock.numKeys = this.readInt();
        keyframeHotspotBlock.hotspots = new HotspotData[keyframeHotspotBlock.numKeys];
        for (int i = 0; i < keyframeHotspotBlock.numKeys; ++i) {
            HotspotData hotspotData;
            keyframeHotspotBlock.hotspots[i] = hotspotData = new HotspotData();
            this.readTrackData(hotspotData);
            hotspotData.angle = this.readFloat();
        }
    }

    private void readFalloffTag(int n, KeyframeFalloffBlock keyframeFalloffBlock) throws IOException {
        keyframeFalloffBlock.flags = this.readUnsignedShort();
        this.readInt();
        this.readInt();
        keyframeFalloffBlock.numKeys = this.readInt();
        keyframeFalloffBlock.falloffs = new FalloffData[keyframeFalloffBlock.numKeys];
        for (int i = 0; i < keyframeFalloffBlock.numKeys; ++i) {
            FalloffData falloffData;
            keyframeFalloffBlock.falloffs[i] = falloffData = new FalloffData();
            this.readTrackData(falloffData);
            falloffData.angle = this.readFloat();
        }
    }

    private int readTrackData(TrackData trackData) throws IOException {
        trackData.frameNumber = this.readInt();
        trackData.splineFlags = this.readUnsignedShort();
        int n = 6;
        if (trackData.splineFlags != 0) {
            trackData.splineData = new float[5];
            if ((trackData.splineFlags & 1) != 0) {
                n += 4;
                trackData.splineData[0] = this.readFloat();
            }
            if ((trackData.splineFlags & 2) != 0) {
                n += 4;
                trackData.splineData[1] = this.readFloat();
            }
            if ((trackData.splineFlags & 4) != 0) {
                n += 4;
                trackData.splineData[2] = this.readFloat();
            }
            if ((trackData.splineFlags & 8) != 0) {
                n += 4;
                trackData.splineData[3] = this.readFloat();
            }
            if ((trackData.splineFlags & 0x10) != 0) {
                n += 4;
                trackData.splineData[4] = this.readFloat();
            }
        }
        return n;
    }

    private float readPercentage() throws IOException {
        int n = this.readUnsignedShort();
        int n2 = this.readInt();
        float f = 0.0f;
        switch (n) {
            case 48: {
                int n3 = this.readUnsignedShort();
                f = (float)n3 * 0.01f;
                break;
            }
            case 49: {
                f = this.readFloat();
                break;
            }
            default: {
                System.out.println("Unknown percentage chunk ID 0x" + Integer.toHexString(n));
                this.skipBytes(n2 - 6);
            }
        }
        return f;
    }

    private void readPoint(float[] fArray, int n) throws IOException {
        fArray[n] = this.readFloat();
        fArray[n + 2] = this.readFloat();
        fArray[n + 1] = this.readFloat();
    }

    private int readColor(float[] fArray) throws IOException {
        int n = this.readUnsignedShort();
        int n2 = this.readInt();
        switch (n) {
            case 16: 
            case 19: {
                fArray[0] = this.readFloat();
                fArray[1] = this.readFloat();
                fArray[2] = this.readFloat();
                break;
            }
            case 17: 
            case 18: {
                int n3 = this.inputStream.readUnsignedByte();
                fArray[0] = (float)n3 * 0.0039215f;
                n3 = this.inputStream.readUnsignedByte();
                fArray[1] = (float)n3 * 0.0039215f;
                n3 = this.inputStream.readUnsignedByte();
                fArray[2] = (float)n3 * 0.0039215f;
                break;
            }
            default: {
                System.out.println("Unknown colour chunk ID 0x" + Integer.toHexString(n));
                this.skipBytes(n2 - 6);
            }
        }
        return n2;
    }

    private String readString() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = (char)this.inputStream.readByte();
        while (c != '\u0000' && c >= '\u0000') {
            stringBuffer.append(c);
            c = (char)this.inputStream.readByte();
        }
        return stringBuffer.toString();
    }

    private int readInt() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.inputStream.readUnsignedByte();
        if ((n4 | (n3 = this.inputStream.readUnsignedByte()) | (n2 = this.inputStream.readUnsignedByte()) | (n = this.inputStream.readUnsignedByte())) < 0) {
            throw new EOFException();
        }
        return n4 + (n3 << 8) + (n2 << 16) + (n << 24);
    }

    private int readUnsignedShort() throws IOException {
        int n;
        int n2 = this.inputStream.readUnsignedByte();
        if ((n2 | (n = this.inputStream.readUnsignedByte())) < 0) {
            throw new EOFException();
        }
        return n2 + (n << 8);
    }

    private float readFloat() throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = this.inputStream.readUnsignedByte();
        if ((n4 | (n3 = this.inputStream.readUnsignedByte()) | (n2 = this.inputStream.readUnsignedByte()) | (n = this.inputStream.readUnsignedByte())) < 0) {
            throw new EOFException();
        }
        return Float.intBitsToFloat((n4 << 0) + (n3 << 8) + (n2 << 16) + (n << 24));
    }

    private void skipBytes(int n) throws IOException {
        if (n == 0) {
            return;
        }
        int n2 = (int)this.inputStream.skip((long)n);
        if (n2 != n) {
            int n3 = n2;
            while (n3 != n) {
                n3 = (int)((long)n3 + this.inputStream.skip((long)(n - n3)));
            }
        }
    }
}

