/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.jalopy.printer;

import antlr.collections.AST;
import de.hunsicker.jalopy.printer.AbstractPrinter;
import de.hunsicker.jalopy.printer.NodeWriter;
import de.hunsicker.jalopy.printer.OperatorPrinter;
import de.hunsicker.jalopy.printer.Printer;
import de.hunsicker.jalopy.printer.PrinterFactory;
import de.hunsicker.jalopy.storage.ConventionKeys;
import java.io.IOException;

final class PrefixOperatorPrinter
extends OperatorPrinter {
    private static final Printer INSTANCE = new PrefixOperatorPrinter();

    protected PrefixOperatorPrinter() {
    }

    public static final Printer getInstance() {
        return INSTANCE;
    }

    public void print(AST node, NodeWriter out) throws IOException {
        this.printCommentsBefore(node, out);
        out.print(node.getText(), node.getType());
        switch (node.getType()) {
            case 163: 
            case 164: {
                this.printSpace(out);
            }
        }
        AST child = node.getFirstChild();
        while (child != null) {
            PrinterFactory.create(child, out).print(child, out);
            child = child.getNextSibling();
        }
    }

    private void printSpace(NodeWriter out) throws IOException {
        if (AbstractPrinter.settings.getBoolean(ConventionKeys.SPACE_BEFORE_LOGICAL_NOT, false)) {
            out.print(" ", out.last);
        }
    }
}

