/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.lw3d.DebugOutput;
import java.io.IOException;
import java.io.StreamTokenizer;

class TextfileParser {
    static int WORD = -3;
    static int NUMBER = -2;
    int currentLevel = 3;
    static final int TRACE = 1;
    static final int VALUES = 2;
    static final int MISC = 4;
    static final int LINE_TRACE = 8;
    static final int NONE = 0;
    static final int EXCEPTION = 16;
    static final int TIME = 32;
    protected DebugOutput debugPrinter = new DebugOutput(16);
    char lineSeparatorChar = '\u0000';

    TextfileParser() {
        String string = System.getProperty("line.separator");
        this.lineSeparatorChar = string.charAt(0);
        this.debugOutputLn(2, "lineSeparatorChar = " + this.lineSeparatorChar);
    }

    protected void debugOutputLn(int n, String string) {
        if (string.equals("")) {
            this.debugPrinter.println(n, string);
        } else {
            this.debugPrinter.println(n, this.getClass().getName() + "::" + string);
        }
    }

    protected void debugOutput(int n, String string) {
        this.debugPrinter.print(n, string);
    }

    void skipUntilString(StreamTokenizer streamTokenizer, String string) throws ParsingErrorException {
        boolean bl = false;
        try {
            while (!bl) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype != WORD || !streamTokenizer.sval.equals(string)) continue;
                bl = true;
            }
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
    }

    double getNumber(StreamTokenizer streamTokenizer) throws ParsingErrorException, NumberFormatException {
        try {
            int n = streamTokenizer.nextToken();
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
        this.checkType(streamTokenizer, WORD);
        return Double.valueOf(streamTokenizer.sval);
    }

    String getString(StreamTokenizer streamTokenizer) throws ParsingErrorException {
        try {
            streamTokenizer.nextToken();
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
        this.checkType(streamTokenizer, WORD);
        return streamTokenizer.sval;
    }

    String getName(StreamTokenizer streamTokenizer) throws ParsingErrorException {
        String string = "";
        streamTokenizer.ordinaryChar(this.lineSeparatorChar);
        streamTokenizer.ordinaryChar(10);
        streamTokenizer.ordinaryChar(13);
        try {
            streamTokenizer.nextToken();
            while (streamTokenizer.ttype != this.lineSeparatorChar && streamTokenizer.ttype != 13 && streamTokenizer.ttype != 10) {
                if (streamTokenizer.ttype != 40 && streamTokenizer.ttype != 41) {
                    string = string + streamTokenizer.sval;
                }
                streamTokenizer.nextToken();
            }
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
        streamTokenizer.whitespaceChars(this.lineSeparatorChar, this.lineSeparatorChar);
        streamTokenizer.whitespaceChars(10, 10);
        streamTokenizer.whitespaceChars(13, 13);
        this.debugOutputLn(2, "name = " + string);
        return string;
    }

    void getAndCheckString(StreamTokenizer streamTokenizer, String string) throws ParsingErrorException {
        try {
            streamTokenizer.nextToken();
            this.checkString(streamTokenizer, string);
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
    }

    void checkString(StreamTokenizer streamTokenizer, String string) throws ParsingErrorException {
        if (streamTokenizer.ttype != -3 || !streamTokenizer.sval.equals(string)) {
            throw new ParsingErrorException("Bad String Token (wanted " + string + ", got " + streamTokenizer.sval + ": " + streamTokenizer.toString());
        }
    }

    void checkType(StreamTokenizer streamTokenizer, int n) throws ParsingErrorException {
        if (streamTokenizer.ttype != n) {
            throw new ParsingErrorException("Bad Type Token, Expected " + n + " and received" + streamTokenizer.ttype);
        }
    }

    void skip(StreamTokenizer streamTokenizer, String string, int n) throws ParsingErrorException {
        try {
            streamTokenizer.nextToken();
            this.checkString(streamTokenizer, string);
            int n2 = 0;
            while (n2 < n) {
                streamTokenizer.nextToken();
                ++n2;
            }
        }
        catch (IOException iOException) {
            throw new ParsingErrorException(iOException.getMessage());
        }
    }

    boolean isCurrentToken(StreamTokenizer streamTokenizer, String string) {
        if (streamTokenizer.ttype == WORD) {
            return streamTokenizer.sval.equals(string);
        }
        return false;
    }
}

