/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.behaviors.sensor;

import com.sun.j3d.utils.behaviors.sensor.SensorButtonListener;
import com.sun.j3d.utils.behaviors.sensor.SensorEvent;
import com.sun.j3d.utils.behaviors.sensor.SensorReadListener;
import com.sun.j3d.utils.timer.J3DTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;

public class SensorEventAgent {
    private long t0 = 0L;
    private Object source = null;
    private SensorEvent e = new SensorEvent();
    private List bindingsList = new ArrayList();
    private SensorBinding[] bindings = new SensorBinding[0];
    private boolean listsDirty = false;

    public SensorEventAgent(Object object) {
        this.source = object;
    }

    private SensorBinding getSensorBinding(Sensor sensor) {
        int n = 0;
        while (n < this.bindingsList.size()) {
            SensorBinding sensorBinding = (SensorBinding)this.bindingsList.get(n);
            if (sensorBinding.sensor == sensor) {
                return sensorBinding;
            }
            ++n;
        }
        return null;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, int n, SensorButtonListener sensorButtonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (n >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + n + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        SensorButtonListener[] sensorButtonListenerArray = new SensorButtonListener[sensorBinding.buttons.length];
        sensorButtonListenerArray[n] = sensorButtonListener;
        SensorButtonBinding sensorButtonBinding = new SensorButtonBinding(sensorButtonListenerArray, true);
        sensorBinding.buttonBindingsList.add(sensorButtonBinding);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListener(Sensor sensor, SensorButtonListener sensorButtonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        SensorButtonListener[] sensorButtonListenerArray = new SensorButtonListener[sensorBinding.buttons.length];
        int n = 0;
        while (n < sensorBinding.buttons.length) {
            sensorButtonListenerArray[n] = sensorButtonListener;
            ++n;
        }
        SensorButtonBinding sensorButtonBinding = new SensorButtonBinding(sensorButtonListenerArray, true);
        sensorBinding.buttonBindingsList.add(sensorButtonBinding);
        this.listsDirty = true;
    }

    public synchronized void addSensorButtonListeners(Sensor sensor, SensorButtonListener[] sensorButtonListenerArray) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        if (sensorBinding.buttons.length != sensorButtonListenerArray.length) {
            throw new IllegalArgumentException("\nbuttonListeners length " + sensorButtonListenerArray.length + " must equal sensor button count " + sensorBinding.buttons.length);
        }
        SensorButtonBinding sensorButtonBinding = new SensorButtonBinding(sensorButtonListenerArray, false);
        sensorBinding.buttonBindingsList.add(sensorButtonBinding);
        this.listsDirty = true;
    }

    public SensorButtonListener[] getSensorButtonListeners(Sensor sensor, int n) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        if (n >= sensor.getSensorButtonCount()) {
            throw new ArrayIndexOutOfBoundsException("\nbutton " + n + " >= sensor button count " + sensor.getSensorButtonCount());
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return null;
        }
        ArrayList<SensorButtonListener> arrayList = new ArrayList<SensorButtonListener>();
        int n2 = 0;
        while (n2 < sensorBinding.buttonBindingsList.size()) {
            SensorButtonBinding sensorButtonBinding = (SensorButtonBinding)sensorBinding.buttonBindingsList.get(n2);
            if (sensorButtonBinding.listeners[n] != null) {
                arrayList.add(sensorButtonBinding.listeners[n]);
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            return null;
        }
        return arrayList.toArray(new SensorButtonListener[arrayList.size()]);
    }

    private void removeSensorButtonListener(SensorBinding sensorBinding, SensorButtonListener sensorButtonListener) {
        Iterator iterator = sensorBinding.buttonBindingsList.iterator();
        while (iterator.hasNext()) {
            int n = 0;
            SensorButtonBinding sensorButtonBinding = (SensorButtonBinding)iterator.next();
            int n2 = 0;
            while (n2 < sensorButtonBinding.listeners.length) {
                if (sensorButtonBinding.listeners[n2] == sensorButtonListener) {
                    sensorButtonBinding.listeners[n2] = null;
                } else if (sensorButtonBinding.listeners[n2] != null) {
                    ++n;
                }
                ++n2;
            }
            if (n != 0) continue;
            iterator.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(Sensor sensor, SensorButtonListener sensorButtonListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return;
        }
        this.removeSensorButtonListener(sensorBinding, sensorButtonListener);
        if (sensorBinding.buttonBindingsList.size() == 0 && sensorBinding.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorButtonListener(SensorButtonListener sensorButtonListener) {
        Iterator iterator = this.bindingsList.iterator();
        while (iterator.hasNext()) {
            SensorBinding sensorBinding = (SensorBinding)iterator.next();
            this.removeSensorButtonListener(sensorBinding, sensorButtonListener);
            if (sensorBinding.buttonBindingsList.size() != 0 || sensorBinding.readBindingsList.size() != 0) continue;
            iterator.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void addSensorReadListener(Sensor sensor, SensorReadListener sensorReadListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            sensorBinding = new SensorBinding(sensor);
            this.bindingsList.add(sensorBinding);
        }
        sensorBinding.readBindingsList.add(sensorReadListener);
        this.listsDirty = true;
    }

    public SensorReadListener[] getSensorReadListeners(Sensor sensor) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return null;
        }
        if (sensorBinding.readBindingsList.size() == 0) {
            return null;
        }
        return sensorBinding.readBindingsList.toArray(new SensorReadListener[sensorBinding.readBindingsList.size()]);
    }

    private void removeSensorReadListener(SensorBinding sensorBinding, SensorReadListener sensorReadListener) {
        Iterator iterator = sensorBinding.readBindingsList.iterator();
        while (iterator.hasNext()) {
            if ((SensorReadListener)iterator.next() != sensorReadListener) continue;
            iterator.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(Sensor sensor, SensorReadListener sensorReadListener) {
        if (sensor == null) {
            throw new NullPointerException("\nsensor is null");
        }
        SensorBinding sensorBinding = this.getSensorBinding(sensor);
        if (sensorBinding == null) {
            return;
        }
        this.removeSensorReadListener(sensorBinding, sensorReadListener);
        if (sensorBinding.buttonBindingsList.size() == 0 && sensorBinding.readBindingsList.size() == 0) {
            this.removeSensorBinding(sensor);
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorReadListener(SensorReadListener sensorReadListener) {
        Iterator iterator = this.bindingsList.iterator();
        while (iterator.hasNext()) {
            SensorBinding sensorBinding = (SensorBinding)iterator.next();
            this.removeSensorReadListener(sensorBinding, sensorReadListener);
            if (sensorBinding.buttonBindingsList.size() != 0 || sensorBinding.readBindingsList.size() != 0) continue;
            iterator.remove();
        }
        this.listsDirty = true;
    }

    public synchronized void removeSensorBinding(Sensor sensor) {
        Iterator iterator = this.bindingsList.iterator();
        while (iterator.hasNext()) {
            SensorBinding sensorBinding = (SensorBinding)iterator.next();
            if (sensorBinding.sensor != sensor) continue;
            iterator.remove();
            break;
        }
        this.listsDirty = true;
    }

    public Sensor[] getSensors() {
        if (this.bindingsList.size() == 0) {
            return null;
        }
        Sensor[] sensorArray = new Sensor[this.bindingsList.size()];
        int n = 0;
        while (n < this.bindingsList.size()) {
            sensorArray[n] = ((SensorBinding)this.bindingsList.get((int)n)).sensor;
            ++n;
        }
        return sensorArray;
    }

    private synchronized void updateArrays() {
        this.bindings = this.bindingsList.toArray(new SensorBinding[this.bindingsList.size()]);
        int n = 0;
        while (n < this.bindings.length) {
            this.bindings[n].updateArrays();
            ++n;
        }
    }

    public void dispatchEvents() {
        long l = this.t0;
        this.t0 = J3DTimer.getValue();
        if (this.listsDirty) {
            this.updateArrays();
            this.listsDirty = false;
        }
        int n = 0;
        while (n < this.bindings.length) {
            SensorBinding sensorBinding = this.bindings[n];
            Sensor sensor = sensorBinding.sensor;
            Transform3D transform3D = sensorBinding.read;
            int[] nArray = sensorBinding.buttons;
            int n2 = 0;
            boolean bl = true;
            boolean bl2 = false;
            sensor.getRead(transform3D);
            sensor.lastButtons(nArray);
            int n3 = 0;
            while (n3 < sensorBinding.buttonBindings.length) {
                SensorButtonBinding sensorButtonBinding = sensorBinding.buttonBindings[n3];
                int n4 = 0;
                while (n4 < nArray.length) {
                    if (sensorButtonBinding.listeners[n4] != null) {
                        if (sensorButtonBinding.prevButtons[n4]) {
                            if (nArray[n4] == 0) {
                                this.e.set(this.source, 2, sensor, transform3D, nArray, n4, this.t0, l);
                                sensorButtonBinding.listeners[n4].released(this.e);
                                sensorButtonBinding.prevButtons[n4] = false;
                                --sensorButtonBinding.buttonsHandled;
                            } else {
                                bl2 = true;
                                n2 = n4;
                            }
                            bl = false;
                        } else if (nArray[n4] == 1 && (sensorButtonBinding.buttonsHandled == 0 || sensorButtonBinding.multiButton)) {
                            this.e.set(this.source, 1, sensor, transform3D, nArray, n4, this.t0, l);
                            sensorButtonBinding.listeners[n4].pressed(this.e);
                            sensorButtonBinding.prevButtons[n4] = true;
                            ++sensorButtonBinding.buttonsHandled;
                            bl = false;
                        }
                    }
                    ++n4;
                }
                if (bl2) {
                    this.e.set(this.source, 3, sensor, transform3D, nArray, -1, this.t0, l);
                    sensorButtonBinding.listeners[n2].dragged(this.e);
                }
                ++n3;
            }
            if (bl) {
                this.e.set(this.source, 4, sensor, transform3D, nArray, -1, this.t0, l);
                int n5 = 0;
                while (n5 < sensorBinding.readBindings.length) {
                    sensorBinding.readBindings[n5].read(this.e);
                    ++n5;
                }
            }
            ++n;
        }
    }

    public String toString() {
        String string = "SensorEventAgent@" + Integer.toHexString(this.hashCode());
        string = string + "\nsensor bindings:\n\n";
        int n = 0;
        while (n < this.bindingsList.size()) {
            string = string + ((SensorBinding)this.bindingsList.get(n)).toString() + "\n";
            ++n;
        }
        return string;
    }

    private static class SensorButtonBinding {
        int buttonsHandled = 0;
        boolean[] prevButtons = null;
        boolean multiButton = false;
        SensorButtonListener[] listeners = null;

        SensorButtonBinding(SensorButtonListener[] sensorButtonListenerArray, boolean bl) {
            this.prevButtons = new boolean[sensorButtonListenerArray.length];
            this.listeners = new SensorButtonListener[sensorButtonListenerArray.length];
            int n = 0;
            while (n < sensorButtonListenerArray.length) {
                this.prevButtons[n] = false;
                this.listeners[n] = sensorButtonListenerArray[n];
                ++n;
            }
            this.multiButton = bl;
        }

        public String toString() {
            String string = new String();
            string = "  length " + this.listeners.length + ", mutual exclusion " + !this.multiButton + "\n";
            int n = 0;
            while (n < this.listeners.length) {
                string = string + "    " + (this.listeners[n] == null ? "null" : this.listeners[n].toString()) + "\n";
                ++n;
            }
            return string;
        }
    }

    private static class SensorBinding {
        Sensor sensor = null;
        int[] buttons = null;
        Transform3D read = null;
        List buttonBindingsList = new ArrayList();
        SensorButtonBinding[] buttonBindings = new SensorButtonBinding[0];
        List readBindingsList = new ArrayList();
        SensorReadListener[] readBindings = new SensorReadListener[0];

        SensorBinding(Sensor sensor) {
            this.sensor = sensor;
            this.buttons = new int[sensor.getSensorButtonCount()];
            this.read = new Transform3D();
        }

        void updateArrays() {
            this.buttonBindings = this.buttonBindingsList.toArray(new SensorButtonBinding[this.buttonBindingsList.size()]);
            this.readBindings = this.readBindingsList.toArray(new SensorReadListener[this.readBindingsList.size()]);
        }

        public String toString() {
            String string = new String();
            string = "sensor " + this.sensor + "\nbutton listener arrays:\n";
            int n = 0;
            while (n < this.buttonBindingsList.size()) {
                string = string + (SensorButtonBinding)this.buttonBindingsList.get(n);
                ++n;
            }
            string = string + "read listeners:\n";
            int n2 = 0;
            while (n2 < this.readBindingsList.size()) {
                string = string + "  " + (SensorReadListener)this.readBindingsList.get(n2) + "\n";
                ++n2;
            }
            return string;
        }
    }
}

