/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.geometry;

import com.sun.j3d.internal.J3dUtilsI18N;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.StripifierStats;
import java.awt.Color;
import java.util.ArrayList;
import javax.vecmath.Color3b;

public class Stripifier {
    final boolean DEBUG = false;
    final boolean CHECK_ORIENT = false;
    static final int EMPTY = -1;
    boolean hasNormals = false;
    boolean hasTextures = false;
    int texSetCount = 0;
    boolean hasColors = false;
    boolean colorStrips = false;
    StripifierStats stats;
    int[] numNhbrs;
    public static final int COLLECT_STATS = 1;

    public Stripifier() {
    }

    public Stripifier(int n) {
        if ((n & 1) != 0) {
            this.stats = new StripifierStats();
        }
    }

    public void stripify(GeometryInfo geometryInfo) {
        long l = System.currentTimeMillis();
        geometryInfo.convertToIndexedTriangles();
        geometryInfo.forgetOldPrim();
        Face[] faceArray = this.createFaceArray(geometryInfo);
        Edge[] edgeArray = this.createEdgeArray(faceArray);
        this.buildAdjacencies(edgeArray, faceArray);
        Node[] nodeArray = new Node[faceArray.length];
        Node[] nodeArray2 = this.dfSearch(faceArray, nodeArray);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        ArrayList arrayList = this.hamilton(nodeArray2, nArray, nArray2);
        int n = nArray[0];
        int n2 = nArray2[0];
        ArrayList arrayList2 = this.stripe(arrayList);
        this.concatenate(arrayList2, faceArray);
        this.putBackData(geometryInfo, arrayList2);
        if (this.stats != null) {
            this.stats.updateInfo(System.currentTimeMillis() - l, arrayList2, faceArray.length);
        }
    }

    public StripifierStats getStripifierStats() {
        if (this.stats == null) {
            throw new IllegalStateException(J3dUtilsI18N.getString("Stripifier0"));
        }
        return this.stats;
    }

    Face[] createFaceArray(GeometryInfo geometryInfo) {
        int[] nArray = geometryInfo.getCoordinateIndices();
        int[] nArray2 = geometryInfo.getNormalIndices();
        int[][] nArrayArray = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int[] nArray5 = null;
        this.texSetCount = geometryInfo.getTexCoordSetCount();
        if (this.texSetCount > 0) {
            this.hasTextures = true;
            nArrayArray = new int[this.texSetCount][];
            int n = 0;
            while (n < this.texSetCount) {
                nArrayArray[n] = geometryInfo.getTextureCoordinateIndices(n);
                ++n;
            }
            nArray3 = new int[this.texSetCount];
            nArray4 = new int[this.texSetCount];
            nArray5 = new int[this.texSetCount];
        } else {
            this.hasTextures = false;
        }
        int[] nArray6 = geometryInfo.getColorIndices();
        Face[] faceArray = new Face[nArray.length / 3];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            if (nArray2 != null) {
                this.hasNormals = true;
                n8 = nArray2[n2];
                n7 = nArray2[n2 + 1];
                n6 = nArray2[n2 + 2];
            } else {
                this.hasNormals = false;
                n8 = -1;
                n7 = -1;
                n6 = -1;
            }
            if (this.hasTextures) {
                int n9 = 0;
                while (n9 < this.texSetCount) {
                    nArray3[n9] = nArrayArray[n9][n2];
                    nArray4[n9] = nArrayArray[n9][n2 + 1];
                    nArray5[n9] = nArrayArray[n9][n2 + 2];
                    ++n9;
                }
            }
            if (nArray6 != null) {
                this.hasColors = true;
                n5 = nArray6[n2];
                n4 = nArray6[n2 + 1];
                n3 = nArray6[n2 + 2];
            } else {
                this.hasColors = false;
                n5 = -1;
                n4 = -1;
                n3 = -1;
            }
            Vertex vertex = new Vertex(nArray[n2], n8, this.texSetCount, nArray3, n5);
            Vertex vertex2 = new Vertex(nArray[n2 + 1], n7, this.texSetCount, nArray4, n4);
            Vertex vertex3 = new Vertex(nArray[n2 + 2], n6, this.texSetCount, nArray5, n3);
            if (!(vertex.equals(vertex2) || vertex2.equals(vertex3) || vertex3.equals(vertex))) {
                faceArray[n] = new Face(n, vertex, vertex2, vertex3);
                ++n;
            }
            n2 += 3;
        }
        if (faceArray.length > n) {
            Face[] faceArray2 = faceArray;
            faceArray = new Face[n];
            System.arraycopy(faceArray2, 0, faceArray, 0, n);
        }
        return faceArray;
    }

    Edge[] createEdgeArray(Face[] faceArray) {
        Edge[] edgeArray = new Edge[faceArray.length * 3];
        int n = 0;
        while (n < faceArray.length) {
            Face face = faceArray[n];
            edgeArray[n * 3] = new Edge(face.verts[0], face.verts[1], face.key);
            edgeArray[n * 3 + 1] = new Edge(face.verts[1], face.verts[2], face.key);
            edgeArray[n * 3 + 2] = new Edge(face.verts[2], face.verts[0], face.key);
            ++n;
        }
        return edgeArray;
    }

    void buildAdjacencies(Edge[] edgeArray, Face[] faceArray) {
        int n;
        int n2;
        boolean bl;
        Face face;
        Edge edge;
        this.quickSortEdges(edgeArray, 0, edgeArray.length - 1);
        int n3 = 0;
        while (n3 < edgeArray.length) {
            edge = edgeArray[n3];
            face = faceArray[edge.face];
            Vertex[] vertexArray = face.verts;
            bl = true;
            if (!vertexArray[0].equals(edge.v1) && !vertexArray[0].equals(edge.v2)) {
                face.edges[0] = edge;
                --face.numNhbrs;
                bl = false;
            } else if (!vertexArray[1].equals(edge.v1) && !vertexArray[1].equals(edge.v2)) {
                face.edges[1] = edge;
                --face.numNhbrs;
                bl = false;
            } else if (!vertexArray[2].equals(edge.v1) && !vertexArray[2].equals(edge.v2)) {
                face.edges[2] = edge;
                --face.numNhbrs;
                bl = false;
            }
            if (bl) {
                if (edge.v1.equals(edge.v2)) {
                    face.edges[--face.numNhbrs] = edge;
                } else {
                    Vertex vertex = vertexArray[0].equals(vertexArray[1]) ? vertexArray[1] : vertexArray[2];
                    if (vertexArray[0].equals(vertex) && face.edges[0] == null) {
                        face.edges[0] = edge;
                        --face.numNhbrs;
                    } else if (vertexArray[1].equals(vertex) && face.edges[1] == null) {
                        face.edges[1] = edge;
                        --face.numNhbrs;
                    } else {
                        face.edges[2] = edge;
                        --face.numNhbrs;
                    }
                }
            }
            ++n3;
        }
        int n4 = 0;
        int n5 = 0;
        while (n4 < edgeArray.length - 1) {
            n5 = n4 + 1;
            if (edgeArray[n4].equals(edgeArray[n5])) {
                n2 = edgeArray[n4].face;
                n = edgeArray[n5].face;
                if (n2 != n) {
                    face = faceArray[n2];
                    edge = edgeArray[n4];
                    int n6 = face.getEdgeIndex(edge);
                    bl = !edge.v1.equals(face.verts[(n6 + 1) % 3]) || !edge.v2.equals(face.verts[(n6 + 2) % 3]);
                    face = faceArray[n];
                    edge = edgeArray[n5];
                    n6 = face.getEdgeIndex(edge);
                    if (!edge.v1.equals(face.verts[(n6 + 1) % 3]) || !edge.v2.equals(face.verts[(n6 + 2) % 3])) {
                        boolean bl2 = bl = !bl;
                    }
                    if (bl) {
                        edgeArray[n4].face = n;
                        edgeArray[n5].face = n2;
                        ++faceArray[n2].numNhbrs;
                        ++faceArray[n].numNhbrs;
                    } else {
                        edgeArray[n4].face = -1;
                    }
                } else {
                    edgeArray[n4].face = -1;
                }
            } else {
                edgeArray[n4].face = -1;
            }
            n4 = ++n5;
        }
        if (n4 <= edgeArray.length - 1) {
            edgeArray[n4].face = -1;
        }
        n4 = 0;
        while (n4 < faceArray.length) {
            face = faceArray[n4];
            if (face.numNhbrs == 3) {
                n2 = face.edges[1].face;
                if (n2 == face.edges[0].face) {
                    face.edges[1].face = -1;
                    --face.numNhbrs;
                    faceArray[n2].counterEdgeDel(face.edges[1]);
                }
                if ((n = face.edges[2].face) == face.edges[0].face) {
                    face.edges[2].face = -1;
                    --face.numNhbrs;
                    faceArray[n].counterEdgeDel(face.edges[2]);
                }
                if (face.edges[1].face != -1 && n2 == n) {
                    face.edges[2].face = -1;
                    --face.numNhbrs;
                    faceArray[n2].counterEdgeDel(face.edges[2]);
                }
            }
            ++n4;
        }
    }

    void sortEdges(Edge[] edgeArray) {
        int n = edgeArray.length;
        boolean bl = false;
        Edge edge = null;
        while (n > 1 && !bl) {
            bl = true;
            int n2 = 1;
            while (n2 < n) {
                if (edgeArray[n2].lessThan(edgeArray[n2 - 1])) {
                    edge = edgeArray[n2 - 1];
                    edgeArray[n2 - 1] = edgeArray[n2];
                    edgeArray[n2] = edge;
                    bl = false;
                }
                ++n2;
            }
            --n;
        }
    }

    void quickSortEdges(Edge[] edgeArray, int n, int n2) {
        if (edgeArray.length > 0) {
            int n3 = n;
            int n4 = n2;
            Edge edge = edgeArray[(n + n2) / 2];
            while (true) {
                if (edgeArray[n3].lessThan(edge)) {
                    ++n3;
                    continue;
                }
                while (edge.lessThan(edgeArray[n4])) {
                    --n4;
                }
                if (n3 <= n4) {
                    Edge edge2 = edgeArray[n3];
                    edgeArray[n3] = edgeArray[n4];
                    edgeArray[n4] = edge2;
                    ++n3;
                    --n4;
                }
                if (n3 > n4) break;
            }
            if (n < n4) {
                this.quickSortEdges(edgeArray, n, n4);
            }
            if (n < n2) {
                this.quickSortEdges(edgeArray, n3, n2);
            }
        }
    }

    Node[] hybridSearch(Face[] faceArray, Node[] nodeArray) {
        int n = faceArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        boolean bl = false;
        Node[] nodeArray2 = new Node[n];
        int n6 = 0;
        n2 = 0;
        while (n2 < n) {
            int n7 = n3 = faceArray[n2].numNhbrs;
            nArray[n7] = nArray[n7] + 1;
            nodeArray[n2] = new Node(faceArray[n2]);
            ++n2;
        }
        n2 = 1;
        while (n2 < 4) {
            int n8 = n2;
            nArray[n8] = nArray[n8] + nArray[n2 - 1];
            ++n2;
        }
        n2 = n - 1;
        while (n2 >= 0) {
            int n9 = n3 = faceArray[n2].numNhbrs;
            nArray[n9] = nArray[n9] - 1;
            nArray2[nArray[n3]] = n2;
            nArray3[n2] = nArray[n3];
            --n2;
        }
        n2 = 0;
        while (n2 < n) {
            if (nArray2[n2] != -1) {
                SortedList sortedList = new SortedList();
                Node node = nodeArray[nArray2[n2]];
                node.setRoot();
                nodeArray2[n5] = node;
                ++n5;
                nArray2[n2] = -1;
                while (node != null) {
                    Node node2 = null;
                    Face face = node.face;
                    n3 = 0;
                    while (n3 < 3) {
                        n4 = face.getNeighbor(n3);
                        if (n4 != -1 && nodeArray[n4].notAccessed()) {
                            node2 = nodeArray[n4];
                            break;
                        }
                        ++n3;
                    }
                    if (node2 != null) {
                        node2.insert(node);
                        if (!bl) {
                            n6 = sortedList.sortedInsert(node, n6);
                        } else {
                            bl = false;
                        }
                        nodeArray2[n5] = node = node2;
                        ++n5;
                        nArray2[nArray3[n4]] = -1;
                        continue;
                    }
                    node.processed();
                    node = sortedList.pop();
                    bl = true;
                    n6 = 0;
                }
            }
            ++n2;
        }
        return nodeArray2;
    }

    Node[] dfSearch(Face[] faceArray, Node[] nodeArray) {
        int n = faceArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[]{0, 0, 0, 0};
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        Node[] nodeArray2 = new Node[n];
        n2 = 0;
        while (n2 < n) {
            int n6 = n3 = faceArray[n2].numNhbrs;
            nArray[n6] = nArray[n6] + 1;
            nodeArray[n2] = new Node(faceArray[n2]);
            ++n2;
        }
        n2 = 1;
        while (n2 < 4) {
            int n7 = n2;
            nArray[n7] = nArray[n7] + nArray[n2 - 1];
            ++n2;
        }
        n2 = n - 1;
        while (n2 >= 0) {
            int n8 = n3 = faceArray[n2].numNhbrs;
            nArray[n8] = nArray[n8] - 1;
            nArray2[nArray[n3]] = n2;
            nArray3[n2] = nArray[n3];
            --n2;
        }
        this.setNumNhbrs(faceArray);
        n2 = 0;
        while (n2 < n) {
            if (nArray2[n2] != -1) {
                Node node = nodeArray[nArray2[n2]];
                node.setRoot();
                nodeArray2[n5] = node;
                ++n5;
                nArray2[n2] = -1;
                Node node2 = node;
                while (node2 != node || node2.right == null) {
                    Node node3 = null;
                    Face face = node2.face;
                    n4 = this.findNext(node2, nodeArray, faceArray);
                    if (n4 != -1) {
                        node3 = nodeArray[n4];
                    }
                    if (node3 != null) {
                        this.updateNumNhbrs(node3);
                    }
                    if (node3 != null) {
                        node3.insert(node2);
                        nodeArray2[n5] = node2 = node3;
                        ++n5;
                        nArray2[nArray3[n4]] = -1;
                    } else {
                        node2.processed();
                        node2 = node2.parent;
                    }
                    if (node2 != node.parent) continue;
                }
            }
            ++n2;
        }
        this.freeNhbrTable();
        return nodeArray2;
    }

    int findNext(Node node, Node[] nodeArray, Face[] faceArray) {
        int n;
        Face face = node.face;
        if (face.numNhbrs == 0) {
            return -1;
        }
        int[] nArray = new int[3];
        int[] nArray2 = new int[]{-1, -1, -1};
        int n2 = 0;
        int n3 = 0;
        while (n3 < 3) {
            n = face.getNeighbor(n3);
            if (n != -1 && nodeArray[n].notAccessed()) {
                nArray2[n2] = n;
                nArray[n2] = this.numNhbrs[n];
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return -1;
        }
        if (n2 == 1) {
            return nArray2[0];
        }
        if (n2 == 2) {
            if (nArray[0] == nArray[1] && nArray[0] != 0) {
                nArray[0] = this.resetNhbr(nArray2[0], faceArray, nodeArray);
                nArray[1] = this.resetNhbr(nArray2[1], faceArray, nodeArray);
            }
            if (nArray[0] < nArray[1]) {
                return nArray2[0];
            }
            if (nArray[1] < nArray[0]) {
                return nArray2[1];
            }
            Node node2 = node.parent;
            if (node2 != null) {
                Face face2 = node2.face;
                n3 = face2.findSharedEdge(face.key);
                Node node3 = node2.parent;
                if (node3 != null) {
                    Face face3 = node3.face;
                    n = face2.getNeighbor((n3 + 1) % 3) == face3.key ? face2.verts[(n3 + 2) % 3].index : face2.verts[(n3 + 1) % 3].index;
                } else {
                    n = face2.verts[(n3 + 1) % 3].index;
                }
                n3 = face.findSharedEdge(nArray2[0]);
                if (face.verts[n3].index == n) {
                    return nArray2[0];
                }
                return nArray2[1];
            }
            return nArray2[0];
        }
        if (nArray[0] < nArray[1] && nArray[0] < nArray[2]) {
            return nArray2[0];
        }
        if (nArray[1] < nArray[0] && nArray[1] < nArray[2]) {
            return nArray2[1];
        }
        if (nArray[2] < nArray[0] && nArray[2] < nArray[1]) {
            return nArray2[2];
        }
        if (nArray[0] == nArray[1] && nArray[0] < nArray[2]) {
            if (nArray[0] != 0) {
                nArray[0] = this.resetNhbr(nArray2[0], faceArray, nodeArray);
                nArray[1] = this.resetNhbr(nArray2[1], faceArray, nodeArray);
            }
            if (nArray[0] <= nArray[1]) {
                return nArray2[0];
            }
            return nArray2[1];
        }
        if (nArray[1] == nArray[2] && nArray[1] < nArray[0]) {
            if (nArray[1] != 0) {
                nArray[1] = this.resetNhbr(nArray2[1], faceArray, nodeArray);
                nArray[2] = this.resetNhbr(nArray2[2], faceArray, nodeArray);
            }
            if (nArray[1] <= nArray[2]) {
                return nArray2[1];
            }
            return nArray2[2];
        }
        if (nArray[2] == nArray[0] && nArray[2] < nArray[1]) {
            if (nArray[0] != 0) {
                nArray[0] = this.resetNhbr(nArray2[0], faceArray, nodeArray);
                nArray[2] = this.resetNhbr(nArray2[2], faceArray, nodeArray);
            }
            if (nArray[0] <= nArray[2]) {
                return nArray2[0];
            }
            return nArray2[2];
        }
        if (nArray[0] != 0) {
            nArray[0] = this.resetNhbr(nArray2[0], faceArray, nodeArray);
            nArray[1] = this.resetNhbr(nArray2[1], faceArray, nodeArray);
            nArray[2] = this.resetNhbr(nArray2[2], faceArray, nodeArray);
        }
        if (nArray[0] <= nArray[1] && nArray[0] <= nArray[2]) {
            return nArray2[0];
        }
        if (nArray[1] <= nArray[2]) {
            return nArray2[1];
        }
        return nArray2[2];
    }

    void setNumNhbrs(Face[] faceArray) {
        int n = faceArray.length;
        this.numNhbrs = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.numNhbrs[n2] = faceArray[n2].numNhbrs;
            ++n2;
        }
    }

    void freeNhbrTable() {
        this.numNhbrs = null;
    }

    void updateNumNhbrs(Node node) {
        Face face = node.face;
        int n = face.getNeighbor(0);
        if (n != -1) {
            int n2 = n;
            this.numNhbrs[n2] = this.numNhbrs[n2] - 1;
        }
        if ((n = face.getNeighbor(1)) != -1) {
            int n3 = n;
            this.numNhbrs[n3] = this.numNhbrs[n3] - 1;
        }
        if ((n = face.getNeighbor(2)) != -1) {
            int n4 = n;
            this.numNhbrs[n4] = this.numNhbrs[n4] - 1;
        }
    }

    int resetNhbr(int n, Face[] faceArray, Node[] nodeArray) {
        int n2 = -1;
        Face face = faceArray[n];
        int n3 = 0;
        while (n3 < 3) {
            int n4 = face.getNeighbor(n3);
            if (n4 != -1 && nodeArray[n4].notAccessed() && (n2 == -1 || n2 > this.numNhbrs[n4])) {
                n2 = this.numNhbrs[n4];
            }
            ++n3;
        }
        return n2;
    }

    ArrayList hamilton(Node[] nodeArray, int[] nArray, int[] nArray2) {
        int n = nodeArray.length;
        int n2 = 0;
        int n3 = 0;
        ArrayList arrayList = new ArrayList();
        int n4 = n - 1;
        while (n4 >= 0) {
            Node node;
            ArrayList<Face> arrayList2;
            Node node2 = nodeArray[n4];
            if (node2.isRoot()) {
                ++n3;
                arrayList2 = new ArrayList<Face>();
                arrayList2.add(0, node2.face);
                node = node2.left;
                while (node != null) {
                    arrayList2.add(0, node.face);
                    node = node.left;
                }
                node = node2.right;
                while (node != null) {
                    arrayList2.add(arrayList2.size(), node.face);
                    node = node.left;
                }
                ++n2;
                arrayList.add(arrayList2);
            } else if (node2.numChildren == 2) {
                Node node3 = node2.parent;
                if (node3.isRoot() && node3.numChildren == 1) {
                    node3 = node2.right;
                    node2 = node3.left != null ? node3 : node2.left;
                }
                node2.remove();
                arrayList2 = new ArrayList();
                arrayList2.add(0, node2.face);
                node = node2.left;
                while (node != null) {
                    arrayList2.add(0, node.face);
                    node = node.left;
                }
                node = node2.right;
                while (node != null) {
                    arrayList2.add(arrayList2.size(), node.face);
                    node = node.left;
                }
                ++n2;
                arrayList.add(arrayList2);
            }
            --n4;
        }
        nArray[0] = n2;
        nArray2[0] = n3;
        return arrayList;
    }

    ArrayList stripe(ArrayList arrayList) {
        int n = arrayList.size();
        ArrayList<Istream> arrayList2 = new ArrayList<Istream>();
        boolean bl = true;
        Vertex[] vertexArray = new Vertex[4];
        int n2 = 0;
        while (n2 < n) {
            ArrayList arrayList3 = (ArrayList)arrayList.get(n2);
            int n3 = 0;
            boolean bl2 = false;
            Face face = this.getNextFace(arrayList3, n3++);
            while (!bl2) {
                Istream istream;
                boolean bl3 = true;
                if (this.stripDone(arrayList3, n3)) {
                    istream = new Istream(face.verts, 3, false);
                    istream.head = face.key;
                    bl2 = true;
                    istream.tail = face.key;
                } else {
                    Face face2 = face;
                    face = this.getNextFace(arrayList3, n3++);
                    int n4 = face2.findSharedEdge(face.key);
                    vertexArray[0] = face2.verts[n4];
                    vertexArray[1] = face2.verts[(n4 + 1) % 3];
                    vertexArray[2] = face2.verts[(n4 + 2) % 3];
                    n4 = face.findSharedEdge(face2.key);
                    vertexArray[3] = face.verts[n4];
                    istream = new Istream(vertexArray, 4, false);
                    istream.head = face2.key;
                    if (this.stripDone(arrayList3, n3)) {
                        bl2 = true;
                        istream.tail = face.key;
                    }
                    while (bl3 && !this.stripDone(arrayList3, n3)) {
                        face2 = face;
                        if (this.seq(istream, face = this.getNextFace(arrayList3, n3++), n4 = face.findSharedEdge(face2.key))) {
                            istream.append(face.verts[n4]);
                            if (!this.stripDone(arrayList3, n3)) continue;
                            bl2 = true;
                            istream.tail = face.key;
                            continue;
                        }
                        istream.swapEnd();
                        istream.append(face.verts[n4]);
                        if (!this.stripDone(arrayList3, n3)) continue;
                        bl2 = true;
                        istream.tail = face.key;
                    }
                }
                arrayList2.add(istream);
            }
            ++n2;
        }
        return arrayList2;
    }

    boolean stripDone(ArrayList arrayList, int n) {
        return n >= arrayList.size();
    }

    boolean seq(Istream istream, Face face, int n) {
        int n2 = istream.length;
        Vertex vertex = face.edges[n].v1;
        Vertex vertex2 = face.edges[n].v2;
        Vertex vertex3 = istream.istream[n2 - 1];
        Vertex vertex4 = istream.istream[n2 - 2];
        return vertex.equals(vertex4) && vertex2.equals(vertex3) || vertex.equals(vertex3) && vertex2.equals(vertex4);
    }

    boolean orientSeq(boolean bl, Istream istream, Face face) {
        int n = istream.length;
        Vertex vertex = istream.istream[n - 1];
        Vertex vertex2 = istream.istream[n - 2];
        return bl && this.checkOrientCCWSeq(vertex, vertex2, face) || !bl && this.checkOrientCWSeq(vertex, vertex2, face);
    }

    boolean orientZAT(boolean bl, Istream istream, Face face) {
        int n = istream.length;
        Vertex vertex = istream.istream[n - 1];
        Vertex vertex2 = istream.istream[n - 3];
        return bl && this.checkOrientCWSeq(vertex, vertex2, face) || !bl && this.checkOrientCCWSeq(vertex, vertex2, face);
    }

    boolean checkOrientCWSeq(Vertex vertex, Vertex vertex2, Face face) {
        System.out.println("checkOrientCWSeq");
        System.out.println("last = " + vertex.index);
        System.out.println("prev = " + vertex2.index);
        System.out.print("face = ");
        face.printVertices();
        return !(vertex.equals(face.verts[0]) ? !vertex2.equals(face.verts[1]) : (vertex.equals(face.verts[1]) ? !vertex2.equals(face.verts[2]) : vertex.equals(face.verts[2]) && !vertex2.equals(face.verts[0])));
    }

    boolean checkOrientCCWSeq(Vertex vertex, Vertex vertex2, Face face) {
        System.out.println("checkOrientCCWSeq");
        System.out.println("last = " + vertex.index);
        System.out.println("prev = " + vertex2.index);
        System.out.print("face = ");
        face.printVertices();
        if (vertex2.equals(face.verts[0])) {
            if (!vertex.equals(face.verts[1])) {
                System.out.println("ORIENTATION PROBLEM!");
                return false;
            }
        } else if (vertex2.equals(face.verts[1])) {
            if (!vertex.equals(face.verts[2])) {
                System.out.println("ORIENTATION PROBLEM!");
                return false;
            }
        } else if (vertex2.equals(face.verts[2]) && !vertex.equals(face.verts[0])) {
            System.out.println("ORIENTATION PROBLEM!");
            return false;
        }
        return true;
    }

    Face getNextFace(ArrayList arrayList, int n) {
        if (arrayList.size() > n) {
            return (Face)arrayList.get(n);
        }
        return null;
    }

    void concatenate(ArrayList arrayList, Face[] faceArray) {
        int n = faceArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = -1;
            ++n2;
        }
        int n3 = 0;
        while (n3 < arrayList.size()) {
            Istream istream = (Istream)arrayList.get(n3);
            nArray[istream.head] = n3;
            nArray[istream.tail] = n3++;
        }
        this.reduceCostByTwo(arrayList, faceArray, nArray);
        this.reduceCostByOne(arrayList, faceArray, nArray);
        this.reduceCostByZero(arrayList, faceArray, nArray);
    }

    void reduceCostByTwo(ArrayList arrayList, Face[] faceArray, int[] nArray) {
        int n = faceArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 != -1) {
                boolean bl = false;
                boolean bl2 = false;
                Istream istream = (Istream)arrayList.get(n3);
                int n4 = istream.length;
                Vertex[] vertexArray = istream.istream;
                Face face = faceArray[n2];
                Vertex[] vertexArray2 = face.verts;
                if (!istream.fan) {
                    Vertex vertex;
                    Vertex[] vertexArray3;
                    int n5;
                    Istream istream2;
                    int n6;
                    int n7;
                    int n8;
                    if (n4 == 3) {
                        n8 = 0;
                        while (n8 < 3) {
                            n7 = face.getNeighbor(n8);
                            if (n7 != -1 && (n6 = nArray[n7]) != -1 && n6 != n3) {
                                vertexArray[0] = vertexArray2[n8];
                                vertexArray[1] = vertexArray2[(n8 + 1) % 3];
                                vertexArray[2] = vertexArray2[(n8 + 2) % 3];
                                istream2 = (Istream)arrayList.get(n6);
                                n5 = istream2.length;
                                if (n7 != istream2.head) {
                                    istream2.invert();
                                    if (n5 % 2 != 0) {
                                        bl2 = true;
                                    }
                                }
                                vertexArray3 = istream2.istream;
                                if (n5 == 3) {
                                    int n9 = faceArray[n7].findSharedEdge(n2);
                                    istream.append(faceArray[n7].verts[n9]);
                                    istream2.length = 0;
                                    istream2.istream = null;
                                    istream.tail = n7;
                                    nArray[n7] = n3;
                                    --n2;
                                    break;
                                }
                                if (n5 == 4 && vertexArray[1].index == vertexArray3[0].index && vertexArray[2].index == vertexArray3[2].index) {
                                    vertex = vertexArray3[1];
                                    vertexArray3[1] = vertexArray3[2];
                                    vertexArray3[2] = vertex;
                                }
                                if (vertexArray[1].index == vertexArray3[0].index && vertexArray[2].index == vertexArray3[1].index) {
                                    istream.addStream(istream2);
                                    nArray[n7] = -1;
                                    nArray[istream.tail] = n3;
                                    --n2;
                                    break;
                                }
                                if (bl2) {
                                    istream2.invert();
                                    bl2 = false;
                                }
                            }
                            ++n8;
                        }
                    } else if (n2 == istream.tail || n4 % 2 == 0) {
                        if (n2 != istream.tail) {
                            istream.invert();
                            vertexArray = istream.istream;
                        }
                        vertex = vertexArray[n4 - 3];
                        n8 = -1;
                        if (vertexArray2[0].index == vertex.index) {
                            n8 = 0;
                        } else if (vertexArray2[1].index == vertex.index) {
                            n8 = 1;
                        } else if (vertexArray2[2].index == vertex.index) {
                            n8 = 2;
                        }
                        if (n8 == -1) {
                            // empty if block
                        }
                        if ((n6 = (n7 = face.getNeighbor(n8)) == -1 ? n7 : nArray[n7]) != -1 && ((Istream)arrayList.get((int)n6)).fan != istream.fan) {
                            n6 = -1;
                        }
                        if (n6 != -1 && n6 != n3) {
                            istream2 = (Istream)arrayList.get(n6);
                            n5 = istream2.length;
                            if (n7 != istream2.head) {
                                istream2.invert();
                                if (n5 % 2 != 0) {
                                    bl2 = true;
                                }
                            }
                            vertexArray3 = istream2.istream;
                            if (n5 == 3) {
                                n8 = faceArray[n7].findSharedEdge(n2);
                                istream.append(faceArray[n7].verts[n8]);
                                istream2.length = 0;
                                istream2.istream = null;
                                istream.tail = n7;
                                nArray[n2] = -1;
                                nArray[n7] = n3;
                            } else {
                                if (n5 == 4 && vertexArray[n4 - 2].index == vertexArray3[0].index && vertexArray[n4 - 1].index == vertexArray3[2].index) {
                                    vertex = vertexArray3[1];
                                    vertexArray3[1] = vertexArray3[2];
                                    vertexArray3[2] = vertex;
                                }
                                if (vertexArray[n4 - 2].index == vertexArray3[0].index && vertexArray[n4 - 1].index == vertexArray3[1].index) {
                                    istream.addStream(istream2);
                                    nArray[n2] = -1;
                                    nArray[istream.tail] = n3;
                                    nArray[n7] = -1;
                                } else if (bl2) {
                                    istream2.invert();
                                }
                            }
                        }
                    }
                }
            }
            ++n2;
        }
    }

    void reduceCostByOne(ArrayList arrayList, Face[] faceArray, int[] nArray) {
        int n = faceArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 != -1 && !((Istream)arrayList.get((int)n3)).fan) {
                Vertex vertex;
                Vertex[] vertexArray;
                int n4;
                Istream istream;
                int n5;
                int n6;
                int n7;
                boolean bl = false;
                Istream istream2 = (Istream)arrayList.get(n3);
                Vertex[] vertexArray2 = istream2.istream;
                Face face = faceArray[n2];
                Vertex[] vertexArray3 = face.verts;
                int n8 = istream2.length;
                if (n8 == 3) {
                    n7 = 0;
                    while (n7 < 3) {
                        n6 = face.getNeighbor(n7);
                        if (n6 != -1 && (n5 = nArray[n6]) != -1 && n5 != n3 && !((Istream)arrayList.get((int)n5)).fan) {
                            vertexArray2[0] = vertexArray3[n7];
                            vertexArray2[1] = vertexArray3[(n7 + 1) % 3];
                            vertexArray2[2] = vertexArray3[(n7 + 2) % 3];
                            istream = (Istream)arrayList.get(n5);
                            n4 = istream.length;
                            if (n6 != istream.head) {
                                istream.invert();
                                if (n4 % 2 != 0) {
                                    bl = true;
                                }
                            }
                            vertexArray = istream.istream;
                            if (n4 == 4 && (vertexArray2[1].index == vertexArray[2].index && vertexArray2[2].index == vertexArray[0].index || vertexArray2[1].index == vertexArray[0].index && vertexArray2[2].index == vertexArray[2].index)) {
                                vertex = vertexArray[1];
                                vertexArray[1] = vertexArray[2];
                                vertexArray[2] = vertex;
                            }
                            if (vertexArray2[1].index == vertexArray[0].index && vertexArray2[2].index == vertexArray[1].index) {
                                istream2.addStream(istream);
                                nArray[n6] = -1;
                                nArray[istream2.tail] = n3;
                                --n2;
                                break;
                            }
                            if (vertexArray2[1].index == vertexArray[1].index && vertexArray2[2].index == vertexArray[0].index) {
                                istream2.append(vertexArray[1]);
                                istream2.addStream(istream);
                                nArray[n6] = -1;
                                nArray[istream2.tail] = n3;
                                --n2;
                                break;
                            }
                            if (vertexArray2[1].index == vertexArray[0].index && vertexArray2[2].index == vertexArray[2].index) {
                                vertexArray[0] = vertexArray[2];
                                istream2.append(vertexArray[1]);
                                istream2.addStream(istream);
                                nArray[n6] = -1;
                                nArray[istream2.tail] = n3;
                                --n2;
                                break;
                            }
                            if (bl) {
                                istream.invert();
                                bl = false;
                            }
                        }
                        ++n7;
                    }
                } else if (n2 == istream2.tail || n8 % 2 == 0) {
                    int n9;
                    int n10;
                    if (n2 != istream2.tail) {
                        istream2.invert();
                        vertexArray2 = istream2.istream;
                    }
                    vertex = vertexArray2[n8 - 3];
                    n7 = -1;
                    if (vertexArray3[0].index == vertex.index) {
                        n7 = 0;
                    } else if (vertexArray3[1].index == vertex.index) {
                        n7 = 1;
                    } else if (vertexArray3[2].index == vertex.index) {
                        n7 = 2;
                    }
                    if (n7 == -1) {
                        // empty if block
                    }
                    if ((n5 = (n6 = face.getNeighbor(n7)) == -1 ? n6 : nArray[n6]) != -1 && ((Istream)arrayList.get((int)n5)).fan != istream2.fan) {
                        n5 = -1;
                    }
                    vertex = vertexArray2[n8 - 2];
                    n7 = -1;
                    if (vertexArray3[0].index == vertex.index) {
                        n7 = 0;
                    } else if (vertexArray3[1].index == vertex.index) {
                        n7 = 1;
                    } else if (vertexArray3[2].index == vertex.index) {
                        n7 = 2;
                    }
                    if (n7 == -1) {
                        // empty if block
                    }
                    if ((n10 = (n9 = face.getNeighbor(n7)) == -1 ? n9 : nArray[n9]) != -1 && ((Istream)arrayList.get((int)n10)).fan != istream2.fan) {
                        n10 = -1;
                    }
                    boolean bl2 = false;
                    if (n5 != -1 && n5 != n3) {
                        istream = (Istream)arrayList.get(n5);
                        n4 = istream.length;
                        if (n6 != istream.head) {
                            istream.invert();
                            if (n4 % 2 != 0) {
                                bl = true;
                            }
                        }
                        vertexArray = istream.istream;
                        if (n4 == 4 && (vertexArray2[n8 - 2].index == vertexArray[2].index && vertexArray2[n8 - 1].index == vertexArray[0].index || vertexArray2[n8 - 2].index == vertexArray[0].index && vertexArray2[n8 - 1].index == vertexArray[2].index)) {
                            vertex = vertexArray[1];
                            vertexArray[1] = vertexArray[2];
                            vertexArray[2] = vertex;
                        }
                        if (vertexArray2[n8 - 2].index == vertexArray[0].index && vertexArray2[n8 - 1].index == vertexArray[1].index) {
                            istream2.addStream(istream);
                            nArray[n2] = -1;
                            nArray[istream2.tail] = n3;
                            nArray[n6] = -1;
                            bl2 = true;
                        } else if (vertexArray2[n8 - 2].index == vertexArray[1].index && vertexArray2[n8 - 1].index == vertexArray[0].index) {
                            istream2.append(vertexArray[1]);
                            istream2.addStream(istream);
                            nArray[n2] = -1;
                            nArray[istream2.tail] = n3;
                            nArray[n6] = -1;
                            bl2 = true;
                        } else if (vertexArray2[n8 - 2].index == vertexArray[0].index && vertexArray2[n8 - 1].index == vertexArray[2].index) {
                            vertexArray[0] = vertexArray[2];
                            istream2.append(vertexArray[1]);
                            istream2.addStream(istream);
                            nArray[n2] = -1;
                            nArray[istream2.tail] = n3;
                            nArray[n6] = -1;
                            bl2 = true;
                        } else if (bl) {
                            istream.invert();
                            bl = false;
                        }
                    }
                    if (!bl2 && n10 != -1 && n10 != n3) {
                        istream = (Istream)arrayList.get(n10);
                        n4 = istream.length;
                        if (n9 != istream.head) {
                            istream.invert();
                            if (n4 % 2 != 0) {
                                bl = true;
                            }
                        }
                        vertexArray = istream.istream;
                        if (n4 == 4 && vertexArray2[n8 - 3].index == vertexArray[0].index && vertexArray2[n8 - 1].index == vertexArray[2].index) {
                            vertex = vertexArray[1];
                            vertexArray[1] = vertexArray[2];
                            vertexArray[2] = vertex;
                        }
                        if (vertexArray2[n8 - 3].index == vertexArray[0].index && vertexArray2[n8 - 1].index == vertexArray[1].index) {
                            istream2.swapEnd();
                            istream2.addStream(istream);
                            nArray[n2] = -1;
                            nArray[istream2.tail] = n3;
                            nArray[n9] = -1;
                            bl2 = true;
                        }
                        if (!bl2 && bl) {
                            istream.invert();
                        }
                    }
                }
            }
            ++n2;
        }
    }

    void reduceCostByZero(ArrayList arrayList, Face[] faceArray, int[] nArray) {
        int n = faceArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            if (n3 != -1 && !((Istream)arrayList.get((int)n3)).fan) {
                Vertex[] vertexArray;
                int n4;
                Istream istream;
                int n5;
                int n6;
                int n7;
                boolean bl = false;
                Istream istream2 = (Istream)arrayList.get(n3);
                Vertex[] vertexArray2 = istream2.istream;
                int n8 = istream2.length;
                Face face = faceArray[n2];
                Vertex[] vertexArray3 = face.verts;
                if (n8 == 3) {
                    n7 = 0;
                    while (n7 < 3) {
                        n6 = face.getNeighbor(n7);
                        if (n6 != -1 && (n5 = nArray[n6]) != -1 && n5 != n3 && !((Istream)arrayList.get((int)n5)).fan) {
                            vertexArray2[0] = vertexArray3[n7];
                            vertexArray2[1] = vertexArray3[(n7 + 1) % 3];
                            vertexArray2[2] = vertexArray3[(n7 + 2) % 3];
                            istream = (Istream)arrayList.get(n5);
                            n4 = istream.length;
                            if (n6 != istream.head) {
                                istream.invert();
                                if (n4 % 2 != 0) {
                                    bl = true;
                                }
                            }
                            vertexArray = istream.istream;
                            if (vertexArray2[1].index == vertexArray[2].index && vertexArray2[2].index == vertexArray[0].index) {
                                vertexArray[0] = vertexArray[2];
                                istream2.append(vertexArray[0]);
                                istream2.append(vertexArray[1]);
                                istream2.addStream(istream);
                                nArray[n6] = -1;
                                nArray[istream2.tail] = n3;
                                --n2;
                                break;
                            }
                            if (bl) {
                                istream.invert();
                                bl = false;
                            }
                        }
                        ++n7;
                    }
                } else if (n2 == istream2.tail || n8 % 2 == 0) {
                    int n9;
                    int n10;
                    if (n2 != istream2.tail) {
                        istream2.invert();
                        vertexArray2 = istream2.istream;
                    }
                    Vertex vertex = vertexArray2[n8 - 3];
                    n7 = -1;
                    if (vertexArray3[0].index == vertex.index) {
                        n7 = 0;
                    } else if (vertexArray3[1].index == vertex.index) {
                        n7 = 1;
                    } else if (vertexArray3[2].index == vertex.index) {
                        n7 = 2;
                    }
                    if (n7 == -1) {
                        // empty if block
                    }
                    if ((n5 = (n6 = face.getNeighbor(n7)) == -1 ? n6 : nArray[n6]) != -1 && ((Istream)arrayList.get((int)n5)).fan != istream2.fan) {
                        n5 = -1;
                    }
                    vertex = vertexArray2[n8 - 2];
                    n7 = -1;
                    if (vertexArray3[0].index == vertex.index) {
                        n7 = 0;
                    } else if (vertexArray3[1].index == vertex.index) {
                        n7 = 1;
                    } else if (vertexArray3[2].index == vertex.index) {
                        n7 = 2;
                    }
                    if (n7 == -1) {
                        // empty if block
                    }
                    if ((n10 = (n9 = face.getNeighbor(n7)) == -1 ? n9 : nArray[n9]) != -1 && ((Istream)arrayList.get((int)n10)).fan != istream2.fan) {
                        n10 = -1;
                    }
                    boolean bl2 = false;
                    if (n5 != -1 && n5 != n3) {
                        istream = (Istream)arrayList.get(n5);
                        n4 = istream.length;
                        if (n6 != istream.head) {
                            istream.invert();
                            if (n4 % 2 != 0) {
                                bl = true;
                            }
                        }
                        vertexArray = istream.istream;
                        if (vertexArray2[n8 - 2].index == vertexArray[2].index && vertexArray2[n8 - 1].index == vertexArray[0].index) {
                            vertexArray[0] = vertexArray[2];
                            istream2.append(vertexArray[0]);
                            istream2.append(vertexArray[1]);
                            istream2.addStream(istream);
                            nArray[n2] = -1;
                            nArray[istream2.tail] = n3;
                            nArray[n6] = -1;
                            bl2 = true;
                        } else if (bl) {
                            istream.invert();
                            bl = false;
                        }
                    }
                    if (!bl2 && n10 != -1 && n10 != n3) {
                        istream = (Istream)arrayList.get(n10);
                        n4 = istream.length;
                        if (n9 != istream.head) {
                            istream.invert();
                            if (n4 % 2 != 0) {
                                bl = true;
                            }
                        }
                        vertexArray = istream.istream;
                        if (n4 == 4 && (vertexArray2[n8 - 3].index == vertexArray[2].index && vertexArray2[n8 - 1].index == vertexArray[0].index || vertexArray2[n8 - 3].index == vertexArray[0].index && vertexArray2[n8 - 1].index == vertexArray[2].index)) {
                            vertex = vertexArray[1];
                            vertexArray[1] = vertexArray[2];
                            vertexArray[2] = vertex;
                        }
                        if (vertexArray2[n8 - 3].index == vertexArray[1].index && vertexArray2[n8 - 1].index == vertexArray[0].index) {
                            istream2.swapEnd();
                            istream2.append(vertexArray[1]);
                            istream2.addStream(istream);
                            nArray[n2] = -1;
                            nArray[istream2.tail] = n3;
                            nArray[n9] = -1;
                        } else if (vertexArray2[n8 - 3].index == vertexArray[0].index && vertexArray2[n8 - 1].index == vertexArray[2].index) {
                            vertexArray[0] = vertexArray[2];
                            istream2.swapEnd();
                            istream2.append(vertexArray[1]);
                            istream2.addStream(istream);
                            nArray[n2] = -1;
                            nArray[istream2.tail] = n3;
                            nArray[n9] = -1;
                        } else if (vertexArray2[n8 - 3].index == vertexArray[0].index && vertexArray2[n8 - 1].index == vertexArray[1].index) {
                            istream2.swapEnd();
                            istream2.addStream(istream);
                            nArray[n2] = -1;
                            nArray[istream2.tail] = n3;
                            nArray[n9] = -1;
                        } else if (bl) {
                            istream.invert();
                        }
                    }
                }
            }
            ++n2;
        }
    }

    void putBackData(GeometryInfo geometryInfo, ArrayList arrayList) {
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        int n2 = 0;
        while (n2 < arrayList.size()) {
            int n3 = ((Istream)arrayList.get((int)n2)).length;
            if (n3 != 0) {
                nArray[n2] = n3;
                n += n3;
                ++n2;
                continue;
            }
            arrayList.remove(n2);
        }
        if (n > 3) {
            geometryInfo.setPrimitive(4);
            int[] nArray2 = new int[arrayList.size()];
            System.arraycopy(nArray, 0, nArray2, 0, arrayList.size());
            geometryInfo.setStripCounts(nArray2);
            int[] nArray3 = new int[n];
            int[] nArray4 = null;
            int[][] nArray5 = null;
            int[] nArray6 = null;
            Object[] objectArray = null;
            if (this.hasNormals) {
                nArray4 = new int[n];
            }
            if (this.hasTextures) {
                nArray5 = new int[this.texSetCount][n];
            }
            if (this.hasColors) {
                nArray6 = new int[n];
            }
            if (this.colorStrips) {
                objectArray = new Color3b[n];
                nArray6 = new int[n];
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < arrayList.size()) {
                int n6;
                int n7;
                Istream istream = (Istream)arrayList.get(n5);
                if (istream.length < 3) {
                    throw new RuntimeException("currStrip.length = " + istream.length);
                }
                Color color = null;
                if (this.colorStrips) {
                    n7 = (int)(Math.random() * 1000.0) % 255;
                    n6 = (int)(Math.random() * 1000.0) % 255;
                    int n8 = (int)(Math.random() * 1000.0) % 255;
                    color = new Color(n7, n6, n8);
                }
                n7 = 0;
                while (n7 < istream.length) {
                    nArray3[n4] = istream.istream[n7].index;
                    if (this.hasNormals) {
                        nArray4[n4] = istream.istream[n7].normal;
                    }
                    if (this.hasTextures) {
                        n6 = 0;
                        while (n6 < this.texSetCount) {
                            nArray5[n6][n4] = istream.istream[n7].texture[n6];
                            ++n6;
                        }
                    }
                    if (this.hasColors) {
                        nArray6[n4] = istream.istream[n7].color;
                    }
                    if (this.colorStrips) {
                        objectArray[n4] = new Color3b(color);
                    }
                    ++n4;
                    ++n7;
                }
                ++n5;
            }
            geometryInfo.setCoordinateIndices(nArray3);
            if (this.hasNormals) {
                geometryInfo.setNormalIndices(nArray4);
            }
            if (this.hasTextures) {
                int n9 = 0;
                while (n9 < this.texSetCount) {
                    geometryInfo.setTextureCoordinateIndices(n9, nArray5[n9]);
                    ++n9;
                }
            }
            if (this.hasColors) {
                geometryInfo.setColorIndices(nArray6);
            }
            if (this.colorStrips) {
                geometryInfo.setColors((Color3b[])objectArray);
                nArray6 = geometryInfo.getListIndices(objectArray);
                geometryInfo.setColorIndices(nArray6);
            }
        }
    }

    class Istream {
        boolean fan = false;
        int length = 0;
        Vertex[] istream;
        int head;
        int tail;

        Istream(Vertex[] vertexArray, int n, boolean bl) {
            if (n == 0) {
                throw new RuntimeException("size is 0");
            }
            this.fan = bl;
            this.length = n;
            this.istream = new Vertex[this.length];
            System.arraycopy(vertexArray, 0, this.istream, 0, this.length);
        }

        void append(Vertex vertex) {
            this.growArray();
            this.istream[this.length] = vertex;
            ++this.length;
        }

        void swapEnd() {
            this.growArray();
            this.istream[this.length] = this.istream[this.length - 1];
            this.istream[this.length - 1] = this.istream[this.length - 3];
            ++this.length;
        }

        void growArray() {
            if (this.length >= this.istream.length) {
                Vertex[] vertexArray = this.istream;
                this.istream = new Vertex[this.length + 3];
                System.arraycopy(vertexArray, 0, this.istream, 0, this.length);
            }
        }

        void invert() {
            Vertex[] vertexArray = new Vertex[this.istream.length];
            int n = 0;
            while (n < this.length) {
                vertexArray[n] = this.istream[this.length - n - 1];
                ++n;
            }
            System.arraycopy(vertexArray, 0, this.istream, 0, this.istream.length);
            vertexArray = null;
            int n2 = this.head;
            this.head = this.tail;
            this.tail = n2;
        }

        void addStream(Istream istream) {
            int n = istream.length;
            int n2 = n + this.length - 2;
            if (n2 >= this.istream.length) {
                Vertex[] vertexArray = this.istream;
                this.istream = new Vertex[n2];
                System.arraycopy(vertexArray, 0, this.istream, 0, this.length);
            }
            System.arraycopy(istream.istream, 2, this.istream, this.length, n - 2);
            this.tail = istream.tail;
            this.length = n2;
            istream.length = 0;
            istream.istream = null;
        }
    }

    class SortedList {
        ArrayList list = new ArrayList();

        SortedList() {
        }

        int sortedInsert(Node node, int n) {
            while (n < this.list.size() && ((Node)this.list.get((int)n)).depth <= node.depth) {
                ++n;
            }
            this.list.add(n, node);
            return n + 1;
        }

        Node pop() {
            if (!this.list.isEmpty()) {
                return (Node)this.list.remove(0);
            }
            return null;
        }
    }

    class Node {
        Face face;
        Node parent;
        Node left;
        Node right;
        int depth;
        int numChildren;
        int attrib;
        static final int WHITE = 0;
        static final int GREY = 1;
        static final int BLACK = 2;

        Node(Face face) {
            this.face = face;
        }

        void insert(Node node) {
            this.parent = node;
            this.depth = node.depth + 1;
            this.attrib = 1;
            if (this.parent.left == null) {
                this.parent.left = this;
            } else {
                this.parent.right = this;
            }
            ++this.parent.numChildren;
        }

        void remove() {
            if (this.parent != null) {
                if (this.parent.left == this) {
                    this.parent.left = this.parent.right;
                    this.parent.right = null;
                } else {
                    this.parent.right = null;
                }
                --this.parent.numChildren;
            }
        }

        void setRoot() {
            this.depth = 0;
            this.attrib = 1;
        }

        boolean notAccessed() {
            return this.attrib == 0;
        }

        void processed() {
            this.attrib = 2;
        }

        boolean isRoot() {
            return this.parent == null;
        }

        void print() {
            System.out.println(this);
            System.out.println("Node depth: " + this.depth);
            this.face.printVertices();
            System.out.print("parent: ");
            if (this.parent != null) {
                this.parent.face.printVertices();
            } else {
                System.out.println("null");
            }
            System.out.print("left: ");
            if (this.left != null) {
                this.left.face.printVertices();
            } else {
                System.out.println("null");
            }
            System.out.print("right: ");
            if (this.right != null) {
                this.right.face.printVertices();
            } else {
                System.out.println("null");
            }
            System.out.println("attrib: " + this.attrib);
            System.out.println("");
        }
    }

    class Face {
        int key;
        int numNhbrs = 0;
        Vertex[] verts = null;
        Edge[] edges = null;

        Face(int n, Vertex vertex, Vertex vertex2, Vertex vertex3) {
            this.key = n;
            this.verts = new Vertex[3];
            this.verts[0] = vertex;
            this.verts[1] = vertex2;
            this.verts[2] = vertex3;
            this.edges = new Edge[3];
            this.edges[0] = null;
            this.edges[1] = null;
            this.edges[2] = null;
            this.numNhbrs = 3;
        }

        int getNeighbor(int n) {
            return this.edges[n].face;
        }

        int findSharedEdge(int n) {
            if (this.edges[0].face == n) {
                return 0;
            }
            if (this.edges[1].face == n) {
                return 1;
            }
            if (this.edges[2].face == n) {
                return 2;
            }
            return -1;
        }

        int getEdgeIndex(Edge edge) {
            if (this.edges[0].equals(edge)) {
                return 0;
            }
            if (this.edges[1].equals(edge)) {
                return 1;
            }
            return 2;
        }

        void counterEdgeDel(Edge edge) {
            if (this.edges[0].equals(edge)) {
                this.edges[0].face = -1;
                --this.numNhbrs;
            } else if (this.edges[1].equals(edge)) {
                this.edges[1].face = -1;
                --this.numNhbrs;
            } else if (this.edges[2].equals(edge)) {
                this.edges[2].face = -1;
                --this.numNhbrs;
            }
        }

        void printAdjacency() {
            System.out.println("Face " + this.key + ": ");
            System.out.println("\t numNhbrs = " + this.numNhbrs);
            System.out.println("\t edge 0: Face " + this.edges[0].face);
            System.out.println("\t edge 1: Face " + this.edges[1].face);
            System.out.println("\t edge 2: Face " + this.edges[2].face);
        }

        void printVertices() {
            System.out.println("Face " + this.key + ": (" + this.verts[0].index + ", " + this.verts[1].index + ", " + this.verts[2].index + ")");
        }
    }

    class Edge {
        Vertex v1;
        Vertex v2;
        int face;

        Edge(Vertex vertex, Vertex vertex2, int n) {
            this.face = n;
            if (vertex.lessThan(vertex2)) {
                this.v1 = vertex;
                this.v2 = vertex2;
            } else {
                this.v1 = vertex2;
                this.v2 = vertex;
            }
        }

        boolean equals(Edge edge) {
            return this.v1.equals(edge.v1) && this.v2.equals(edge.v2);
        }

        boolean lessThan(Edge edge) {
            if (this.v1.lessThan(edge.v1)) {
                return true;
            }
            if (this.v1.equals(edge.v1)) {
                return this.v2.lessThan(edge.v2);
            }
            return false;
        }
    }

    class Vertex {
        int index;
        int normal = -1;
        int numTexSets = 0;
        int[] texture = null;
        int color = -1;

        Vertex(int n) {
            this(n, -1, 0, null, -1);
        }

        Vertex(int n, int n2, int n3, int[] nArray, int n4) {
            this.index = n;
            this.normal = n2;
            this.numTexSets = n3;
            if (this.numTexSets > 0) {
                this.texture = new int[this.numTexSets];
                System.arraycopy(nArray, 0, this.texture, 0, this.numTexSets);
            }
            this.color = n4;
        }

        boolean equals(Vertex vertex) {
            int n = 0;
            while (n < this.numTexSets) {
                if (this.texture[n] != vertex.texture[n]) {
                    return false;
                }
                ++n;
            }
            return vertex.index == this.index && vertex.normal == this.normal && vertex.color == this.color;
        }

        boolean lessThan(Vertex vertex) {
            if (this.index < vertex.index) {
                return true;
            }
            if (this.index > vertex.index) {
                return false;
            }
            if (this.normal < vertex.normal) {
                return true;
            }
            if (this.normal > vertex.normal) {
                return false;
            }
            int n = 0;
            while (n < this.numTexSets) {
                if (this.texture[n] < vertex.texture[n]) {
                    return true;
                }
                if (this.texture[n] > vertex.texture[n]) {
                    return false;
                }
                ++n;
            }
            if (this.color < vertex.color) {
                return true;
            }
            if (this.color > vertex.color) {
                return false;
            }
            return false;
        }
    }
}

