/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.BehaviorState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.LOD;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.Switch;

public abstract class LODState
extends BehaviorState {
    private int[] switches;

    public LODState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
        if (this.node != null) {
            this.switches = new int[((LOD)this.node).numSwitches()];
            int n = 0;
            while (n < this.switches.length) {
                this.switches[n] = controller.getSymbolTable().addReference((SceneGraphObject)((LOD)this.node).getSwitch(n));
                ++n;
            }
        }
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        dataOutput.writeInt(this.switches.length);
        int n = 0;
        while (n < this.switches.length) {
            dataOutput.writeInt(this.switches[n]);
            ++n;
        }
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        LOD lOD = (LOD)this.node;
        this.switches = new int[dataInput.readInt()];
        int n = 0;
        while (n < this.switches.length) {
            this.switches[n] = dataInput.readInt();
            ++n;
        }
    }

    public void buildGraph() {
        LOD lOD = (LOD)this.node;
        int n = 0;
        while (n < this.switches.length) {
            lOD.addSwitch((Switch)this.control.getSymbolTable().getJ3dNode(this.switches[n]));
            ++n;
        }
        super.buildGraph();
    }
}

