/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.universe;

import com.sun.j3d.utils.universe.ConfigCommand;
import com.sun.j3d.utils.universe.ConfigObject;
import com.sun.j3d.utils.universe.ConfigPhysicalBody;
import com.sun.j3d.utils.universe.ConfigPhysicalEnvironment;
import com.sun.j3d.utils.universe.ConfigScreen;
import com.sun.j3d.utils.universe.ConfigViewPlatform;
import com.sun.j3d.utils.universe.Viewer;
import java.util.HashSet;
import java.util.Set;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;

class ConfigView
extends ConfigObject {
    View j3dView = null;
    Viewer j3dViewer = null;
    Set screens = new HashSet();
    boolean stereoEnable = false;
    boolean antialiasingEnable = false;
    PhysicalBody physicalBody = null;
    PhysicalEnvironment physicalEnvironment = null;
    private double fieldOfView = 0.7853981633974483;
    private int backClipPolicy = 3;
    private int frontClipPolicy = 3;
    private double backClipDistance = 10.0;
    private double frontClipDistance = 0.1;
    private int screenScalePolicy = 0;
    private double screenScale = 1.0;
    private boolean trackingEnable = false;
    private int viewPolicy = 0;
    private int windowEyepointPolicy = -1;
    private int windowMovementPolicy = -1;
    private int windowResizePolicy = -1;
    private boolean coeCenteringEnableSet = false;
    private boolean coeCenteringEnable = false;
    private Point3d centerEyeInCoexistence = null;
    private ConfigPhysicalBody configBody = null;
    private ConfigPhysicalEnvironment configEnv = null;
    private ConfigViewPlatform configViewPlatform = null;

    ConfigView() {
    }

    protected void initialize(ConfigCommand configCommand) {
    }

    protected void setProperty(ConfigCommand configCommand) {
        int n = configCommand.argc;
        Object[] objectArray = configCommand.argv;
        String string = null;
        Object object = null;
        String string2 = null;
        ConfigScreen configScreen = null;
        if (n != 4) {
            this.syntaxError("Incorrect number of arguments to " + configCommand.commandName);
        }
        if (!this.isName(objectArray[1])) {
            this.syntaxError("The first argument to " + configCommand.commandName + " must be the instance name");
        }
        if (!this.isName(objectArray[2])) {
            this.syntaxError("The second argument to " + configCommand.commandName + " must be a property name");
        }
        string = (String)objectArray[2];
        object = objectArray[3];
        if (string.equals("Screen") || string.equals("Window")) {
            if (!(object instanceof String)) {
                this.syntaxError("Value for " + string + " must be a name");
            }
            if (!this.screens.add(configScreen = (ConfigScreen)this.configContainer.findConfigObject("Screen", (String)object))) {
                this.syntaxError(string + " \"" + (String)object + "\" has already been added to " + this.instanceName);
            }
        } else if (string.equals("ViewPlatform")) {
            if (!(object instanceof String)) {
                this.syntaxError("value for ViewPlatform  must be an instance name");
            }
            this.configViewPlatform = (ConfigViewPlatform)this.configContainer.findConfigObject("ViewPlatform", (String)object);
            this.configViewPlatform.addConfigView(this);
        } else if (string.equals("PhysicalEnvironment")) {
            if (!(object instanceof String)) {
                this.syntaxError("value for PhysicalEnvironment must be an instance name");
            }
            this.configEnv = (ConfigPhysicalEnvironment)this.configContainer.findConfigObject("PhysicalEnvironment", (String)object);
        } else if (string.equals("PhysicalBody")) {
            if (!(object instanceof String)) {
                this.syntaxError("value for PhysicalBody must be an instance name");
            }
            this.configBody = (ConfigPhysicalBody)this.configContainer.findConfigObject("PhysicalBody", (String)object);
        } else if (string.equals("BackClipPolicy")) {
            if (!(object instanceof String)) {
                this.syntaxError("value for BackClipPolicy must be a string");
            }
            if ((string2 = (String)object).equals("PHYSICAL_EYE")) {
                this.backClipPolicy = 3;
            } else if (string2.equals("PHYSICAL_SCREEN")) {
                this.backClipPolicy = 1;
            } else if (string2.equals("VIRTUAL_EYE")) {
                this.backClipPolicy = 2;
            } else if (string2.equals("VIRTUAL_SCREEN")) {
                this.backClipPolicy = 0;
            } else {
                this.syntaxError("Invalid value for BackClipPolicy " + string2);
            }
        } else if (string.equals("FrontClipPolicy")) {
            if (!(object instanceof String)) {
                this.syntaxError("value for FrontClipPolicy must be a string");
            }
            if ((string2 = (String)object).equals("PHYSICAL_EYE")) {
                this.frontClipPolicy = 3;
            } else if (string2.equals("PHYSICAL_SCREEN")) {
                this.frontClipPolicy = 1;
            } else if (string2.equals("VIRTUAL_EYE")) {
                this.frontClipPolicy = 2;
            } else if (string2.equals("VIRTUAL_SCREEN")) {
                this.frontClipPolicy = 0;
            } else {
                this.syntaxError("Invalid value for FrontClipPolicy " + string2);
            }
        } else if (string.equals("ScreenScalePolicy")) {
            if (!(object instanceof String)) {
                this.syntaxError("value for ScreenScalePolicy must be a string");
            }
            if ((string2 = (String)object).equals("SCALE_SCREEN_SIZE")) {
                this.screenScalePolicy = 0;
            } else if (string2.equals("SCALE_EXPLICIT")) {
                this.screenScalePolicy = 1;
            } else {
                this.syntaxError("Invalid value for ScreenScalePolicy " + string2);
            }
        } else if (string.equals("FieldOfView")) {
            if (!(object instanceof Double)) {
                this.syntaxError("value for FieldOfView must be a number");
            }
            this.fieldOfView = (Double)object;
        } else if (string.equals("BackClipDistance")) {
            if (!(object instanceof Double)) {
                this.syntaxError("value for BackClipDistance must be a number");
            }
            this.backClipDistance = (Double)object;
        } else if (string.equals("FrontClipDistance")) {
            if (!(object instanceof Double)) {
                this.syntaxError("value for FrontClipDistance must be a number");
            }
            this.frontClipDistance = (Double)object;
        } else if (string.equals("ScreenScale")) {
            if (!(object instanceof Double)) {
                this.syntaxError("value for ScreenScale must be a number");
            }
            this.screenScale = (Double)object;
        } else if (string.equals("TrackingEnable")) {
            if (!(object instanceof Boolean)) {
                this.syntaxError("value for TrackingEnable must be a boolean");
            }
            this.trackingEnable = (Boolean)object;
        } else if (string.equals("CoexistenceCenteringEnable")) {
            if (!(object instanceof Boolean)) {
                this.syntaxError("value for CoexistenceCenteringEnable must be a boolean");
            }
            this.coeCenteringEnable = (Boolean)object;
            this.coeCenteringEnableSet = true;
        } else if (string.equals("ViewPolicy")) {
            if (!(object instanceof String)) {
                this.syntaxError("value for ViewPolicy must be a string");
            }
            if ((string2 = (String)object).equals("SCREEN_VIEW")) {
                this.viewPolicy = 0;
            } else if (string2.equals("HMD_VIEW")) {
                this.viewPolicy = 1;
            } else {
                this.syntaxError("Invalid value for ViewPolicy " + string2);
            }
        } else if (string.equals("WindowEyepointPolicy")) {
            if (!(object instanceof String)) {
                this.syntaxError("value for WindowEyepointPolicy must be a string");
            }
            if ((string2 = (String)object).equals("RELATIVE_TO_SCREEN")) {
                this.windowEyepointPolicy = 0;
            } else if (string2.equals("RELATIVE_TO_COEXISTENCE")) {
                this.windowEyepointPolicy = 3;
            } else if (string2.equals("RELATIVE_TO_WINDOW")) {
                this.windowEyepointPolicy = 1;
            } else if (string2.equals("RELATIVE_TO_FIELD_OF_VIEW")) {
                this.windowEyepointPolicy = 2;
            } else {
                this.syntaxError("Invalid value for WindowEyepointPolicy " + string2);
            }
        } else if (string.equals("WindowMovementPolicy")) {
            if (!(object instanceof String)) {
                this.syntaxError("value for WindowEyeMovementPolicy must be a string");
            }
            if ((string2 = (String)object).equals("VIRTUAL_WORLD")) {
                this.windowMovementPolicy = 0;
            } else if (string2.equals("PHYSICAL_WORLD")) {
                this.windowMovementPolicy = 1;
            } else {
                this.syntaxError("Invalid value for WindowMovementPolicy " + string2);
            }
        } else if (string.equals("WindowResizePolicy")) {
            if (!(object instanceof String)) {
                this.syntaxError("value for WindowResizePolicy must be a string");
            }
            if ((string2 = (String)object).equals("VIRTUAL_WORLD")) {
                this.windowResizePolicy = 0;
            } else if (string2.equals("PHYSICAL_WORLD")) {
                this.windowResizePolicy = 1;
            } else {
                this.syntaxError("Invalid value for WindowResizePolicy " + string2);
            }
        } else if (string.equals("CenterEyeInCoexistence")) {
            if (object instanceof Point3d) {
                this.centerEyeInCoexistence = (Point3d)object;
            } else {
                this.syntaxError("value for CenterEyeInCoexistence must be a Point3d");
            }
        } else if (string.equals("StereoEnable")) {
            if (!(object instanceof Boolean)) {
                this.syntaxError("value for StereoEnable must be a boolean");
            }
            this.stereoEnable = (Boolean)object;
        } else if (string.equals("AntialiasingEnable")) {
            if (!(object instanceof Boolean)) {
                this.syntaxError("value for AntialiasingEnable must be a boolean");
            }
            this.antialiasingEnable = (Boolean)object;
        } else {
            this.syntaxError("Unknown " + configCommand.commandName + " \"" + string + "\"");
        }
    }

    protected Viewer createViewer(boolean bl) {
        ConfigScreen configScreen;
        ConfigScreen[] configScreenArray;
        this.j3dView = new View();
        this.j3dView.setViewPolicy(this.viewPolicy);
        this.physicalBody = this.configBody == null ? new PhysicalBody() : this.configBody.j3dPhysicalBody;
        this.physicalEnvironment = this.configEnv == null ? new PhysicalEnvironment() : this.configEnv.j3dPhysicalEnvironment;
        this.j3dView.setPhysicalBody(this.physicalBody);
        this.j3dView.setPhysicalEnvironment(this.physicalEnvironment);
        boolean bl2 = true;
        if (this.coeCenteringEnableSet && !this.coeCenteringEnable) {
            bl2 = false;
        }
        if (this.configEnv != null && this.configEnv.coexistenceToTrackerBase != null) {
            bl2 = false;
        } else {
            configScreenArray = this.screens.iterator();
            while (configScreenArray.hasNext()) {
                configScreen = (ConfigScreen)configScreenArray.next();
                if (configScreen.trackerBaseToImagePlate == null) continue;
                bl2 = false;
                break;
            }
        }
        if (bl2) {
            if (this.windowEyepointPolicy == -1) {
                this.windowEyepointPolicy = 2;
            }
            if (this.windowMovementPolicy == -1) {
                this.windowMovementPolicy = 1;
            }
            if (this.windowResizePolicy == -1) {
                this.windowResizePolicy = 1;
            }
            if (!this.coeCenteringEnableSet) {
                this.coeCenteringEnable = true;
            }
        } else {
            if (this.windowEyepointPolicy == -1) {
                this.windowEyepointPolicy = 3;
            }
            if (this.windowMovementPolicy == -1) {
                this.windowMovementPolicy = 0;
            }
            if (this.windowResizePolicy == -1) {
                this.windowResizePolicy = 0;
            }
            if (!this.coeCenteringEnableSet) {
                this.coeCenteringEnable = false;
            }
        }
        this.j3dView.setWindowEyepointPolicy(this.windowEyepointPolicy);
        this.j3dView.setWindowMovementPolicy(this.windowMovementPolicy);
        this.j3dView.setWindowResizePolicy(this.windowResizePolicy);
        this.j3dView.setCoexistenceCenteringEnable(this.coeCenteringEnable);
        if (this.centerEyeInCoexistence == null) {
            this.centerEyeInCoexistence = new Point3d(0.0, 0.0, 0.4572);
        }
        Point3d point3d = new Point3d(this.centerEyeInCoexistence);
        Point3d point3d2 = new Point3d(this.centerEyeInCoexistence);
        if (this.stereoEnable) {
            configScreenArray = new Point3d();
            configScreen = new Point3d();
            this.physicalBody.getLeftEyePosition((Point3d)configScreenArray);
            this.physicalBody.getRightEyePosition((Point3d)configScreen);
            point3d.add((Tuple3d)configScreenArray);
            point3d2.add((Tuple3d)configScreen);
        }
        this.j3dView.setLeftManualEyeInCoexistence(point3d);
        this.j3dView.setRightManualEyeInCoexistence(point3d2);
        this.j3dView.setBackClipPolicy(this.backClipPolicy);
        this.j3dView.setFrontClipPolicy(this.frontClipPolicy);
        this.j3dView.setBackClipDistance(this.backClipDistance);
        this.j3dView.setFrontClipDistance(this.frontClipDistance);
        this.j3dView.setScreenScalePolicy(this.screenScalePolicy);
        this.j3dView.setScreenScale(this.screenScale);
        this.j3dView.setFieldOfView(this.fieldOfView);
        this.j3dView.setTrackingEnable(this.trackingEnable);
        this.j3dView.setSceneAntialiasingEnable(this.antialiasingEnable);
        if (this.screens.size() == 0) {
            throw new IllegalStateException(ConfigObject.errorMessage(this.creatingCommand, "View \"" + this.instanceName + "\" has no canvases or screens"));
        }
        configScreenArray = new ConfigScreen[this.screens.size()];
        this.screens.toArray(configScreenArray);
        this.j3dViewer = new Viewer(configScreenArray, this, bl);
        return this.j3dViewer;
    }
}

