/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball;

import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.j3d.device.input.spaceball.InputDeviceBehavior;
import org.j3d.device.input.spaceball.transformation.TransformationUtils;

public abstract class InputDeviceBase
implements InputDevice {
    protected InputDeviceBehavior itsBehavior = null;
    private int itsProcessingMode = 5;
    private Sensor itsSensor = null;
    private final Transform3D itsTempTransform = new Transform3D();
    private final Vector3d itsTempPosition = new Vector3d();
    private final Point3d itsTempDirection = new Point3d();
    private final Vector3d itsTempUpVector = new Vector3d();
    private final double[] itsScale = new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0};
    private final double[] itsScaledInput = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private final int[] itsInputOrder = new int[]{0, 1, 2, 3, 4, 5};

    public InputDeviceBase(int n) {
        this(n, null);
    }

    public InputDeviceBase(int n, Sensor sensor) {
        this.itsProcessingMode = n;
        this.itsSensor = sensor;
    }

    public boolean initialize() {
        return this.itsSensor != null;
    }

    public void setNominalPositionAndOrientation() {
    }

    public void processStreamInput() {
    }

    public void close() {
    }

    public int getProcessingMode() {
        return this.itsProcessingMode;
    }

    public void setProcessingMode(int n) {
    }

    public int getSensorCount() {
        return 1;
    }

    public Sensor getSensor(int n) {
        return this.itsSensor;
    }

    public void setScale(double[] dArray) {
        System.arraycopy(dArray, 0, this.itsScale, 0, dArray.length);
    }

    public void setScale(int n, double d) {
        this.itsScale[n] = d;
    }

    public InputDeviceBehavior getBehavior() {
        if (this.itsBehavior == null) {
            this.itsBehavior = new InputDeviceBehavior(this.itsSensor);
        }
        return this.itsBehavior;
    }

    public void setInputValueProcessingOrder(int[] nArray) {
        System.arraycopy(nArray, 0, this.itsInputOrder, 0, nArray.length);
    }

    protected void setDeltaDeviceInput(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            this.itsScaledInput[n2] = (double)nArray[this.itsInputOrder[n2]] * this.itsScale[this.itsInputOrder[n2]];
            ++n2;
        }
        TransformationUtils.getRotationTranslationTransform3D(this.itsScaledInput, this.itsTempTransform, this.itsTempPosition, this.itsTempDirection, this.itsTempUpVector);
        this.itsSensor.setNextSensorRead(System.currentTimeMillis(), this.itsTempTransform, nArray2);
    }

    protected void setSensor(Sensor sensor) {
        this.itsSensor = sensor;
    }
}

