/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.device.input.spaceball;

import javax.media.j3d.InputDevice;
import javax.media.j3d.Sensor;
import org.j3d.device.input.spaceball.InputDeviceBase;
import org.j3d.device.input.spaceball.driver.SpaceballDriver;
import org.j3d.device.input.spaceball.driver.SpaceballTypeDetector;

public class SpaceballInputDevice
extends InputDeviceBase {
    private SpaceballDriver itsDriver = null;
    private final int[] itsCurrentPositionValues = new int[]{0, 0, 0, 0, 0, 0};
    private int[] itsCurrentButtonValues = null;
    private String itsPortDescriptor = null;

    public SpaceballInputDevice(String string) {
        super(4);
        this.setScale(new double[]{1.0E-4, 1.0E-4, 1.0E-4, 1.0E-4, 1.0E-4, 1.0E-4});
        this.itsPortDescriptor = string;
    }

    public boolean initialize() {
        try {
            this.itsDriver = SpaceballTypeDetector.createSpaceballDriver(this.itsPortDescriptor, 4000);
            int n = this.itsDriver.getNumOfButtons();
            this.setSensor(new Sensor((InputDevice)this, 30, n));
            this.itsDriver.enableDevice(100);
            this.itsCurrentButtonValues = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.itsCurrentButtonValues[n2] = 0;
                ++n2;
            }
            if (super.initialize()) {
                return true;
            }
            this.close();
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close();
            return false;
        }
    }

    public void close() {
        block4: {
            try {
                if (this.itsDriver == null) break block4;
                this.itsDriver.emitPatternedBeep(new char[]{'F', 'f', 'F', 'f'});
                this.itsDriver.disableDevice(100);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.itsDriver.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        super.close();
    }

    public void pollAndProcessInput() {
        try {
            this.itsDriver.read();
            this.itsDriver.getLastButtonValues(this.itsCurrentButtonValues);
            this.itsDriver.getLastPositionValues(this.itsCurrentPositionValues);
            this.setDeltaDeviceInput(this.itsCurrentPositionValues, this.itsCurrentButtonValues);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

