/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public abstract class GeometryGenerator {
    private Vector3f normal;
    private Vector3f v0 = new Vector3f();
    private Vector3f v1 = new Vector3f();

    protected GeometryGenerator() {
        this.normal = new Vector3f();
    }

    public abstract int getVertexCount(GeometryData var1) throws UnsupportedTypeException;

    public abstract void generate(GeometryData var1) throws UnsupportedTypeException, InvalidArraySizeException;

    protected Vector3f createFaceNormal(float[] fArray, int n, int n2, int n3) {
        this.v0.x = fArray[n2] - fArray[n];
        this.v0.y = fArray[n2 + 1] - fArray[n + 1];
        this.v0.z = fArray[n2 + 2] - fArray[n + 2];
        this.v1.x = fArray[n] - fArray[n3];
        this.v1.y = fArray[n + 1] - fArray[n3 + 1];
        this.v1.z = fArray[n + 2] - fArray[n3 + 2];
        this.normal.cross(this.v0, this.v1);
        this.normal.normalize();
        return this.normal;
    }

    protected Vector3f createFaceNormal(float[][] fArray, int n, int n2, int n3, int n4, int n5, int n6) {
        this.v0.x = fArray[n3][n4] - fArray[n][n2];
        this.v0.y = fArray[n3][n4 + 1] - fArray[n][n2 + 1];
        this.v0.z = fArray[n3][n4 + 2] - fArray[n][n2 + 2];
        this.v1.x = fArray[n][n2] - fArray[n5][n6];
        this.v1.y = fArray[n][n2 + 1] - fArray[n5][n6 + 1];
        this.v1.z = fArray[n][n2 + 2] - fArray[n5][n6 + 2];
        this.normal.cross(this.v0, this.v1);
        this.normal.normalize();
        return this.normal;
    }

    protected Vector3f createRadialNormal(float[] fArray, int n) {
        float f = fArray[n];
        float f2 = fArray[n + 1];
        float f3 = fArray[n + 2];
        float f4 = f * f + f2 * f2 + f3 * f3;
        if ((double)f4 != 0.0) {
            f4 = 1.0f / (float)Math.sqrt(f4);
            this.normal.x = f * f4;
            this.normal.y = f2 * f4;
            this.normal.z = f3 * f4;
        } else {
            this.normal.x = 0.0f;
            this.normal.y = 0.0f;
            this.normal.z = 0.0f;
        }
        return this.normal;
    }

    protected Vector3f createRadialNormal(float[] fArray, int n, float[] fArray2, int n2) {
        float f = fArray[n] - fArray2[n2];
        float f2 = fArray[n + 1] - fArray2[n2 + 1];
        float f3 = fArray[n + 2] - fArray2[n2 + 2];
        float f4 = f * f + f2 * f2 + f3 * f3;
        if ((double)f4 != 0.0) {
            f4 = 1.0f / (float)Math.sqrt(f4);
            this.normal.x = f * f4;
            this.normal.y = f2 * f4;
            this.normal.z = f3 * f4;
        } else {
            this.normal.x = 0.0f;
            this.normal.y = 0.0f;
            this.normal.z = 0.0f;
        }
        return this.normal;
    }

    protected void printData(GeometryData geometryData) {
        boolean bl = (geometryData.geometryComponents & 4) == 0;
        System.out.println();
        int n = 0;
        while (n < geometryData.vertexCount) {
            System.out.print(n);
            System.out.print("v: ");
            System.out.print(geometryData.coordinates[n * 3]);
            System.out.print(' ');
            System.out.print(geometryData.coordinates[n * 3 + 1]);
            System.out.print(' ');
            System.out.print(geometryData.coordinates[n * 3 + 2]);
            if (geometryData.normals != null) {
                System.out.print(", n: ");
                System.out.print(geometryData.normals[n * 3]);
                System.out.print(' ');
                System.out.print(geometryData.normals[n * 3 + 1]);
                System.out.print(' ');
                System.out.print(geometryData.normals[n * 3 + 2]);
            }
            if (geometryData.textureCoordinates != null) {
                System.out.print(", t: ");
                System.out.print(geometryData.textureCoordinates[n * 2]);
                System.out.print(' ');
                System.out.print(geometryData.textureCoordinates[n * 2 + 1]);
                if (bl) {
                    System.out.print(' ');
                    System.out.print(geometryData.textureCoordinates[n * 3 + 1]);
                }
            }
            System.out.println();
            ++n;
        }
    }
}

