/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class SphereGenerator
extends GeometryGenerator {
    private static final float DEFAULT_RADIUS = 1.0f;
    private static final int DEFAULT_FACETS = 16;
    private float radius;
    private int facetCount;
    private boolean useHalf;
    private float[] quadCoordinates;
    private int numQuadValues;
    private boolean quadChanged;
    private boolean facetsChanged;
    private float[] texCoordinates2D;
    private int numTexCoords2D;
    private float[] texCoordinates3D;
    private int numTexCoords3D;

    public SphereGenerator() {
        this(1.0f, 16, false);
    }

    public SphereGenerator(float f) {
        this(f, 16, false);
    }

    public SphereGenerator(float f, boolean bl) {
        this(f, 16, bl);
    }

    public SphereGenerator(float f, int n) {
        this(f, n, false);
    }

    public SphereGenerator(float f, int n, boolean bl) {
        if (n < 4) {
            throw new IllegalArgumentException("Number of facets is < 4");
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Number of facets not / 2");
        }
        this.facetCount = n;
        this.radius = f;
        this.useHalf = bl;
        this.quadChanged = true;
        this.facetsChanged = true;
    }

    public boolean isHalf() {
        return this.useHalf;
    }

    public float getDimension() {
        return this.radius;
    }

    public void setDimensions(float f, boolean bl) {
        if (f != this.radius || this.useHalf != bl) {
            this.quadChanged = true;
        }
        if (this.useHalf != bl) {
            this.facetsChanged = true;
        }
        this.radius = f;
        this.useHalf = bl;
    }

    public void setFacetCount(int n) {
        if (n < 4) {
            throw new IllegalArgumentException("Number of facets is < 4");
        }
        if (n % 2 != 0) {
            throw new IllegalArgumentException("Number of facets not / 2");
        }
        if (this.facetCount != n) {
            this.quadChanged = true;
            this.facetsChanged = true;
        }
        this.facetCount = n;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 1: {
                n = this.facetCount * this.facetCount * 3;
                break;
            }
            case 2: {
                n = this.facetCount * this.facetCount * 2;
                break;
            }
            case 3: {
                n = (this.facetCount >> 1) * (this.facetCount + 1) * 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n = (this.facetCount + 1) * this.facetCount;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        if (this.useHalf) {
            n /= 2;
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            case 2: {
                this.unindexedQuads(geometryData);
                break;
            }
            case 3: {
                this.triangleStrips(geometryData);
                break;
            }
            case 5: {
                this.indexedQuads(geometryData);
                break;
            }
            case 6: {
                this.indexedTriangles(geometryData);
                break;
            }
            case 7: {
                this.indexedTriangleStrips(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateUnindexedTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedQuadCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateUnindexedQuadTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
        int n4 = geometryData.vertexCount * 2;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n4];
        } else if (geometryData.indexes.length < n4) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n4);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n4;
        int n5 = 0;
        int n6 = this.facetCount / 4;
        int n7 = 0;
        while (n7 < n6) {
            n3 = n7 * (this.facetCount + 1);
            n2 = 0;
            while (n2 < this.facetCount) {
                n = n2 + n3;
                nArray[n5++] = n + this.facetCount + 1;
                nArray[n5++] = n;
                nArray[n5++] = n + 1;
                nArray[n5++] = n + this.facetCount + 2;
                ++n2;
            }
            ++n7;
        }
        if (!this.useHalf) {
            n7 = n6 + 1;
            while (n7 <= n6 * 2) {
                n3 = n7 * (this.facetCount + 1);
                n2 = 0;
                while (n2 < this.facetCount) {
                    n = n2 + n3;
                    nArray[n5++] = n;
                    nArray[n5++] = n + this.facetCount + 1;
                    nArray[n5++] = n + this.facetCount + 2;
                    nArray[n5++] = n + 1;
                    ++n2;
                }
                ++n7;
            }
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
        int n4 = geometryData.vertexCount * 6;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n4];
        } else if (geometryData.indexes.length < n4) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n4);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n4;
        int n5 = 0;
        int n6 = this.facetCount / 4;
        int n7 = 0;
        while (n7 < n6) {
            n3 = n7 * (this.facetCount + 1);
            n2 = 0;
            while (n2 < this.facetCount) {
                n = n2 + n3;
                nArray[n5++] = n + this.facetCount + 1;
                nArray[n5++] = n;
                nArray[n5++] = n + 1;
                nArray[n5++] = n + 1;
                nArray[n5++] = n + this.facetCount + 2;
                nArray[n5++] = n + this.facetCount + 1;
                ++n2;
            }
            ++n7;
        }
        if (!this.useHalf) {
            n7 = n6 + 1;
            while (n7 <= n6 * 2) {
                n3 = n7 * (this.facetCount + 1);
                n2 = 0;
                while (n2 < this.facetCount) {
                    n = n2 + n3;
                    nArray[n5++] = n;
                    nArray[n5++] = n + this.facetCount + 1;
                    nArray[n5++] = n + this.facetCount + 2;
                    nArray[n5++] = n + this.facetCount + 2;
                    nArray[n5++] = n + 1;
                    nArray[n5++] = n;
                    ++n2;
                }
                ++n7;
            }
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriStripCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateUnindexedTriStripTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
        int n = this.facetCount >> 1;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = this.facetCount + 1 << 1;
        int[] nArray = geometryData.stripCounts;
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = n2;
        }
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateIndexedTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTexture3D(geometryData);
        }
        int n4 = this.facetCount * (this.facetCount + 1);
        int n5 = this.facetCount >> 1;
        if (this.useHalf) {
            n4 >>= 1;
            n5 >>= 1;
        }
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n4];
        } else if (geometryData.indexes.length < n4) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n4);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n5];
        } else if (geometryData.stripCounts.length < n5) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n5);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n4;
        geometryData.numStrips = n5;
        int n6 = 0;
        int n7 = this.facetCount >> 2;
        int n8 = 0;
        while (n8 < n7) {
            n3 = n8 * (this.facetCount + 1);
            nArray2[n8] = this.facetCount + 1 << 1;
            n2 = 0;
            while (n2 <= this.facetCount) {
                n = n2 + n3;
                nArray[n6++] = n + this.facetCount + 1;
                nArray[n6++] = n;
                ++n2;
            }
            ++n8;
        }
        if (this.useHalf) {
            return;
        }
        n8 = n7;
        while (n8 < n7 << 1) {
            n3 = (n8 + 1) * (this.facetCount + 1);
            nArray2[n8] = this.facetCount + 1 << 1;
            n2 = 0;
            while (n2 <= this.facetCount) {
                n = n2 + n3;
                nArray[n6++] = n;
                nArray[n6++] = n + this.facetCount + 1;
                ++n2;
            }
            ++n8;
        }
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.facetCount * this.facetCount * 6;
        if (this.useHalf) {
            n /= 2;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.recalculateQuadSphere();
        int n2 = this.facetCount / 4;
        int n3 = (this.facetCount + 1) * 3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5 * n3;
            int n7 = 0;
            while (n7 < this.facetCount) {
                int n8 = n7 * 3 + n6;
                fArray[n4++] = this.quadCoordinates[n8 + n3];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 1];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 2];
                fArray[n4++] = this.quadCoordinates[n8];
                fArray[n4++] = this.quadCoordinates[n8 + 1];
                fArray[n4++] = this.quadCoordinates[n8 + 2];
                fArray[n4++] = this.quadCoordinates[n8 + 3];
                fArray[n4++] = this.quadCoordinates[n8 + 4];
                fArray[n4++] = this.quadCoordinates[n8 + 5];
                fArray[n4++] = this.quadCoordinates[n8 + 3];
                fArray[n4++] = this.quadCoordinates[n8 + 4];
                fArray[n4++] = this.quadCoordinates[n8 + 5];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 3];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 4];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 5];
                fArray[n4++] = this.quadCoordinates[n8 + n3];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 1];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 2];
                ++n7;
            }
            ++n5;
        }
        int n9 = n4;
        n5 = 0;
        while (n5 < n9) {
            fArray[n4++] = fArray[n5 + 6];
            fArray[n4++] = -fArray[n5 + 7];
            fArray[n4++] = fArray[n5 + 8];
            fArray[n4++] = fArray[n5 + 3];
            fArray[n4++] = -fArray[n5 + 4];
            fArray[n4++] = fArray[n5 + 5];
            fArray[n4++] = fArray[n5 + 0];
            fArray[n4++] = -fArray[n5 + 1];
            fArray[n4++] = fArray[n5 + 2];
            fArray[n4++] = fArray[n5 + 15];
            fArray[n4++] = -fArray[n5 + 16];
            fArray[n4++] = fArray[n5 + 17];
            fArray[n4++] = fArray[n5 + 12];
            fArray[n4++] = -fArray[n5 + 13];
            fArray[n4++] = fArray[n5 + 14];
            fArray[n4++] = fArray[n5 + 9];
            fArray[n4++] = -fArray[n5 + 10];
            fArray[n4++] = fArray[n5 + 11];
            n5 += 18;
        }
    }

    private void generateUnindexedQuadCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (this.useHalf) {
            n /= 2;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.recalculateQuadSphere();
        int n2 = this.facetCount / 4;
        int n3 = (this.facetCount + 1) * 3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5 * n3;
            int n7 = 0;
            while (n7 < this.facetCount) {
                int n8 = n7 * 3 + n6;
                fArray[n4++] = this.quadCoordinates[n8 + n3];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 1];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 2];
                fArray[n4++] = this.quadCoordinates[n8];
                fArray[n4++] = this.quadCoordinates[n8 + 1];
                fArray[n4++] = this.quadCoordinates[n8 + 2];
                fArray[n4++] = this.quadCoordinates[n8 + 3];
                fArray[n4++] = this.quadCoordinates[n8 + 4];
                fArray[n4++] = this.quadCoordinates[n8 + 5];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 3];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 4];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 5];
                ++n7;
            }
            ++n5;
        }
        if (!this.useHalf) {
            int n9 = n4;
            n5 = 0;
            while (n5 < n9) {
                fArray[n4++] = fArray[n5 + 3];
                fArray[n4++] = -fArray[n5 + 4];
                fArray[n4++] = fArray[n5 + 5];
                fArray[n4++] = fArray[n5];
                fArray[n4++] = -fArray[n5 + 1];
                fArray[n4++] = fArray[n5 + 2];
                fArray[n4++] = fArray[n5 + 9];
                fArray[n4++] = -fArray[n5 + 10];
                fArray[n4++] = fArray[n5 + 11];
                fArray[n4++] = fArray[n5 + 6];
                fArray[n4++] = -fArray[n5 + 7];
                fArray[n4++] = fArray[n5 + 8];
                n5 += 12;
            }
        }
    }

    private void generateUnindexedTriStripCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = (this.facetCount >> 1) * (this.facetCount + 1) * 2;
        if (this.useHalf) {
            n /= 2;
        }
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.recalculateQuadSphere();
        int n2 = this.facetCount / 4;
        int n3 = (this.facetCount + 1) * 3;
        int n4 = 0;
        int n5 = 0;
        while (n5 < n2) {
            int n6 = n5 * n3;
            int n7 = 0;
            while (n7 <= this.facetCount) {
                int n8 = n7 * 3 + n6;
                fArray[n4++] = this.quadCoordinates[n8 + n3];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 1];
                fArray[n4++] = this.quadCoordinates[n8 + n3 + 2];
                fArray[n4++] = this.quadCoordinates[n8];
                fArray[n4++] = this.quadCoordinates[n8 + 1];
                fArray[n4++] = this.quadCoordinates[n8 + 2];
                ++n7;
            }
            ++n5;
        }
        int n9 = n4;
        n5 = 0;
        while (n5 < n9) {
            fArray[n4++] = fArray[n5 + 3];
            fArray[n4++] = -fArray[n5 + 4];
            fArray[n4++] = fArray[n5 + 5];
            fArray[n4++] = fArray[n5];
            fArray[n4++] = -fArray[n5 + 1];
            fArray[n4++] = fArray[n5 + 2];
            n5 += 6;
        }
    }

    private void generateIndexedCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.recalculateQuadSphere();
        System.arraycopy(this.quadCoordinates, 0, geometryData.coordinates, 0, this.numQuadValues);
    }

    private void generateNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.normals == null) {
            geometryData.normals = new float[n * 3];
        } else if (geometryData.normals.length < n * 3) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n * 3);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = n;
        while (--n3 >= 0) {
            Vector3f vector3f = this.createRadialNormal(geometryData.coordinates, n2);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
        }
    }

    private void generateUnindexedTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        int n4 = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n4];
        } else if (geometryData.textureCoordinates.length < n4) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n4);
        }
        float[] fArray = geometryData.textureCoordinates;
        this.recalc2DTexture();
        int n5 = this.facetCount / 4;
        int n6 = (this.facetCount + 1) * 2;
        int n7 = this.facetCount - 1;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            n3 = n9 * n6;
            n2 = 0;
            while (n2 < n7) {
                n = n2 * 2 + n3;
                fArray[n8++] = this.texCoordinates2D[n + n6];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
                fArray[n8++] = this.texCoordinates2D[n];
                fArray[n8++] = this.texCoordinates2D[n + 1];
                fArray[n8++] = this.texCoordinates2D[n + 2];
                fArray[n8++] = this.texCoordinates2D[n + 3];
                fArray[n8++] = this.texCoordinates2D[n + 2];
                fArray[n8++] = this.texCoordinates2D[n + 3];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 2];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 3];
                fArray[n8++] = this.texCoordinates2D[n + n6];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
                ++n2;
            }
            n = n2 * 2 + n3;
            fArray[n8++] = this.texCoordinates2D[n + n6];
            fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
            fArray[n8++] = this.texCoordinates2D[n];
            fArray[n8++] = this.texCoordinates2D[n + 1];
            fArray[n8++] = 1.0f;
            fArray[n8++] = this.texCoordinates2D[n3 + 1];
            fArray[n8++] = 1.0f;
            fArray[n8++] = this.texCoordinates2D[n3 + 1];
            fArray[n8++] = 1.0f;
            fArray[n8++] = this.texCoordinates2D[n3 + n6 + 1];
            fArray[n8++] = this.texCoordinates2D[n + n6];
            fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
            ++n9;
        }
        if (this.useHalf) {
            return;
        }
        int n10 = this.numTexCoords2D / 2;
        n9 = 0;
        while (n9 < n5) {
            n3 = n9 * n6;
            n2 = 0;
            while (n2 < n7) {
                n = 2 * n2 + n3 + n10;
                fArray[n8++] = this.texCoordinates2D[n + 2];
                fArray[n8++] = this.texCoordinates2D[n + 3];
                fArray[n8++] = this.texCoordinates2D[n];
                fArray[n8++] = this.texCoordinates2D[n + 1];
                fArray[n8++] = this.texCoordinates2D[n + n6];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
                fArray[n8++] = this.texCoordinates2D[n + n6];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 2];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 3];
                fArray[n8++] = this.texCoordinates2D[n + 2];
                fArray[n8++] = this.texCoordinates2D[n + 3];
                ++n2;
            }
            n = n2 * 2 + n3 + n10;
            fArray[n8++] = this.texCoordinates2D[n10 + n3];
            fArray[n8++] = this.texCoordinates2D[n10 + n3 + 1];
            fArray[n8++] = this.texCoordinates2D[n];
            fArray[n8++] = this.texCoordinates2D[n + 1];
            fArray[n8++] = 1.0f;
            fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
            fArray[n8++] = 1.0f;
            fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
            fArray[n8++] = 1.0f;
            fArray[n8++] = this.texCoordinates2D[n10 + n3 + n6 + 1];
            fArray[n8++] = this.texCoordinates2D[n10 + n3];
            fArray[n8++] = this.texCoordinates2D[n10 + n3 + 1];
            ++n9;
        }
    }

    private void generateUnindexedQuadTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        int n4 = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n4];
        } else if (geometryData.textureCoordinates.length < n4) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n4);
        }
        float[] fArray = geometryData.textureCoordinates;
        this.recalc2DTexture();
        int n5 = this.facetCount / 4;
        int n6 = (this.facetCount + 1) * 2;
        int n7 = this.facetCount - 1;
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            n3 = n9 * n6;
            n2 = 0;
            while (n2 < n7) {
                n = n2 * 2 + n3;
                fArray[n8++] = this.texCoordinates2D[n + n6];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
                fArray[n8++] = this.texCoordinates2D[n];
                fArray[n8++] = this.texCoordinates2D[n + 1];
                fArray[n8++] = this.texCoordinates2D[n + 2];
                fArray[n8++] = this.texCoordinates2D[n + 3];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 2];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 3];
                ++n2;
            }
            n = n2 * 2 + n3;
            fArray[n8++] = this.texCoordinates2D[n + n6];
            fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
            fArray[n8++] = this.texCoordinates2D[n];
            fArray[n8++] = this.texCoordinates2D[n + 1];
            fArray[n8++] = 1.0f;
            fArray[n8++] = this.texCoordinates2D[n3 + 1];
            fArray[n8++] = 1.0f;
            fArray[n8++] = this.texCoordinates2D[n3 + n6 + 1];
            ++n9;
        }
        if (this.useHalf) {
            return;
        }
        int n10 = this.numTexCoords2D / 2;
        n9 = 0;
        while (n9 < n5) {
            n3 = n9 * n6;
            n2 = 0;
            while (n2 < n7) {
                n = n2 * 2 + n3 + n10;
                fArray[n8++] = this.texCoordinates2D[n];
                fArray[n8++] = this.texCoordinates2D[n + 1];
                fArray[n8++] = this.texCoordinates2D[n + n6];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 2];
                fArray[n8++] = this.texCoordinates2D[n + n6 + 3];
                fArray[n8++] = this.texCoordinates2D[n + 2];
                fArray[n8++] = this.texCoordinates2D[n + 3];
                ++n2;
            }
            n = n2 * 2 + n3 + n10;
            fArray[n8++] = this.texCoordinates2D[n];
            fArray[n8++] = this.texCoordinates2D[n + 1];
            fArray[n8++] = this.texCoordinates2D[n + n6];
            fArray[n8++] = this.texCoordinates2D[n + n6 + 1];
            fArray[n8++] = 1.0f;
            fArray[n8++] = this.texCoordinates2D[n10 + n3 + n6 + 1];
            fArray[n8++] = 1.0f;
            fArray[n8++] = this.texCoordinates2D[n10 + n3 + 1];
            ++n9;
        }
    }

    private void generateUnindexedTriStripTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        int n4 = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n4];
        } else if (geometryData.textureCoordinates.length < n4) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n4);
        }
        float[] fArray = geometryData.textureCoordinates;
        this.recalc2DTexture();
        int n5 = this.facetCount / 4;
        int n6 = (this.facetCount + 1) * 2;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            n3 = n8 * n6;
            n2 = 0;
            while (n2 < this.facetCount) {
                n = n2 * 2 + n3;
                fArray[n7++] = this.texCoordinates2D[n + n6];
                fArray[n7++] = this.texCoordinates2D[n + n6 + 1];
                fArray[n7++] = this.texCoordinates2D[n];
                fArray[n7++] = this.texCoordinates2D[n + 1];
                ++n2;
            }
            fArray[n7++] = 1.0f;
            fArray[n7++] = this.texCoordinates2D[n3 + 1];
            fArray[n7++] = 1.0f;
            fArray[n7++] = this.texCoordinates2D[n3 + n6 + 1];
            ++n8;
        }
        if (this.useHalf) {
            return;
        }
        int n9 = this.numTexCoords2D / 2;
        n8 = 0;
        while (n8 < n5) {
            n3 = n8 * n6;
            n2 = 0;
            while (n2 < this.facetCount) {
                n = 2 * n2 + n3 + n9;
                fArray[n7++] = this.texCoordinates2D[n];
                fArray[n7++] = this.texCoordinates2D[n + 1];
                fArray[n7++] = this.texCoordinates2D[n + n6];
                fArray[n7++] = this.texCoordinates2D[n + n6 + 1];
                ++n2;
            }
            fArray[n7++] = 1.0f;
            fArray[n7++] = this.texCoordinates2D[n3 + n9 + 1];
            fArray[n7++] = 1.0f;
            fArray[n7++] = this.texCoordinates2D[n3 + n9 + n6 + 1];
            ++n8;
        }
    }

    private void generateIndexedTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
        this.recalc2DTexture();
        System.arraycopy(this.texCoordinates2D, 0, geometryData.textureCoordinates, 0, this.numTexCoords2D);
    }

    private void generateTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void recalculateQuadSphere() {
        if (!this.quadChanged) {
            return;
        }
        this.quadChanged = false;
        int n = (this.facetCount + 1) * this.facetCount;
        if (this.useHalf) {
            n /= 2;
        }
        if (this.quadCoordinates == null || n * 3 > this.quadCoordinates.length) {
            this.quadCoordinates = new float[n * 3];
        }
        this.numQuadValues = n * 3;
        int n2 = this.facetCount / 4;
        double d = Math.PI * 2 / (double)this.facetCount;
        int n3 = 0;
        double d2 = this.radius;
        float f = 0.0f;
        float[] fArray = new float[this.facetCount];
        float[] fArray2 = new float[this.facetCount];
        int n4 = 0;
        while (n4 < this.facetCount) {
            fArray[n4] = (float)Math.cos(d * (double)n4 + 1.5707963267948966);
            fArray2[n4] = (float)Math.sin(d * (double)n4 + 1.5707963267948966);
            this.quadCoordinates[n3++] = (float)(d2 * (double)fArray2[n4]);
            this.quadCoordinates[n3++] = f;
            this.quadCoordinates[n3++] = (float)(d2 * (double)fArray[n4]);
            ++n4;
        }
        this.quadCoordinates[n3++] = (float)(d2 * (double)fArray2[0]);
        this.quadCoordinates[n3++] = f;
        this.quadCoordinates[n3++] = (float)(d2 * (double)fArray[0]);
        int n5 = 1;
        while (n5 < n2) {
            d2 = (double)this.radius * Math.cos(d * (double)n5);
            f = (float)((double)this.radius * Math.sin(d * (double)n5));
            n4 = 0;
            while (n4 < this.facetCount) {
                this.quadCoordinates[n3++] = (float)(d2 * (double)fArray2[n4]);
                this.quadCoordinates[n3++] = f;
                this.quadCoordinates[n3++] = (float)(d2 * (double)fArray[n4]);
                ++n4;
            }
            this.quadCoordinates[n3++] = (float)(d2 * (double)fArray2[0]);
            this.quadCoordinates[n3++] = f;
            this.quadCoordinates[n3++] = (float)(d2 * (double)fArray[0]);
            ++n5;
        }
        n4 = this.facetCount + 1;
        while (--n4 >= 0) {
            this.quadCoordinates[n3++] = 0.0f;
            this.quadCoordinates[n3++] = this.radius;
            this.quadCoordinates[n3++] = 0.0f;
        }
        if (!this.useHalf) {
            int n6 = n3;
            System.arraycopy(this.quadCoordinates, 0, this.quadCoordinates, n6, n6);
            n4 = this.quadCoordinates.length - 2;
            while (n4 > n6) {
                this.quadCoordinates[n4] = -this.quadCoordinates[n4];
                n4 -= 3;
            }
        }
    }

    private void recalc2DTexture() {
        float f;
        if (!this.facetsChanged) {
            return;
        }
        this.facetsChanged = false;
        int n = (this.facetCount - 2) * (this.facetCount + 1);
        if (this.useHalf) {
            n /= 2;
        }
        if (this.texCoordinates2D == null || n * 2 > this.texCoordinates2D.length) {
            this.texCoordinates2D = new float[n * 2];
        }
        int n2 = this.facetCount / 4;
        float f2 = 1.0f / (float)this.facetCount;
        int n3 = 0;
        float[] fArray = new float[this.facetCount];
        int n4 = 0;
        while (n4 < this.facetCount) {
            fArray[n4] = (float)n4 * f2;
            this.texCoordinates2D[n3++] = fArray[n4];
            this.texCoordinates2D[n3++] = 0.5f;
            ++n4;
        }
        this.texCoordinates2D[n3++] = 1.0f;
        this.texCoordinates2D[n3++] = 0.5f;
        int n5 = 1;
        while (n5 < n2) {
            f = 0.5f + f2 * 2.0f * (float)n5;
            n4 = 0;
            while (n4 < this.facetCount) {
                this.texCoordinates2D[n3++] = fArray[n4];
                this.texCoordinates2D[n3++] = f;
                ++n4;
            }
            this.texCoordinates2D[n3++] = 1.0f;
            this.texCoordinates2D[n3++] = f;
            ++n5;
        }
        this.texCoordinates2D[n3++] = 0.0f;
        this.texCoordinates2D[n3++] = 1.0f;
        n4 = 1;
        while (n4 < this.facetCount) {
            this.texCoordinates2D[n3++] = fArray[n4];
            this.texCoordinates2D[n3++] = 1.0f;
            ++n4;
        }
        this.texCoordinates2D[n3++] = 1.0f;
        this.texCoordinates2D[n3++] = 1.0f;
        if (this.useHalf) {
            return;
        }
        n4 = 0;
        while (n4 < this.facetCount) {
            this.texCoordinates2D[n3++] = fArray[n4];
            this.texCoordinates2D[n3++] = 0.5f;
            ++n4;
        }
        this.texCoordinates2D[n3++] = 1.0f;
        this.texCoordinates2D[n3++] = 0.5f;
        n5 = 1;
        while (n5 < n2) {
            f = 0.5f - f2 * 2.0f * (float)n5;
            n4 = 0;
            while (n4 < this.facetCount) {
                this.texCoordinates2D[n3++] = fArray[n4];
                this.texCoordinates2D[n3++] = f;
                ++n4;
            }
            this.texCoordinates2D[n3++] = 1.0f;
            this.texCoordinates2D[n3++] = f;
            ++n5;
        }
        n4 = 0;
        while (n4 < this.facetCount) {
            this.texCoordinates2D[n3++] = fArray[n4];
            this.texCoordinates2D[n3++] = 0.0f;
            ++n4;
        }
        this.texCoordinates2D[n3++] = 1.0f;
        this.texCoordinates2D[n3++] = 0.0f;
        this.numTexCoords2D = n3;
    }
}

