/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class SpringGenerator
extends GeometryGenerator {
    private static final float DEFAULT_INNER_RADIUS = 0.25f;
    private static final float DEFAULT_OUTER_RADIUS = 1.0f;
    private static final int DEFAULT_INNER_FACETS = 16;
    private static final int DEFAULT_OUTER_FACETS = 16;
    private static final int DEFAULT_LOOP_COUNT = 4;
    private static final float DEFAULT_LOOP_SPACING = 1.0f;
    private float innerRadius;
    private float outerRadius;
    private float loopSpacing;
    private int loopCount;
    private int innerFacetCount;
    private int outerFacetCount;
    private float[] shapeCoordinates;
    private int numShapeValues;
    private boolean shapeChanged;
    private float[] oradiusCoordinates;

    public SpringGenerator() {
        this(0.25f, 1.0f, 1.0f, 4, 16, 16);
    }

    public SpringGenerator(float f, float f2) {
        this(f, f2, 1.0f, 4, 16, 16);
    }

    public SpringGenerator(int n) {
        this(0.25f, 1.0f, 1.0f, n, 16, 16);
    }

    public SpringGenerator(float f) {
        this(0.25f, 1.0f, f, 4, 16, 16);
    }

    public SpringGenerator(int n, int n2) {
        this(0.25f, 1.0f, 1.0f, 4, n, n2);
    }

    public SpringGenerator(float f, float f2, float f3, int n) {
        this(f, f2, f3, n, 16, 16);
    }

    public SpringGenerator(float f, float f2, float f3, int n, int n2, int n3) {
        if (n2 < 4 || n3 < 4) {
            throw new IllegalArgumentException("Number of facets is < 4");
        }
        if (n2 % 4 != 0) {
            throw new IllegalArgumentException("Inner facets not / 4");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Loop count < 1");
        }
        this.innerRadius = f;
        this.outerRadius = f2;
        this.innerFacetCount = n2;
        this.outerFacetCount = n3;
        this.loopCount = n;
        this.loopSpacing = f3;
        this.shapeChanged = true;
    }

    public float[] getDimensions() {
        return new float[]{this.innerRadius, this.outerRadius, this.loopSpacing, this.loopCount};
    }

    public void setDimensions(float f, float f2) {
        if (this.innerRadius != f || this.outerRadius != f2) {
            this.shapeChanged = true;
            this.innerRadius = f;
            this.outerRadius = f2;
        }
    }

    public void setLoopDimensions(float f, int n) {
        if (this.loopSpacing != f || this.loopCount != n) {
            this.shapeChanged = true;
            this.loopSpacing = f;
            this.loopCount = n;
        }
    }

    public void setFacetCount(int n, int n2) {
        if (n < 4 || n2 < 4) {
            throw new IllegalArgumentException("Number of facets is < 4");
        }
        if (n % 4 != 0) {
            throw new IllegalArgumentException("Inner facets not / 4");
        }
        this.innerFacetCount = n;
        this.outerFacetCount = n2;
        this.shapeChanged = true;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 1: {
                n = this.innerFacetCount * this.outerFacetCount * 6;
                break;
            }
            case 2: {
                n = this.innerFacetCount * this.outerFacetCount * 4;
                break;
            }
            case 3: {
                n = this.innerFacetCount * (this.outerFacetCount + 1) * 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n = this.innerFacetCount * (this.outerFacetCount + 1);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n *= this.loopCount;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            case 2: {
                this.unindexedQuads(geometryData);
                break;
            }
            case 3: {
                this.triangleStrips(geometryData);
                break;
            }
            case 5: {
                this.indexedQuads(geometryData);
                break;
            }
            case 6: {
                this.indexedTriangles(geometryData);
                break;
            }
            case 7: {
                this.indexedTriangleStrips(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedQuadCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedQuadNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n4 = geometryData.vertexCount * 4;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n4];
        } else if (geometryData.indexes.length < n4) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n4);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n4;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.innerFacetCount - 1) {
            n3 = n6 * (this.outerFacetCount + 1);
            n2 = 0;
            while (n2 < this.outerFacetCount) {
                n = n2 + n3;
                nArray[n5++] = n + this.outerFacetCount + 1;
                nArray[n5++] = n;
                nArray[n5++] = n + 1;
                nArray[n5++] = n + this.outerFacetCount + 2;
                ++n2;
            }
            ++n6;
        }
        n3 = (this.innerFacetCount - 1) * (this.outerFacetCount + 1);
        n2 = 0;
        while (n2 < this.outerFacetCount) {
            n = n2 + n3;
            nArray[n5++] = n2;
            nArray[n5++] = n;
            nArray[n5++] = n + 1;
            nArray[n5++] = n2 + 1;
            ++n2;
        }
        n2 = 1;
        while (n2 < this.loopCount) {
            System.arraycopy(nArray, 0, nArray, n2 * n5, n5);
            ++n2;
        }
        int n7 = nArray[n5 - 2] + 1;
        int n8 = n5;
        n6 = 1;
        while (n6 < this.loopCount) {
            n2 = n8;
            while (--n2 >= 0) {
                int n9 = n5++;
                nArray[n9] = nArray[n9] + n7 * n6;
            }
            ++n6;
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n4 = geometryData.vertexCount * 6;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n4];
        } else if (geometryData.indexes.length < n4) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n4);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n4;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.innerFacetCount - 1) {
            n3 = n6 * (this.outerFacetCount + 1);
            n2 = 0;
            while (n2 < this.outerFacetCount) {
                n = n2 + n3;
                nArray[n5++] = n + this.outerFacetCount + 1;
                nArray[n5++] = n;
                nArray[n5++] = n + 1;
                nArray[n5++] = n + 1;
                nArray[n5++] = n + this.outerFacetCount + 2;
                nArray[n5++] = n + this.outerFacetCount + 1;
                ++n2;
            }
            ++n6;
        }
        n3 = (this.innerFacetCount - 1) * (this.outerFacetCount + 1);
        n2 = 0;
        while (n2 < this.outerFacetCount) {
            n = n2 + n3;
            nArray[n5++] = n2;
            nArray[n5++] = n;
            nArray[n5++] = n + 1;
            nArray[n5++] = n + 1;
            nArray[n5++] = n2 + 1;
            nArray[n5++] = n2++;
        }
        n2 = 1;
        while (n2 < this.loopCount) {
            System.arraycopy(nArray, 0, nArray, n2 * n5, n5);
            ++n2;
        }
        int n7 = nArray[n5 - 3] + 1;
        int n8 = n5;
        n6 = 1;
        while (n6 < this.loopCount) {
            n2 = n8;
            while (--n2 >= 0) {
                int n9 = n5++;
                nArray[n9] = nArray[n9] + n7 * n6;
            }
            ++n6;
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriStripCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriStripNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.innerFacetCount * this.loopCount;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = this.outerFacetCount + 1 << 1;
        int[] nArray = geometryData.stripCounts;
        int n3 = n;
        while (--n3 >= 0) {
            nArray[n3] = n2;
        }
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n3 = this.innerFacetCount * (this.outerFacetCount + 1) * 2 * this.loopCount;
        int n4 = this.innerFacetCount * this.loopCount;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n3];
        } else if (geometryData.indexes.length < n3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n3);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n4];
        } else if (geometryData.stripCounts.length < n4) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n4);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n3;
        geometryData.numStrips = n4;
        int n5 = this.outerFacetCount + 1 << 1;
        int n6 = 0;
        int n7 = n4;
        while (--n7 >= 0) {
            nArray2[n7] = n5;
        }
        int n8 = 0;
        while (n8 < this.innerFacetCount - 1) {
            n2 = n8 * (this.outerFacetCount + 1);
            n7 = 0;
            while (n7 <= this.outerFacetCount) {
                n = n7 + n2;
                nArray[n6++] = n + this.outerFacetCount + 1;
                nArray[n6++] = n;
                ++n7;
            }
            ++n8;
        }
        n2 = (this.innerFacetCount - 1) * (this.outerFacetCount + 1);
        n7 = 0;
        while (n7 <= this.outerFacetCount) {
            n = n7 + n2;
            nArray[n6++] = n7++;
            nArray[n6++] = n;
        }
        n7 = 1;
        while (n7 < this.loopCount) {
            System.arraycopy(nArray, 0, nArray, n7 * n6, n6);
            ++n7;
        }
        int n9 = nArray[n6 - 1] + 1;
        int n10 = n6;
        n8 = 1;
        while (n8 < this.loopCount) {
            n7 = n10;
            while (--n7 >= 0) {
                int n11 = n6++;
                nArray[n11] = nArray[n11] + n9 * n8;
            }
            ++n8;
        }
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = this.innerFacetCount * this.outerFacetCount * 6 * this.loopCount;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n2 * 3];
        } else if (geometryData.coordinates.length < n2 * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n2 * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n2;
        this.generateShape();
        int n3 = (this.outerFacetCount + 1) * 3;
        int n4 = 0;
        float f = this.loopSpacing * (float)(this.loopCount / 2);
        int n5 = 0;
        while (n5 < this.innerFacetCount) {
            int n6 = n5 * n3;
            n = 0;
            while (n < this.outerFacetCount) {
                int n7 = n * 3 + n6;
                fArray[n4++] = this.shapeCoordinates[n7 + n3];
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 1] + f;
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 2];
                fArray[n4++] = this.shapeCoordinates[n7];
                fArray[n4++] = this.shapeCoordinates[n7 + 1] + f;
                fArray[n4++] = this.shapeCoordinates[n7 + 2];
                fArray[n4++] = this.shapeCoordinates[n7 + 3];
                fArray[n4++] = this.shapeCoordinates[n7 + 4] + f;
                fArray[n4++] = this.shapeCoordinates[n7 + 5];
                fArray[n4++] = this.shapeCoordinates[n7 + 3];
                fArray[n4++] = this.shapeCoordinates[n7 + 4] + f;
                fArray[n4++] = this.shapeCoordinates[n7 + 5];
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 3];
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 4] + f;
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 5];
                fArray[n4++] = this.shapeCoordinates[n7 + n3];
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 1] + f;
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 2];
                ++n;
            }
            ++n5;
        }
        n = 1;
        while (n < this.loopCount) {
            System.arraycopy(fArray, 0, fArray, n * n4, n4);
            ++n;
        }
        int n8 = ++n4 / 3;
        f = 0.0f;
        n = 1;
        while (n < this.loopCount) {
            f += this.loopSpacing;
            n5 = 0;
            while (n5 < n8) {
                int n9 = n4;
                fArray[n9] = fArray[n9] + f;
                n4 += 3;
                ++n5;
            }
            ++n;
        }
    }

    private void generateUnindexedQuadCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = this.innerFacetCount * this.outerFacetCount * 4 * this.loopCount;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n2 * 3];
        } else if (geometryData.coordinates.length < n2 * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n2 * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n2;
        this.generateShape();
        int n3 = (this.outerFacetCount + 1) * 3;
        int n4 = 0;
        float f = this.loopSpacing * (float)(this.loopCount / 2);
        int n5 = 0;
        while (n5 < this.innerFacetCount) {
            int n6 = n5 * n3;
            n = 0;
            while (n < this.outerFacetCount) {
                int n7 = n * 3 + n6;
                fArray[n4++] = this.shapeCoordinates[n7 + n3];
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 1] + f;
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 2];
                fArray[n4++] = this.shapeCoordinates[n7];
                fArray[n4++] = this.shapeCoordinates[n7 + 1] + f;
                fArray[n4++] = this.shapeCoordinates[n7 + 2];
                fArray[n4++] = this.shapeCoordinates[n7 + 3];
                fArray[n4++] = this.shapeCoordinates[n7 + 4] + f;
                fArray[n4++] = this.shapeCoordinates[n7 + 5];
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 3];
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 4] + f;
                fArray[n4++] = this.shapeCoordinates[n7 + n3 + 5];
                ++n;
            }
            ++n5;
        }
        n = 1;
        while (n < this.loopCount) {
            System.arraycopy(fArray, 0, fArray, n * n4, n4);
            ++n;
        }
        int n8 = ++n4 / 3;
        f = 0.0f;
        n = 1;
        while (n < this.loopCount) {
            f += this.loopSpacing;
            n5 = 0;
            while (n5 < n8) {
                int n9 = n4;
                fArray[n9] = fArray[n9] + f;
                n4 += 3;
                ++n5;
            }
            ++n;
        }
    }

    private void generateUnindexedTriStripCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2;
        int n3;
        int n4 = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n4 * 3];
        } else if (geometryData.coordinates.length < n4 * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n4 * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n4;
        this.generateShape();
        int n5 = (this.outerFacetCount + 1) * 3;
        int n6 = 0;
        float f = this.loopSpacing * (float)(this.loopCount / 2);
        int n7 = 0;
        while (n7 < this.innerFacetCount - 1) {
            n3 = n7 * n5;
            n2 = 0;
            while (n2 <= this.outerFacetCount) {
                n = n2 * 3 + n3;
                fArray[n6++] = this.shapeCoordinates[n + n5];
                fArray[n6++] = this.shapeCoordinates[n + n5 + 1] + f;
                fArray[n6++] = this.shapeCoordinates[n + n5 + 2];
                fArray[n6++] = this.shapeCoordinates[n];
                fArray[n6++] = this.shapeCoordinates[n + 1] + f;
                fArray[n6++] = this.shapeCoordinates[n + 2];
                ++n2;
            }
            ++n7;
        }
        n3 = n7 * n5;
        n2 = 0;
        while (n2 <= this.outerFacetCount) {
            n = n2 * 3 + n3;
            fArray[n6++] = this.shapeCoordinates[n2 * 3];
            fArray[n6++] = this.shapeCoordinates[n2 * 3 + 1] + f;
            fArray[n6++] = this.shapeCoordinates[n2 * 3 + 2];
            fArray[n6++] = this.shapeCoordinates[n];
            fArray[n6++] = this.shapeCoordinates[n + 1] + f;
            fArray[n6++] = this.shapeCoordinates[n + 2];
            ++n2;
        }
        n2 = 1;
        while (n2 < this.loopCount) {
            System.arraycopy(fArray, 0, fArray, n2 * n6, n6);
            ++n2;
        }
        int n8 = ++n6 / 3;
        f = 0.0f;
        n2 = 1;
        while (n2 < this.loopCount) {
            f += this.loopSpacing;
            n7 = 0;
            while (n7 < n8) {
                int n9 = n6;
                fArray[n9] = fArray[n9] + f;
                n6 += 3;
                ++n7;
            }
            ++n2;
        }
    }

    private void generateIndexedCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.getVertexCount(geometryData);
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        int n2 = n * 3 / this.loopCount;
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.generateShape();
        int n3 = 0;
        while (n3 < this.loopCount) {
            System.arraycopy(this.shapeCoordinates, 0, fArray, n3 * n2, n2);
            ++n3;
        }
        int n4 = n2 / 3;
        float f = this.loopSpacing * (float)(this.loopCount / 2);
        n2 = 1;
        n3 = this.loopCount;
        while (--n3 >= 0) {
            int n5 = n4;
            while (--n5 >= 0) {
                int n6 = n2;
                fArray[n6] = fArray[n6] + f;
                n2 += 3;
            }
            f += this.loopSpacing;
        }
    }

    private void generateUnindexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        float[] fArray2 = new float[3];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.innerFacetCount) {
            Vector3f vector3f;
            n3 = 0;
            n = this.outerFacetCount;
            while (--n > 0) {
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3 + 3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3 + 3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3 + 3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                n3 += 3;
            }
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            ++n4;
        }
        n = 1;
        while (n < this.loopCount) {
            System.arraycopy(fArray, 0, fArray, n * n2, n2);
            ++n;
        }
    }

    private void generateUnindexedQuadNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        float[] fArray2 = new float[3];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.innerFacetCount) {
            n3 = 0;
            Vector3f vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            n = this.outerFacetCount;
            while (--n > 0) {
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3 += 3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                fArray[n2 + 6] = vector3f.x;
                fArray[n2 + 7] = vector3f.y;
                fArray[n2 + 8] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                n2 += 3;
            }
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, 0);
            fArray[n2++] = vector3f.x;
            fArray[n2++] = vector3f.y;
            fArray[n2++] = vector3f.z;
            ++n4;
        }
        n = 1;
        while (n < this.loopCount) {
            System.arraycopy(fArray, 0, fArray, n * n2, n2);
            ++n;
        }
    }

    private void generateUnindexedTriStripNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        float[] fArray2 = new float[3];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.innerFacetCount) {
            n3 = 0;
            n = this.outerFacetCount + 1;
            while (--n >= 0) {
                Vector3f vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                n3 += 3;
            }
            ++n4;
        }
        n = 1;
        while (n < this.loopCount) {
            System.arraycopy(fArray, 0, fArray, n * n2, n2);
            ++n;
        }
    }

    private void generateIndexedNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        if (geometryData.normals == null) {
            geometryData.normals = new float[geometryData.coordinates.length];
        } else if (geometryData.normals.length < geometryData.coordinates.length) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, geometryData.coordinates.length);
        }
        float[] fArray = geometryData.normals;
        int n2 = 0;
        float[] fArray2 = new float[3];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.innerFacetCount) {
            n3 = 0;
            n = this.outerFacetCount + 1;
            while (--n >= 0) {
                Vector3f vector3f = this.createRadialNormal(geometryData.coordinates, n2, this.oradiusCoordinates, n3);
                fArray[n2++] = vector3f.x;
                fArray[n2++] = vector3f.y;
                fArray[n2++] = vector3f.z;
                n3 += 3;
            }
            ++n4;
        }
        n = 1;
        while (n < this.loopCount) {
            System.arraycopy(fArray, 0, fArray, n * n2, n2);
            ++n;
        }
    }

    private void generateTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
    }

    private void generateShape() {
        if (!this.shapeChanged) {
            return;
        }
        this.shapeChanged = false;
        int n = (this.innerFacetCount + 1) * (this.outerFacetCount + 1) * 3;
        if (this.shapeCoordinates == null || n > this.shapeCoordinates.length) {
            this.shapeCoordinates = new float[n];
            this.oradiusCoordinates = new float[(this.outerFacetCount + 1) * 3];
        }
        this.numShapeValues = n;
        double d = Math.PI * 2 * (double)this.outerRadius / (double)this.outerFacetCount;
        float f = (float)(d / (double)this.outerRadius);
        d = Math.PI * 2 * (double)this.innerRadius / (double)this.innerFacetCount;
        float f2 = (float)(d / (double)this.innerRadius);
        int n2 = 0;
        float f3 = -this.loopSpacing / 2.0f;
        float f4 = this.loopSpacing / (float)this.outerFacetCount;
        float f5 = this.outerRadius + this.innerRadius;
        float[] fArray = new float[this.outerFacetCount];
        float[] fArray2 = new float[this.outerFacetCount];
        float f6 = this.loopSpacing * (float)(this.loopCount / 2);
        int n3 = 0;
        while (n3 < this.outerFacetCount) {
            fArray[n3] = (float)Math.cos(f * (float)n3);
            fArray2[n3] = (float)Math.sin(f * (float)n3);
            this.oradiusCoordinates[n2++] = this.outerRadius * fArray[n3];
            this.oradiusCoordinates[n2++] = f3 + f6;
            this.oradiusCoordinates[n2++] = -this.outerRadius * fArray2[n3];
            f3 += f4;
            ++n3;
        }
        this.oradiusCoordinates[n2++] = this.oradiusCoordinates[0];
        this.oradiusCoordinates[n2++] = f3;
        this.oradiusCoordinates[n2++] = this.oradiusCoordinates[2];
        n2 = 0;
        int n4 = 0;
        while (n4 < this.innerFacetCount) {
            f3 = -this.loopSpacing / 2.0f;
            f5 = this.outerRadius + this.innerRadius * (float)Math.cos(f2 * (float)n4);
            float f7 = this.innerRadius * (float)Math.sin(f2 * (float)n4);
            n3 = 0;
            while (n3 < this.outerFacetCount) {
                this.shapeCoordinates[n2++] = f5 * fArray[n3];
                this.shapeCoordinates[n2++] = f7 + f3;
                this.shapeCoordinates[n2++] = -f5 * fArray2[n3];
                f3 += f4;
                ++n3;
            }
            this.shapeCoordinates[n2++] = f5 * fArray[0];
            this.shapeCoordinates[n2++] = f7 + f3;
            this.shapeCoordinates[n2++] = -f5 * fArray2[0];
            ++n4;
        }
        System.arraycopy(this.shapeCoordinates, 0, this.shapeCoordinates, n2, (this.outerFacetCount + 1) * 3);
    }
}

