/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.j3d.geom.GeometryData;
import org.j3d.geom.SpringGenerator;

public class TestSpringGenerator
extends TestCase {
    private static final float TEST_INNER_RADIUS = 0.5f;
    private static final float TEST_OUTER_RADIUS = 6.3f;
    private static final float TEST_LOOP_SPACING = 3.3f;
    private static final int TEST_LOOP_COUNT = 7;
    private static final int[] VALID_INNER_FACETS = new int[]{12, 32, 72};
    private static final int[] VALID_OUTER_FACETS = new int[]{10, 20, 32};
    private static final int[] INVALID_INNER_FACETS = new int[]{-5, 0, 2, 10};
    private static final int[] INVALID_OUTER_FACETS = new int[]{-5, 0, 2};
    private SpringGenerator generator;

    public TestSpringGenerator(String string) {
        super(string);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestSpringGenerator("testCreate"));
        testSuite.addTest((Test)new TestSpringGenerator("testCoordinateArray"));
        testSuite.addTest((Test)new TestSpringGenerator("testNormalArray"));
        testSuite.addTest((Test)new TestSpringGenerator("testInvalidFacets"));
        testSuite.addTest((Test)new TestSpringGenerator("testValidFacets"));
        return testSuite;
    }

    public void testCreate() {
        this.generator = new SpringGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 2;
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Default spring vertex count", (int)4096, (int)geometryData.vertexCount);
        float[] fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Default spring inner radius", (float)0.25f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Default spring outer radius", (float)1.0f, (float)fArray[1], (float)0.0f);
        Assert.assertEquals((String)"Default loop spacing", (float)1.0f, (float)fArray[2], (float)0.0f);
        Assert.assertEquals((String)"Default loop count", (int)4, (int)((int)fArray[3]));
        this.generator.setDimensions(0.5f, 6.3f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Dimensioned vertex count", (int)4096, (int)geometryData.vertexCount);
        fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Dimensioned spring outer radius", (float)0.5f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Dimensioned spring inner radius", (float)6.3f, (float)fArray[1], (float)0.0f);
        Assert.assertEquals((String)"Dimensioned loop spacing", (float)1.0f, (float)fArray[2], (float)0.0f);
        Assert.assertEquals((String)"Dimensioned loop count", (int)4, (int)((int)fArray[3]));
        this.generator.setLoopDimensions(3.3f, 7);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Looped spring vertex count is wrong", (int)7168, (int)geometryData.vertexCount);
        fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Looped spring outer radius", (float)0.5f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Looped spring inner radius", (float)6.3f, (float)fArray[1], (float)0.0f);
        Assert.assertEquals((String)"Looped loop spacing", (float)3.3f, (float)fArray[2], (float)0.0f);
        Assert.assertEquals((String)"Looped loop count", (int)7, (int)((int)fArray[3]));
        this.generator = new SpringGenerator(0.5f, 6.3f, 3.3f, 7);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Test spring vertex count is wrong", (int)7168, (int)geometryData.vertexCount);
        fArray = this.generator.getDimensions();
        Assert.assertEquals((String)"Test spring outer radius wrong", (float)0.5f, (float)fArray[0], (float)0.0f);
        Assert.assertEquals((String)"Test spring inner radius wrong", (float)6.3f, (float)fArray[1], (float)0.0f);
        Assert.assertEquals((String)"Test loop spacing", (float)3.3f, (float)fArray[2], (float)0.0f);
        Assert.assertEquals((String)"Test loop count", (int)7, (int)((int)fArray[3]));
    }

    public void testCoordinateArray() {
        this.generator = new SpringGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 2;
        this.generator.generate(geometryData);
        int n = geometryData.vertexCount;
        float[] fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Default spring coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator.setDimensions(0.5f, 6.3f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Dimensioned spring coordinate length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new SpringGenerator(0.5f, 6.3f);
        geometryData.coordinates = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.coordinates;
        Assert.assertEquals((String)"Test spring coordinate length wrong", (int)(n * 3), (int)fArray.length);
    }

    public void testNormalArray() {
        this.generator = new SpringGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 2;
        geometryData.geometryComponents = 2;
        this.generator.generate(geometryData);
        int n = geometryData.vertexCount;
        float[] fArray = geometryData.normals;
        Assert.assertEquals((String)"Default spring normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator.setDimensions(0.5f, 6.3f);
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"Dimensioned spring normal length wrong", (int)(n * 3), (int)fArray.length);
        this.generator = new SpringGenerator(0.5f, 6.3f);
        geometryData.normals = null;
        this.generator.generate(geometryData);
        n = geometryData.vertexCount;
        fArray = geometryData.normals;
        Assert.assertEquals((String)"Test spring normal length wrong", (int)(n * 3), (int)fArray.length);
    }

    public void testInvalidFacets() {
        int n = 0;
        while (n < INVALID_INNER_FACETS.length) {
            try {
                this.generator = new SpringGenerator(INVALID_INNER_FACETS[n], 4);
                Assert.fail((String)("Did not detect bad inner facet count on construction " + INVALID_INNER_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
        n = 0;
        while (n < INVALID_OUTER_FACETS.length) {
            try {
                this.generator = new SpringGenerator(4, INVALID_OUTER_FACETS[n]);
                Assert.fail((String)("Did not detect bad outer facet count on construction " + INVALID_OUTER_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
        this.generator = new SpringGenerator();
        n = 0;
        while (n < INVALID_INNER_FACETS.length) {
            try {
                this.generator.setFacetCount(INVALID_INNER_FACETS[n], 4);
                Assert.fail((String)("Did not detect invalid inner facet count on set " + INVALID_OUTER_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
        n = 0;
        while (n < INVALID_OUTER_FACETS.length) {
            try {
                this.generator.setFacetCount(4, INVALID_OUTER_FACETS[n]);
                Assert.fail((String)("Did not detect invalid outer facet count on set " + INVALID_OUTER_FACETS[n]));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            ++n;
        }
    }

    public void testValidFacets() {
        float[] fArray;
        int n;
        int n2;
        this.generator = new SpringGenerator();
        GeometryData geometryData = new GeometryData();
        geometryData.geometryType = 2;
        this.generator.generate(geometryData);
        Assert.assertEquals((String)"Valid inner & outer facet lengths", (int)VALID_INNER_FACETS.length, (int)VALID_OUTER_FACETS.length);
        int n3 = 0;
        while (n3 < VALID_INNER_FACETS.length) {
            this.generator = new SpringGenerator(VALID_INNER_FACETS[n3], VALID_OUTER_FACETS[n3]);
            n2 = VALID_INNER_FACETS[n3] * VALID_OUTER_FACETS[n3] * 16;
            geometryData.coordinates = null;
            this.generator.generate(geometryData);
            n = geometryData.vertexCount;
            Assert.assertEquals((String)("Construct vertex count for inner facet " + VALID_INNER_FACETS[n3]), (int)n2, (int)n);
            fArray = geometryData.coordinates;
            Assert.assertEquals((String)("Generated initial vertex count for inner facet " + VALID_INNER_FACETS[n3]), (int)(n2 *= 3), (int)fArray.length);
            ++n3;
        }
        this.generator = new SpringGenerator();
        n3 = 0;
        while (n3 < VALID_INNER_FACETS.length) {
            this.generator.setFacetCount(VALID_INNER_FACETS[n3], VALID_OUTER_FACETS[n3]);
            n2 = VALID_INNER_FACETS[n3] * VALID_OUTER_FACETS[n3] * 16;
            geometryData.coordinates = null;
            this.generator.generate(geometryData);
            n = geometryData.vertexCount;
            Assert.assertEquals((String)("Construct vertex count for inner facet" + VALID_INNER_FACETS[n3]), (int)n2, (int)n);
            fArray = geometryData.coordinates;
            Assert.assertEquals((String)("Generated initial vertex count for inner facet" + VALID_INNER_FACETS[n3]), (int)(n2 *= 3), (int)fArray.length);
            ++n3;
        }
    }

    public static void main(String[] stringArray) {
        TestRunner.run((Test)TestSpringGenerator.suite());
    }
}

