/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.overlay;

import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.media.j3d.WakeupOr;
import org.j3d.geom.overlay.InputRequester;
import org.j3d.geom.overlay.Overlay;

class AWTEventBehavior
extends Behavior
implements InputRequester {
    private static final int REBUILD_ID = 1008;
    private WakeupOnAWTEvent awtCondition;
    private ArrayList mouseOverlays;
    private HashMap mouseListeners;
    private ArrayList motionOverlays;
    private HashMap motionListeners;
    private KeyListener currentKey;
    private HashMap keyListeners;
    private WakeupOnBehaviorPost postCondition = new WakeupOnBehaviorPost((Behavior)this, 1008);
    private WakeupCondition bothConditions;
    private Overlay currentMouseOverlay;
    private MouseListener lastMouse;
    private Overlay lastMouseOverlay;
    private Overlay currentMotionOverlay;
    private MouseMotionListener lastMotion;
    private Overlay lastMotionOverlay;
    private boolean inDrag = false;

    public AWTEventBehavior() {
        this.mouseListeners = new HashMap();
        this.mouseOverlays = new ArrayList();
        this.motionListeners = new HashMap();
        this.motionOverlays = new ArrayList();
        this.keyListeners = new HashMap();
    }

    public void requestFocus(Object object) {
        if (this.keyListeners.containsKey(object)) {
            this.currentKey = (KeyListener)this.keyListeners.get(object);
        }
    }

    public void addMouseListener(MouseListener mouseListener, Overlay overlay) {
        if (mouseListener == null) {
            return;
        }
        boolean bl = this.mouseOverlays.size() == 0;
        this.mouseListeners.put(overlay, mouseListener);
        this.mouseOverlays.add(overlay);
        if (bl) {
            this.rebuildCriteria();
            this.postId(1008);
        }
    }

    public void removeMouseListener(MouseListener mouseListener, Overlay overlay) {
        if (mouseListener == null) {
            return;
        }
        this.mouseListeners.remove(overlay);
        this.mouseOverlays.remove(overlay);
        if (this.mouseListeners.size() == 0) {
            this.rebuildCriteria();
        }
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener, Overlay overlay) {
        if (mouseMotionListener == null) {
            return;
        }
        boolean bl = this.motionListeners.size() == 0;
        this.motionListeners.put(overlay, mouseMotionListener);
        this.motionOverlays.add(overlay);
        if (bl) {
            this.rebuildCriteria();
            this.postId(1008);
        }
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener, Overlay overlay) {
        if (mouseMotionListener == null) {
            return;
        }
        this.motionListeners.remove(overlay);
        this.motionOverlays.remove(overlay);
        if (this.motionListeners.size() == 0) {
            this.rebuildCriteria();
        }
    }

    public void addKeyListener(KeyListener keyListener, Object object) {
        boolean bl;
        if (keyListener == null) {
            return;
        }
        boolean bl2 = bl = this.keyListeners.size() == 0;
        if (keyListener != null) {
            this.keyListeners.put(object, keyListener);
        }
        if (bl) {
            this.rebuildCriteria();
            this.postId(1008);
        }
    }

    public void removeKeyListener(KeyListener keyListener, Object object) {
        if (keyListener == null) {
            return;
        }
        Object v = this.keyListeners.get(object);
        if (v == keyListener) {
            this.keyListeners.remove(object);
        }
        if (this.keyListeners.size() == 0) {
            this.rebuildCriteria();
        }
    }

    public void initialize() {
        if (this.awtCondition != null) {
            this.wakeupOn(this.bothConditions);
        } else {
            this.wakeupOn((WakeupCondition)this.postCondition);
        }
    }

    public void processStimulus(Enumeration enumeration) {
        if (this.awtCondition.hasTriggered()) {
            AWTEvent[] aWTEventArray = this.awtCondition.getAWTEvent();
            MouseListener mouseListener = null;
            MouseMotionListener mouseMotionListener = null;
            int n = 0;
            while (n < aWTEventArray.length) {
                switch (aWTEventArray[n].getID()) {
                    case 401: {
                        if (this.currentKey == null) break;
                        this.currentKey.keyPressed((KeyEvent)aWTEventArray[n]);
                        break;
                    }
                    case 402: {
                        if (this.currentKey == null) break;
                        this.currentKey.keyReleased((KeyEvent)aWTEventArray[n]);
                        break;
                    }
                    case 400: {
                        if (this.currentKey == null) break;
                        this.currentKey.keyTyped((KeyEvent)aWTEventArray[n]);
                        break;
                    }
                    case 501: {
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[n];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (mouseListener == null) break;
                        this.adjustMousePosition(mouseEvent2, this.currentMouseOverlay);
                        mouseListener.mousePressed(mouseEvent2);
                        break;
                    }
                    case 502: {
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[n];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (mouseListener == null) break;
                        this.adjustMousePosition(mouseEvent2, this.currentMouseOverlay);
                        mouseListener.mouseReleased(mouseEvent2);
                        break;
                    }
                    case 500: {
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[n];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (mouseListener == null) break;
                        this.adjustMousePosition(mouseEvent2, this.currentMouseOverlay);
                        mouseListener.mouseClicked(mouseEvent2);
                        break;
                    }
                    case 504: {
                        MouseEvent mouseEvent;
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[n];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (mouseListener == this.lastMouse) break;
                        if (this.lastMouse != null) {
                            mouseEvent = this.cloneEvent(mouseEvent2, true);
                            this.adjustMousePosition(mouseEvent, this.lastMouseOverlay);
                            this.lastMouse.mouseExited(mouseEvent);
                        }
                        if (this.inDrag) break;
                        this.adjustMousePosition(mouseEvent2, this.currentMouseOverlay);
                        mouseListener.mouseEntered(mouseEvent2);
                        this.lastMouse = mouseListener;
                        break;
                    }
                    case 505: {
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[n];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (this.inDrag) break;
                        if (mouseListener != null) {
                            this.adjustMousePosition(mouseEvent2, this.currentMouseOverlay);
                            mouseListener.mouseExited(mouseEvent2);
                        }
                        this.lastMouse = null;
                        this.lastMotion = null;
                        break;
                    }
                    case 506: {
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[n];
                        this.inDrag = true;
                        if (this.lastMotion == null) break;
                        this.adjustMousePosition(mouseEvent2, this.currentMotionOverlay);
                        this.lastMotion.mouseDragged(mouseEvent2);
                        break;
                    }
                    case 503: {
                        MouseEvent mouseEvent;
                        MouseEvent mouseEvent2 = (MouseEvent)aWTEventArray[n];
                        mouseListener = this.getMouseListener(mouseEvent2.getPoint());
                        if (mouseListener != this.lastMouse) {
                            if (this.lastMouse == null) {
                                mouseEvent = this.cloneEvent(mouseEvent2, false);
                                this.adjustMousePosition(mouseEvent, this.currentMouseOverlay);
                                mouseListener.mouseEntered(mouseEvent);
                            } else if (mouseListener == null) {
                                mouseEvent = this.cloneEvent(mouseEvent2, true);
                                this.adjustMousePosition(mouseEvent, this.lastMouseOverlay);
                                this.lastMouse.mouseExited(mouseEvent);
                            } else {
                                mouseEvent = this.cloneEvent(mouseEvent2, true);
                                this.adjustMousePosition(mouseEvent, this.lastMotionOverlay);
                                this.lastMouse.mouseExited(mouseEvent);
                                mouseEvent = this.cloneEvent(mouseEvent2, false);
                                this.adjustMousePosition(mouseEvent, this.currentMouseOverlay);
                                mouseListener.mouseEntered(mouseEvent);
                            }
                            this.lastMouse = mouseListener;
                            break;
                        }
                        mouseMotionListener = this.getMotionListener(mouseEvent2.getPoint());
                        if (mouseMotionListener != null) {
                            this.adjustMousePosition(mouseEvent2, this.currentMotionOverlay);
                            mouseMotionListener.mouseMoved(mouseEvent2);
                        }
                        this.lastMotion = mouseMotionListener;
                    }
                }
                ++n;
            }
        }
        if (this.awtCondition != null) {
            this.wakeupOn(this.bothConditions);
        } else {
            this.wakeupOn((WakeupCondition)this.postCondition);
        }
    }

    private void rebuildCriteria() {
        long l = 0L;
        if (this.mouseListeners.size() != 0) {
            l = 48L;
        } else if (this.motionListeners.size() != 0) {
            l = 32L;
        }
        if (this.keyListeners.size() != 0) {
            l |= 8L;
        }
        if (l != 0L) {
            this.awtCondition = new WakeupOnAWTEvent(l);
            WakeupCriterion[] wakeupCriterionArray = new WakeupCriterion[]{this.awtCondition, this.postCondition};
            this.bothConditions = new WakeupOr(wakeupCriterionArray);
        } else if (this.awtCondition != null) {
            this.awtCondition = null;
            this.bothConditions = null;
        }
    }

    private MouseListener getMouseListener(Point point) {
        if (this.lastMouseOverlay != null && this.lastMouseOverlay.contains(point)) {
            this.currentMouseOverlay = this.lastMouseOverlay;
            return this.lastMouse;
        }
        int n = this.mouseOverlays.size();
        Overlay overlay = null;
        int n2 = 0;
        while (n2 < n) {
            overlay = (Overlay)this.mouseOverlays.get(n2);
            if (overlay.isVisible() && overlay.contains(point)) break;
            overlay = null;
            ++n2;
        }
        this.lastMouseOverlay = this.currentMouseOverlay;
        this.currentMouseOverlay = overlay != null ? overlay : null;
        MouseListener mouseListener = (MouseListener)this.mouseListeners.get(overlay);
        return mouseListener;
    }

    private MouseMotionListener getMotionListener(Point point) {
        if (this.lastMotionOverlay != null && this.lastMotionOverlay.contains(point)) {
            this.currentMotionOverlay = this.lastMotionOverlay;
            return this.lastMotion;
        }
        int n = this.motionOverlays.size();
        Overlay overlay = null;
        int n2 = 0;
        while (n2 < n) {
            overlay = (Overlay)this.motionOverlays.get(n2);
            if (overlay.isVisible() && overlay.contains(point)) break;
            overlay = null;
            ++n2;
        }
        this.lastMotionOverlay = this.currentMotionOverlay;
        this.currentMotionOverlay = overlay != null ? overlay : null;
        MouseMotionListener mouseMotionListener = (MouseMotionListener)this.motionListeners.get(overlay);
        return mouseMotionListener;
    }

    private MouseEvent cloneEvent(MouseEvent mouseEvent, boolean bl) {
        return new MouseEvent(mouseEvent.getComponent(), bl ? 505 : 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX(), mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
    }

    private void adjustMousePosition(MouseEvent mouseEvent, Overlay overlay) {
        if (overlay == null) {
            return;
        }
        Rectangle rectangle = overlay.getBounds();
        mouseEvent.translatePoint(-rectangle.x, -rectangle.y);
    }
}

