/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.media.j3d.Appearance;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryUpdater;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import org.j3d.geom.particle.ByRefParticle;
import org.j3d.geom.particle.ParticleSystem;

public abstract class ByRefParticleSystem
extends ParticleSystem
implements GeometryUpdater {
    private GeometryArray geometryArray;
    private float[] positionRefArray;
    private float[] textureCoordRefArray;
    private float[] colorRefArray;
    private float[] normalRefArray;
    protected Shape3D shape = new OrientedShape3D();
    protected int coordInc;
    protected int colorInc;
    protected int textureInc;
    protected int numValidVertices;
    private boolean firstUpdate;

    public ByRefParticleSystem(String string, int n) {
        super(string, n);
        this.geometryArray = this.createGeometryArray();
        this.geometryArray.setCapability(19);
        this.geometryArray.setCapability(20);
        this.shape.setCapability(15);
        this.shape.setGeometry((Geometry)this.geometryArray);
        this.shape.setAppearance(this.createAppearance());
        this.shape.setCollidable(false);
        this.shape.setPickable(false);
        this.firstUpdate = false;
    }

    public void initialize() {
        int n = this.coordinatesPerParticle();
        this.coordInc = n * 3;
        this.colorInc = n * this.numColorComponents();
        this.textureInc = n * this.numTexCoordComponents();
        int n2 = this.maxParticleCount * this.coordInc;
        int n3 = this.maxParticleCount * this.colorInc;
        int n4 = this.maxParticleCount * this.coordInc;
        int n5 = this.maxParticleCount * this.textureInc;
        this.positionRefArray = new float[n2];
        this.colorRefArray = new float[n3];
        this.normalRefArray = new float[n4];
        this.textureCoordRefArray = new float[n5];
        super.initialize();
    }

    public Node getNode() {
        return this.shape;
    }

    public void onRemove() {
        Appearance appearance = new Appearance();
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setVisible(false);
        appearance.setRenderingAttributes(renderingAttributes);
        this.shape.setAppearance(appearance);
    }

    public abstract GeometryArray createGeometryArray();

    protected void updateGeometry() {
        ByRefParticle byRefParticle;
        int n = this.particleList.size();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            byRefParticle = (ByRefParticle)this.particleList.next();
            byRefParticle.updateGeometry(this.positionRefArray, n3);
            byRefParticle.updateColors(this.colorRefArray, n2);
            n3 += this.coordInc;
            n2 += this.colorInc;
            ++n4;
        }
        this.particleList.reset();
        this.numValidVertices = n * this.coordinatesPerParticle();
        if (this.firstUpdate) {
            this.firstUpdate = false;
            n2 = 0;
            n3 = 0;
            byRefParticle = (ByRefParticle)this.particleList.next();
            int n5 = 0;
            while (n5 < n) {
                byRefParticle.updateNormals(this.normalRefArray, n3);
                byRefParticle.updateTexCoords(this.textureCoordRefArray, n2);
                n3 += this.coordInc;
                n2 += this.textureInc;
                ++n5;
            }
            this.particleList.reset();
        }
    }

    public boolean update() {
        boolean bl = super.update();
        this.geometryArray.updateData((GeometryUpdater)this);
        return bl;
    }

    public void updateData(Geometry geometry) {
        GeometryArray geometryArray = (GeometryArray)geometry;
        geometryArray.setValidVertexCount(this.numValidVertices);
        geometryArray.setCoordRefFloat(this.positionRefArray);
        geometryArray.setColorRefFloat(this.colorRefArray);
        geometryArray.setNormalRefFloat(this.normalRefArray);
        geometryArray.setTexCoordRefFloat(0, this.textureCoordRefArray);
    }
}

