/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleFunction;
import org.j3d.util.interpolator.ColorInterpolator;

public class ColorRampFunction
implements ParticleFunction {
    private static final String LENGTH_MSG = "Ramp and time arrays not same length";
    private ColorInterpolator interpolator;
    private boolean hasAlpha;
    private boolean enabled;
    private long currentTime;
    private float lastTime;
    private float[] lastColor = new float[4];

    public ColorRampFunction() {
        this.enabled = false;
    }

    public ColorRampFunction(float[] fArray, float[] fArray2, boolean bl) {
        int n = fArray2 == null ? 0 : fArray2.length;
        n = bl ? n / 4 : n / 3;
        this.setColorRamp(fArray, fArray2, n, bl);
        this.enabled = true;
    }

    public ColorRampFunction(float[] fArray, float[] fArray2, int n, boolean bl) {
        this.setColorRamp(fArray, fArray2, n, bl);
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean newFrame() {
        this.currentTime = System.currentTimeMillis();
        return true;
    }

    public boolean apply(Particle particle) {
        int n = (int)(this.currentTime - particle.wallClockBirth);
        float[] fArray = (float)n >= this.lastTime ? this.lastColor : this.interpolator.floatRGBValue(n);
        particle.setColor(fArray[0], fArray[1], fArray[2], fArray[3]);
        return true;
    }

    public void setColorRamp(float[] fArray, float[] fArray2, boolean bl) {
        int n = fArray2 == null ? 0 : fArray2.length;
        n = bl ? n / 4 : n / 3;
        this.setColorRamp(fArray, fArray2, n, bl);
    }

    public void setColorRamp(float[] fArray, float[] fArray2, int n, boolean bl) {
        if (fArray.length != n) {
            throw new IllegalArgumentException(LENGTH_MSG);
        }
        this.hasAlpha = bl;
        this.interpolator = new ColorInterpolator(n, 1);
        int n2 = 0;
        if (bl) {
            int n3 = 0;
            while (n3 < n) {
                this.interpolator.addRGBKeyFrame(fArray[n3] * 1000.0f, fArray2[n2++], fArray2[n2++], fArray2[n2++], fArray2[n2++]);
                ++n3;
            }
            this.lastTime = fArray[n - 1] * 1000.0f;
            this.lastColor[0] = fArray2[n2 - 4];
            this.lastColor[1] = fArray2[n2 - 3];
            this.lastColor[2] = fArray2[n2 - 2];
            this.lastColor[3] = fArray2[n2 - 1];
        } else {
            int n4 = 0;
            while (n4 < n) {
                this.interpolator.addRGBKeyFrame(fArray[n4] * 1000.0f, fArray2[n2++], fArray2[n2++], fArray2[n2++], 0.0f);
                ++n4;
            }
            this.lastTime = fArray[n - 1] * 1000.0f;
            this.lastColor[0] = fArray2[n2 - 3];
            this.lastColor[1] = fArray2[n2 - 2];
            this.lastColor[2] = fArray2[n2 - 1];
        }
    }
}

