/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.Random;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleInitializer;

public class ExplosionPointEmitter
implements ParticleInitializer {
    private int lifetime;
    private int particleCount;
    private float[] origin;
    private float[] color;
    private float[] direction;
    private float velocity;
    private float variation;
    private double initialMass;
    private double surfaceArea;
    private Random randomiser;

    public ExplosionPointEmitter(int n, int n2, float[] fArray, float[] fArray2, float f, float f2) {
        this.lifetime = n;
        this.particleCount = n2;
        this.origin = new float[3];
        this.origin[0] = fArray[0];
        this.origin[1] = fArray[1];
        this.origin[2] = fArray[2];
        this.direction = new float[3];
        this.direction[0] = this.direction[0];
        this.direction[1] = this.direction[1];
        this.direction[2] = this.direction[2];
        this.color = new float[4];
        this.color[0] = fArray2[0];
        this.color[1] = fArray2[1];
        this.color[2] = fArray2[2];
        this.color[3] = fArray2[3];
        this.velocity = f;
        this.variation = f2;
        this.initialMass = 1.0E-7;
        this.surfaceArea = 4.0E-4;
        this.randomiser = new Random();
    }

    public int numParticlesToCreate(int n) {
        int n2 = this.particleCount;
        this.particleCount = 0;
        return n2;
    }

    public boolean initialize(Particle particle) {
        float f = 1.0f - this.randomiser.nextFloat() * this.variation;
        particle.setColor(this.color[0], this.color[1], this.color[2], this.color[3] * f);
        f = 1.0f - this.randomiser.nextFloat() * this.variation;
        particle.setCycleTime((int)((float)this.lifetime * f));
        particle.setPositionAndPrevious(this.origin[0], this.origin[1], this.origin[2]);
        particle.resultantForce.set(0.0, 0.0, 0.0);
        f = 1.0f - this.randomiser.nextFloat() * this.variation;
        float f2 = this.randomiser.nextBoolean() ? 1.0f : -1.0f;
        float f3 = this.randomiser.nextBoolean() ? 1.0f : -1.0f;
        float f4 = this.randomiser.nextBoolean() ? 1.0f : -1.0f;
        float f5 = f * this.randomiser.nextFloat() * f2;
        float f6 = f * this.randomiser.nextFloat() * f3;
        float f7 = f * this.randomiser.nextFloat() * f4;
        particle.velocity.set((double)f5, (double)f6, (double)f7);
        particle.velocity.normalize();
        particle.velocity.scale((double)(this.velocity * f));
        return true;
    }

    public void setPosition(float f, float f2, float f3) {
        this.origin[0] = f;
        this.origin[1] = f2;
        this.origin[2] = f3;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void setSurfaceArea(double d) {
        this.surfaceArea = d;
    }

    public void setMass(double d) {
        this.initialMass = d;
    }

    public void setVelocity(float f, float f2, float f3) {
    }
}

