/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineArray;
import javax.media.j3d.LineAttributes;
import org.j3d.geom.particle.ByRefParticleSystem;
import org.j3d.geom.particle.LineArrayByRefParticle;
import org.j3d.geom.particle.Particle;

public class LineArrayByRefParticleSystem
extends ByRefParticleSystem {
    private boolean usePreviousPosition;
    private float lineSize;
    private boolean antiAliased;
    private int linePattern;

    public LineArrayByRefParticleSystem(String string, int n, boolean bl) {
        super(string, n);
        this.usePreviousPosition = bl;
        this.lineSize = 3.0f;
        this.antiAliased = false;
        this.linePattern = 0;
    }

    public GeometryArray createGeometryArray() {
        LineArray lineArray = new LineArray(this.maxParticleCount * 2, 173);
        return lineArray;
    }

    public int coordinatesPerParticle() {
        return 2;
    }

    public int numColorComponents() {
        return 4;
    }

    public int numTexCoordComponents() {
        return 2;
    }

    public Particle createParticle() {
        LineArrayByRefParticle lineArrayByRefParticle = new LineArrayByRefParticle(this.usePreviousPosition);
        return lineArrayByRefParticle;
    }

    public Appearance createAppearance() {
        LineAttributes lineAttributes = new LineAttributes(this.lineSize, this.linePattern, this.antiAliased);
        Appearance appearance = super.createAppearance();
        appearance.setLineAttributes(lineAttributes);
        return appearance;
    }

    public void setLineSize(float f) throws IllegalArgumentException {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Line width <= 0");
        }
        this.lineSize = f;
    }

    public void setLineStyle(int n) {
        this.linePattern = n;
    }

    public void setAntiAliased(boolean bl) {
        this.antiAliased = bl;
    }
}

