/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.vecmath.Vector3f;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleInitializer;

public class MaxTimePointEmitter
implements ParticleInitializer {
    private static final int DELTA_LIMIT = 5;
    private int lifetime;
    private float particlesPerMs;
    private float[] origin;
    private float[] initialVelocity;
    private float[] color;
    private float[] direction;
    private float velocity;
    private float variation;
    private double initialMass;
    private double surfaceArea;
    private int zeroDeltaCounter;

    public MaxTimePointEmitter(int n, int n2, float[] fArray, float[] fArray2, float[] fArray3, float f, float f2) {
        this.lifetime = n;
        this.particlesPerMs = (float)n2 / (float)n;
        this.initialVelocity = new float[3];
        this.origin = new float[3];
        this.origin[0] = fArray[0];
        this.origin[1] = fArray[1];
        this.origin[2] = fArray[2];
        this.direction = new float[3];
        this.direction[0] = fArray3[0];
        this.direction[1] = fArray3[1];
        this.direction[2] = fArray3[2];
        this.color = new float[4];
        this.color[0] = fArray2[0];
        this.color[1] = fArray2[1];
        this.color[2] = fArray2[2];
        this.color[3] = fArray2[3];
        this.velocity = f;
        this.variation = f2;
        this.updateVelocity();
        this.initialMass = 1.0E-7;
        this.surfaceArea = 4.0E-4;
    }

    public int numParticlesToCreate(int n) {
        int n2 = 0;
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                if (this.zeroDeltaCounter == 5) {
                    n2 = 1;
                    this.zeroDeltaCounter = 0;
                    break;
                }
                ++this.zeroDeltaCounter;
                break;
            }
            default: {
                this.zeroDeltaCounter = 0;
                n2 = (int)(this.particlesPerMs * (float)n);
            }
        }
        return n2;
    }

    public boolean initialize(Particle particle) {
        particle.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
        particle.setCycleTime((int)(Math.random() * (double)this.lifetime));
        particle.setPositionAndPrevious(this.origin[0], this.origin[1], this.origin[2]);
        particle.resultantForce.set(0.0, 0.0, 0.0);
        float f = (float)Math.random() * this.variation;
        float f2 = this.initialVelocity[0] * f;
        float f3 = this.initialVelocity[1] * f;
        float f4 = this.initialVelocity[2] * f;
        particle.velocity.set((double)f2, (double)f3, (double)f4);
        return true;
    }

    public void setPosition(float f, float f2, float f3) {
        this.origin[0] = f;
        this.origin[1] = f2;
        this.origin[2] = f3;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void setSurfaceArea(double d) {
        this.surfaceArea = d;
    }

    public void setMass(double d) {
        this.initialMass = d;
    }

    public void setVelocity(float f, float f2, float f3) {
        this.initialVelocity[0] = f;
        this.initialVelocity[1] = f2;
        this.initialVelocity[2] = f3;
    }

    public void setVelocity(float f) {
        this.velocity = f;
        this.updateVelocity();
    }

    public void setEmitDirection(float[] fArray) {
        this.direction[0] = fArray[0];
        this.direction[1] = fArray[1];
        this.direction[2] = fArray[2];
        this.updateVelocity();
    }

    private void updateVelocity() {
        if (this.velocity == 0.0f) {
            this.initialVelocity[0] = 0.0f;
            this.initialVelocity[1] = 0.0f;
            this.initialVelocity[2] = 0.0f;
        } else {
            Vector3f vector3f = new Vector3f(this.direction);
            vector3f.normalize();
            vector3f.scale(this.velocity);
            this.initialVelocity[0] = vector3f.x;
            this.initialVelocity[1] = vector3f.y;
            this.initialVelocity[2] = vector3f.z;
        }
    }
}

