/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.Bounds;
import javax.vecmath.Color4f;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3d;

public abstract class Particle {
    public static final String RENDER_FROM_PREVIOUS_POSITION = "RENDER_FROM_PREVIOUS_POSITION";
    protected int cycleAge = 0;
    protected long wallClockBirth;
    protected int wallClockLife;
    protected double surfaceArea;
    protected double energy;
    protected double mass;
    protected Vector3d resultantForce;
    protected Vector3d velocity;
    protected Point3f position;
    protected Point3f previousPosition;
    protected BoundingBox boundingBox;
    protected Color4f color;
    protected float width;
    protected float height;
    protected float depth;
    protected boolean renderFromPreviousPosition;

    public Particle(boolean bl) {
        this.renderFromPreviousPosition = bl;
        this.surfaceArea = 4.0E-4;
        this.energy = 0.0;
        this.mass = 1.0E-7;
        this.resultantForce = new Vector3d();
        this.velocity = new Vector3d();
        this.position = new Point3f();
        this.previousPosition = new Point3f();
        this.color = new Color4f();
        this.width = 0.2f;
        this.height = 0.2f;
        this.depth = 0.2f;
    }

    public boolean isRenderFromPreviousPosition() {
        return this.renderFromPreviousPosition;
    }

    public void setPosition(float f, float f2, float f3) {
        this.previousPosition.set((Tuple3f)this.position);
        this.position.set(f, f2, f3);
    }

    public void setPositionAndPrevious(float f, float f2, float f3) {
        this.position.set(f, f2, f3);
        this.previousPosition.set((Tuple3f)this.position);
    }

    public void getPosition(Tuple3d tuple3d) {
        tuple3d.set((Tuple3f)this.position);
    }

    public void getPreviousPosition(Tuple3d tuple3d) {
        tuple3d.set((Tuple3f)this.previousPosition);
    }

    public float getPositionX() {
        return this.position.x;
    }

    public float getPositionY() {
        return this.position.y;
    }

    public float getPositionZ() {
        return this.position.z;
    }

    public void getColor(Color4f color4f) {
        color4f.set((Tuple4f)this.color);
    }

    public float getColorRed() {
        return this.color.x;
    }

    public float getColorGreen() {
        return this.color.y;
    }

    public float getColorBlue() {
        return this.color.z;
    }

    public float getColorAlpha() {
        return this.color.w;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color.set(f, f2, f3, f4);
    }

    public void setAlpha(float f) {
        this.color.w = f;
    }

    public Bounds getBounds() {
        if (this.boundingBox == null) {
            this.boundingBox = new BoundingBox();
        }
        this.boundingBox.setLower((double)(this.position.x - this.width), (double)(this.position.y - this.height), (double)(this.position.z - this.depth));
        this.boundingBox.setUpper((double)(this.position.x + this.width), (double)(this.position.y + this.height), (double)(this.position.z + this.depth));
        return this.boundingBox;
    }

    public void incAge() {
        ++this.cycleAge;
    }

    public int getCycleAge() {
        return this.cycleAge;
    }

    public void setCycleAge(int n) {
        this.cycleAge = n;
    }

    public int getCycleTime() {
        return this.wallClockLife;
    }

    public void setCycleTime(int n) {
        this.wallClockLife = n;
    }

    public double getMass() {
        return this.mass;
    }

    public void setMass(double d) {
        this.mass = d;
    }

    public Vector3d getResultantForce() {
        return this.resultantForce;
    }

    public void setResultantForce(Vector3d vector3d) {
        this.resultantForce = vector3d;
    }

    public double getSurfaceArea() {
        return this.surfaceArea;
    }

    public void setSurfaceArea(double d) {
        this.surfaceArea = d;
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3d vector3d) {
        this.velocity = vector3d;
    }

    public void setDepth(float f) {
        this.depth = f;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getDepth() {
        return this.depth;
    }
}

