/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.ArrayList;
import javax.media.j3d.Appearance;
import javax.media.j3d.Node;
import javax.media.j3d.Texture;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.TransparencyAttributes;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleFactory;
import org.j3d.geom.particle.ParticleFunction;
import org.j3d.geom.particle.ParticleInitializer;
import org.j3d.geom.particle.ParticleList;

public abstract class ParticleSystem
implements ParticleFactory {
    private static final int NUM_INIT_FUNCTIONS = 5;
    private String systemName;
    protected int maxParticleCount;
    protected int particleCount;
    private int creationResidue;
    protected int frameTime;
    protected long timeNow;
    private ArrayList particleFunctions;
    private Particle[] deadParticles;
    private ParticleFunction[] activeFunctions;
    private int numActiveFunctions;
    private int numDeadParticles;
    protected ParticleList particleList;
    private ParticleInitializer particleInitializer;

    public ParticleSystem(String string, int n) {
        this.systemName = string;
        this.particleFunctions = new ArrayList(5);
        this.particleList = new ParticleList();
        this.deadParticles = new Particle[n];
        this.maxParticleCount = n;
        this.numDeadParticles = 0;
        this.frameTime = -1;
        this.numActiveFunctions = 0;
        this.activeFunctions = new ParticleFunction[5];
    }

    public void initialize() {
        this.timeNow = System.currentTimeMillis();
        this.createParticles();
        this.updateGeometry();
    }

    public abstract Node getNode();

    public abstract void onRemove();

    protected abstract void updateGeometry();

    public void setParticleInitializer(ParticleInitializer particleInitializer) {
        this.particleInitializer = particleInitializer;
    }

    public void addParticleFunction(ParticleFunction particleFunction) {
        if (particleFunction != null) {
            this.particleFunctions.add(particleFunction);
        }
        if (this.activeFunctions.length < this.particleFunctions.size()) {
            this.activeFunctions = new ParticleFunction[this.particleFunctions.size()];
        }
    }

    public void insertParticleFunction(int n, ParticleFunction particleFunction) {
        if (particleFunction != null) {
            int n2 = this.particleFunctions.size();
            if (n > n2) {
                this.particleFunctions.add(particleFunction);
            } else {
                this.particleFunctions.add(n, particleFunction);
            }
            if (this.activeFunctions.length < n2) {
                this.activeFunctions = new ParticleFunction[n2];
            }
        }
    }

    public void removeParticleFunction(ParticleFunction particleFunction) {
        this.particleFunctions.remove(particleFunction);
    }

    public boolean update() {
        if (this.particleInitializer == null) {
            return true;
        }
        long l = System.currentTimeMillis();
        this.frameTime = (int)(l - this.timeNow);
        this.timeNow = l;
        this.updateParticleFunctions();
        this.runParticleFunctions();
        this.createParticles();
        this.updateGeometry();
        return true;
    }

    public void setTexture(Texture texture) {
    }

    protected Appearance createAppearance() {
        Appearance appearance = new Appearance();
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes(2, 0.0f);
        transparencyAttributes.setSrcBlendFunction(3);
        TextureAttributes textureAttributes = new TextureAttributes();
        textureAttributes.setTextureMode(2);
        textureAttributes.setPerspectiveCorrectionMode(0);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setTextureAttributes(textureAttributes);
        return appearance;
    }

    public String getSystemName() {
        return this.systemName;
    }

    public void setSystemName(String string) {
        this.systemName = string;
    }

    private void updateParticleFunctions() {
        int n = 0;
        int n2 = this.particleFunctions.size();
        while (--n2 >= 0) {
            ParticleFunction particleFunction = (ParticleFunction)this.particleFunctions.get(n2);
            if (!particleFunction.isEnabled()) continue;
            this.activeFunctions[n++] = particleFunction;
            particleFunction.newFrame();
        }
        this.numActiveFunctions = n;
    }

    private void runParticleFunctions() {
        if (this.particleFunctions.size() == 0 || this.particleList.size() == 0) {
            return;
        }
        int n = this.particleFunctions.size();
        int n2 = this.particleList.size();
        int n3 = 0;
        while (n3 < n2) {
            Particle particle = this.particleList.next();
            int n4 = 0;
            while (n4 < this.numActiveFunctions) {
                if (!this.activeFunctions[n4].apply(particle)) {
                    this.particleList.remove();
                    this.releaseParticle(particle);
                    --this.particleCount;
                    break;
                }
                ++n4;
            }
            ++n3;
        }
        this.particleList.reset();
    }

    private void createParticles() {
        int n = this.maxParticleCount - this.particleCount;
        int n2 = this.particleInitializer.numParticlesToCreate(this.frameTime) + this.creationResidue;
        int n3 = 0;
        if (n < n2) {
            n3 = n;
            this.creationResidue = n2 - n;
        } else {
            n3 = n2;
            this.creationResidue = 0;
        }
        int n4 = 0;
        while (n4 < n3) {
            Particle particle = this.fetchParticle();
            this.particleInitializer.initialize(particle);
            particle.wallClockBirth = this.timeNow;
            this.particleList.add(particle);
            ++n4;
        }
        this.particleCount += n3;
    }

    private Particle fetchParticle() {
        Particle particle;
        if (this.numDeadParticles != 0) {
            particle = this.deadParticles[this.numDeadParticles - 1];
            this.deadParticles[this.numDeadParticles - 1] = null;
            --this.numDeadParticles;
        } else {
            particle = this.createParticle();
        }
        return particle;
    }

    private void releaseParticle(Particle particle) {
        this.deadParticles[this.numDeadParticles] = particle;
        ++this.numDeadParticles;
    }
}

