/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.WakeupCondition;
import org.j3d.geom.particle.ParticleSystem;

public class ParticleSystemManager
extends Behavior {
    private ArrayList particleSystems = new ArrayList();
    private WakeupCondition wakeupCondition;

    public ParticleSystemManager(WakeupCondition wakeupCondition) {
        this.wakeupCondition = wakeupCondition;
    }

    public void initialize() {
        this.wakeupOn(this.wakeupCondition);
    }

    public void processStimulus(Enumeration enumeration) {
        this.update();
        this.wakeupOn(this.wakeupCondition);
    }

    public void update() {
        int n = this.particleSystems.size() - 1;
        while (n >= 0) {
            ParticleSystem particleSystem = (ParticleSystem)this.particleSystems.get(n);
            if (particleSystem != null && !particleSystem.update()) {
                System.out.println("Removing ParticleSystem: " + particleSystem.getSystemName());
                particleSystem.onRemove();
                this.particleSystems.remove(n);
            }
            --n;
        }
    }

    public void addParticleSystem(ParticleSystem particleSystem) {
        this.particleSystems.add(particleSystem);
    }

    public void removeParticleSystem(ParticleSystem particleSystem) {
        this.particleSystems.remove(particleSystem);
    }
}

