/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.media.j3d.Appearance;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.PointArray;
import javax.media.j3d.PointAttributes;
import org.j3d.geom.particle.ByRefParticleSystem;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.PointArrayByRefParticle;

public class PointArrayByRefParticleSystem
extends ByRefParticleSystem {
    private float pointSize = 3.0f;
    private boolean antiAliased = false;

    public PointArrayByRefParticleSystem(String string, int n) {
        super(string, n);
    }

    public Particle createParticle() {
        return new PointArrayByRefParticle(false);
    }

    public int coordinatesPerParticle() {
        return 1;
    }

    public int numColorComponents() {
        return 4;
    }

    public int numTexCoordComponents() {
        return 2;
    }

    public GeometryArray createGeometryArray() {
        int n = 175;
        PointArray pointArray = new PointArray(this.maxParticleCount, n);
        return pointArray;
    }

    protected Appearance createAppearance() {
        PointAttributes pointAttributes = new PointAttributes(this.pointSize, this.antiAliased);
        Appearance appearance = new Appearance();
        appearance.setPointAttributes(pointAttributes);
        return appearance;
    }

    public void setPointSize(float f) throws IllegalArgumentException {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Point size <= 0");
        }
        this.pointSize = f;
    }

    public void setAntiAliased(boolean bl) {
        this.antiAliased = bl;
    }
}

