/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleInitializer;
import org.j3d.util.interpolator.PositionInterpolator;

public class PolylineEmitter
implements ParticleInitializer {
    private static final int DELTA_LIMIT = 5;
    private int lifetime;
    private float particlesPerMs;
    private float[] origin;
    private float[] initialVelocity;
    private float[] color;
    private float variation;
    private double initialMass;
    private double surfaceArea;
    private PositionInterpolator interpolator;
    private float[] lengthTmp;
    private int zeroDeltaCounter;

    public PolylineEmitter(int n, int n2, float[] fArray, float[] fArray2, float[] fArray3, float f) {
        this(n, n2, fArray, fArray.length / 3, fArray2, fArray3, f);
    }

    public PolylineEmitter(int n, int n2, float[] fArray, int n3, float[] fArray2, float[] fArray3, float f) {
        this.lifetime = n;
        this.particlesPerMs = (float)n2 / (float)n;
        this.initialVelocity = new float[3];
        this.initialVelocity[0] = fArray3[0];
        this.initialVelocity[1] = fArray3[1];
        this.initialVelocity[2] = fArray3[2];
        this.color = new float[4];
        this.color[0] = fArray2[0];
        this.color[1] = fArray2[1];
        this.color[2] = fArray2[2];
        this.color[3] = fArray2[3];
        this.variation = f;
        this.initialMass = 1.0E-7;
        this.surfaceArea = 4.0E-4;
        this.zeroDeltaCounter = 0;
        this.interpolator = new PositionInterpolator(n3);
        this.lengthTmp = new float[n3];
        this.updateEmitterLine(fArray, n3);
    }

    public int numParticlesToCreate(int n) {
        int n2 = 0;
        switch (n) {
            case -1: {
                break;
            }
            case 0: {
                if (this.zeroDeltaCounter == 5) {
                    n2 = 1;
                    this.zeroDeltaCounter = 0;
                    break;
                }
                ++this.zeroDeltaCounter;
                break;
            }
            default: {
                this.zeroDeltaCounter = 0;
                n2 = (int)(this.particlesPerMs * (float)n);
            }
        }
        return n2;
    }

    public boolean initialize(Particle particle) {
        particle.resultantForce.set(0.0, 0.0, 0.0);
        particle.setColor(this.color[0], this.color[1], this.color[2], this.color[3]);
        float f = 1.0f - (float)Math.random() * this.variation;
        particle.setCycleTime((int)(f * (float)this.lifetime));
        float f2 = (float)Math.random();
        float[] fArray = this.interpolator.floatValue(f2);
        particle.setPositionAndPrevious(fArray[0], fArray[1], fArray[2]);
        f = 1.0f - (float)Math.random() * this.variation;
        float f3 = this.initialVelocity[0] * f;
        float f4 = this.initialVelocity[1] * f;
        float f5 = this.initialVelocity[2] * f;
        particle.velocity.set((double)f3, (double)f4, (double)f5);
        return true;
    }

    public void setColor(float f, float f2, float f3, float f4) {
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void setSurfaceArea(double d) {
        this.surfaceArea = d;
    }

    public void setMass(double d) {
        this.initialMass = d;
    }

    public void setPosition(float f, float f2, float f3) {
    }

    public void setVelocity(float f, float f2, float f3) {
        this.initialVelocity[0] = f;
        this.initialVelocity[1] = f2;
        this.initialVelocity[2] = f3;
    }

    public void setEmitterLine(float[] fArray) {
        this.updateEmitterLine(fArray, fArray.length / 3);
    }

    public void setEmitterLine(float[] fArray, int n) {
        this.updateEmitterLine(fArray, n);
    }

    private void updateEmitterLine(float[] fArray, int n) {
        float f;
        float f2;
        this.interpolator.clear();
        if (this.lengthTmp.length < n) {
            this.lengthTmp = new float[n];
        }
        int n2 = 0;
        float f3 = 0.0f;
        int n3 = 0;
        while (n3 < n - 1) {
            f2 = fArray[n2] - fArray[n2 + 3];
            float f4 = fArray[n2 + 1] - fArray[n2 + 4];
            f = fArray[n2 + 2] - fArray[n2 + 5];
            this.lengthTmp[n3] = f2 * f2 + f4 * f4 + f * f;
            f3 += this.lengthTmp[n3];
            n2 += 3;
            ++n3;
        }
        this.interpolator.addKeyFrame(0.0f, fArray[0], fArray[1], fArray[2]);
        n2 = 3;
        f2 = 0.0f;
        int n4 = 0;
        while (n4 < n - 1) {
            f = (f2 += this.lengthTmp[n4]) / f3;
            this.interpolator.addKeyFrame(f, fArray[n2++], fArray[n2++], fArray[n2++]);
            ++n4;
        }
    }
}

