/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.particle;

import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.j3d.geom.particle.Particle;
import org.j3d.geom.particle.ParticleFunction;

public class WindParticleFunction
implements ParticleFunction {
    private Point3d windStart = new Point3d(0.0, -1000.0, 0.0);
    private Point3d windEnd = new Point3d(0.0, 1000.0, 0.0);
    private Vector3d ab;
    private Vector3d ap = new Vector3d();
    private Vector3d crossAbAp = new Vector3d();
    private double abLength;
    private double attenuationStart = 0.2;
    private double attenuationEnd = 0.8;
    private Vector3d forcePerSquareMeter = new Vector3d(0.0, 0.02, 0.0);
    private Vector3d currentForcePerSquareMeter = new Vector3d();
    private double gustiness = 0.4;
    private double swirlinessX = -5.0E-4;
    private double swirlinessY = 5.0E-4;
    private double swirlinessZ = -5.0E-4;
    private boolean enabled;

    public WindParticleFunction(Vector3d vector3d) {
        this.ab = new Vector3d(this.windEnd.x - this.windStart.x, this.windEnd.y - this.windStart.y, this.windEnd.z - this.windStart.z);
        this.abLength = this.ab.length();
        this.forcePerSquareMeter = vector3d;
        this.enabled = true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean newFrame() {
        this.currentForcePerSquareMeter.x = Math.random() * this.forcePerSquareMeter.x * this.gustiness;
        this.currentForcePerSquareMeter.y = Math.random() * this.forcePerSquareMeter.y * this.gustiness;
        this.currentForcePerSquareMeter.z = Math.random() * this.forcePerSquareMeter.z * this.gustiness;
        return true;
    }

    public boolean apply(Particle particle) {
        particle.getPosition((Tuple3d)this.ap);
        this.ap.sub((Tuple3d)this.windStart);
        this.crossAbAp.cross(this.ab, this.ap);
        double d = this.crossAbAp.length() / this.abLength;
        if (d > this.attenuationStart) {
            if (d <= this.attenuationEnd) {
                this.currentForcePerSquareMeter.scale((d - this.attenuationStart) / (this.attenuationEnd - this.attenuationStart));
            } else {
                this.currentForcePerSquareMeter.set(0.0, 0.0, 0.0);
            }
        }
        if (d < this.attenuationEnd) {
            this.currentForcePerSquareMeter.x += Math.random() * this.swirlinessX;
            this.currentForcePerSquareMeter.y += Math.random() * this.swirlinessY;
            this.currentForcePerSquareMeter.z += Math.random() * this.swirlinessZ;
            this.currentForcePerSquareMeter.scale(particle.surfaceArea);
            particle.resultantForce.add((Tuple3d)this.currentForcePerSquareMeter);
        }
        return true;
    }
}

