/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.terrain;

import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;

public class ElevationGridGenerator
extends GeometryGenerator {
    public static final int RELATIVE_HEIGHTS = 1;
    public static final int ABSOLUTE_HEIGHTS = 2;
    private static final float DEFAULT_SIZE = 100.0f;
    private static final int DEFAULT_POINT_COUNT = 2;
    private static final float DEFAULT_HEIGHT = 2.0f;
    private float terrainWidth;
    private float terrainDepth;
    private int widthPoints;
    private int depthPoints;
    private float baseHeight;
    private float[] flatHeights;
    private float[][] arrayHeights;
    private int numTerrainValues;
    private int numTexcoordValues;
    private float[] terrainCoordinates;
    private float[] terrainNormals;
    private float[] terrainTexcoords;
    private boolean terrainChanged;
    private boolean normalsChanged;
    private boolean texcoordsChanged;
    private int facetCount;
    private boolean centerOrigin;

    public ElevationGridGenerator() {
        this(100.0f, 100.0f, 2, 2, (float[])null, 2.0f, true);
    }

    public ElevationGridGenerator(float f, float f2, int n, int n2) {
        this(f, f2, n, n2, (float[])null, 2.0f, true);
    }

    public ElevationGridGenerator(float f, float f2, int n, int n2, boolean bl) {
        this(f, f2, n, n2, (float[])null, 2.0f, bl);
    }

    public ElevationGridGenerator(float f, float f2, int n, int n2, float[] fArray, float f3) {
        this(f, f2, n, n2, fArray, f3, true);
    }

    public ElevationGridGenerator(float f, float f2, int n, int n2, float[][] fArray, float f3) {
        this(f, f2, n, n2, fArray, f3, true);
    }

    public ElevationGridGenerator(float f, float f2, int n, int n2, float[] fArray, float f3, boolean bl) {
        if (n < 2 || n2 < 2) {
            throw new IllegalArgumentException("Point count <= 1");
        }
        if (f <= 0.0f || f2 <= 0.0f) {
            throw new IllegalArgumentException("Dimension <= 0");
        }
        this.terrainWidth = f;
        this.terrainDepth = f2;
        this.widthPoints = n;
        this.depthPoints = n2;
        this.centerOrigin = bl;
        this.facetCount = (this.depthPoints - 1) * (this.widthPoints - 1);
        this.flatHeights = fArray;
        this.baseHeight = f3;
        this.terrainChanged = true;
        this.normalsChanged = true;
        this.texcoordsChanged = true;
    }

    public ElevationGridGenerator(float f, float f2, int n, int n2, float[][] fArray, float f3, boolean bl) {
        if (n < 2 || n2 < 2) {
            throw new IllegalArgumentException("Point count <= 1");
        }
        if (f <= 0.0f || f2 <= 0.0f) {
            throw new IllegalArgumentException("Dimension <= 0");
        }
        this.terrainWidth = f;
        this.terrainDepth = f2;
        this.widthPoints = n;
        this.depthPoints = n2;
        this.centerOrigin = bl;
        this.facetCount = (this.depthPoints - 1) * (this.widthPoints - 1);
        this.arrayHeights = fArray;
        this.baseHeight = f3;
        this.terrainChanged = true;
        this.normalsChanged = true;
        this.texcoordsChanged = true;
    }

    public float[] getDimensions() {
        return new float[]{this.terrainWidth, this.terrainDepth};
    }

    public void setDimensions(float f, float f2, int n, int n2) {
        if (this.terrainWidth != f || this.terrainDepth != f2) {
            this.terrainChanged = true;
            this.normalsChanged = true;
            this.texcoordsChanged = true;
            this.terrainDepth = f2;
            this.terrainWidth = f;
        }
        if (n != this.widthPoints || n2 != this.depthPoints) {
            this.terrainChanged = true;
            this.normalsChanged = true;
            this.texcoordsChanged = true;
            this.widthPoints = n;
            this.depthPoints = n2;
            this.facetCount = (this.depthPoints - 1) * (this.widthPoints - 1);
        }
    }

    public void setTerrainDetail(float[] fArray, float f) {
        this.flatHeights = fArray;
        this.baseHeight = f;
        this.arrayHeights = null;
        this.terrainChanged = true;
        this.normalsChanged = true;
    }

    public void setTerrainDetail(float[][] fArray, float f) {
        this.arrayHeights = fArray;
        this.baseHeight = f;
        this.flatHeights = null;
        this.terrainChanged = true;
        this.normalsChanged = true;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        int n = 0;
        switch (geometryData.geometryType) {
            case 1: {
                n = this.facetCount * 6;
                break;
            }
            case 2: {
                n = this.facetCount * 4;
                break;
            }
            case 3: {
                n = this.widthPoints * 2 * (this.depthPoints - 1);
                break;
            }
            case 4: {
                n = this.facetCount * 4;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n = this.facetCount * 2;
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
        return n;
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        switch (geometryData.geometryType) {
            case 1: {
                this.unindexedTriangles(geometryData);
                break;
            }
            case 2: {
                this.unindexedQuads(geometryData);
                break;
            }
            case 3: {
                this.triangleStrips(geometryData);
                break;
            }
            case 4: {
                this.triangleFans(geometryData);
                break;
            }
            case 5: {
                this.indexedQuads(geometryData);
                break;
            }
            case 6: {
                this.indexedTriangles(geometryData);
                break;
            }
            case 7: {
                this.indexedTriangleStrips(geometryData);
                break;
            }
            case 8: {
                this.indexedTriangleFans(geometryData);
                break;
            }
            default: {
                throw new UnsupportedTypeException("Unknown geometry type: " + geometryData.geometryType);
            }
        }
    }

    private void unindexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void unindexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedQuadCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedQuadNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateUnindexedQuadTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
    }

    private void indexedQuads(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.facetCount * this.facetCount * 4;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.facetCount * this.facetCount;
        while (--n4 >= 0) {
            nArray[n2++] = n3;
            nArray[n2++] = n3 + this.widthPoints;
            nArray[n2++] = n3 + this.widthPoints + 1;
            nArray[n2++] = n3 + 1;
            ++n3;
            if (n4 % (this.widthPoints - 1) != 0) continue;
            ++n3;
        }
    }

    private void indexedTriangles(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.facetCount * this.facetCount * 6;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Coordinates", geometryData.indexes.length, n);
        }
        int[] nArray = geometryData.indexes;
        geometryData.indexesCount = n;
        int n2 = 0;
        int n3 = 0;
        int n4 = this.facetCount * this.facetCount;
        while (--n4 >= 0) {
            nArray[n2++] = n3;
            nArray[n2++] = n3 + this.widthPoints + 1;
            nArray[n2++] = n3 + 1;
            nArray[n2++] = n3 + this.widthPoints;
            nArray[n2++] = n3 + this.widthPoints + 1;
            nArray[n2++] = n3++;
            if (n4 % (this.widthPoints - 1) != 0) continue;
            ++n3;
        }
    }

    private void triangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriStripCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriStripNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateUnindexedTriStripTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.depthPoints - 1;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = n;
        while (--n2 >= 0) {
            geometryData.stripCounts[n2] = this.widthPoints * 2;
        }
    }

    private void triangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateUnindexedTriFanCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateUnindexedTriFanNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.facetCount;
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n];
        } else if (geometryData.stripCounts.length < n) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n);
        }
        int n2 = this.facetCount;
        while (--n2 >= 0) {
            geometryData.stripCounts[n2] = 4;
        }
    }

    private void indexedTriangleStrips(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n2 = this.widthPoints * (this.depthPoints - 1) * 2;
        int n3 = this.depthPoints - 1;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n2];
        } else if (geometryData.indexes.length < n2) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n2);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n3];
        } else if (geometryData.stripCounts.length < n3) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n3);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n2;
        geometryData.numStrips = n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = n = this.widthPoints * (this.depthPoints - 1);
        while (--n6 >= 0) {
            nArray[n4++] = n5;
            nArray[n4++] = n5 + this.widthPoints;
            ++n5;
        }
        int n7 = n3;
        while (--n7 >= 0) {
            nArray2[n7] = this.widthPoints * 2;
        }
    }

    private void indexedTriangleFans(GeometryData geometryData) throws InvalidArraySizeException {
        this.generateIndexedCoordinates(geometryData);
        if ((geometryData.geometryComponents & 2) != 0) {
            this.generateIndexedNormals(geometryData);
        }
        if ((geometryData.geometryComponents & 4) != 0) {
            this.generateTriTexture2D(geometryData);
        } else if ((geometryData.geometryComponents & 8) != 0) {
            this.generateTriTexture3D(geometryData);
        }
        int n = this.facetCount * 4;
        int n2 = this.facetCount;
        if (geometryData.indexes == null) {
            geometryData.indexes = new int[n];
        } else if (geometryData.indexes.length < n) {
            throw new InvalidArraySizeException("Indexes", geometryData.indexes.length, n);
        }
        if (geometryData.stripCounts == null) {
            geometryData.stripCounts = new int[n2];
        } else if (geometryData.stripCounts.length < n2) {
            throw new InvalidArraySizeException("Strip counts", geometryData.stripCounts.length, n2);
        }
        int[] nArray = geometryData.indexes;
        int[] nArray2 = geometryData.stripCounts;
        geometryData.indexesCount = n;
        geometryData.numStrips = n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.facetCount;
        while (--n5 >= 0) {
            nArray[n3++] = n4 + this.widthPoints;
            nArray[n3++] = n4 + this.widthPoints + 1;
            nArray[n3++] = n4 + 1;
            nArray[n3++] = n4++;
            nArray2[n5] = 4;
            if (n5 % (this.widthPoints - 1) != 0) continue;
            ++n4;
        }
    }

    private void generateUnindexedTriCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.depthPoints * this.widthPoints * 6;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 3;
        n3 = this.facetCount;
        while (--n3 >= 0) {
            fArray[n2++] = this.terrainCoordinates[n4];
            fArray[n2++] = this.terrainCoordinates[n4 + 1];
            fArray[n2++] = this.terrainCoordinates[n4 + 2];
            fArray[n2++] = this.terrainCoordinates[n4 + n5];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 1];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 2];
            fArray[n2++] = this.terrainCoordinates[n4 + 3];
            fArray[n2++] = this.terrainCoordinates[n4 + 4];
            fArray[n2++] = this.terrainCoordinates[n4 + 5];
            fArray[n2++] = this.terrainCoordinates[n4 + n5];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 1];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 2];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 3];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 4];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 5];
            fArray[n2++] = this.terrainCoordinates[n4 + 3];
            fArray[n2++] = this.terrainCoordinates[n4 + 4];
            fArray[n2++] = this.terrainCoordinates[n4 + 5];
            n4 += 3;
            if (n3 % (this.widthPoints - 1) != 0) continue;
            n4 += 3;
        }
        this.checkRelativeHeights(geometryData.geometrySubType, fArray, n);
    }

    private void generateUnindexedTriStripCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = this.widthPoints * (this.depthPoints - 1) * 2;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n2 * 3];
        } else if (geometryData.coordinates.length < n2 * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n2 * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n2;
        this.regenerateBase();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 3;
        int n6 = n = this.widthPoints * (this.depthPoints - 1);
        while (--n6 >= 0) {
            fArray[n3++] = this.terrainCoordinates[n4];
            fArray[n3++] = this.terrainCoordinates[n4 + 1];
            fArray[n3++] = this.terrainCoordinates[n4 + 2];
            fArray[n3++] = this.terrainCoordinates[n4 + n5];
            fArray[n3++] = this.terrainCoordinates[n4 + n5 + 1];
            fArray[n3++] = this.terrainCoordinates[n4 + n5 + 2];
            n4 += 3;
        }
        this.checkRelativeHeights(geometryData.geometrySubType, fArray, n2);
    }

    private void generateUnindexedTriFanCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.facetCount * 4;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 3;
        n3 = this.facetCount;
        while (--n3 >= 0) {
            fArray[n2++] = this.terrainCoordinates[n4 + n5];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 1];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 2];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 3];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 4];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 5];
            fArray[n2++] = this.terrainCoordinates[n4 + 3];
            fArray[n2++] = this.terrainCoordinates[n4 + 4];
            fArray[n2++] = this.terrainCoordinates[n4 + 5];
            fArray[n2++] = this.terrainCoordinates[n4];
            fArray[n2++] = this.terrainCoordinates[n4 + 1];
            fArray[n2++] = this.terrainCoordinates[n4 + 2];
            n4 += 3;
            if (n3 % (this.widthPoints - 1) != 0) continue;
            n4 += 3;
        }
        this.checkRelativeHeights(geometryData.geometrySubType, fArray, n);
    }

    private void generateUnindexedQuadCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.facetCount * 4;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 3;
        n3 = this.facetCount;
        while (--n3 >= 0) {
            fArray[n2++] = this.terrainCoordinates[n4];
            fArray[n2++] = this.terrainCoordinates[n4 + 1];
            fArray[n2++] = this.terrainCoordinates[n4 + 2];
            fArray[n2++] = this.terrainCoordinates[n4 + n5];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 1];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 2];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 3];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 4];
            fArray[n2++] = this.terrainCoordinates[n4 + n5 + 5];
            fArray[n2++] = this.terrainCoordinates[n4 + 3];
            fArray[n2++] = this.terrainCoordinates[n4 + 4];
            fArray[n2++] = this.terrainCoordinates[n4 + 5];
            n4 += 3;
            if (n3 % (this.widthPoints - 1) != 0) continue;
            n4 += 3;
        }
        this.checkRelativeHeights(geometryData.geometrySubType, fArray, n);
    }

    private void generateIndexedCoordinates(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.widthPoints * this.depthPoints;
        if (geometryData.coordinates == null) {
            geometryData.coordinates = new float[n * 3];
        } else if (geometryData.coordinates.length < n * 3) {
            throw new InvalidArraySizeException("Coordinates", geometryData.coordinates.length, n * 3);
        }
        float[] fArray = geometryData.coordinates;
        geometryData.vertexCount = n;
        this.regenerateBase();
        System.arraycopy(this.terrainCoordinates, 0, fArray, 0, this.numTerrainValues);
        this.checkRelativeHeights(geometryData.geometrySubType, fArray, n);
    }

    private void generateUnindexedTriNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        this.regenerateNormals();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 3;
        float[] fArray = geometryData.normals;
        n2 = this.facetCount;
        while (--n2 >= 0) {
            fArray[n3++] = this.terrainNormals[n4];
            fArray[n3++] = this.terrainNormals[n4 + 1];
            fArray[n3++] = this.terrainNormals[n4 + 2];
            fArray[n3++] = this.terrainNormals[n4 + n5];
            fArray[n3++] = this.terrainNormals[n4 + n5 + 1];
            fArray[n3++] = this.terrainNormals[n4 + n5 + 2];
            fArray[n3++] = this.terrainNormals[n4 + 3];
            fArray[n3++] = this.terrainNormals[n4 + 4];
            fArray[n3++] = this.terrainNormals[n4 + 5];
            fArray[n3++] = this.terrainNormals[n4 + n5];
            fArray[n3++] = this.terrainNormals[n4 + n5 + 1];
            fArray[n3++] = this.terrainNormals[n4 + n5 + 2];
            fArray[n3++] = this.terrainNormals[n4 + n5 + 3];
            fArray[n3++] = this.terrainNormals[n4 + n5 + 4];
            fArray[n3++] = this.terrainNormals[n4 + n5 + 5];
            fArray[n3++] = this.terrainNormals[n4 + 3];
            fArray[n3++] = this.terrainNormals[n4 + 4];
            fArray[n3++] = this.terrainNormals[n4 + 5];
            n4 += 3;
            if (n2 % (this.widthPoints - 1) != 0) continue;
            n4 += 3;
        }
    }

    private void generateUnindexedTriStripNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n2];
        } else if (geometryData.normals.length < n2) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n2);
        }
        this.regenerateNormals();
        float[] fArray = geometryData.normals;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 3;
        int n6 = n = this.widthPoints * (this.depthPoints - 1);
        while (--n6 >= 0) {
            fArray[n3++] = this.terrainNormals[n4];
            fArray[n3++] = this.terrainNormals[n4 + 1];
            fArray[n3++] = this.terrainNormals[n4 + 2];
            fArray[n3++] = this.terrainNormals[n4 + n5];
            fArray[n3++] = this.terrainNormals[n4 + n5 + 1];
            fArray[n3++] = this.terrainNormals[n4 + n5 + 2];
            n4 += 3;
        }
    }

    private void generateUnindexedTriFanNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        this.regenerateNormals();
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 3;
        n3 = this.facetCount;
        while (--n3 >= 0) {
            fArray[n2++] = this.terrainNormals[n4 + n5];
            fArray[n2++] = this.terrainNormals[n4 + n5 + 1];
            fArray[n2++] = this.terrainNormals[n4 + n5 + 2];
            fArray[n2++] = this.terrainNormals[n4 + n5 + 3];
            fArray[n2++] = this.terrainNormals[n4 + n5 + 4];
            fArray[n2++] = this.terrainNormals[n4 + n5 + 5];
            fArray[n2++] = this.terrainNormals[n4 + 3];
            fArray[n2++] = this.terrainNormals[n4 + 4];
            fArray[n2++] = this.terrainNormals[n4 + 5];
            fArray[n2++] = this.terrainNormals[n4];
            fArray[n2++] = this.terrainNormals[n4 + 1];
            fArray[n2++] = this.terrainNormals[n4 + 2];
            n4 += 3;
            if (n3 % (this.widthPoints - 1) != 0) continue;
            n4 += 3;
        }
    }

    private void generateUnindexedQuadNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        this.regenerateNormals();
        float[] fArray = geometryData.normals;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 3;
        n3 = this.facetCount;
        while (--n3 >= 0) {
            fArray[n2++] = this.terrainNormals[n4];
            fArray[n2++] = this.terrainNormals[n4 + 1];
            fArray[n2++] = this.terrainNormals[n4 + 2];
            fArray[n2++] = this.terrainNormals[n4 + n5];
            fArray[n2++] = this.terrainNormals[n4 + n5 + 1];
            fArray[n2++] = this.terrainNormals[n4 + n5 + 2];
            fArray[n2++] = this.terrainNormals[n4 + n5 + 3];
            fArray[n2++] = this.terrainNormals[n4 + n5 + 4];
            fArray[n2++] = this.terrainNormals[n4 + n5 + 5];
            fArray[n2++] = this.terrainNormals[n4 + 3];
            fArray[n2++] = this.terrainNormals[n4 + 4];
            fArray[n2++] = this.terrainNormals[n4 + 5];
            n4 += 3;
            if (n3 % (this.widthPoints - 1) != 0) continue;
            n4 += 3;
        }
    }

    private void generateIndexedNormals(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 3;
        if (geometryData.normals == null) {
            geometryData.normals = new float[n];
        } else if (geometryData.normals.length < n) {
            throw new InvalidArraySizeException("Normals", geometryData.normals.length, n);
        }
        this.regenerateNormals();
        System.arraycopy(this.terrainNormals, 0, geometryData.normals, 0, this.numTerrainValues);
    }

    private void generateUnindexedTriStripTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n;
        int n2 = this.widthPoints * (this.depthPoints - 1) * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n2 * 2];
        } else if (geometryData.textureCoordinates.length < n2 * 2) {
            throw new InvalidArraySizeException("Coordinates", geometryData.textureCoordinates.length, n2 * 2);
        }
        float[] fArray = geometryData.textureCoordinates;
        this.regenerateTexcoords();
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 2;
        int n6 = n = this.widthPoints * (this.depthPoints - 1);
        while (--n6 >= 0) {
            fArray[n3++] = this.terrainTexcoords[n4];
            fArray[n3++] = this.terrainTexcoords[n4 + 1];
            fArray[n3++] = this.terrainTexcoords[n4 + n5];
            fArray[n3++] = this.terrainTexcoords[n4 + n5 + 1];
            n4 += 2;
        }
    }

    private void generateUnindexedQuadTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = this.facetCount * 4;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n * 2];
        } else if (geometryData.textureCoordinates.length < n * 2) {
            throw new InvalidArraySizeException("Coordinates", geometryData.textureCoordinates.length, n * 2);
        }
        float[] fArray = geometryData.textureCoordinates;
        this.regenerateTexcoords();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.widthPoints * 2;
        n3 = this.facetCount;
        while (--n3 >= 0) {
            fArray[n2++] = this.terrainTexcoords[n4];
            fArray[n2++] = this.terrainTexcoords[n4 + 1];
            fArray[n2++] = this.terrainTexcoords[n4 + n5];
            fArray[n2++] = this.terrainTexcoords[n4 + n5 + 1];
            fArray[n2++] = this.terrainTexcoords[n4 + n5 + 2];
            fArray[n2++] = this.terrainTexcoords[n4 + n5 + 3];
            fArray[n2++] = this.terrainTexcoords[n4 + 2];
            fArray[n2++] = this.terrainTexcoords[n4 + 3];
            n4 += 2;
            if (n3 % (this.widthPoints - 1) != 0) continue;
            n4 += 2;
        }
    }

    private void generateTriTexture2D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("2D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        this.regenerateTexcoords();
        System.out.println("Unhandled textured generation case in ElevationGridGenerator");
    }

    private void generateTriTexture3D(GeometryData geometryData) throws InvalidArraySizeException {
        int n = geometryData.vertexCount * 2;
        if (geometryData.textureCoordinates == null) {
            geometryData.textureCoordinates = new float[n];
        } else if (geometryData.textureCoordinates.length < n) {
            throw new InvalidArraySizeException("3D Texture coordinates", geometryData.textureCoordinates.length, n);
        }
        float[] fArray = geometryData.textureCoordinates;
        System.out.println("Unhandled textured generation case in ElevationGridGenerator");
    }

    private void checkRelativeHeights(int n, float[] fArray, int n2) {
        if ((n & 1) == 0) {
            return;
        }
        int n3 = n2 * 3 - 2;
        while (n3 >= 0) {
            int n4 = n3;
            fArray[n4] = fArray[n4] + this.baseHeight;
            n3 -= 3;
        }
    }

    private final void regenerateBase() {
        float f;
        float f2;
        if (!this.terrainChanged) {
            return;
        }
        this.terrainChanged = false;
        this.numTerrainValues = this.widthPoints * this.depthPoints * 3;
        if (this.terrainCoordinates == null || this.numTerrainValues > this.terrainCoordinates.length) {
            this.terrainCoordinates = new float[this.numTerrainValues];
        }
        if (this.centerOrigin) {
            f2 = -this.terrainDepth / 2.0f;
            f = -this.terrainWidth / 2.0f;
        } else {
            f2 = 0.0f;
            f = 0.0f;
        }
        float f3 = this.terrainWidth / (float)(this.widthPoints - 1);
        float f4 = this.terrainDepth / (float)(this.depthPoints - 1);
        int n = 0;
        if (this.flatHeights != null) {
            int n2 = this.numTerrainValues / 3;
            int n3 = 1;
            while (n3 <= n2) {
                this.terrainCoordinates[n++] = f;
                this.terrainCoordinates[n++] = this.flatHeights[n3 - 1];
                this.terrainCoordinates[n++] = f2;
                f += f3;
                if (n3 % this.widthPoints == 0) {
                    f2 += f4;
                    f = this.centerOrigin ? -this.terrainWidth / 2.0f : 0.0f;
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < this.depthPoints) {
                int n5 = 0;
                while (n5 < this.widthPoints) {
                    this.terrainCoordinates[n++] = f;
                    this.terrainCoordinates[n++] = this.arrayHeights[n4][n5];
                    this.terrainCoordinates[n++] = f2;
                    f += f3;
                    ++n5;
                }
                f2 += f4;
                f = this.centerOrigin ? -this.terrainWidth / 2.0f : 0.0f;
                ++n4;
            }
        }
    }

    private final void regenerateNormals() {
        if (!this.normalsChanged) {
            return;
        }
        this.normalsChanged = false;
        if (this.terrainNormals == null || this.numTerrainValues > this.terrainNormals.length) {
            this.terrainNormals = new float[this.numTerrainValues];
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.widthPoints * 3;
        Vector3f vector3f = this.createFaceNormal(this.terrainCoordinates, n3, 0, 3);
        this.terrainNormals[n++] = vector3f.x;
        this.terrainNormals[n++] = vector3f.y;
        this.terrainNormals[n++] = vector3f.z;
        n2 = 3;
        int n4 = 1;
        while (n4 < this.widthPoints - 1) {
            vector3f = this.calcSideAverageNormal(this.terrainCoordinates, n2, n2 + 3, n2 + n3, n2 - 3);
            this.terrainNormals[n++] = vector3f.x;
            this.terrainNormals[n++] = vector3f.y;
            this.terrainNormals[n++] = vector3f.z;
            n2 += 3;
            ++n4;
        }
        vector3f = this.createFaceNormal(this.terrainCoordinates, n2, n2 + n3, n2 - 3);
        this.terrainNormals[n++] = vector3f.x;
        this.terrainNormals[n++] = vector3f.y;
        this.terrainNormals[n++] = vector3f.z;
        n2 += 3;
        n4 = 1;
        while (n4 < this.depthPoints - 1) {
            vector3f = this.calcSideAverageNormal(this.terrainCoordinates, n2, n2 - n3, n2 + 3, n2 + n3);
            this.terrainNormals[n++] = vector3f.x;
            this.terrainNormals[n++] = vector3f.y;
            this.terrainNormals[n++] = vector3f.z;
            n2 += 3;
            int n5 = 1;
            while (n5 < this.widthPoints - 1) {
                vector3f = this.calcQuadAverageNormal(this.terrainCoordinates, n2, n2 + 3, n2 + n3, n2 - 3, n2 - n3);
                this.terrainNormals[n++] = vector3f.x;
                this.terrainNormals[n++] = vector3f.y;
                this.terrainNormals[n++] = vector3f.z;
                n2 += 3;
                ++n5;
            }
            vector3f = this.calcSideAverageNormal(this.terrainCoordinates, n2, n2 + n3, n2 - 3, n2 - n3);
            this.terrainNormals[n++] = vector3f.x;
            this.terrainNormals[n++] = vector3f.y;
            this.terrainNormals[n++] = vector3f.z;
            n2 += 3;
            ++n4;
        }
        vector3f = this.createFaceNormal(this.terrainCoordinates, n2, n2 - n3, n2 + 3);
        this.terrainNormals[n++] = vector3f.x;
        this.terrainNormals[n++] = vector3f.y;
        this.terrainNormals[n++] = vector3f.z;
        n2 += 3;
        n4 = 1;
        while (n4 < this.widthPoints - 1) {
            vector3f = this.calcSideAverageNormal(this.terrainCoordinates, n2, n2 - 3, n2 - n3, n2 + 3);
            this.terrainNormals[n++] = vector3f.x;
            this.terrainNormals[n++] = vector3f.y;
            this.terrainNormals[n++] = vector3f.z;
            n2 += 3;
            ++n4;
        }
        vector3f = this.createFaceNormal(this.terrainCoordinates, n2, n2 - 3, n2 - n3);
        this.terrainNormals[n++] = vector3f.x;
        this.terrainNormals[n++] = vector3f.y;
        this.terrainNormals[n++] = vector3f.z;
    }

    private Vector3f calcSideAverageNormal(float[] fArray, int n, int n2, int n3, int n4) {
        Vector3f vector3f = this.createFaceNormal(this.terrainCoordinates, n, n2, n3);
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f = this.createFaceNormal(this.terrainCoordinates, n, n3, n4);
        vector3f.x = (vector3f.x + f) / 2.0f;
        vector3f.y = (vector3f.y + f2) / 2.0f;
        vector3f.z = (vector3f.z + f3) / 2.0f;
        vector3f.normalize();
        return vector3f;
    }

    private Vector3f calcQuadAverageNormal(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        Vector3f vector3f = this.createFaceNormal(this.terrainCoordinates, n, n3, n2);
        float f = vector3f.x;
        float f2 = vector3f.y;
        float f3 = vector3f.z;
        vector3f = this.createFaceNormal(this.terrainCoordinates, n, n3, n4);
        f += vector3f.x;
        f2 += vector3f.y;
        f3 += vector3f.z;
        vector3f = this.createFaceNormal(this.terrainCoordinates, n, n4, n5);
        vector3f = this.createFaceNormal(this.terrainCoordinates, n, n5, n2);
        vector3f.x = (vector3f.x + (f += vector3f.x)) / 4.0f;
        vector3f.y = (vector3f.y + (f2 += vector3f.y)) / 4.0f;
        vector3f.z = (vector3f.z + (f3 += vector3f.z)) / 4.0f;
        vector3f.normalize();
        return vector3f;
    }

    private final void regenerateTexcoords() {
        if (!this.texcoordsChanged) {
            return;
        }
        this.texcoordsChanged = false;
        this.numTexcoordValues = this.widthPoints * this.depthPoints * 2;
        if (this.terrainTexcoords == null || this.numTexcoordValues > this.terrainTexcoords.length) {
            this.terrainTexcoords = new float[this.numTexcoordValues];
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 1.0f / (float)(this.widthPoints - 1);
        float f4 = 1.0f / (float)(this.depthPoints - 1);
        int n = 0;
        if (this.flatHeights != null) {
            int n2 = this.numTerrainValues / 3;
            int n3 = 1;
            while (n3 <= n2) {
                this.terrainTexcoords[n++] = f2;
                this.terrainTexcoords[n++] = f;
                f2 += f3;
                if (n3 % this.widthPoints == 0) {
                    f += f4;
                    f2 = 0.0f;
                }
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < this.depthPoints) {
                int n5 = 0;
                while (n5 < this.widthPoints) {
                    this.terrainTexcoords[n++] = f2;
                    this.terrainTexcoords[n++] = f;
                    f2 += f3;
                    ++n5;
                }
                f += f4;
                f2 = 0.0f;
                ++n4;
            }
        }
    }
}

