/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.geom.terrain;

import java.util.Random;
import javax.vecmath.Vector3f;
import org.j3d.geom.GeometryData;
import org.j3d.geom.GeometryGenerator;
import org.j3d.geom.InvalidArraySizeException;
import org.j3d.geom.UnsupportedTypeException;
import org.j3d.geom.terrain.ElevationGridGenerator;

public class FractalTerrainGenerator
extends GeometryGenerator {
    private static final int DEFAULT_ITERATIONS = 20;
    private static final float DEFAULT_SIZE = 100.0f;
    private static final float DEFAULT_ROUGHNESS = 2.0f;
    private static final float DEFAULT_SEALEVEL = 0.0f;
    private static final float DEFAULT_HEIGHT = 20.0f;
    private boolean useSeaLevel;
    private float terrainWidth;
    private float terrainDepth;
    private float terrainHeight;
    private float seaLevelHeight;
    private float roughness;
    private int iterations;
    private boolean terrainChanged;
    private Vector3f normal;
    private Random randomiser;
    private int facetCount;
    private ElevationGridGenerator gridGenerator;
    private float[] subdivPoints;
    private float[][] seedTerrain;
    private float[][] terrainHeights;

    public FractalTerrainGenerator() {
        this(100.0f, 100.0f, 20.0f, true, 0.0f, 20, 2.0f, 0L, null);
    }

    public FractalTerrainGenerator(float[][] fArray) {
        this(100.0f, 100.0f, 20.0f, true, 0.0f, 20, 2.0f, 0L, fArray);
    }

    public FractalTerrainGenerator(boolean bl, float f) {
        this(100.0f, 100.0f, 20.0f, bl, f, 20, 2.0f, 0L, null);
    }

    public FractalTerrainGenerator(float[][] fArray, boolean bl, float f) {
        this(100.0f, 100.0f, 20.0f, bl, f, 20, 2.0f, 0L, fArray);
    }

    public FractalTerrainGenerator(float f, float f2) {
        this(f, f2, 20.0f, true, 0.0f, 20, 2.0f, 0L, null);
    }

    public FractalTerrainGenerator(float[][] fArray, float f, float f2) {
        this(f, f2, 20.0f, true, 0.0f, 20, 2.0f, 0L, fArray);
    }

    public FractalTerrainGenerator(float f, int n, float f2, long l) {
        this(100.0f, 100.0f, f, true, 0.0f, n, f2, l, null);
    }

    public FractalTerrainGenerator(float f, float f2, float f3, int n, float f4, long l) {
        this(f, f2, f3, true, 0.0f, n, f4, l, null);
    }

    public FractalTerrainGenerator(float f, float f2, float f3, boolean bl, float f4, int n, float f5, long l, float[][] fArray) {
        if (f <= 0.0f || f3 <= 0.0f) {
            throw new IllegalArgumentException("Width or height <= 0");
        }
        if (bl) {
            if (f4 >= f3) {
                throw new IllegalArgumentException("Sea level >= height");
            }
            this.seaLevelHeight = f4;
        }
        if (f5 <= 1.0f) {
            throw new IllegalArgumentException("Roughness <= 1");
        }
        this.useSeaLevel = bl;
        this.terrainWidth = f;
        this.terrainHeight = f3;
        this.terrainDepth = f2;
        this.iterations = n;
        this.roughness = f5;
        this.randomiser = new Random();
        if (l != 0L) {
            this.randomiser.setSeed(l);
        }
        this.normal = new Vector3f();
        if (fArray == null) {
            this.seedTerrain = new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}};
        } else {
            if (fArray.length < 2 || fArray.length != fArray[0].length) {
                throw new IllegalArgumentException("Non-square terrain");
            }
            this.seedTerrain = fArray;
        }
        int n2 = this.calcSidePoints(n);
        this.gridGenerator = new ElevationGridGenerator(this.terrainWidth, this.terrainDepth, n2, n2);
        this.facetCount = n2 * n2;
        this.subdivPoints = new float[5];
        this.terrainChanged = true;
    }

    public boolean hasSeaLevel() {
        return this.useSeaLevel;
    }

    public float[] getDimensions() {
        return new float[]{this.terrainWidth, this.terrainDepth};
    }

    public void setGenerationFactors(float f, int n, float f2, long l) {
        if (f2 <= 1.0f) {
            throw new IllegalArgumentException("Roughness <= 1");
        }
        this.terrainHeight = f;
        this.iterations = n;
        this.roughness = f2;
        this.terrainChanged = true;
        if (l != 0L) {
            this.randomiser.setSeed(l);
        }
        int n2 = this.calcSidePoints(n);
        this.gridGenerator.setDimensions(this.terrainWidth, this.terrainDepth, n2, n2);
        this.facetCount = n2 * n2;
    }

    public void setDimensions(float f, float f2) {
        if (this.terrainWidth != f || this.terrainDepth != f2) {
            this.terrainChanged = true;
            this.terrainDepth = f2;
            this.terrainWidth = f;
            int n = this.calcSidePoints(this.iterations);
            this.gridGenerator.setDimensions(this.terrainWidth, this.terrainDepth, n, n);
            this.facetCount = n * n;
        }
    }

    public void setSeaData(boolean bl, float f) {
        if (bl) {
            if (f >= this.terrainHeight) {
                throw new IllegalArgumentException("Sea level >= height");
            }
            this.seaLevelHeight = f;
        }
        this.useSeaLevel = bl;
        this.terrainChanged = true;
    }

    public void setSeedTerrain(float[][] fArray) {
        if (fArray == null) {
            this.seedTerrain = new float[][]{{0.0f, 0.0f}, {0.0f, 0.0f}};
        } else {
            if (fArray.length < 2 || fArray.length != fArray[0].length) {
                throw new IllegalArgumentException("Non-square terrain");
            }
            this.seedTerrain = fArray;
        }
        int n = this.calcSidePoints(this.iterations);
        this.gridGenerator = new ElevationGridGenerator(this.terrainWidth, this.terrainDepth, n, n);
        this.facetCount = n * n;
        this.terrainChanged = true;
    }

    public void forceRegenerate() {
        this.terrainChanged = true;
    }

    public int getVertexCount(GeometryData geometryData) throws UnsupportedTypeException {
        return this.gridGenerator.getVertexCount(geometryData);
    }

    public void generate(GeometryData geometryData) throws UnsupportedTypeException, InvalidArraySizeException {
        this.regenerateTerrain();
        this.gridGenerator.generate(geometryData);
    }

    public float[][] generate() {
        this.regenerateTerrain();
        return this.terrainHeights;
    }

    private void regenerateTerrain() {
        if (!this.terrainChanged) {
            return;
        }
        this.terrainChanged = false;
        float[][] fArray = this.subdivideSurface();
        if (this.useSeaLevel) {
            int n = fArray.length;
            while (--n >= 0) {
                int n2 = fArray.length;
                while (--n2 >= 0) {
                    if (!(fArray[n][n2] < this.seaLevelHeight)) continue;
                    fArray[n][n2] = this.seaLevelHeight;
                }
            }
        }
        this.terrainHeights = fArray;
        this.gridGenerator.setTerrainDetail(fArray, 0.0f);
    }

    private float[][] subdivideSurface() {
        int n = 0;
        int n2 = this.seedTerrain.length;
        int n3 = 0;
        float f = this.terrainHeight;
        float[][] fArray = null;
        float[][] fArray2 = this.seedTerrain;
        int n4 = 1;
        while (n4 <= this.iterations) {
            n3 = 0;
            n = n2 + (int)Math.pow(2.0, n4 - 1);
            fArray = new float[n][n];
            int n5 = 0;
            while (n5 < n) {
                float f2;
                int n6;
                int n7;
                int n8 = 0;
                if (n5 % 2 != 1) {
                    n7 = 0;
                    while (n7 < n2 - 1) {
                        n6 = this.randomiser.nextBoolean() ? 1 : -1;
                        f2 = (fArray2[n3][n7] + fArray2[n3][n7 + 1]) / 2.0f;
                        fArray[n5][n8++] = fArray2[n3][n7];
                        fArray[n5][n8++] = f2 += f * this.randomiser.nextFloat() * (float)n6;
                        ++n7;
                    }
                    fArray[n5][n8++] = fArray2[n3][n7];
                    ++n3;
                } else {
                    n7 = 0;
                    while (n7 < n2 - 1) {
                        n6 = this.randomiser.nextBoolean() ? 1 : -1;
                        f2 = (fArray2[n3 - 1][n7] + fArray2[n3][n7]) / 2.0f;
                        fArray[n5][n8++] = f2 += f * this.randomiser.nextFloat() * (float)n6;
                        n6 = this.randomiser.nextBoolean() ? 1 : -1;
                        f2 = (fArray2[n3 - 1][n7] + fArray2[n3 - 1][n7 + 1] + fArray2[n3][n7] + fArray2[n3][n7 + 1]) / 4.0f;
                        fArray[n5][n8++] = f2 += f * this.randomiser.nextFloat() * (float)n6;
                        ++n7;
                    }
                    n6 = this.randomiser.nextBoolean() ? 1 : -1;
                    f2 = (fArray2[n3 - 1][n7] + fArray2[n3][n7]) / 2.0f;
                    fArray[n5][n8++] = f2 += f * this.randomiser.nextFloat() * (float)n6;
                }
                ++n5;
            }
            f /= this.roughness;
            fArray2 = fArray;
            n2 = n;
            ++n4;
        }
        return fArray;
    }

    private final int calcSidePoints(int n) {
        int n2 = this.seedTerrain.length;
        int n3 = 0;
        while (n3 < n) {
            n2 += (int)Math.pow(2.0, n3);
            ++n3;
        }
        return n2;
    }
}

