/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d;

import com.sun.j3d.loaders.IncorrectFormatException;
import com.sun.j3d.loaders.Loader;
import com.sun.j3d.loaders.ParsingErrorException;
import com.sun.j3d.loaders.Scene;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.j3d.loaders.ac3d.LoaderTokenHandler;
import org.j3d.loaders.ac3d.parser.Ac3dParser;

public class Ac3dLoader
implements Loader {
    private LoaderTokenHandler tokenHandler = new LoaderTokenHandler();
    private int flags = 0;
    private String basePath = null;
    private URL baseUrl = null;

    public Scene load(String string) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        if (this.basePath == null) {
            this.tokenHandler.setBasePath(new File(string).getParent());
        } else {
            this.tokenHandler.setBasePath(this.basePath);
        }
        FileReader fileReader = new FileReader(string);
        return this.load(fileReader);
    }

    public Scene load(Reader reader) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        Scene scene = null;
        BufferedReader bufferedReader = new BufferedReader(reader);
        Ac3dParser ac3dParser = new Ac3dParser();
        try {
            ac3dParser.setBufferedReader(bufferedReader);
            this.tokenHandler.setBufferedReader(bufferedReader);
            ac3dParser.setTokenHandler(this.tokenHandler);
            ac3dParser.parse();
            scene = this.tokenHandler.getScene();
        }
        catch (Exception exception) {
            System.err.println("Exception during parse: " + exception.getMessage());
            exception.printStackTrace(System.err);
        }
        return scene;
    }

    public Scene load(URL uRL) throws FileNotFoundException, IncorrectFormatException, ParsingErrorException {
        InputStreamReader inputStreamReader;
        if (this.baseUrl == null) {
            this.tokenHandler.setBaseUrl(uRL);
        } else {
            this.tokenHandler.setBaseUrl(this.baseUrl);
        }
        try {
            inputStreamReader = new InputStreamReader(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.getMessage());
        }
        return this.load(inputStreamReader);
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setBaseUrl(URL uRL) {
        this.baseUrl = uRL;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public void setBasePath(String string) {
        this.basePath = string;
    }

    public String getBasePath() {
        return this.basePath;
    }
}

