/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d.models;

import org.j3d.loaders.ac3d.models.Ac3dSurface;

public class Ac3dObject {
    private String name = "";
    private String type = "";
    private int numKids = 0;
    private Ac3dObject[] kids = new Ac3dObject[this.numKids];
    private int numvert = 0;
    private float[] loc = new float[3];
    private float[] rot;
    private int numsurf = 0;
    private Ac3dSurface[] surfaces;
    private float[] verticies;
    private String texture = "";
    char[] data = new char[0];
    public static float[] IDENTITY_MATRIX_ARRAY = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};

    public Ac3dObject() {
        this.rot = IDENTITY_MATRIX_ARRAY;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    public void setNumKids(int n) {
        this.numKids = n;
        this.kids = new Ac3dObject[n];
    }

    public int getNumKids() {
        return this.numKids;
    }

    public void setNumvert(int n) {
        this.numvert = n;
        this.verticies = new float[n * 3];
    }

    public int getNumvert() {
        return this.numvert;
    }

    public void setNumsurf(int n) {
        this.numsurf = n;
        this.surfaces = new Ac3dSurface[n];
    }

    public int getNumsurf() {
        return this.numsurf;
    }

    public void setLoc(float[] fArray) {
        if (fArray.length == 3) {
            this.loc = fArray;
        }
    }

    public float[] getLoc() {
        return this.loc;
    }

    public void setRot(float[] fArray) {
        if (fArray.length == 9) {
            this.rot = fArray;
        }
    }

    public float[] getRot() {
        return this.rot;
    }

    public void addSurface(int n, Ac3dSurface ac3dSurface) {
        this.surfaces[n] = ac3dSurface;
    }

    public Ac3dSurface getSurface(int n) {
        return this.surfaces[n];
    }

    public void addVertex(int n, float[] fArray) {
        this.verticies[3 * n] = fArray[0];
        this.verticies[3 * n + 1] = fArray[1];
        this.verticies[3 * n + 2] = fArray[2];
    }

    public float[] getVerticies() {
        return this.verticies;
    }

    public float[] getVertexAtIndex(int n) {
        float[] fArray = new float[3];
        int n2 = 0;
        while (n2 < 3) {
            fArray[n2] = this.verticies[3 * n + n2];
            ++n2;
        }
        return fArray;
    }

    public void setTexture(String string) {
        this.texture = string;
    }

    public String getTexture() {
        return this.texture;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ name=\"");
        stringBuffer.append(this.name);
        stringBuffer.append("\", type=\"");
        stringBuffer.append(this.type);
        stringBuffer.append("\", numKids=");
        stringBuffer.append(this.numKids);
        stringBuffer.append(", numvert=");
        stringBuffer.append(this.numvert);
        stringBuffer.append(", loc={");
        stringBuffer.append(Ac3dObject.stringifyXf(this.loc));
        stringBuffer.append("}, rot={");
        stringBuffer.append(Ac3dObject.stringifyXf(this.rot));
        stringBuffer.append("}, numsurf=");
        stringBuffer.append(this.numsurf);
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }

    private static String stringifyXf(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (fArray.length > 0) {
            stringBuffer.append(fArray[0]);
            int n = 1;
            while (n < fArray.length) {
                stringBuffer.append(",");
                stringBuffer.append(fArray[n]);
                ++n;
            }
        }
        return stringBuffer.toString();
    }
}

