/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d.models;

public class Ac3dSurface {
    int numrefs = 0;
    int flags = 0;
    int mat = -1;
    int[] verticies;
    float[] textureCoordinates;
    public static final int FLAG_POLYGON = 0;
    public static final int FLAG_CLOSEDLINE = 1;
    public static final int FLAG_LINE = 2;
    public static final int FLAG_SHADED = 16;
    public static final int FLAG_TWOSIDED = 32;

    public void setNumrefs(int n) {
        this.numrefs = n;
        this.verticies = new int[n];
        this.textureCoordinates = new float[n * 2];
    }

    public int getNumrefs() {
        return this.numrefs;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setMat(int n) {
        this.mat = n;
    }

    public int getMat() {
        return this.mat;
    }

    public void addRef(int n, int n2, float[] fArray) {
        this.verticies[n] = n2;
        this.textureCoordinates[2 * n] = fArray[0];
        this.textureCoordinates[2 * n + 1] = fArray[1];
    }

    public int[] getVerticiesIndex() {
        return this.verticies;
    }

    public float[] getTextureCoordinates() {
        return this.textureCoordinates;
    }

    public boolean checkFlag(int n) {
        return Ac3dSurface.checkFlag(n, this.flags);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ flags=");
        stringBuffer.append(this.flags);
        stringBuffer.append(" { ");
        stringBuffer.append(Ac3dSurface.stringifyFlags(this.flags));
        stringBuffer.append(" }, mat=");
        stringBuffer.append(this.mat);
        stringBuffer.append(", numrefs=");
        stringBuffer.append(this.numrefs);
        stringBuffer.append(", refs= { ");
        int n = 0;
        while (n < this.verticies.length) {
            stringBuffer.append(this.verticies[n]);
            stringBuffer.append("@(");
            stringBuffer.append(this.textureCoordinates[2 * n]);
            stringBuffer.append(", ");
            stringBuffer.append(this.textureCoordinates[2 * n + 1]);
            stringBuffer.append(") ");
            ++n;
        }
        stringBuffer.append(" } ]");
        return stringBuffer.toString();
    }

    private static final String stringifyFlags(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Ac3dSurface.checkFlag(0, n)) {
            stringBuffer.append("FLAG_POLYGON");
        }
        if (Ac3dSurface.checkFlag(1, n)) {
            stringBuffer.append("FLAG_CLOSEDLINE");
        }
        if (Ac3dSurface.checkFlag(2, n)) {
            stringBuffer.append("FLAG_LINE");
        }
        if (Ac3dSurface.checkFlag(16, n)) {
            stringBuffer.append(" | FLAG_SHADED");
        }
        if (Ac3dSurface.checkFlag(32, n)) {
            stringBuffer.append(" | FLAG_TWOSIDED");
        }
        return stringBuffer.toString();
    }

    private static final boolean checkFlag(int n, int n2) {
        return (n2 & n) == n;
    }
}

