/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.loaders.ac3d.util;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.j3d.Texture2D;

public class TextureLoaderHelper
implements ImageObserver {
    private URL baseUrl = null;

    public Texture2D loadTexture(String string) {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return this.loadTextureFromQualified(uRL);
    }

    public Texture2D loadTexture(URL uRL) {
        Texture2D texture2D = this.loadTextureFromQualified(uRL);
        return texture2D;
    }

    private synchronized Texture2D loadTextureFromQualified(URL uRL) {
        BufferedImage bufferedImage = null;
        boolean bl = false;
        boolean bl2 = false;
        Texture2D texture2D = null;
        bufferedImage = TextureLoaderHelper.loadImageWithToolkit(uRL, this);
        if (bufferedImage != null) {
            texture2D = TextureLoaderHelper.buildTexture(bufferedImage, bl, bl2);
        }
        return texture2D;
    }

    private static final Texture2D buildTexture(BufferedImage bufferedImage, boolean bl, boolean bl2) {
        String string = bl && bl2 ? "LUM8_ALPHA8" : (bl ? "LUMINANCE" : (bl2 ? "RGBA" : "RGB"));
        TextureLoader textureLoader = new TextureLoader(bufferedImage, string, 1);
        Texture2D texture2D = (Texture2D)textureLoader.getTexture();
        texture2D.setMinFilter(5);
        return texture2D;
    }

    private static final BufferedImage loadImageWithToolkit(Object object, TextureLoaderHelper textureLoaderHelper) {
        BufferedImage bufferedImage;
        block8: {
            boolean bl;
            bufferedImage = null;
            boolean bl2 = false;
            int n = 0;
            final Image[] imageArray = new Image[1];
            final Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (object instanceof File) {
                final String string = ((File)object).toString();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        imageArray[0] = toolkit.getImage(string);
                        return null;
                    }
                });
            } else if (object instanceof URL) {
                final URL uRL = (URL)object;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        imageArray[0] = toolkit.getImage(uRL);
                        return null;
                    }
                });
            }
            toolkit.prepareImage(imageArray[0], -1, -1, textureLoaderHelper);
            try {
                do {
                    bl2 = ((n = toolkit.checkImage(imageArray[0], -1, -1, textureLoaderHelper)) & 0xE0) != 0;
                    Thread.sleep(10L);
                } while (!bl2);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
            boolean bl3 = bl = (n & 0xC0) != 0;
            if (!bl2 || bl) break block8;
            int n2 = imageArray[0].getWidth(textureLoaderHelper);
            int n3 = imageArray[0].getHeight(textureLoaderHelper);
            bufferedImage = new BufferedImage(n2, n3, 2);
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            PixelGrabber pixelGrabber = new PixelGrabber(imageArray[0], 0, 0, n2, n3, nArray, 0, n2);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace(System.err);
            }
        }
        return bufferedImage;
    }

    public void setBasePath(String string) {
        try {
            this.baseUrl = new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    public String getBasePath() {
        return this.baseUrl.getFile();
    }

    public void setBaseUrl(URL uRL) {
        this.baseUrl = uRL;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        return (n & 0xA0) == 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ ");
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

