/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain;

import java.awt.Dimension;
import java.awt.Rectangle;
import javax.media.j3d.Texture;
import org.j3d.terrain.AbstractTerrainData;
import org.j3d.terrain.FreeFormTerrainData;
import org.j3d.terrain.TextureTileGenerator;

public abstract class AbstractFreeFormTerrainData
extends AbstractTerrainData
implements FreeFormTerrainData {
    protected TextureTileGenerator tileGenerator;
    protected int gridWidth;
    protected int gridDepth;
    private int widthPixelsPerGridStep;
    private int depthPixelsPerGridStep;
    private Rectangle pixelBounds;

    protected AbstractFreeFormTerrainData() {
        super(3);
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridDepth() {
        return this.gridDepth;
    }

    public Texture getTexture(Rectangle rectangle) {
        this.pixelBounds.x = rectangle.x * this.widthPixelsPerGridStep;
        this.pixelBounds.y = rectangle.y * this.depthPixelsPerGridStep;
        this.pixelBounds.width = rectangle.width * this.widthPixelsPerGridStep;
        this.pixelBounds.height = rectangle.height * this.depthPixelsPerGridStep;
        Texture texture = null;
        if (this.tileGenerator != null) {
            texture = this.tileGenerator.getTextureTile(this.pixelBounds);
        }
        return texture;
    }

    public void setTextureTileGenerator(TextureTileGenerator textureTileGenerator) {
        this.tileGenerator = textureTileGenerator;
        if (textureTileGenerator != null) {
            if (this.pixelBounds != null) {
                this.pixelBounds = new Rectangle();
            }
            Dimension dimension = textureTileGenerator.getTextureSize();
            this.widthPixelsPerGridStep = dimension.width / this.gridWidth;
            this.depthPixelsPerGridStep = dimension.height / this.gridDepth;
        }
    }
}

