/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.j3d.terrain.AppearanceGenerator;
import org.j3d.terrain.TerrainData;
import org.j3d.ui.navigation.FrameUpdateListener;
import org.j3d.ui.navigation.HeightMapGeometry;
import org.j3d.util.frustum.ViewFrustum;

public abstract class Landscape
extends BranchGroup
implements FrameUpdateListener,
HeightMapGeometry {
    protected ViewFrustum landscapeView;
    protected TerrainData terrainData;
    protected AppearanceGenerator appearanceGenerator;
    private Vector3f tmpPosition;
    private Vector3f tmpOrientation;
    private Matrix3f tmpMatrix;

    public Landscape(ViewFrustum viewFrustum, TerrainData terrainData) {
        if (viewFrustum == null) {
            throw new IllegalArgumentException("ViewFrustum not supplied");
        }
        if (terrainData == null) {
            throw new IllegalArgumentException("Terrain data not supplied");
        }
        this.terrainData = terrainData;
        this.landscapeView = viewFrustum;
        this.tmpPosition = new Vector3f();
        this.tmpOrientation = new Vector3f();
        this.tmpMatrix = new Matrix3f();
    }

    public Landscape(ViewFrustum viewFrustum, TerrainData terrainData, AppearanceGenerator appearanceGenerator) {
        this(viewFrustum, terrainData);
        this.appearanceGenerator = appearanceGenerator;
    }

    public void transitionEnded(Transform3D transform3D) {
        this.landscapeView.viewingPlatformMoved();
        this.setView(transform3D);
    }

    public void viewerPositionUpdated(Transform3D transform3D) {
        this.landscapeView.viewingPlatformMoved();
        this.setView(transform3D);
    }

    public float getHeight(float f, float f2) {
        return this.terrainData.getHeight(f, f2);
    }

    public abstract void initialize(Tuple3f var1, Vector3f var2);

    public abstract void setView(Tuple3f var1, Vector3f var2);

    public void setView(Transform3D transform3D) {
        transform3D.get(this.tmpMatrix, this.tmpPosition);
        this.tmpOrientation.set(0.0f, 0.0f, -1.0f);
        this.tmpMatrix.transform((Tuple3f)this.tmpOrientation);
        this.setView((Tuple3f)this.tmpPosition, this.tmpOrientation);
    }

    public void setAppearanceGenerator(AppearanceGenerator appearanceGenerator) {
        this.appearanceGenerator = appearanceGenerator;
    }

    public AppearanceGenerator getAppearanceGenerator() {
        return this.appearanceGenerator;
    }
}

