/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.terrain.roam;

import java.awt.Rectangle;
import org.j3d.terrain.roam.Patch;

class PatchGrid {
    private int numNorth;
    private int numEast;
    private int northOffset;
    private int eastOffset;
    private Patch[][] grid;

    PatchGrid(Rectangle rectangle) {
        this.grid = new Patch[rectangle.width][rectangle.height];
        this.numEast = rectangle.width;
        this.numNorth = rectangle.height;
        this.eastOffset = rectangle.x;
        this.northOffset = rectangle.y;
    }

    void prepareNewBounds(Rectangle rectangle) {
        int n;
        int n2;
        int n3;
        Patch[][] patchArrayArray;
        if (rectangle.width > this.grid.length) {
            patchArrayArray = new Patch[rectangle.width][];
            n3 = 0;
            while (n3 < this.grid.length) {
                patchArrayArray[n3] = this.grid[n3];
                ++n3;
            }
            n2 = this.grid[0].length;
            while (n3 < rectangle.width) {
                patchArrayArray[n3] = new Patch[n2];
                ++n3;
            }
        } else if (rectangle.width < this.numEast) {
            n3 = rectangle.width;
            while (n3 < this.numEast) {
                n = 0;
                while (n < this.numNorth) {
                    this.grid[n3][n] = null;
                    ++n;
                }
                ++n3;
            }
        }
        if (rectangle.height > this.grid[0].length) {
            n3 = 0;
            while (n3 < this.numEast) {
                patchArrayArray = new Patch[rectangle.height];
                System.arraycopy(this.grid[n3], 0, patchArrayArray, 0, this.numNorth);
                this.grid[n3] = patchArrayArray;
                ++n3;
            }
            while (n3 < this.grid.length) {
                this.grid[n3] = new Patch[rectangle.height];
                ++n3;
            }
        } else if (rectangle.height < this.numNorth) {
            n3 = 0;
            while (n3 < this.numEast) {
                n = rectangle.height;
                while (n < this.numNorth) {
                    this.grid[n3][n] = null;
                    ++n;
                }
                ++n3;
            }
        }
        if (rectangle.y > this.northOffset) {
            int n4 = rectangle.y - this.northOffset;
            n2 = rectangle.height - n4;
            n3 = 0;
            while (n3 < rectangle.width) {
                System.arraycopy(this.grid[n3], n4, this.grid[n3], 0, n2);
                n = n4;
                while (n < this.numNorth) {
                    this.grid[n3][n] = null;
                    ++n;
                }
                ++n3;
            }
        } else if (rectangle.y < this.northOffset) {
            int n5 = this.northOffset - rectangle.y;
            n2 = rectangle.height - n5;
            n3 = 0;
            while (n3 < rectangle.width) {
                System.arraycopy(this.grid[n3], 0, this.grid[n3], n5, n2);
                n = 0;
                while (n < n5) {
                    this.grid[n3][n] = null;
                    ++n;
                }
                ++n3;
            }
        }
        if (rectangle.x > this.eastOffset) {
            int n6 = rectangle.x - this.eastOffset;
            n2 = rectangle.height - n6;
            n3 = 0;
            while (n3 < n6) {
                System.arraycopy(this.grid[n3], 0, this.grid[n3 + 1], 0, this.numNorth);
                ++n3;
            }
            while (n3 < rectangle.width) {
                n = 0;
                while (n < rectangle.height) {
                    this.grid[n3][n] = null;
                    ++n;
                }
                ++n3;
            }
        } else if (rectangle.x < this.eastOffset) {
            int n7 = this.eastOffset - rectangle.x;
            n2 = rectangle.height - n7;
            n3 = n7;
            while (n3 <= rectangle.width - n7) {
                System.arraycopy(this.grid[n3 - 1], 0, this.grid[n3], 0, this.numNorth);
                ++n3;
            }
            n3 = 0;
            while (n3 < n7) {
                n = 0;
                while (n < rectangle.height) {
                    this.grid[n3][n] = null;
                    ++n;
                }
                ++n3;
            }
        }
        this.numEast = rectangle.width;
        this.numNorth = rectangle.height;
        this.eastOffset = rectangle.x;
        this.northOffset = rectangle.y;
    }

    void addPatch(Patch patch, int n, int n2) {
        Patch patch2;
        int n3 = n - this.eastOffset;
        int n4 = n2 - this.northOffset;
        this.grid[n3][n4] = patch;
        if (n3 != 0) {
            patch2 = this.grid[n3 - 1][n4];
            patch.setWestNeighbour(patch2);
            if (patch2 != null) {
                patch2.setEastNeighbour(patch);
            }
        }
        if (n3 < this.numEast - 1) {
            patch2 = this.grid[n3 + 1][n4];
            if (patch2 != null) {
                patch2.setWestNeighbour(patch);
            }
            patch.setEastNeighbour(patch2);
        }
        if (n4 != 0) {
            patch2 = this.grid[n3][n4 - 1];
            patch.setSouthNeighbour(patch2);
            if (patch2 != null) {
                patch2.setNorthNeighbour(patch);
            }
        }
        if (n4 < this.numNorth - 1) {
            patch2 = this.grid[n3][n4 + 1];
            if (patch2 != null) {
                patch2.setSouthNeighbour(patch);
            }
            patch.setNorthNeighbour(patch2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("PatchGrid:\n");
        stringBuffer.append("Size: ");
        stringBuffer.append(this.numEast);
        stringBuffer.append(' ');
        stringBuffer.append(this.numNorth);
        stringBuffer.append("\nOffsets: ");
        stringBuffer.append(this.eastOffset);
        stringBuffer.append(' ');
        stringBuffer.append(this.northOffset);
        int n = this.numNorth - 1;
        while (n >= 0) {
            stringBuffer.append('\n');
            int n2 = 0;
            while (n2 < this.numEast) {
                if (this.grid[n2][n] == null) {
                    stringBuffer.append('0');
                } else {
                    stringBuffer.append(this.grid[n2][n].hashCode());
                }
                stringBuffer.append(' ');
                ++n2;
            }
            --n;
        }
        return stringBuffer.toString();
    }

    public String toRelationsString() {
        StringBuffer stringBuffer = new StringBuffer("PatchGrid Relations:");
        int n = this.numNorth - 1;
        while (n >= 0) {
            stringBuffer.append('\n');
            int n2 = 0;
            while (n2 < this.numEast) {
                if (this.grid[n2][n] == null) {
                    stringBuffer.append('0');
                } else {
                    stringBuffer.append(this.grid[n2][n].toString2());
                }
                stringBuffer.append("  ");
                ++n2;
            }
            --n;
        }
        return stringBuffer.toString();
    }
}

