/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.texture;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.ImageComponent;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.ImageComponent3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture3D;
import org.j3d.texture.AbstractTextureCache;
import org.j3d.util.Queue;

class LRUTextureCache
extends AbstractTextureCache {
    private static final int DEFAULT_CACHE_SIZE = 20;
    public static final String DEFAULT_SIZE_PROP = "org.j3d.texture.LRUSize";
    private HashMap textureMap = new HashMap();
    private HashMap componentMap = new HashMap();
    private final int maxCacheSize;
    private Queue textureQueue = new Queue();
    private Queue componentQueue = new Queue();

    LRUTextureCache() {
        String string = System.getProperty(DEFAULT_SIZE_PROP);
        if (string != null) {
            int n = 20;
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.maxCacheSize = n;
        } else {
            this.maxCacheSize = 20;
        }
    }

    public Texture fetchTexture(String string) throws IOException {
        Object object = (Texture)this.textureMap.get(string);
        if (object == null) {
            ImageComponent imageComponent = (ImageComponent)this.componentMap.get(string);
            if (imageComponent == null) {
                imageComponent = this.load2DImage(string);
                this.addImageComponent(string, imageComponent);
            } else {
                this.componentQueue.remove(string);
                this.componentQueue.add(string);
            }
            int n = this.getTextureFormat(imageComponent);
            object = imageComponent instanceof ImageComponent2D ? new Texture2D(1, n, imageComponent.getWidth(), imageComponent.getHeight()) : new Texture3D(1, n, imageComponent.getWidth(), imageComponent.getHeight(), ((ImageComponent3D)imageComponent).getDepth());
            object.setImage(0, imageComponent);
            this.addTexture(string, (Texture)object);
        } else {
            this.textureQueue.remove(string);
            this.textureQueue.add(string);
        }
        return object;
    }

    public Texture fetchTexture(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        Object object = (Texture)this.textureMap.get(string);
        if (object == null) {
            ImageComponent imageComponent = (ImageComponent)this.componentMap.get(string);
            if (imageComponent == null) {
                imageComponent = this.load2DImage(string);
                this.addImageComponent(string, imageComponent);
            } else {
                this.componentQueue.remove(string);
                this.componentQueue.add(string);
            }
            int n = this.getTextureFormat(imageComponent);
            object = imageComponent instanceof ImageComponent2D ? new Texture2D(1, n, imageComponent.getWidth(), imageComponent.getHeight()) : new Texture3D(1, n, imageComponent.getWidth(), imageComponent.getHeight(), ((ImageComponent3D)imageComponent).getDepth());
            object.setImage(0, imageComponent);
            this.addTexture(string, (Texture)object);
        } else {
            this.textureQueue.remove(string);
            this.textureQueue.add(string);
        }
        return object;
    }

    public ImageComponent fetchImageComponent(String string) throws IOException {
        ImageComponent imageComponent = (ImageComponent)this.componentMap.get(string);
        if (imageComponent == null) {
            imageComponent = this.load2DImage(string);
            this.addImageComponent(string, imageComponent);
        } else {
            this.componentQueue.remove(string);
            this.componentQueue.add(string);
        }
        return imageComponent;
    }

    public ImageComponent fetchImageComponent(URL uRL) throws IOException {
        String string = uRL.toExternalForm();
        ImageComponent imageComponent = (ImageComponent)this.componentMap.get(string);
        if (imageComponent == null) {
            imageComponent = this.load2DImage(string);
            this.addImageComponent(string, imageComponent);
        } else {
            this.componentQueue.remove(string);
            this.componentQueue.add(string);
        }
        return imageComponent;
    }

    public void releaseTexture(String string) {
        this.textureMap.remove(string);
        this.componentMap.remove(string);
        this.textureQueue.remove(string);
        this.componentQueue.remove(string);
    }

    public void releaseTexture(URL uRL) {
        String string = uRL.toExternalForm();
        this.textureMap.remove(string);
        this.componentMap.remove(string);
        this.textureQueue.remove(string);
        this.componentQueue.remove(string);
    }

    public void clearAll() {
        this.textureMap.clear();
        this.componentMap.clear();
        this.textureQueue.clear();
        this.componentQueue.clear();
    }

    public boolean checkTexture(String string) {
        return this.textureMap.containsKey(string);
    }

    public boolean checkImageComponent(String string) {
        return this.componentMap.containsKey(string);
    }

    public void registerTexture(Texture texture, String string) {
        this.textureMap.put(string, texture);
        try {
            ImageComponent imageComponent = texture.getImage(0);
            this.componentMap.put(string, imageComponent);
        }
        catch (CapabilityNotSetException capabilityNotSetException) {}
    }

    public void registerImageComponent(ImageComponent imageComponent, String string) {
        this.componentMap.put(string, imageComponent);
    }

    private void addTexture(String string, Texture texture) {
        this.textureQueue.add(string);
        this.textureMap.put(string, texture);
        if (this.textureQueue.size() > this.maxCacheSize) {
            Object object = this.textureQueue.getNext();
            this.textureMap.remove(string);
        }
    }

    private void addImageComponent(String string, ImageComponent imageComponent) {
        this.componentQueue.add(string);
        this.componentMap.put(string, imageComponent);
        if (this.componentQueue.size() > this.maxCacheSize) {
            Object object = this.componentQueue.getNext();
            this.componentMap.remove(string);
        }
    }
}

