/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.ui.navigation;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupOnElapsedFrames;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.j3d.geom.GeometryData;
import org.j3d.geom.IntersectionUtils;
import org.j3d.ui.navigation.CollisionListener;
import org.j3d.ui.navigation.FrameUpdateListener;
import org.j3d.ui.navigation.HeightDataSource;
import org.j3d.ui.navigation.NavigationStateListener;
import org.j3d.util.UserSupplementData;

public class NavigationHandler {
    private static final float DEFAULT_AVATAR_HEIGHT = 1.8f;
    private static final float DEFAULT_AVATAR_SIZE = 0.25f;
    private static final float DEFAULT_STEP_HEIGHT = 0.4f;
    private static final float DEFAULT_ORBIT_TIME = 5.0f;
    private static final double ZEROEPS = 1.0E-6;
    private static final Vector3d Y_DOWN = new Vector3d(0.0, -1.0, 0.0);
    private static final Vector3d Y_UP = new Vector3d(0.0, 1.0, 0.0);
    private static final Vector3d COLLISION_DIRECTION = new Vector3d(0.0, 0.0, -1.0);
    private IntersectionUtils terrainIntersect = new IntersectionUtils();
    private IntersectionUtils collideIntersect = new IntersectionUtils();
    private View view;
    private TransformGroup viewTg = new TransformGroup();
    private Transform3D viewTx = new Transform3D();
    private NavigationStateListener navigationListener;
    private CollisionListener collisionListener;
    private int navigationState = 0;
    private int previousState = 0;
    private int buttonOneState = 0;
    private int buttonTwoState = 0;
    private int buttonThreeState = 0;
    private boolean movementInProgress = false;
    private int activeButton;
    private float speed = 0.0f;
    private BranchGroup terrain;
    private BranchGroup collidables;
    private PickRay terrainPicker;
    private PickSegment collisionPicker;
    private Vector3d downVector;
    private Vector3d collisionVector;
    private FrameUpdateListener updateListener;
    private float avatarHeight = 1.8f;
    private float avatarSize = 0.25f;
    private float avatarStep = 0.4f;
    private float lastTerrainHeight = 0.0f;
    private Vector3d locationVector;
    private Point3d locationPoint;
    private Point3d locationEndPoint;
    private Point3d wkPoint;
    private Vector3d diffVec;
    private Point3d intersectionPoint;
    private Point3d centerOfRotation;
    private float orbitTime = 5.0f;
    private double lastAngle;
    private double rotationRadius;
    private int screenWidth;
    private int screenHeight;
    private Vector3d dragTranslationAmt;
    private Vector3d oneFrameTranslation;
    private Transform3D oneFrameRotation;
    private Vector3d viewTranslation;
    private Transform3D worldEyeTransform = new Transform3D();
    private double inputRotationY = 0.0;
    private double inputRotationX = 0.0;
    private Point2d startMousePos;
    private Point2d latestMousePos;
    private Point2d mouseDifference;
    private boolean allowCollisions = false;
    private boolean allowTerrainFollowing = false;
    private double angle;
    private FrameTimerBehavior frameTimer;
    private long startFrameDurationCalc;
    private long frameDuration;

    public NavigationHandler() {
        this.downVector = new Vector3d();
        this.terrainPicker = new PickRay();
        this.centerOfRotation = new Point3d();
        this.collisionVector = new Vector3d();
        this.collisionPicker = new PickSegment();
        this.intersectionPoint = new Point3d();
        this.wkPoint = new Point3d();
        this.diffVec = new Vector3d();
        this.locationVector = new Vector3d();
        this.locationPoint = new Point3d();
        this.locationEndPoint = new Point3d();
        this.dragTranslationAmt = new Vector3d();
        this.oneFrameTranslation = new Vector3d();
        this.oneFrameRotation = new Transform3D();
        this.viewTranslation = new Vector3d();
        this.startMousePos = new Point2d();
        this.latestMousePos = new Point2d();
        this.mouseDifference = new Point2d();
        this.centerOfRotation = new Point3d(0.0, 0.0, 0.0);
    }

    public Behavior getTimerBehavior() {
        if (this.frameTimer == null) {
            BoundingSphere boundingSphere = new BoundingSphere();
            boundingSphere.setRadius(Double.POSITIVE_INFINITY);
            this.frameTimer = new FrameTimerBehavior();
            this.frameTimer.setSchedulingBounds((Bounds)boundingSphere);
            this.frameTimer.setEnable(false);
        }
        return this.frameTimer;
    }

    public void setCenterOfRotation(float[] fArray) {
        this.centerOfRotation.x = fArray[0];
        this.centerOfRotation.y = fArray[1];
        this.centerOfRotation.z = fArray[2];
        if (this.navigationState == 5) {
            this.viewTg.getTransform(this.viewTx);
            this.viewTx.get(this.viewTranslation);
            double d = this.viewTranslation.x - this.centerOfRotation.x;
            double d2 = this.viewTranslation.z - this.centerOfRotation.z;
            this.rotationRadius = Math.sqrt(d * d + d2 * d2);
            this.lastAngle = Math.atan2(d2, d);
            this.locationPoint.set((Tuple3d)this.viewTranslation);
            this.viewTx.lookAt(this.locationPoint, this.centerOfRotation, Y_UP);
            this.viewTx.invert();
            this.viewTg.setTransform(this.viewTx);
        }
    }

    public void setViewInfo(View view, TransformGroup transformGroup) {
        if (view != null && transformGroup == null || view == null && transformGroup != null) {
            throw new IllegalArgumentException("View or TG is null when the other isn't");
        }
        this.view = view;
        this.viewTg = transformGroup;
        if (transformGroup == null) {
            return;
        }
        this.viewTg.getTransform(this.viewTx);
        if (transformGroup.isLive()) {
            if (!this.viewTg.getCapability(11)) {
                throw new IllegalStateException("Live scenegraph and cannot read the VWorld transform");
            }
        } else {
            transformGroup.setCapability(11);
        }
    }

    public void setWorldInfo(BranchGroup branchGroup, BranchGroup branchGroup2) {
        this.terrain = branchGroup;
        this.collidables = branchGroup2;
    }

    public void setAvatarInfo(float f, float f2, float f3) {
        this.avatarHeight = f;
        this.avatarSize = f2;
        this.avatarStep = f3;
    }

    public void setNavigationSpeed(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("Negative speed value");
        }
        this.speed = f;
    }

    public void setOrbitTime(float f) {
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Orbit time <= 0");
        }
        this.orbitTime = f;
    }

    public void setButtonNavigation(int n, int n2) {
        switch (n) {
            case 16: {
                this.buttonOneState = n2;
                break;
            }
            case 8: {
                this.buttonTwoState = n2;
                break;
            }
            case 4: {
                this.buttonThreeState = n2;
            }
        }
    }

    public void setNavigationStateListener(NavigationStateListener navigationStateListener) {
        this.navigationListener = navigationStateListener;
    }

    public void setCollisionListener(CollisionListener collisionListener) {
        this.collisionListener = collisionListener;
    }

    public int getNavigationState() {
        return this.navigationState;
    }

    public void processNextFrame() {
        this.frameDuration = System.currentTimeMillis() - this.startFrameDurationCalc;
        if (this.frameDuration == 0L) {
            this.frameDuration = 1L;
        }
        this.processClockTick();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.viewTg == null) {
            return;
        }
        this.latestMousePos.set((double)mouseEvent.getX(), (double)mouseEvent.getY());
        this.mouseDifference.sub((Tuple2d)this.startMousePos, (Tuple2d)this.latestMousePos);
        switch (this.navigationState) {
            case 4: {
                this.dragTranslationAmt.set(0.0, 0.0, -this.mouseDifference.y * (double)this.speed);
                this.inputRotationY = this.mouseDifference.x;
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = false;
                break;
            }
            case 3: {
                this.dragTranslationAmt.set(-this.mouseDifference.x * 2.0, this.mouseDifference.y * 2.0, 0.0);
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 2: {
                this.inputRotationX = this.mouseDifference.y;
                this.inputRotationY = this.mouseDifference.x;
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 1: {
                this.dragTranslationAmt.set(0.0, 0.0, -this.mouseDifference.y * (double)this.speed);
                this.inputRotationY = this.mouseDifference.x;
                this.allowCollisions = this.collidables != null;
                this.allowTerrainFollowing = this.terrain != null;
                break;
            }
            case 5: {
                this.dragTranslationAmt.set(0.0, 0.0, -this.mouseDifference.y * (double)this.speed);
                this.inputRotationY = this.mouseDifference.x;
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
                break;
            }
            case 0: {
                this.allowCollisions = false;
                this.allowTerrainFollowing = false;
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.movementInProgress || this.viewTg == null) {
            return;
        }
        int n = mouseEvent.getModifiers();
        this.previousState = this.navigationState;
        this.activeButton = n & 0x10;
        if ((n & 0x10) != 0) {
            this.navigationState = this.buttonOneState;
        } else if ((n & 8) != 0) {
            this.navigationState = this.buttonTwoState;
        } else if ((n & 4) != 0) {
            this.navigationState = this.buttonThreeState;
        }
        if (this.navigationListener != null) {
            this.navigationListener.setNavigationState(this.navigationState);
        }
        if (this.navigationState == 0) {
            return;
        }
        this.viewTg.getTransform(this.viewTx);
        this.viewTx.get(this.viewTranslation);
        this.startMousePos.set((double)mouseEvent.getX(), (double)mouseEvent.getY());
        this.startFrameDurationCalc = System.currentTimeMillis();
        if (this.frameTimer != null) {
            this.frameTimer.setEnable(true);
        }
        if (this.navigationState == 1 && this.allowTerrainFollowing) {
            this.setInitialTerrainHeight();
        }
        if (this.navigationState == 5) {
            Canvas3D canvas3D = this.view.getCanvas3D(0);
            Dimension dimension = canvas3D.getSize();
            this.screenWidth = dimension.width;
            this.screenHeight = dimension.height;
            double d = this.viewTranslation.x - this.centerOfRotation.x;
            double d2 = this.viewTranslation.z - this.centerOfRotation.z;
            this.rotationRadius = Math.sqrt(d * d + d2 * d2);
            this.lastAngle = Math.atan2(d2, d);
            this.locationPoint.set((Tuple3d)this.viewTranslation);
            this.viewTx.lookAt(this.locationPoint, this.centerOfRotation, Y_UP);
            this.viewTx.invert();
            this.viewTg.setTransform(this.viewTx);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getModifiers();
        if (this.viewTg == null || this.movementInProgress && ((long)n & 0x10L) != (long)this.activeButton) {
            return;
        }
        this.movementInProgress = false;
        this.allowCollisions = false;
        this.allowTerrainFollowing = false;
        if (this.frameTimer != null) {
            this.frameTimer.setEnable(false);
        }
        this.viewTx.normalize();
        this.inputRotationY = 0.0;
        this.inputRotationX = 0.0;
        this.oneFrameRotation.setIdentity();
        this.dragTranslationAmt.scale(0.0);
        this.viewTg.getTransform(this.viewTx);
        this.navigationState = this.previousState;
        if (this.navigationListener != null) {
            this.navigationListener.setNavigationState(this.previousState);
        }
    }

    public void setFrameUpdateListener(FrameUpdateListener frameUpdateListener) {
        this.updateListener = frameUpdateListener;
    }

    private void processClockTick() {
        if (this.navigationState == 5) {
            this.processExamineMotion();
        } else {
            this.processDefaultMotion();
        }
    }

    private void processExamineMotion() {
        block6: {
            double d;
            double d2;
            double d3;
            double d4;
            boolean bl = false;
            double d5 = this.lastAngle;
            this.viewTg.getTransform(this.viewTx);
            this.viewTx.get(this.locationVector);
            if (this.dragTranslationAmt.z != 0.0) {
                d4 = 5.0E-6 * (double)this.frameDuration;
                d3 = this.locationVector.x - this.centerOfRotation.x;
                d2 = this.locationVector.z - this.centerOfRotation.z;
                d = this.dragTranslationAmt.z * 2.0 / (double)this.screenHeight;
                this.rotationRadius = Math.sqrt(d3 * d3 + d2 * d2) + d;
                bl = true;
            }
            if (this.inputRotationY != 0.0) {
                d4 = this.inputRotationY * 2.0 / (double)this.screenWidth;
                d = d4 * Math.PI * 2.0 * (double)this.frameDuration / (double)(this.orbitTime * 1000.0f);
                if ((d5 += d) > Math.PI * 2) {
                    d5 -= Math.PI * 2;
                }
                this.lastAngle = d5;
                bl = true;
            }
            if (bl) {
                d3 = this.rotationRadius * Math.cos(d5);
                d2 = this.rotationRadius * Math.sin(d5);
                this.locationPoint.x = this.centerOfRotation.x + d3;
                this.locationPoint.y = this.locationVector.y;
                this.locationPoint.z = this.centerOfRotation.z + d2;
                this.viewTx.lookAt(this.locationPoint, this.centerOfRotation, Y_UP);
                this.viewTx.invert();
                this.viewTg.setTransform(this.viewTx);
            }
            this.startFrameDurationCalc = System.currentTimeMillis();
            if (this.updateListener == null) break block6;
            try {
                this.updateListener.viewerPositionUpdated(this.viewTx);
            }
            catch (Exception exception) {
                System.out.println("Error sending frame update message");
                exception.printStackTrace();
            }
        }
    }

    private void processDefaultMotion() {
        block8: {
            double d = 5.0E-6 * (double)this.frameDuration;
            this.viewTg.getTransform(this.viewTx);
            this.oneFrameRotation.rotX(this.inputRotationX * d);
            this.viewTx.mul(this.oneFrameRotation);
            this.oneFrameRotation.rotY(this.inputRotationY * d);
            this.viewTx.mul(this.oneFrameRotation);
            this.oneFrameTranslation.set((Tuple3d)this.dragTranslationAmt);
            this.oneFrameTranslation.scale(d);
            this.viewTx.transform(this.oneFrameTranslation);
            boolean bl = false;
            if (this.allowCollisions) {
                boolean bl2 = bl = !this.checkCollisions();
            }
            if (this.allowTerrainFollowing && !bl) {
                boolean bl3 = bl = !this.checkTerrainFollowing();
            }
            if (bl) {
                System.out.println("J3DNavHandler: Need to notify of collision geometry");
                if (this.collisionListener != null) {
                    this.collisionListener.avatarCollision(null);
                }
                this.oneFrameTranslation.z = 0.0;
            }
            this.viewTranslation.add((Tuple3d)this.oneFrameTranslation);
            this.viewTx.setTranslation(this.viewTranslation);
            try {
                this.viewTg.setTransform(this.viewTx);
            }
            catch (Exception exception) {
                this.viewTx.rotX(0.0);
                this.viewTg.setTransform(this.viewTx);
            }
            this.startFrameDurationCalc = System.currentTimeMillis();
            if (this.updateListener == null) break block8;
            try {
                this.updateListener.viewerPositionUpdated(this.viewTx);
            }
            catch (Exception exception) {
                System.out.println("Error sending frame update message");
                exception.printStackTrace();
            }
        }
    }

    private boolean checkTerrainFollowing() {
        boolean bl = true;
        this.viewTg.getLocalToVworld(this.worldEyeTransform);
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.worldEyeTransform.transform(Y_DOWN, this.downVector);
        this.locationPoint.add((Tuple3d)this.locationVector, (Tuple3d)this.oneFrameTranslation);
        this.terrainPicker.set(this.locationPoint, this.downVector);
        SceneGraphPath[] sceneGraphPathArray = this.terrain.pickAllSorted((PickShape)this.terrainPicker);
        if (sceneGraphPathArray == null || sceneGraphPathArray.length == 0) {
            return bl;
        }
        double d = -1.0;
        int n = 0;
        while (n < sceneGraphPathArray.length) {
            block27: {
                Object object;
                GeometryData geometryData;
                HeightDataSource heightDataSource;
                Shape3D shape3D;
                Transform3D transform3D;
                Object object2;
                block29: {
                    block28: {
                        Node node = sceneGraphPathArray[n].getObject();
                        object2 = node.getUserData();
                        if (object2 instanceof UserSupplementData && !((UserSupplementData)object2).isTerrain) break block27;
                        int n2 = sceneGraphPathArray[n].nodeCount();
                        boolean bl2 = false;
                        int n3 = 0;
                        while (n3 < n2 && !bl2) {
                            transform3D = sceneGraphPathArray[n].getNode(n3);
                            object2 = transform3D.getUserData();
                            if (object2 instanceof UserSupplementData) {
                                bl2 = !((UserSupplementData)object2).isTerrain;
                            }
                            ++n3;
                        }
                        if (bl2) break block27;
                        transform3D = sceneGraphPathArray[n].getTransform();
                        transform3D.get(this.locationVector);
                        shape3D = (Shape3D)sceneGraphPathArray[n].getObject();
                        object2 = shape3D.getUserData();
                        heightDataSource = null;
                        geometryData = null;
                        if (object2 instanceof UserSupplementData) {
                            object = (UserSupplementData)object2;
                            if (((UserSupplementData)object).geometryData instanceof HeightDataSource) {
                                heightDataSource = (HeightDataSource)((UserSupplementData)object).geometryData;
                            } else if (((UserSupplementData)object).geometryData instanceof GeometryData) {
                                geometryData = (GeometryData)((UserSupplementData)object).geometryData;
                            }
                        } else if (object2 instanceof HeightDataSource) {
                            heightDataSource = (HeightDataSource)object2;
                        } else if (object2 instanceof GeometryData) {
                            geometryData = (GeometryData)object2;
                        }
                        if (heightDataSource == null) break block28;
                        this.intersectionPoint.x = this.locationVector.x;
                        this.intersectionPoint.y = this.locationVector.y;
                        this.intersectionPoint.z = heightDataSource.getHeight((float)this.locationVector.x, (float)this.locationVector.y);
                        break block27;
                    }
                    if (geometryData == null) break block29;
                    if (!this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryData, transform3D, this.wkPoint, false)) break block27;
                    this.diffVec.sub((Tuple3d)this.locationPoint, (Tuple3d)this.wkPoint);
                    if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) break block27;
                    d = this.diffVec.lengthSquared();
                    this.intersectionPoint.set((Tuple3d)this.wkPoint);
                    break block27;
                }
                object = shape3D.getAllGeometries();
                while (object.hasMoreElements()) {
                    GeometryArray geometryArray = (GeometryArray)object.nextElement();
                    if (geometryArray == null) continue;
                    object2 = geometryArray.getUserData();
                    geometryData = null;
                    if (object2 instanceof UserSupplementData) {
                        UserSupplementData userSupplementData = (UserSupplementData)object2;
                        if (userSupplementData.geometryData instanceof HeightDataSource) {
                            heightDataSource = (HeightDataSource)userSupplementData.geometryData;
                        } else if (userSupplementData.geometryData instanceof GeometryData) {
                            geometryData = (GeometryData)userSupplementData.geometryData;
                        }
                    } else if (object2 instanceof HeightDataSource) {
                        heightDataSource = (HeightDataSource)object2;
                    } else if (object2 instanceof GeometryData) {
                        geometryData = (GeometryData)object2;
                    }
                    boolean bl3 = false;
                    bl3 = geometryData != null ? this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryData, transform3D, this.wkPoint, false) : this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryArray, transform3D, this.wkPoint, false);
                    if (!bl3) continue;
                    this.diffVec.sub((Tuple3d)this.locationPoint, (Tuple3d)this.wkPoint);
                    if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) continue;
                    d = this.diffVec.lengthSquared();
                    this.intersectionPoint.set((Tuple3d)this.wkPoint);
                }
            }
            ++n;
        }
        if (d == -1.0) {
            return true;
        }
        double d2 = this.intersectionPoint.y - (double)this.lastTerrainHeight;
        double d3 = this.locationPoint.y - this.intersectionPoint.y;
        if (!this.floatEq(d3 - (double)this.avatarHeight, 0.0)) {
            if (this.floatEq(d2, 0.0)) {
                this.oneFrameTranslation.y = (double)this.avatarHeight - d3;
                bl = true;
            } else if (d2 < (double)this.avatarStep) {
                this.oneFrameTranslation.y = d2;
                bl = true;
            } else {
                bl = false;
            }
        }
        this.lastTerrainHeight = (float)this.intersectionPoint.y;
        return bl;
    }

    private boolean checkCollisions() {
        boolean bl = true;
        this.viewTg.getLocalToVworld(this.worldEyeTransform);
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.locationPoint.set((Tuple3d)this.locationVector);
        this.worldEyeTransform.transform(COLLISION_DIRECTION, this.collisionVector);
        this.collisionVector.scale((double)this.avatarSize);
        this.locationEndPoint.add((Tuple3d)this.locationVector, (Tuple3d)this.collisionVector);
        this.locationEndPoint.add((Tuple3d)this.oneFrameTranslation);
        this.collisionPicker.set(this.locationPoint, this.locationEndPoint);
        SceneGraphPath[] sceneGraphPathArray = this.collidables.pickAllSorted((PickShape)this.collisionPicker);
        if (sceneGraphPathArray == null || sceneGraphPathArray.length == 0) {
            return true;
        }
        boolean bl2 = false;
        float f = (float)this.collisionVector.length();
        int n = 0;
        while (n < sceneGraphPathArray.length && !bl2) {
            Node node = sceneGraphPathArray[n].getObject();
            Object object = node.getUserData();
            if (!(object instanceof UserSupplementData) || ((UserSupplementData)object).collidable) {
                Transform3D transform3D;
                int n2 = sceneGraphPathArray[n].nodeCount();
                boolean bl3 = false;
                int n3 = 0;
                while (n3 < n2 && !bl3) {
                    transform3D = sceneGraphPathArray[n].getNode(n3);
                    object = transform3D.getUserData();
                    if (object instanceof UserSupplementData) {
                        bl3 = !((UserSupplementData)object).collidable;
                    }
                    ++n3;
                }
                if (!bl3) {
                    transform3D = sceneGraphPathArray[n].getTransform();
                    Shape3D shape3D = (Shape3D)sceneGraphPathArray[n].getObject();
                    Enumeration enumeration = shape3D.getAllGeometries();
                    GeometryData geometryData = null;
                    while (enumeration.hasMoreElements() && !bl2) {
                        GeometryArray geometryArray = (GeometryArray)enumeration.nextElement();
                        if (geometryArray == null) continue;
                        object = geometryArray.getUserData();
                        geometryData = null;
                        if (object instanceof UserSupplementData) {
                            UserSupplementData userSupplementData = (UserSupplementData)object;
                            if (userSupplementData.geometryData instanceof GeometryData) {
                                geometryData = (GeometryData)userSupplementData.geometryData;
                            }
                        } else if (object instanceof GeometryData) {
                            geometryData = (GeometryData)object;
                        }
                        bl2 = geometryData != null ? this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.collisionVector, f, geometryData, transform3D, this.wkPoint, true) : this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.collisionVector, f, geometryArray, transform3D, this.wkPoint, true);
                    }
                    bl = !bl2;
                }
            }
            ++n;
        }
        return bl;
    }

    private void setInitialTerrainHeight() {
        if (this.terrain == null) {
            return;
        }
        this.viewTg.getLocalToVworld(this.worldEyeTransform);
        this.worldEyeTransform.mul(this.viewTx);
        this.worldEyeTransform.get(this.locationVector);
        this.worldEyeTransform.transform(Y_DOWN, this.downVector);
        this.locationPoint.set((Tuple3d)this.locationVector);
        this.terrainPicker.set(this.locationPoint, this.downVector);
        SceneGraphPath[] sceneGraphPathArray = this.terrain.pickAllSorted((PickShape)this.terrainPicker);
        if (sceneGraphPathArray == null) {
            return;
        }
        double d = -1.0;
        int n = 0;
        while (n < sceneGraphPathArray.length) {
            block23: {
                Object object;
                GeometryData geometryData;
                HeightDataSource heightDataSource;
                Shape3D shape3D;
                Transform3D transform3D;
                Object object2;
                block25: {
                    block24: {
                        Node node = sceneGraphPathArray[n].getObject();
                        object2 = node.getUserData();
                        if (object2 instanceof UserSupplementData && !((UserSupplementData)object2).isTerrain) break block23;
                        int n2 = sceneGraphPathArray[n].nodeCount();
                        boolean bl = false;
                        int n3 = 0;
                        while (n3 < n2 && !bl) {
                            transform3D = sceneGraphPathArray[n].getNode(n3);
                            object2 = transform3D.getUserData();
                            if (object2 instanceof UserSupplementData) {
                                bl = !((UserSupplementData)object2).isTerrain;
                            }
                            ++n3;
                        }
                        if (bl) break block23;
                        transform3D = sceneGraphPathArray[n].getTransform();
                        transform3D.get(this.locationVector);
                        shape3D = (Shape3D)sceneGraphPathArray[n].getObject();
                        object2 = shape3D.getUserData();
                        heightDataSource = null;
                        geometryData = null;
                        if (object2 instanceof UserSupplementData) {
                            object = (UserSupplementData)object2;
                            if (((UserSupplementData)object).geometryData instanceof HeightDataSource) {
                                heightDataSource = (HeightDataSource)((UserSupplementData)object).geometryData;
                            } else if (((UserSupplementData)object).geometryData instanceof GeometryData) {
                                geometryData = (GeometryData)((UserSupplementData)object).geometryData;
                            }
                        } else if (object2 instanceof HeightDataSource) {
                            heightDataSource = (HeightDataSource)object2;
                        } else if (object2 instanceof GeometryData) {
                            geometryData = (GeometryData)object2;
                        }
                        if (heightDataSource == null) break block24;
                        this.intersectionPoint.x = this.locationVector.x;
                        this.intersectionPoint.y = this.locationVector.y;
                        this.intersectionPoint.z = heightDataSource.getHeight((float)this.locationVector.x, (float)this.locationVector.y);
                        break block23;
                    }
                    if (geometryData == null) break block25;
                    if (!this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryData, transform3D, this.wkPoint, false)) break block23;
                    this.diffVec.sub((Tuple3d)this.locationPoint, (Tuple3d)this.wkPoint);
                    if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) break block23;
                    d = this.diffVec.lengthSquared();
                    this.intersectionPoint.set((Tuple3d)this.wkPoint);
                    break block23;
                }
                object = shape3D.getAllGeometries();
                while (object.hasMoreElements()) {
                    GeometryArray geometryArray = (GeometryArray)object.nextElement();
                    if (geometryArray == null) continue;
                    object2 = geometryArray.getUserData();
                    geometryData = null;
                    if (object2 instanceof UserSupplementData) {
                        UserSupplementData userSupplementData = (UserSupplementData)object2;
                        if (userSupplementData.geometryData instanceof HeightDataSource) {
                            heightDataSource = (HeightDataSource)userSupplementData.geometryData;
                        } else if (userSupplementData.geometryData instanceof GeometryData) {
                            geometryData = (GeometryData)userSupplementData.geometryData;
                        }
                    } else if (object2 instanceof HeightDataSource) {
                        heightDataSource = (HeightDataSource)object2;
                    } else if (object2 instanceof GeometryData) {
                        geometryData = (GeometryData)object2;
                    }
                    boolean bl = false;
                    bl = geometryData != null ? this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryData, transform3D, this.wkPoint, false) : this.terrainIntersect.rayUnknownGeometry(this.locationPoint, this.downVector, 0.0f, geometryArray, transform3D, this.wkPoint, false);
                    if (!bl) continue;
                    this.diffVec.sub((Tuple3d)this.locationPoint, (Tuple3d)this.wkPoint);
                    if (d != -1.0 && !(this.diffVec.lengthSquared() < d)) continue;
                    d = this.diffVec.lengthSquared();
                    this.intersectionPoint.set((Tuple3d)this.wkPoint);
                }
            }
            ++n;
        }
        if (d != -1.0) {
            this.lastTerrainHeight = (float)this.intersectionPoint.y;
        }
    }

    private boolean floatEq(double d, double d2) {
        double d3 = d - d2;
        if (d3 < 0.0) {
            d3 *= -1.0;
        }
        return d3 < 1.0E-6;
    }

    private class FrameTimerBehavior
    extends Behavior {
        private WakeupCondition fpsCriterion = new WakeupOnElapsedFrames(0, false);

        public void initialize() {
            this.wakeupOn(this.fpsCriterion);
        }

        public void processStimulus(Enumeration enumeration) {
            NavigationHandler.this.frameDuration = System.currentTimeMillis() - NavigationHandler.this.startFrameDurationCalc;
            if (!this.getEnable()) {
                NavigationHandler.this.startFrameDurationCalc = System.currentTimeMillis();
                this.wakeupOn(this.fpsCriterion);
                return;
            }
            NavigationHandler.this.processClockTick();
            this.wakeupOn(this.fpsCriterion);
        }
    }
}

