/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util;

import java.util.Arrays;

public class FloatHashMap {
    private transient Entry[] table;
    private transient int count = 0;
    private int threshold;
    private float loadFactor;
    private transient int modCount = 0;

    public FloatHashMap() {
        this(20, 0.75f);
    }

    public FloatHashMap(int n) {
        this(n, 0.75f);
    }

    public FloatHashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.loadFactor = f;
        this.table = new Entry[n];
        this.threshold = (int)((float)n * f);
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException("value object may not be null!");
        }
        Entry[] entryArray = this.table;
        int n = entryArray.length;
        while (n-- > 0) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (entry.value.equals(object)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    public boolean containsValue(Object object) {
        return this.contains(object);
    }

    public boolean containsKey(float f) {
        Entry[] entryArray = this.table;
        long l = Double.doubleToLongBits(f);
        int n = (int)(l ^ l >>> 32);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key == f) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    public Object get(float f) {
        Entry[] entryArray = this.table;
        long l = Double.doubleToLongBits(f);
        int n = (int)(l ^ l >>> 32);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (entry.hash == n && entry.key == f) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(float f, Object object) {
        Entry entry;
        Entry[] entryArray = this.table;
        long l = Double.doubleToLongBits(f);
        int n = (int)(l ^ l >>> 32);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry2 = entryArray[n2];
        while (entry2 != null) {
            if (entry2.hash == n && entry2.key == f) {
                Object object2 = entry2.value;
                entry2.value = object;
                return object2;
            }
            entry2 = entry2.next;
        }
        ++this.modCount;
        if (this.count >= this.threshold) {
            this.rehash();
            entryArray = this.table;
            n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        }
        entryArray[n2] = entry = new Entry(n, f, object, entryArray[n2]);
        ++this.count;
        return null;
    }

    public Object remove(float f) {
        Entry[] entryArray = this.table;
        long l = Double.doubleToLongBits(f);
        int n = (int)(l ^ l >>> 32);
        int n2 = (n & Integer.MAX_VALUE) % entryArray.length;
        Entry entry = entryArray[n2];
        Entry entry2 = null;
        while (entry != null) {
            if (entry.hash == n && entry.key == f) {
                ++this.modCount;
                if (entry2 != null) {
                    entry2.next = entry.next;
                } else {
                    entryArray[n2] = entry.next;
                }
                --this.count;
                Object object = entry.value;
                entry.value = null;
                return object;
            }
            entry2 = entry;
            entry = entry.next;
        }
        return null;
    }

    public synchronized void clear() {
        Entry[] entryArray = this.table;
        ++this.modCount;
        int n = entryArray.length;
        while (--n >= 0) {
            entryArray[n] = null;
        }
        this.count = 0;
    }

    public float[] keySet() {
        float[] fArray = new float[this.count];
        int n = 0;
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry entry = entryArray[n2];
            while (entry != null) {
                fArray[n++] = entry.key;
                entry = entry.next;
            }
        }
        return fArray;
    }

    public float[] keySetSorted() {
        float[] fArray = this.keySet();
        Arrays.sort(fArray);
        return fArray;
    }

    private void rehash() {
        int n = this.table.length;
        Entry[] entryArray = this.table;
        int n2 = n * 2 + 1;
        Entry[] entryArray2 = new Entry[n2];
        ++this.modCount;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = entryArray2;
        int n3 = n;
        while (n3-- > 0) {
            Entry entry = entryArray[n3];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n4 = (entry2.hash & Integer.MAX_VALUE) % n2;
                entry2.next = entryArray2[n4];
                entryArray2[n4] = entry2;
            }
        }
    }

    private static class Entry {
        int hash;
        float key;
        Object value;
        Entry next;

        protected Entry(int n, float f, Object object, Entry entry) {
            this.hash = n;
            this.key = f;
            this.value = object;
            this.next = entry;
        }
    }
}

