/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.device;

import com.sun.j3d.loaders.Loader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.InputDevice;
import org.j3d.util.ErrorHandler;
import org.j3d.util.device.AudioDeviceDescriptor;
import org.j3d.util.device.DynamicClassLoader;
import org.j3d.util.device.ErrorOutput;
import org.j3d.util.device.FileLoaderDescriptor;
import org.j3d.util.device.InputDeviceDescriptor;

public class DeviceManager {
    private static final String INPUT_LIST = "input.list";
    private static final String AUDIO_LIST = "audio.list";
    private static final String LOADER_LIST = "loader.list";
    private static final String NAME_PART = ".name";
    private static final String DESCRIPTION_PART = ".desc";
    private static final String CLASS_PART = ".class";
    private static final String MIME_PART = ".mime";
    private static final String EXTENSION_PART = ".ext";
    private static final String PROP_FILE = "j3d_devices.properties";
    private static DeviceManager _instance;
    private Properties device_props;
    private ErrorHandler error_handler;
    private List input_devices;
    private List audio_devices;
    private List file_loaders;
    static /* synthetic */ Class class$javax$media$j3d$InputDevice;
    static /* synthetic */ Class class$javax$media$j3d$AudioDevice;
    static /* synthetic */ Class class$com$sun$j3d$loaders$Loader;

    private DeviceManager() {
        block3: {
            this.device_props = new Properties();
            this.error_handler = new ErrorOutput();
            try {
                InputStream inputStream = ClassLoader.getSystemResourceAsStream(PROP_FILE);
                if (inputStream != null) {
                    this.device_props.load(inputStream);
                    break block3;
                }
                this.device_props.setProperty(INPUT_LIST, null);
                this.device_props.setProperty(AUDIO_LIST, null);
                this.device_props.setProperty(LOADER_LIST, null);
            }
            catch (IOException iOException) {
                System.err.println("Error: Could not read device definitions");
            }
        }
    }

    public static DeviceManager getDeviceManager() {
        if (_instance == null) {
            _instance = new DeviceManager();
        }
        return _instance;
    }

    public static void shutdown() {
        if (_instance != null) {
            _instance.stop();
            _instance = null;
        }
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.error_handler = errorHandler != null ? errorHandler : new ErrorOutput();
    }

    public List getAllInputDevices() {
        if (this.input_devices == null) {
            List list = this.listItems(INPUT_LIST);
            if (list.size() == 0) {
                this.input_devices = Collections.EMPTY_LIST;
            } else {
                this.input_devices = new LinkedList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = ((String)iterator.next()).trim();
                    String string2 = this.device_props.getProperty(string + NAME_PART);
                    String string3 = this.device_props.getProperty(string + DESCRIPTION_PART);
                    String string4 = this.device_props.getProperty(string + CLASS_PART);
                    this.input_devices.add(new InputDeviceDescriptor(string2, string3, string4));
                }
            }
        }
        return this.input_devices;
    }

    public InputDevice getInputDevice(InputDeviceDescriptor inputDeviceDescriptor) {
        InputDevice inputDevice;
        block2: {
            inputDevice = (InputDevice)inputDeviceDescriptor.getDevice();
            if (inputDevice != null) break block2;
            String string = inputDeviceDescriptor.getClassName();
            try {
                inputDevice = (InputDevice)DynamicClassLoader.loadCheckedClass(string, class$javax$media$j3d$InputDevice == null ? (class$javax$media$j3d$InputDevice = DeviceManager.class$("javax.media.j3d.InputDevice")) : class$javax$media$j3d$InputDevice);
            }
            catch (Exception exception) {
                this.error_handler.writeError("Unable to find class", exception);
            }
        }
        return inputDevice;
    }

    public void releaseInputDevice(InputDeviceDescriptor inputDeviceDescriptor) {
        inputDeviceDescriptor.setDevice(null);
    }

    public List getAllAudioDevices() {
        if (this.audio_devices == null) {
            List list = this.listItems(AUDIO_LIST);
            if (list.size() == 0) {
                this.audio_devices = Collections.EMPTY_LIST;
            } else {
                this.audio_devices = new LinkedList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = ((String)iterator.next()).trim();
                    String string2 = this.device_props.getProperty(string + NAME_PART);
                    String string3 = this.device_props.getProperty(string + DESCRIPTION_PART);
                    String string4 = this.device_props.getProperty(string + CLASS_PART);
                    this.audio_devices.add(new AudioDeviceDescriptor(string2, string3, string4));
                }
            }
        }
        return this.audio_devices;
    }

    public AudioDevice getAudioDevice(AudioDeviceDescriptor audioDeviceDescriptor) {
        AudioDevice audioDevice;
        block2: {
            audioDevice = (AudioDevice)audioDeviceDescriptor.getDevice();
            if (audioDevice != null) break block2;
            String string = audioDeviceDescriptor.getClassName();
            try {
                audioDevice = (AudioDevice)DynamicClassLoader.loadCheckedClass(string, class$javax$media$j3d$AudioDevice == null ? (class$javax$media$j3d$AudioDevice = DeviceManager.class$("javax.media.j3d.AudioDevice")) : class$javax$media$j3d$AudioDevice);
            }
            catch (Exception exception) {
                this.error_handler.writeError("Unable to find class", exception);
            }
        }
        return audioDevice;
    }

    public void releaseAudioDevice(AudioDeviceDescriptor audioDeviceDescriptor) {
        audioDeviceDescriptor.setDevice(null);
    }

    public List getAllFileLoaders() {
        if (this.file_loaders == null) {
            List list = this.listItems(LOADER_LIST);
            if (list.size() == 0) {
                this.file_loaders = Collections.EMPTY_LIST;
            } else {
                this.file_loaders = new LinkedList();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string = ((String)iterator.next()).trim();
                    String string2 = this.device_props.getProperty(string + NAME_PART);
                    String string3 = this.device_props.getProperty(string + DESCRIPTION_PART);
                    String string4 = this.device_props.getProperty(string + CLASS_PART);
                    String string5 = this.device_props.getProperty(string + MIME_PART);
                    String string6 = this.device_props.getProperty(string + EXTENSION_PART);
                    FileLoaderDescriptor fileLoaderDescriptor = new FileLoaderDescriptor(string2, string3, string4, string5, string6);
                    this.file_loaders.add(fileLoaderDescriptor);
                }
            }
        }
        return this.file_loaders;
    }

    public Loader getFileLoader(FileLoaderDescriptor fileLoaderDescriptor) {
        Loader loader;
        block2: {
            loader = (Loader)fileLoaderDescriptor.getDevice();
            if (loader != null) break block2;
            String string = fileLoaderDescriptor.getClassName();
            try {
                loader = (Loader)DynamicClassLoader.loadCheckedClass(string, class$com$sun$j3d$loaders$Loader == null ? (class$com$sun$j3d$loaders$Loader = DeviceManager.class$("com.sun.j3d.loaders.Loader")) : class$com$sun$j3d$loaders$Loader);
            }
            catch (Exception exception) {
                this.error_handler.writeError("Unable to find class", exception);
            }
        }
        return loader;
    }

    public void releaseFileLoader(FileLoaderDescriptor fileLoaderDescriptor) {
        fileLoaderDescriptor.setDevice(null);
    }

    private List listItems(String string) {
        LinkedList<String> linkedList = new LinkedList<String>();
        String string2 = this.device_props.getProperty(string);
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "|");
            while (stringTokenizer.hasMoreTokens()) {
                linkedList.add(stringTokenizer.nextToken());
            }
        }
        return linkedList;
    }

    private void stop() {
        this.device_props.clear();
        this.device_props = null;
        this.error_handler = null;
        if (this.input_devices != null) {
            this.input_devices.clear();
            this.input_devices = null;
        }
        if (this.audio_devices != null) {
            this.audio_devices.clear();
            this.audio_devices = null;
        }
        if (this.file_loaders != null) {
            this.file_loaders.clear();
            this.file_loaders = null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

