/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.util.device;

import java.io.InvalidClassException;

class DynamicClassLoader {
    private static final String NULL_NAME_MSG = "Name supplied is null or zero length";
    private static final String NULL_BASE_MSG = "Base class name supplied is null or zero length";
    private static final String BACKGROUND_MSG = "The class does not implement the correct base class";
    private static final String INIT_MSG = "The class failed to load correctly";

    private DynamicClassLoader() {
    }

    public static Object loadBasicClass(String string) throws ClassNotFoundException, InvalidClassException {
        if (string == null || string.trim().length() == 0) {
            throw new NullPointerException(NULL_NAME_MSG);
        }
        Object var1_1 = null;
        try {
            Class<?> clazz = Class.forName(string);
            var1_1 = clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw classNotFoundException;
        }
        catch (Exception exception) {
            throw new InvalidClassException(INIT_MSG);
        }
        catch (LinkageError linkageError) {
            throw new InvalidClassException(INIT_MSG);
        }
        return var1_1;
    }

    public static Object loadCheckedClass(String string, String string2) throws ClassNotFoundException, InvalidClassException {
        if (string == null || string.trim().length() == 0) {
            throw new NullPointerException(NULL_NAME_MSG);
        }
        if (string2 == null || string2.trim().length() == 0) {
            throw new NullPointerException(NULL_BASE_MSG);
        }
        Object object = null;
        try {
            Class<?> clazz = Class.forName(string2);
            object = DynamicClassLoader.loadCheckedClass(string, clazz);
        }
        catch (LinkageError linkageError) {
            throw new InvalidClassException(INIT_MSG);
        }
        return object;
    }

    public static Object loadCheckedClass(String string, Class clazz) throws ClassNotFoundException, InvalidClassException {
        if (string == null || string.trim().length() == 0) {
            throw new NullPointerException(NULL_NAME_MSG);
        }
        if (clazz == null) {
            throw new NullPointerException(NULL_BASE_MSG);
        }
        Object var2_2 = null;
        boolean bl = true;
        try {
            Class<?> clazz2 = Class.forName(string);
            bl = DynamicClassLoader.backgroundChecks(clazz2, clazz);
            if (bl) {
                var2_2 = clazz2.newInstance();
            }
        }
        catch (Exception exception) {
            throw new InvalidClassException(INIT_MSG);
        }
        if (!bl) {
            throw new InvalidClassException(BACKGROUND_MSG);
        }
        return var2_2;
    }

    private static boolean backgroundChecks(Class clazz, Class clazz2) {
        Class clazz3;
        boolean bl = false;
        bl = clazz2.isAssignableFrom(clazz);
        if (!bl && (clazz3 = clazz.getSuperclass()) != null) {
            bl = DynamicClassLoader.backgroundChecks(clazz3, clazz2);
        }
        return bl;
    }
}

